/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.omsdk;

import android.view.View;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.iab.omid.library.vungle.Omid;
import com.iab.omid.library.vungle.adsession.AdSession;
import com.iab.omid.library.vungle.adsession.AdSessionConfiguration;
import com.iab.omid.library.vungle.adsession.AdSessionContext;
import com.iab.omid.library.vungle.adsession.CreativeType;
import com.iab.omid.library.vungle.adsession.ImpressionType;
import com.iab.omid.library.vungle.adsession.Owner;
import com.iab.omid.library.vungle.adsession.Partner;
import com.vungle.warren.omsdk.WebViewObserver;
import java.util.concurrent.TimeUnit;

public class OMTracker
implements WebViewObserver {
    @VisibleForTesting
    static final long DESTROY_DELAY_MS = TimeUnit.SECONDS.toMillis(1L);
    private final boolean enabled;
    private boolean started;
    private AdSession adSession;

    private OMTracker(boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
        if (this.enabled && Omid.isActive()) {
            this.started = true;
        }
    }

    public long stop() {
        long delay = 0L;
        if (this.started && this.adSession != null) {
            this.adSession.finish();
            delay = DESTROY_DELAY_MS;
        }
        this.started = false;
        this.adSession = null;
        return delay;
    }

    @Override
    public void onPageFinished(@NonNull WebView webView) {
        if (this.started && this.adSession == null) {
            AdSessionConfiguration adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(CreativeType.DEFINED_BY_JAVASCRIPT, ImpressionType.DEFINED_BY_JAVASCRIPT, Owner.JAVASCRIPT, Owner.JAVASCRIPT, false);
            Partner partner = Partner.createPartner("Vungle", "6.12.0");
            AdSessionContext adSessionContext = AdSessionContext.createHtmlAdSessionContext(partner, webView, null, null);
            this.adSession = AdSession.createAdSession(adSessionConfiguration, adSessionContext);
            this.adSession.registerAdView((View)webView);
            this.adSession.start();
        }
    }

    public static class Factory {
        public OMTracker make(boolean enabled) {
            return new OMTracker(enabled);
        }
    }
}

