/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureResult<T>
implements Future<T> {
    public static final String TAG = FutureResult.class.getSimpleName();
    private final Future<T> future;

    public FutureResult(Future<T> future) {
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    @Nullable
    public T get() {
        T result = null;
        try {
            result = this.future.get();
        }
        catch (InterruptedException e2) {
            Log.w((String)TAG, (String)("future.get() Interrupted on Thread " + Thread.currentThread().getName()));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            Log.e((String)TAG, (String)"error on execution", (Throwable)e3);
        }
        return result;
    }

    @Override
    @Nullable
    public T get(long timeout, @NonNull TimeUnit unit) {
        T result = null;
        try {
            result = this.future.get(timeout, unit);
        }
        catch (InterruptedException e2) {
            Log.w((String)TAG, (String)("future.get() Interrupted on Thread " + Thread.currentThread().getName()));
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e3) {
            Log.e((String)TAG, (String)"error on execution", (Throwable)e3);
        }
        catch (TimeoutException e4) {
            Log.w((String)TAG, (String)("future.get() Timeout on Thread " + Thread.currentThread().getName()));
        }
        return result;
    }
}

