/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.AdAsset;
import com.vungle.warren.model.AdAssetDBAdapter;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.AdvertisementDBAdapter;
import com.vungle.warren.model.AnalyticUrl;
import com.vungle.warren.model.AnalyticUrlDBAdapter;
import com.vungle.warren.model.CacheBust;
import com.vungle.warren.model.CacheBustDBAdapter;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.CookieDBAdapter;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.PlacementDBAdapter;
import com.vungle.warren.model.Report;
import com.vungle.warren.model.ReportDBAdapter;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.model.SessionDataDBAdapter;
import com.vungle.warren.model.VisionData;
import com.vungle.warren.model.VisionDataDBAdapter;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.persistence.FutureResult;
import com.vungle.warren.persistence.Query;
import com.vungle.warren.utility.FileUtility;
import com.vungle.warren.utility.VungleThreadPoolExecutor;
import com.vungle.warren.vision.VisionAggregationData;
import com.vungle.warren.vision.VisionAggregationInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class Repository {
    private static final String TAG = Repository.class.getSimpleName();
    @VisibleForTesting
    protected DatabaseHelper dbHelper;
    private final VungleThreadPoolExecutor ioExecutor;
    private final ExecutorService uiExecutor;
    private final Designer designer;
    private final Context appCtx;
    @VisibleForTesting
    protected static final int VERSION = 11;
    private Map<Class, DBAdapter> adapters = new HashMap<Class, DBAdapter>();

    public Repository(Context context, Designer designer, VungleThreadPoolExecutor ioExecutor, ExecutorService uiExecutor) {
        this(context, designer, ioExecutor, uiExecutor, 11);
    }

    public Repository(Context context, Designer designer, VungleThreadPoolExecutor ioExecutor, ExecutorService uiExecutor, int version) {
        this.appCtx = context.getApplicationContext();
        this.ioExecutor = ioExecutor;
        this.uiExecutor = uiExecutor;
        this.dbHelper = new DatabaseHelper(context, version, new VungleDatabaseCreator(this.appCtx));
        this.designer = designer;
        this.adapters.put(Placement.class, new PlacementDBAdapter());
        this.adapters.put(Cookie.class, new CookieDBAdapter());
        this.adapters.put(Report.class, new ReportDBAdapter());
        this.adapters.put(Advertisement.class, new AdvertisementDBAdapter());
        this.adapters.put(AdAsset.class, new AdAssetDBAdapter());
        this.adapters.put(VisionData.class, new VisionDataDBAdapter());
        this.adapters.put(AnalyticUrl.class, new AnalyticUrlDBAdapter());
        this.adapters.put(CacheBust.class, new CacheBustDBAdapter());
        this.adapters.put(SessionData.class, new SessionDataDBAdapter());
    }

    public void init() throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Repository.this.dbHelper.init();
                ContentValues contentValues = new ContentValues();
                contentValues.put("state", Integer.valueOf(3));
                Query query = new Query("advertisement");
                query.selection = "state=?";
                query.args = new String[]{String.valueOf(2)};
                Repository.this.dbHelper.update(query, contentValues);
                return null;
            }
        });
    }

    private <T> List<T> loadAllModels(Class<T> tClass) {
        DBAdapter adapter = this.adapters.get(tClass);
        if (adapter == null) {
            return Collections.EMPTY_LIST;
        }
        Cursor cursor = this.dbHelper.query(new Query(adapter.tableName()));
        return this.extractModels(tClass, cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private <T> List<T> extractModels(Class<T> clazz, Cursor cursor) {
        if (cursor == null || cursor.isClosed()) {
            return Collections.emptyList();
        }
        ArrayList items = new ArrayList();
        try {
            DBAdapter adapter = this.adapters.get(clazz);
            while (cursor.moveToNext()) {
                ContentValues values = new ContentValues();
                DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                items.add(adapter.fromContentValues(values));
            }
        }
        catch (Exception e2) {
            VungleLogger.critical(true, Repository.class.getSimpleName(), "extractModels", e2.toString());
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T loadModel(String id2, Class<T> tClass) {
        DBAdapter adapter = this.adapters.get(tClass);
        Query query = new Query(adapter.tableName());
        query.selection = "item_id = ? ";
        query.args = new String[]{id2};
        Cursor cursor = this.dbHelper.query(query);
        if (cursor != null) {
            try {
                if (cursor.moveToNext()) {
                    ContentValues values = new ContentValues();
                    DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                    Object t = adapter.fromContentValues(values);
                    return t;
                }
            }
            catch (Exception e2) {
                VungleLogger.critical(true, Repository.class.getSimpleName(), "loadModel", e2.toString());
                T t = null;
                return t;
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    private <T> void saveModel(T model) throws DatabaseHelper.DBException {
        DBAdapter adapter = this.adapters.get(model.getClass());
        ContentValues contentValues = adapter.toContentValues(model);
        this.dbHelper.insertWithConflict(adapter.tableName(), contentValues, 5);
    }

    public <T> FutureResult<T> load(final @NonNull String id2, final @NonNull Class<T> clazz) {
        return new FutureResult(this.ioExecutor.submit(new Callable<T>(){

            @Override
            public T call() {
                return Repository.this.loadModel(id2, clazz);
            }
        }));
    }

    public <T> void load(final @NonNull String id2, final @NonNull Class<T> clazz, final @NonNull LoadCallback<T> loadCallback) {
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final Object result = Repository.this.loadModel(id2, clazz);
                Repository.this.uiExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        loadCallback.onLoaded(result);
                    }
                });
            }
        });
    }

    public <T> void save(final T item) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Repository.this.saveModel(item);
                return null;
            }
        });
    }

    public <T> void save(final T item, final @Nullable SaveCallback callback, boolean waitForResult) {
        Future<?> future = this.ioExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.this.saveModel(item);
                }
                catch (DatabaseHelper.DBException e2) {
                    Repository.this.onSaveCallbackError(callback, e2);
                    return;
                }
                if (callback != null) {
                    Repository.this.uiExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSaved();
                        }
                    });
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                Repository.this.onSaveCallbackError(callback, new VungleException(39));
            }
        });
        if (waitForResult) {
            try {
                future.get();
            }
            catch (InterruptedException e2) {
                Log.e((String)TAG, (String)"InterruptedException ", (Throwable)e2);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                Log.e((String)TAG, (String)"Error on execution during saving", (Throwable)e3);
            }
        }
    }

    private void onSaveCallbackError(final SaveCallback callback, final Exception e2) {
        if (callback != null) {
            this.uiExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onError(e2);
                }
            });
        }
    }

    public <T> void save(T item, @Nullable SaveCallback callback) {
        this.save(item, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Advertisement> findValidAdvertisementsForPlacementFromDB(String placementId, String eventId) {
        String[] args;
        Log.i((String)TAG, (String)(" Searching for valid advertisement for placement with " + placementId + "event ID " + eventId));
        Query query = new Query("advertisement");
        StringBuilder sb = new StringBuilder().append("placement_id = ? AND ").append("(state = ? OR ").append("state = ?) AND ").append("expire_time > ?");
        if (eventId != null) {
            sb.append(" AND item_id = ?");
            args = new String[]{placementId, String.valueOf(1), String.valueOf(0), String.valueOf(System.currentTimeMillis() / 1000L), eventId};
        } else {
            args = new String[]{placementId, String.valueOf(1), String.valueOf(0), String.valueOf(System.currentTimeMillis() / 1000L)};
        }
        query.selection = sb.toString();
        query.args = args;
        query.orderBy = "state DESC";
        AdvertisementDBAdapter adapter = (AdvertisementDBAdapter)this.adapters.get(Advertisement.class);
        ArrayList<Advertisement> items = new ArrayList<Advertisement>();
        Cursor cursor = this.dbHelper.query(query);
        if (cursor == null) {
            return items;
        }
        try {
            while (adapter != null && cursor.moveToNext()) {
                ContentValues values = new ContentValues();
                DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                items.add(adapter.fromContentValues(values));
            }
        }
        catch (Exception e2) {
            VungleLogger.critical(true, Repository.class.getSimpleName(), "findValidAdvertisementsForPlacementFromDB", e2.toString());
            ArrayList<Advertisement> arrayList = new ArrayList<Advertisement>();
            return arrayList;
        }
        finally {
            cursor.close();
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Advertisement findValidAdvertisementForPlacementFromDB(@NonNull String placementId, @Nullable String eventId) {
        String[] args;
        Log.i((String)TAG, (String)(" Searching for valid advertisement for placement with " + placementId + "event ID " + eventId));
        Query query = new Query("advertisement");
        StringBuilder sb = new StringBuilder().append("placement_id = ? AND ").append("(state = ? OR ").append("state = ?) AND ").append("expire_time > ?");
        if (eventId != null) {
            sb.append(" AND item_id = ?");
            args = new String[]{placementId, String.valueOf(1), String.valueOf(0), String.valueOf(System.currentTimeMillis() / 1000L), eventId};
        } else {
            args = new String[]{placementId, String.valueOf(1), String.valueOf(0), String.valueOf(System.currentTimeMillis() / 1000L)};
        }
        query.selection = sb.toString();
        query.args = args;
        query.limit = "1";
        Advertisement advertisement = null;
        Cursor cursor = this.dbHelper.query(query);
        if (cursor == null) {
            return null;
        }
        try {
            AdvertisementDBAdapter adapter = (AdvertisementDBAdapter)this.adapters.get(Advertisement.class);
            if (adapter != null && cursor.moveToNext()) {
                ContentValues values = new ContentValues();
                DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                advertisement = adapter.fromContentValues(values);
            }
        }
        catch (Exception e2) {
            VungleLogger.critical(true, Repository.class.getSimpleName(), "findValidAdvertisementForPlacementFromDB", e2.toString());
            Advertisement advertisement2 = null;
            return advertisement2;
        }
        finally {
            cursor.close();
        }
        return advertisement;
    }

    public FutureResult<Advertisement> findValidAdvertisementForPlacement(final String placementId, final @Nullable String eventId) {
        return new FutureResult<Advertisement>(this.ioExecutor.submit(new Callable<Advertisement>(){

            @Override
            public Advertisement call() {
                return Repository.this.findValidAdvertisementForPlacementFromDB(placementId, eventId);
            }
        }));
    }

    public FutureResult<Advertisement> findPotentiallyExpiredAd(final String placementId, final String eventId) {
        Log.i((String)TAG, (String)(" Searching for valid advertisement for placement with " + placementId + " event ID " + eventId));
        return new FutureResult<Advertisement>(this.ioExecutor.submit(new Callable<Advertisement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Advertisement call() {
                String[] args;
                Query query = new Query("advertisement");
                StringBuilder sb = new StringBuilder().append("placement_id = ? AND ").append("(state = ? OR ").append("state = ?)");
                if (eventId != null) {
                    sb.append(" AND item_id = ?");
                    args = new String[]{placementId, String.valueOf(1), String.valueOf(0), eventId};
                } else {
                    args = new String[]{placementId, String.valueOf(1), String.valueOf(0)};
                }
                query.selection = sb.toString();
                query.args = args;
                Advertisement advertisement = null;
                Cursor cursor = Repository.this.dbHelper.query(query);
                if (cursor == null) {
                    return null;
                }
                try {
                    AdvertisementDBAdapter adapter = (AdvertisementDBAdapter)Repository.this.adapters.get(Advertisement.class);
                    if (adapter != null && cursor.moveToNext()) {
                        ContentValues values = new ContentValues();
                        DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                        advertisement = adapter.fromContentValues(values);
                    }
                }
                catch (Exception e2) {
                    VungleLogger.critical(true, Repository.class.getSimpleName(), "findPotentiallyExpiredAd", e2.toString());
                    Advertisement advertisement2 = null;
                    return advertisement2;
                }
                finally {
                    cursor.close();
                }
                return advertisement;
            }
        }));
    }

    public FutureResult<List<Advertisement>> findValidAdvertisementsForPlacement(final String placementId, final @Nullable String eventId) {
        return new FutureResult<List<Advertisement>>(this.ioExecutor.submit(new Callable<List<Advertisement>>(){

            @Override
            public List<Advertisement> call() {
                return Repository.this.findValidAdvertisementsForPlacementFromDB(placementId, eventId);
            }
        }));
    }

    public <T> FutureResult<List<T>> loadAll(final Class<T> clazz) {
        return new FutureResult<List<T>>(this.ioExecutor.submit(new Callable<List<T>>(){

            @Override
            public List<T> call() {
                return Repository.this.loadAllModels(clazz);
            }
        }));
    }

    @Nullable
    public FutureResult<List<Report>> loadAllReportToSend() {
        return new FutureResult<List<Report>>(this.ioExecutor.submit(new Callable<List<Report>>(){

            @Override
            public List<Report> call() {
                List sendReports = Repository.this.loadAllModels(Report.class);
                for (Report report : sendReports) {
                    report.setStatus(2);
                    try {
                        Repository.this.saveModel(report);
                    }
                    catch (DatabaseHelper.DBException e2) {
                        return null;
                    }
                }
                return sendReports;
            }
        }));
    }

    @Nullable
    public FutureResult<List<Report>> loadReadyOrFailedReportToSend() {
        return new FutureResult<List<Report>>(this.ioExecutor.submit(new Callable<List<Report>>(){

            @Override
            public List<Report> call() {
                Query query = new Query("report");
                query.selection = "status = ?  OR status = ? ";
                query.args = new String[]{String.valueOf(1), String.valueOf(3)};
                Cursor cursor = Repository.this.dbHelper.query(query);
                List sendReports = Repository.this.extractModels(Report.class, cursor);
                for (Report report : sendReports) {
                    report.setStatus(2);
                    try {
                        Repository.this.saveModel(report);
                    }
                    catch (DatabaseHelper.DBException e2) {
                        return null;
                    }
                }
                return sendReports;
            }
        }));
    }

    public void updateAndSaveReportState(final String placementId, final String appId, final int statusFrom, final int statusTo) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ContentValues contentValues = new ContentValues();
                contentValues.put("status", Integer.valueOf(statusTo));
                Query query = new Query("report");
                query.selection = "placementId = ?  AND status = ?  AND appId = ? ";
                query.args = new String[]{placementId, String.valueOf(statusFrom), appId};
                Repository.this.dbHelper.update(query, contentValues);
                return null;
            }
        });
    }

    public FutureResult<List<AdAsset>> loadAllAdAssets(final @NonNull String adId) {
        return new FutureResult<List<AdAsset>>(this.ioExecutor.submit(new Callable<List<AdAsset>>(){

            @Override
            public List<AdAsset> call() {
                return Repository.this.loadAllAdAssetModels(adId);
            }
        }));
    }

    private List<AdAsset> loadAllAdAssetModels(@NonNull String adId) {
        Query query = new Query("adAsset");
        query.selection = "ad_identifier = ? ";
        query.args = new String[]{adId};
        Cursor cursor = this.dbHelper.query(query);
        return this.extractModels(AdAsset.class, cursor);
    }

    public List<AdAsset> loadAllAdAssetByStatus(@NonNull String adId, int status) {
        Query query = new Query("adAsset");
        query.selection = "ad_identifier = ?  AND file_status = ? ";
        query.args = new String[]{adId, String.valueOf(status)};
        Cursor cursor = this.dbHelper.query(query);
        return this.extractModels(AdAsset.class, cursor);
    }

    public <T> void delete(final T r) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Repository.this.deleteModel(r);
                return null;
            }
        });
    }

    private <T> void deleteModel(Class<T> clazz, String id2) throws DatabaseHelper.DBException {
        DBAdapter adapter = this.adapters.get(clazz);
        Query query = new Query(adapter.tableName());
        query.selection = "item_id=?";
        query.args = new String[]{id2};
        this.dbHelper.delete(query);
    }

    private void deleteAssetForAdId(String adId) throws DatabaseHelper.DBException {
        DBAdapter adapter = this.adapters.get(AdAsset.class);
        Query query = new Query(adapter.tableName());
        query.selection = "ad_identifier=?";
        query.args = new String[]{adId};
        this.dbHelper.delete(query);
    }

    private <T> void deleteModel(T model) throws DatabaseHelper.DBException {
        DBAdapter adapter = this.adapters.get(model.getClass());
        ContentValues contentValues = adapter.toContentValues(model);
        this.deleteModel(model.getClass(), contentValues.getAsString("item_id"));
    }

    public void deleteAdvertisement(final String advertisementId) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Repository.this.deleteAdInternal(advertisementId);
                return null;
            }
        });
    }

    private void deleteAdInternal(String advertisementId) throws DatabaseHelper.DBException {
        if (TextUtils.isEmpty((CharSequence)advertisementId)) {
            return;
        }
        this.deleteAssetForAdId(advertisementId);
        this.deleteModel(Advertisement.class, advertisementId);
        try {
            this.designer.deleteAssets(advertisementId);
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)"IOException ", (Throwable)e2);
        }
    }

    public FutureResult<Collection<Placement>> loadValidPlacements() {
        return new FutureResult<Collection<Placement>>(this.ioExecutor.submit(new Callable<Collection<Placement>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Placement> call() {
                Repository repository = Repository.this;
                synchronized (repository) {
                    Query query = new Query("placement");
                    query.selection = "is_valid = ?";
                    query.args = new String[]{"1"};
                    Cursor cursor = Repository.this.dbHelper.query(query);
                    return Repository.this.extractModels(Placement.class, cursor);
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadValidPlacementIds() {
        Query query = new Query("placement");
        query.selection = "is_valid = ?";
        query.args = new String[]{"1"};
        query.columns = new String[]{"item_id"};
        Cursor cursor = this.dbHelper.query(query);
        ArrayList<String> ids = new ArrayList<String>();
        if (cursor != null) {
            try {
                while (cursor != null && cursor.moveToNext()) {
                    ids.add(cursor.getString(cursor.getColumnIndex("item_id")));
                }
            }
            catch (Exception e2) {
                VungleLogger.critical(true, Repository.class.getSimpleName(), "loadValidPlacementIds", e2.toString());
            }
            finally {
                cursor.close();
            }
        }
        return ids;
    }

    public FutureResult<File> getAdvertisementAssetDirectory(final String id2) {
        return new FutureResult<File>(this.ioExecutor.submit(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return Repository.this.designer.getAssetDirectory(id2);
            }
        }));
    }

    public FutureResult<Collection<String>> getValidPlacementIds() {
        return new FutureResult<Collection<String>>(this.ioExecutor.submit(new Callable<Collection<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<String> call() throws Exception {
                Repository repository = Repository.this;
                synchronized (repository) {
                    return Repository.this.loadValidPlacementIds();
                }
            }
        }));
    }

    public FutureResult<List<String>> getAvailableBidTokens(final @Nullable String placementId, final int maxNumberOfBytes, final int commaDelimiterBytePadding) {
        return new FutureResult<List<String>>(this.ioExecutor.submit(new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public List<String> call() {
                Repository repository = Repository.this;
                synchronized (repository) {
                    Query query = new Query("advertisement");
                    String selection = "bid_token != '' AND ( state = ? OR state = ? ) AND expire_time > ?";
                    if (!TextUtils.isEmpty((CharSequence)placementId)) {
                        selection = selection + " AND placement_id = ?";
                    }
                    query.selection = selection;
                    query.columns = new String[]{"bid_token"};
                    String[] arguments = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(System.currentTimeMillis() / 1000L)};
                    if (!TextUtils.isEmpty((CharSequence)placementId)) {
                        arguments = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(System.currentTimeMillis() / 1000L), placementId};
                    }
                    query.args = arguments;
                    Cursor cursor = Repository.this.dbHelper.query(query);
                    ArrayList<String> bidTokens = new ArrayList<String>();
                    int sizeOfTokens = 0;
                    if (cursor == null) return bidTokens;
                    try {
                        while (cursor.moveToNext() && sizeOfTokens < maxNumberOfBytes) {
                            int bidTokenColumnIndex = cursor.getColumnIndex("bid_token");
                            String bidToken = cursor.getString(bidTokenColumnIndex);
                            if (sizeOfTokens + bidToken.getBytes().length > maxNumberOfBytes) continue;
                            sizeOfTokens += bidToken.getBytes().length + commaDelimiterBytePadding;
                            bidTokens.add(bidToken);
                        }
                    }
                    catch (Exception e2) {
                        ArrayList<String> arrayList;
                        try {
                            VungleLogger.critical(true, Repository.class.getSimpleName(), "getAvailableBidTokens", e2.toString());
                            arrayList = new ArrayList<String>();
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            throw throwable;
                        }
                        cursor.close();
                        return arrayList;
                    }
                    cursor.close();
                    return bidTokens;
                }
            }
        }));
    }

    public void setValidPlacements(final @NonNull List<Placement> placements) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                Class<Repository> clazz = Repository.class;
                synchronized (Repository.class) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("is_valid", Boolean.valueOf(false));
                    Repository.this.dbHelper.update(new Query("placement"), contentValues);
                    for (Placement placement : placements) {
                        Placement disk = (Placement)Repository.this.loadModel(placement.getId(), Placement.class);
                        if (disk != null && (disk.isIncentivized() != placement.isIncentivized() || disk.isHeaderBidding() != placement.isHeaderBidding())) {
                            Log.w((String)TAG, (String)("Placements data for " + placement.getId() + " is different from disc, deleting old"));
                            List adIds = Repository.this.getAdsForPlacement(placement.getId());
                            for (String id2 : adIds) {
                                Repository.this.deleteAdInternal(id2);
                            }
                            Repository.this.deleteModel(Placement.class, disk.getId());
                        }
                        if (disk != null) {
                            placement.setWakeupTime(disk.getWakeupTime());
                            placement.setAdSize(disk.getAdSize());
                        }
                        placement.setValid(placement.getPlacementAdType() != 2);
                        if (placement.getMaxHbCache() == Integer.MIN_VALUE) {
                            placement.setValid(false);
                        }
                        Repository.this.saveModel(placement);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
        });
    }

    public FutureResult<List<String>> findAdsForPlacement(final String placementId) {
        return new FutureResult<List<String>>(this.ioExecutor.submit(new Callable<List<String>>(){

            @Override
            public List<String> call() {
                return Repository.this.getAdsForPlacement(placementId);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAdsForPlacement(String id2) {
        Query query = new Query("advertisement");
        query.columns = new String[]{"item_id"};
        query.selection = "placement_id=?";
        query.args = new String[]{id2};
        ArrayList<String> ids = new ArrayList<String>();
        Cursor cursor = this.dbHelper.query(query);
        if (cursor == null) {
            return ids;
        }
        try {
            while (cursor.moveToNext()) {
                ids.add(cursor.getString(cursor.getColumnIndex("item_id")));
            }
        }
        catch (Exception e2) {
            VungleLogger.critical(true, Repository.class.getSimpleName(), "getAdsForPlacement", e2.toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            cursor.close();
        }
        return ids;
    }

    public List<Advertisement> getAdsByCreative(Collection<String> creativeIds) {
        HashSet<String> idsSet = new HashSet<String>(creativeIds);
        HashSet<Advertisement> advertisements = new HashSet<Advertisement>();
        List<Advertisement> allModels = this.loadAllModels(Advertisement.class);
        for (Advertisement advertisement : allModels) {
            if (!idsSet.contains(advertisement.getCreativeId())) continue;
            advertisements.add(advertisement);
        }
        return new ArrayList<Advertisement>(advertisements);
    }

    public List<Advertisement> getAdsByCreative(String creativeId) {
        return this.getAdsByCreative(Collections.singletonList(creativeId));
    }

    public List<Advertisement> getAdsByCampaign(Collection<String> campaignIds) {
        HashSet<String> idsSet = new HashSet<String>(campaignIds);
        HashSet<Advertisement> advertisements = new HashSet<Advertisement>();
        List<Advertisement> allModels = this.loadAllModels(Advertisement.class);
        for (Advertisement advertisement : allModels) {
            if (!idsSet.contains(advertisement.getCampaignId())) continue;
            advertisements.add(advertisement);
        }
        return new ArrayList<Advertisement>(advertisements);
    }

    public List<Advertisement> getAdsByCampaign(String campaignId) {
        return this.getAdsByCampaign(Collections.singletonList(campaignId));
    }

    public String getPlacementIdByAd(Advertisement advertisement) {
        return advertisement.getPlacementId();
    }

    public List<CacheBust> getUnProcessedBusts() {
        List<CacheBust> cacheBusts = this.loadAllModels(CacheBust.class);
        ArrayList<CacheBust> unProcessedBusts = new ArrayList<CacheBust>();
        for (CacheBust bust : cacheBusts) {
            if (bust.getTimestampProcessed() != 0L) continue;
            unProcessedBusts.add(bust);
        }
        return unProcessedBusts;
    }

    public void clearAllData() {
        this.dbHelper.dropDb();
        this.designer.clearCache();
    }

    public void close() {
        this.dbHelper.close();
    }

    public void saveAndApplyState(final @NonNull Advertisement advertisement, final @NonNull String placementId, final @Advertisement.State int state) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Log.i((String)TAG, (String)("Setting " + state + " for adv " + advertisement.getId() + " and pl " + placementId));
                advertisement.setState(state);
                switch (state) {
                    case 0: 
                    case 1: 
                    case 5: {
                        advertisement.setPlacementId(placementId);
                        Repository.this.saveModel(advertisement);
                        break;
                    }
                    case 2: {
                        advertisement.setPlacementId(null);
                        Repository.this.saveModel(advertisement);
                        break;
                    }
                    case 3: 
                    case 4: {
                        Repository.this.deleteAdInternal(advertisement.getId());
                    }
                }
                return null;
            }
        });
    }

    public void trimVisionData(final int size) throws DatabaseHelper.DBException {
        this.runAndWait(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Query query = new Query("vision_data");
                query.selection = "_id <= ( SELECT MAX( _id ) FROM vision_data ) - ?";
                query.args = new String[]{Integer.toString(size)};
                Repository.this.dbHelper.delete(query);
                return null;
            }
        });
    }

    public FutureResult<VisionAggregationInfo> getVisionAggregationInfo(final long after) {
        return new FutureResult<VisionAggregationInfo>(this.ioExecutor.submit(new Callable<VisionAggregationInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VisionAggregationInfo call() {
                Query query = new Query("vision_data");
                query.selection = "timestamp >= ?";
                query.orderBy = "_id DESC";
                query.args = new String[]{Long.toString(after)};
                Cursor cursor = Repository.this.dbHelper.query(query);
                VisionDataDBAdapter adapter = (VisionDataDBAdapter)Repository.this.adapters.get(VisionData.class);
                if (cursor != null) {
                    try {
                        if (adapter != null && cursor.moveToFirst()) {
                            ContentValues values = new ContentValues();
                            DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                            VisionData data = adapter.fromContentValues(values);
                            VisionAggregationInfo visionAggregationInfo = new VisionAggregationInfo(cursor.getCount(), data.creative);
                            return visionAggregationInfo;
                        }
                    }
                    catch (Exception e2) {
                        VungleLogger.critical(true, Repository.class.getSimpleName(), "getVisionAggregationInfo", e2.toString());
                        VisionAggregationInfo visionAggregationInfo = null;
                        return visionAggregationInfo;
                    }
                    finally {
                        cursor.close();
                    }
                }
                return null;
            }
        }));
    }

    public FutureResult<List<VisionAggregationData>> getVisionAggregationData(final long after, final int limit, final String filter) {
        return new FutureResult<List<VisionAggregationData>>(this.ioExecutor.submit(new Callable<List<VisionAggregationData>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<VisionAggregationData> call() {
                ArrayList<VisionAggregationData> list = new ArrayList<VisionAggregationData>();
                if (!("advertiser".equals(filter) || "campaign".equals(filter) || "creative".equals(filter))) {
                    return list;
                }
                String viewCount = "viewCount";
                String lastTimeStamp = "lastTimeStamp";
                Query query = new Query("vision_data");
                query.columns = new String[]{"COUNT ( * ) as viewCount", "MAX ( timestamp ) as lastTimeStamp", filter};
                query.selection = "timestamp >= ?";
                query.groupBy = filter;
                query.orderBy = "_id DESC";
                query.limit = Integer.toString(limit);
                query.args = new String[]{Long.toString(after)};
                Cursor cursor = Repository.this.dbHelper.query(query);
                if (cursor != null) {
                    try {
                        while (cursor.moveToNext()) {
                            ContentValues values = new ContentValues();
                            DatabaseUtils.cursorRowToContentValues((Cursor)cursor, (ContentValues)values);
                            list.add(new VisionAggregationData(values.getAsString(filter), values.getAsInteger("viewCount"), values.getAsLong("lastTimeStamp")));
                        }
                    }
                    catch (Exception e2) {
                        VungleLogger.critical(true, Repository.class.getSimpleName(), "getVisionAggregationInfo", e2.toString());
                        ArrayList<VisionAggregationData> arrayList = new ArrayList<VisionAggregationData>();
                        return arrayList;
                    }
                    finally {
                        cursor.close();
                    }
                }
                return list;
            }
        }));
    }

    private void runAndWait(Callable<Void> callable) throws DatabaseHelper.DBException {
        try {
            this.ioExecutor.submit(callable).get();
        }
        catch (ExecutionException e2) {
            if (e2.getCause() instanceof DatabaseHelper.DBException) {
                throw (DatabaseHelper.DBException)e2.getCause();
            }
            Log.e((String)TAG, (String)"Exception during runAndWait", (Throwable)e2);
        }
        catch (InterruptedException e3) {
            Log.e((String)TAG, (String)"InterruptedException ", (Throwable)e3);
            Thread.currentThread().interrupt();
        }
    }

    public <T> void deleteAll(Class<T> clazz) {
        if (clazz == Advertisement.class) {
            List<Advertisement> advertisements = this.loadAll(Advertisement.class).get();
            for (Advertisement advertisement : advertisements) {
                try {
                    this.deleteAdvertisement(advertisement.getId());
                }
                catch (DatabaseHelper.DBException e2) {
                    Log.e((String)TAG, (String)"DB Exception deleting advertisement", (Throwable)e2);
                }
            }
        } else {
            List<T> items = this.loadAll(clazz).get();
            for (T item : items) {
                try {
                    this.deleteModel(item);
                }
                catch (DatabaseHelper.DBException e3) {
                    Log.e((String)TAG, (String)"DB Exception deleting db entry", (Throwable)e3);
                }
            }
        }
    }

    @VisibleForTesting
    public void setMockDBHelper(DatabaseHelper helper) {
        this.dbHelper = helper;
    }

    private static class VungleDatabaseCreator
    implements DatabaseHelper.DatabaseFactory {
        private final Context context;

        public VungleDatabaseCreator(Context context) {
            this.context = context;
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (oldVersion < 2) {
                db.execSQL("ALTER TABLE report ADD COLUMN status INTEGER DEFAULT 1");
            }
            if (oldVersion < 3) {
                db.execSQL("CREATE TABLE IF NOT EXISTS vision_data(_id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp NUMERIC, creative TEXT, campaign TEXT, advertiser TEXT )");
                db.execSQL("ALTER TABLE report ADD COLUMN ad_size TEXT ");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN tt_download NUMERIC DEFAULT -1");
                db.execSQL("ALTER TABLE placement ADD COLUMN ad_size TEXT ");
                db.execSQL("ALTER TABLE placement ADD COLUMN refresh_duration NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE placement ADD COLUMN supported_template_types NUMERIC DEFAULT 0");
            }
            if (oldVersion < 4) {
                db.execSQL("ALTER TABLE placement ADD COLUMN header_bidding SHORT ");
                db.execSQL("ALTER TABLE report ADD COLUMN header_bidding SHORT ");
            }
            if (oldVersion < 5) {
                db.execSQL("ALTER TABLE placement ADD COLUMN autocache_priority NUMERIC DEFAULT 2147483647");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN asset_download_timestamp NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN asset_download_duration NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN ad_request_start_time NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE report ADD COLUMN init_timestamp NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE report ADD COLUMN asset_download_duration NUMERIC DEFAULT 0");
            }
            if (oldVersion < 6) {
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_enable_om_sdk NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_om_sdk_extra_vast TEXT ");
            }
            if (oldVersion < 7) {
                db.execSQL("CREATE TABLE IF NOT EXISTS analytic_url(_id INTEGER PRIMARY KEY AUTOINCREMENT,  item_id TEXT UNIQUE)");
            }
            if (oldVersion < 8) {
                db.execSQL("CREATE TABLE IF NOT EXISTS cache_bust(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, id TEXT, time_window_end INTEGER, id_type INTEGER, event_ids TEXT, timestamp_processed INTEGER )");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_request_timestamp NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE placement ADD COLUMN max_hb_cache NUMERIC DEFAULT 0");
                db.execSQL("ALTER TABLE placement ADD COLUMN recommended_ad_size TEXT ");
            }
            if (oldVersion < 9) {
                db.execSQL("ALTER TABLE report ADD COLUMN play_remote_url SHORT DEFAULT 0");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_assets_fully_downloaded SHORT DEFAULT 0");
            }
            if (oldVersion < 10) {
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_click_coordinates_enabled SHORT DEFAULT 0");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_deep_link TEXT ");
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_notifications TEXT ");
            }
            if (oldVersion < 11) {
                db.execSQL("ALTER TABLE advertisement ADD COLUMN column_header_bidding SHORT DEFAULT 0");
            }
        }

        @Override
        public void create(SQLiteDatabase db) {
            this.dropOldFilesData();
            db.execSQL("CREATE TABLE IF NOT EXISTS advertisement(_id INTEGER PRIMARY KEY AUTOINCREMENT,  item_id TEXT UNIQUE, ad_config TEXT,ad_type INT, expire_time NUMERIC, delay NUMERIC, show_close_delay INT, show_close_incentivized INT, countdown INT, video_height INT, video_width INT, cta_overlay_enabled SHORT, cta_click_area NUMERIC, retry_count INT, requires_non_market_install SHORT, app_id TEXT, campaign TEXT, video_url TEXT, md5 TEXT, postroll_bundle_url TEXT, cta_destination_url TEXT, cta_url TEXT, ad_token TEXT, video_identifier TEXT, template_url TEXT, TEMPLATE_ID TEXT, TEMPLATE_TYPE TEXT, ad_market_id TEXT,bid_token TEXT,  checkpoints TEXT, template_settings TEXT, mraid_files TEXT, cacheable_assets TEXT, state INT, placement_id TEXT, tt_download NUMERIC,asset_download_timestamp NUMERIC,asset_download_duration NUMERIC,ad_request_start_time NUMERIC,column_enable_om_sdk SHORT,column_om_sdk_extra_vast TEXT,column_request_timestamp NUMERIC,column_click_coordinates_enabled SHORT,dynamic_events_and_urls TEXT, column_deep_link TEXT, column_notifications TEXT, column_assets_fully_downloaded SHORT, column_header_bidding SHORT)");
            db.execSQL("CREATE TABLE IF NOT EXISTS placement(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, incentivized SHORT, auto_cached SHORT, is_valid SHORT, wakeup_time NUMERIC, header_bidding SHORT, refresh_duration NUMERIC, supported_template_types NUMERIC, ad_size TEXT, autocache_priority NUMERIC, max_hb_cache NUMERIC, recommended_ad_size TEXT)");
            db.execSQL("CREATE TABLE IF NOT EXISTS cookie(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, bools TEXT, ints TEXT, longs TEXT, strings TEXT )");
            db.execSQL("CREATE TABLE IF NOT EXISTS report(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE,appId TEXT, placementId TEXT, adToken TEXT, incentivized SHORT, header_bidding SHORT, adStartTime NUMERIC, url TEXT, ad_duration NUMERIC, tt_download NUMERIC, campaign TEXT, videoViewed NUMERIC, ad_type TEXT, template_id TEXT, was_CTAC_licked SHORT, clicked_through TEXT, errors TEXT, user_actions TEXT, user_id TEXT, ordinal INT, videoLength NUMERIC, status INT, ad_size TEXT, init_timestamp NUMERIC, asset_download_duration NUMERIC,play_remote_url SHORT )");
            db.execSQL("CREATE TABLE IF NOT EXISTS adAsset ( _id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, paren_id TEXT , ad_identifier TEXT NOT NULL, server_path TEXT, local_path TEXT NOT NULL, file_status SHORT, file_type SHORT, file_size INT, retry_count SHORT, retry_error SHORT, unique ( local_path, ad_identifier ));");
            db.execSQL("CREATE TABLE IF NOT EXISTS vision_data(_id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp NUMERIC, creative TEXT, campaign TEXT, advertiser TEXT )");
            db.execSQL("CREATE TABLE IF NOT EXISTS analytic_url(_id INTEGER PRIMARY KEY AUTOINCREMENT,  item_id TEXT UNIQUE)");
            db.execSQL("CREATE TABLE IF NOT EXISTS cache_bust(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, id TEXT, time_window_end INTEGER, id_type INTEGER, event_ids TEXT, timestamp_processed INTEGER )");
            db.execSQL("CREATE TABLE IF NOT EXISTS session_data(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE,json_string TEXT, send_attempts INT)");
        }

        @Override
        public void deleteData(SQLiteDatabase db) {
            db.execSQL("DROP TABLE IF EXISTS advertisement");
            db.execSQL("DROP TABLE IF EXISTS cookie");
            db.execSQL("DROP TABLE IF EXISTS placement");
            db.execSQL("DROP TABLE IF EXISTS report");
            db.execSQL("DROP TABLE IF EXISTS adAsset");
            db.execSQL("DROP TABLE IF EXISTS vision_data");
            db.execSQL("DROP TABLE IF EXISTS analytic_url");
            db.execSQL("DROP TABLE IF EXISTS cache_bust");
            db.execSQL("DROP TABLE IF EXISTS session_data");
        }

        @Override
        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            ArrayList<String> names = new ArrayList<String>();
            Cursor cursor = db.rawQuery("SELECT * FROM sqlite_master WHERE type='table'", null);
            while (cursor != null && cursor.moveToNext()) {
                String tableName = cursor.getString(1);
                if (tableName.equals("android_metadata") || tableName.startsWith("sqlite_")) continue;
                names.add(tableName);
            }
            if (cursor != null) {
                cursor.close();
            }
            for (String name : names) {
                db.execSQL("DROP TABLE IF EXISTS " + name);
            }
            this.create(db);
        }

        private void deleteDatabase(String dbName) {
            this.context.deleteDatabase(dbName);
        }

        private void dropOldFilesData() {
            File file;
            boolean canUseExternal;
            this.deleteDatabase("vungle");
            File external = this.context.getExternalFilesDir(null);
            boolean bl = canUseExternal = Environment.getExternalStorageState().equals("mounted") && external != null;
            if (canUseExternal && external.exists()) {
                File oldData = new File(external, ".vungle");
                try {
                    FileUtility.delete(oldData);
                }
                catch (IOException e2) {
                    Log.e((String)TAG, (String)"IOException ", (Throwable)e2);
                }
            }
            if ((file = this.context.getFilesDir()).exists()) {
                File oldData = new File(file, "vungle");
                try {
                    FileUtility.delete(oldData);
                }
                catch (IOException e3) {
                    Log.e((String)TAG, (String)"IOException ", (Throwable)e3);
                }
            }
            try {
                FileUtility.delete(new File(this.context.getCacheDir() + File.separator + "downloads_vungle"));
            }
            catch (IOException e4) {
                Log.e((String)TAG, (String)"IOException ", (Throwable)e4);
            }
        }
    }

    public static interface SaveCallback {
        public void onSaved();

        public void onError(Exception var1);
    }

    public static interface LoadCallback<T> {
        public void onLoaded(T var1);
    }
}

