/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;

public class AnalyticsJob
implements Job {
    public static final String TAG = AnalyticsJob.class.getSimpleName();
    public static final String EXTRA_ACTION = "action_extra";
    private static final String EXTRA_BODY = "extra_body";
    private static final String EXTRA_URLS = "extra_urls";
    private static final long DEFAULT_DELAY = 2000L;
    private final AdAnalytics adAnalytics;

    public static JobInfo makeJob(@Action int action, String body, String[] urls, @JobInfo.NetworkType int networkType) {
        Bundle extras = new Bundle();
        extras.putInt(EXTRA_ACTION, action);
        extras.putString(EXTRA_BODY, body);
        extras.putStringArray(EXTRA_URLS, urls);
        return new JobInfo(TAG).setUpdateCurrent(false).setExtras(extras).setReschedulePolicy(2000L, 1).setRequiredNetworkType(networkType).setPriority(5);
    }

    public AnalyticsJob(AdAnalytics adAnalytics) {
        this.adAnalytics = adAnalytics;
    }

    @Override
    public int onRunJob(Bundle bundle, JobRunner jobRunner) {
        String[] urls;
        int action = bundle.getInt(EXTRA_ACTION, -1);
        if (action == 0) {
            String body = bundle.getString(EXTRA_BODY);
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson(body, JsonElement.class);
            JsonObject jsonObj = element.getAsJsonObject();
            this.adAnalytics.ri(jsonObj);
        } else if (action == 1) {
            String[] failed;
            String[] urls2 = bundle.getStringArray(EXTRA_URLS);
            if (urls2 != null && (failed = this.adAnalytics.ping(urls2)).length != 0) {
                bundle.putStringArray(EXTRA_URLS, failed);
                return 2;
            }
        } else if (action == 2) {
            String[] failed = this.adAnalytics.retryUnsent();
            if (failed.length != 0) {
                bundle.putStringArray(EXTRA_URLS, failed);
                return 2;
            }
        } else if (action == 3 && (urls = bundle.getStringArray(EXTRA_URLS)) != null) {
            this.adAnalytics.saveVungleUrls(urls);
        }
        return 0;
    }

    public static @interface Action {
        public static final int RI = 0;
        public static final int PING = 1;
        public static final int RETRY_UNSENT = 2;
        public static final int STORE_URL = 3;
    }
}

