/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.LocalAdContract;
import com.vungle.warren.ui.presenter.LocalAdPresenter;
import com.vungle.warren.ui.view.BaseAdView;
import com.vungle.warren.ui.view.FullAdWidget;
import java.io.File;

public class LocalAdView
extends BaseAdView<LocalAdPresenter>
implements LocalAdContract.LocalView,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private LocalAdContract.LocalPresenter presenter;
    private boolean muted = false;
    private MediaPlayer mediaPlayer;
    private boolean ctaClickAreaEnabled = false;
    private Runnable reportProgress;
    private Handler handler = new Handler(Looper.getMainLooper());
    private FullAdWidget.OnItemClickListener clickListener = new FullAdWidget.OnItemClickListener(){

        @Override
        public void onItemClicked(int code) {
            switch (code) {
                case 4: {
                    LocalAdView.this.presenter.onPrivacy();
                    break;
                }
                case 1: {
                    LocalAdView.this.presenter.handleExit();
                    break;
                }
                case 2: {
                    LocalAdView.this.presenter.onDownload();
                    break;
                }
                case 5: {
                    if (!LocalAdView.this.ctaClickAreaEnabled) break;
                    LocalAdView.this.presenter.onDownload();
                    break;
                }
                case 3: {
                    if (LocalAdView.this.mediaPlayer == null) break;
                    LocalAdView.this.muteAudio();
                    LocalAdView.this.presenter.onMute(LocalAdView.this.muted);
                    LocalAdView.this.view.setMuted(LocalAdView.this.muted);
                }
            }
        }
    };

    public LocalAdView(@NonNull Context context, @NonNull FullAdWidget view, @NonNull OrientationDelegate orientationDelegate, @NonNull CloseDelegate closeDelegate) {
        super(context, view, orientationDelegate, closeDelegate);
        this.attachListeners();
    }

    private void attachListeners() {
        this.view.setOnItemClickListener(this.clickListener);
        this.view.setOnPreparedListener(this);
        this.view.setOnErrorListener(this);
    }

    @Override
    public void showCTAOverlay(boolean ctaOverlayEnabled, boolean ctaClickAreaEnabled) {
        this.ctaClickAreaEnabled = ctaClickAreaEnabled;
        this.view.setCtaEnabled(ctaOverlayEnabled && ctaClickAreaEnabled);
    }

    @Override
    public void playVideo(@NonNull File file, boolean startMuted, int videoPosition) {
        boolean bl = this.muted = this.muted || startMuted;
        if (file != null) {
            this.setupPlayerProgressBar();
            this.view.playVideo(Uri.fromFile((File)file), videoPosition);
            this.view.setMuted(this.muted);
            if (this.muted) {
                this.presenter.onMute(this.muted);
            }
        }
    }

    @Override
    public void pauseVideo() {
        this.view.pausePlayback();
        if (this.reportProgress != null) {
            this.handler.removeCallbacks(this.reportProgress);
        }
    }

    @Override
    public boolean isVideoPlaying() {
        return this.view.isVideoPlaying();
    }

    @Override
    public int getVideoPosition() {
        return this.view.getCurrentVideoPosition();
    }

    @Override
    public void setPresenter(@NonNull LocalAdPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showWebsite(@NonNull String url) {
        this.view.stopPlayback();
        this.view.showWebsite(url);
        this.handler.removeCallbacks(this.reportProgress);
        this.mediaPlayer = null;
    }

    private void muteAudio() {
        if (this.mediaPlayer == null) {
            return;
        }
        this.muted = !this.muted;
        this.switchMuteState();
    }

    private void switchMuteState() {
        if (this.mediaPlayer != null) {
            try {
                float volume = this.muted ? 0.0f : 1.0f;
                this.mediaPlayer.setVolume(volume, volume);
            }
            catch (IllegalStateException e2) {
                Log.i((String)this.TAG, (String)"Exception On Mute/Unmute", (Throwable)e2);
            }
        }
    }

    private void setupPlayerProgressBar() {
        this.reportProgress = new Runnable(){
            float duration = -2.0f;

            @Override
            public void run() {
                try {
                    if (LocalAdView.this.view.isVideoPlaying()) {
                        int currentPosition = LocalAdView.this.view.getCurrentVideoPosition();
                        int currentDuration = LocalAdView.this.view.getVideoDuration();
                        if (currentDuration > 0) {
                            if (this.duration == -2.0f) {
                                this.duration = currentDuration;
                            }
                            LocalAdView.this.presenter.onProgressUpdate(currentPosition, this.duration);
                            LocalAdView.this.view.setProgress(currentPosition, this.duration);
                        }
                    }
                    LocalAdView.this.handler.postDelayed((Runnable)this, 1000L);
                }
                catch (IllegalStateException released) {
                    Log.v((String)LocalAdView.this.TAG, (String)"IllegalStateException while reporting progress indicates activity was killed via SIGKILL.");
                }
            }
        };
        this.handler.post(this.reportProgress);
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        StringBuilder description = new StringBuilder(30);
        switch (what) {
            case 100: {
                description.append("MEDIA_ERROR_SERVER_DIED");
                break;
            }
            case 1: {
                description.append("MEDIA_ERROR_UNKNOWN");
                break;
            }
            default: {
                description.append("UNKNOWN");
            }
        }
        description.append(':');
        switch (extra) {
            case -1004: {
                description.append("MEDIA_ERROR_IO");
                break;
            }
            case -1007: {
                description.append("MEDIA_ERROR_MALFORMED");
                break;
            }
            case 200: {
                description.append("MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK");
                break;
            }
            case -1010: {
                description.append("MEDIA_ERROR_UNSUPPORTED");
                break;
            }
            case -110: {
                description.append("MEDIA_ERROR_TIMED_OUT");
                break;
            }
            default: {
                description.append("MEDIA_ERROR_SYSTEM");
            }
        }
        this.presenter.onMediaError(description.toString());
        return true;
    }

    public void onPrepared(MediaPlayer mp) {
        this.mediaPlayer = mp;
        this.switchMuteState();
        this.view.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                Log.d((String)LocalAdView.this.TAG, (String)"mediaplayer onCompletion");
                if (LocalAdView.this.reportProgress != null) {
                    LocalAdView.this.handler.removeCallbacks(LocalAdView.this.reportProgress);
                }
                LocalAdView.this.presenter.onProgressUpdate(mp.getDuration(), mp.getDuration());
            }
        });
        this.presenter.onVideoStart(this.getVideoPosition(), mp.getDuration());
        this.setupPlayerProgressBar();
    }

    @Override
    public void close() {
        super.close();
        this.handler.removeCallbacksAndMessages(null);
    }
}

