/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.NativeAdLayout;
import com.vungle.warren.ui.PresenterAdOpenCallback;
import com.vungle.warren.ui.contract.NativeAdContract;
import com.vungle.warren.ui.presenter.NativeAdPresenter;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.ExternalRouter;
import java.util.concurrent.atomic.AtomicReference;

public class NativeAdView
implements NativeAdContract.NativeView,
NativeAdLayout.OnItemClickListener {
    private static final String TAG = NativeAdView.class.getSimpleName();
    private final Context context;
    private final NativeAdLayout view;
    private NativeAdContract.NativePresenter presenter;
    private Dialog currentDialog;

    public NativeAdView(@NonNull Context context, @NonNull NativeAdLayout view) {
        this.context = context;
        this.view = view;
        view.setOnItemClickListener(this);
    }

    @Override
    public void setPresenter(@NonNull NativeAdPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setOrientation(int orientation) {
    }

    @Override
    public void showWebsite(@NonNull String url) {
    }

    @Override
    public String getWebsiteUrl() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public void showCloseButton() {
    }

    @Override
    public void open(String deeplinkUrl, @NonNull String url, ActivityManager.LeftApplicationCallback leftApplicationCallback, PresenterAdOpenCallback adOpenCallback) {
        if (!ExternalRouter.launch(deeplinkUrl, url, this.context, leftApplicationCallback, true, adOpenCallback)) {
            Log.e((String)TAG, (String)("Cannot open url " + url));
        }
    }

    @Override
    public void showDialog(@Nullable String dialogTitle, @Nullable String dialogBody, @NonNull String dialogContinue, @NonNull String dialogClose, final @Nullable DialogInterface.OnClickListener responseListener) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, this.context.getApplicationInfo().theme));
        DialogInterface.OnDismissListener dismissListener = this.getDialogDismissListener();
        DialogInterface.OnClickListener onClickListenerProxy = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                NativeAdView.this.currentDialog = null;
                if (responseListener != null) {
                    responseListener.onClick(dialog, which);
                }
            }
        };
        DialogClickListenerProxy listener = new DialogClickListenerProxy(onClickListenerProxy, dismissListener);
        if (!TextUtils.isEmpty((CharSequence)dialogTitle)) {
            dialogBuilder.setTitle((CharSequence)dialogTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)dialogBody)) {
            dialogBuilder.setMessage((CharSequence)dialogBody);
        }
        dialogBuilder.setPositiveButton((CharSequence)dialogContinue, (DialogInterface.OnClickListener)listener);
        dialogBuilder.setNegativeButton((CharSequence)dialogClose, (DialogInterface.OnClickListener)listener);
        dialogBuilder.setCancelable(false);
        this.currentDialog = dialogBuilder.create();
        listener.autoRelease(this.currentDialog);
        this.currentDialog.show();
    }

    @NonNull
    protected DialogInterface.OnDismissListener getDialogDismissListener() {
        return new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                NativeAdView.this.currentDialog = null;
            }
        };
    }

    @Override
    public void setImmersiveMode() {
    }

    @Override
    public void resumeWeb() {
    }

    @Override
    public void pauseWeb() {
    }

    @Override
    public void removeWebView() {
    }

    @Override
    public boolean hasWebView() {
        return false;
    }

    @Override
    public void destroyAdView(long webViewDestroyDelay) {
        this.view.release();
    }

    @Override
    public void refreshDialogIfVisible() {
        if (this.isDialogVisible()) {
            this.currentDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    NativeAdView.this.currentDialog.setOnDismissListener(NativeAdView.this.getDialogDismissListener());
                }
            });
            this.currentDialog.dismiss();
            this.currentDialog.show();
        }
    }

    @Override
    public boolean isDialogVisible() {
        return this.currentDialog != null;
    }

    @Override
    public void onItemClicked(int code) {
        switch (code) {
            case 2: {
                this.presenter.onPrivacy();
                break;
            }
            case 1: {
                this.presenter.onDownload();
            }
        }
    }

    private static class DialogClickListenerProxy
    implements DialogInterface.OnClickListener,
    DialogInterface.OnDismissListener {
        private final AtomicReference<DialogInterface.OnClickListener> ckickRef = new AtomicReference();
        private final AtomicReference<DialogInterface.OnDismissListener> dismissRef = new AtomicReference();

        public DialogClickListenerProxy(DialogInterface.OnClickListener onClickListener, DialogInterface.OnDismissListener onDismissListener) {
            this.ckickRef.set(onClickListener);
            this.dismissRef.set(onDismissListener);
        }

        public void onClick(DialogInterface dialog, int which) {
            dialog.dismiss();
            DialogInterface.OnClickListener base = this.ckickRef.get();
            if (base != null) {
                base.onClick(dialog, which);
            }
        }

        private void autoRelease(Dialog dialog) {
            dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        }

        public void onDismiss(DialogInterface dialog) {
            DialogInterface.OnDismissListener base = this.dismissRef.get();
            if (base != null) {
                base.onDismiss(dialog);
            }
            this.dismissRef.set(null);
            this.ckickRef.set(null);
        }
    }
}

