/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.view;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.view.ViewParent;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdRequest;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.JavascriptBridge;
import com.vungle.warren.ui.PresenterAdOpenCallback;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.WebAdContract;
import com.vungle.warren.ui.view.OnViewTouchListener;
import com.vungle.warren.ui.view.VungleWebClient;
import com.vungle.warren.ui.view.WebSettingsUtils;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.ExternalRouter;
import com.vungle.warren.utility.HandlerScheduler;
import java.util.concurrent.atomic.AtomicReference;

public class VungleBannerView
extends WebView
implements WebAdContract.WebAdView {
    private static final String TAG = VungleBannerView.class.getName();
    private WebAdContract.WebAdPresenter presenter;
    private BroadcastReceiver broadcastReceiver;
    private final AdContract.AdvertisementPresenter.EventListener listener;
    private final AdRequest request;
    private final AdConfig config;
    PresentationFactory presenterFactory;
    private AtomicReference<Boolean> isAdVisible = new AtomicReference();
    private boolean destroyed;
    private OnViewTouchListener onViewTouchListener = new OnViewTouchListener(){

        @Override
        public boolean onTouch(MotionEvent event) {
            if (VungleBannerView.this.presenter != null) {
                VungleBannerView.this.presenter.onViewTouched(event);
            }
            return false;
        }
    };

    public void onResume() {
        super.onResume();
        Log.d((String)TAG, (String)"Resuming Flex");
        this.setAdVisibility(true);
    }

    public void onPause() {
        super.onPause();
        this.setAdVisibility(false);
    }

    public VungleBannerView(@NonNull Context context, @NonNull AdRequest request, @Nullable AdConfig config, @NonNull PresentationFactory presentationFactory, @NonNull AdContract.AdvertisementPresenter.EventListener listener) {
        super(context);
        this.listener = listener;
        this.request = request;
        this.config = config;
        this.presenterFactory = presentationFactory;
        this.setLayerType(2, null);
        this.setBackgroundColor(0);
        this.attachListeners();
    }

    private void attachListeners() {
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (VungleBannerView.this.onViewTouchListener != null) {
                    return VungleBannerView.this.onViewTouchListener.onTouch(event);
                }
                return VungleBannerView.super.onTouchEvent(event);
            }
        });
    }

    @SuppressLint(value={"AddJavascriptInterface", "NewApi"})
    private void prepare() {
        WebSettingsUtils.applyDefault(this);
        this.addJavascriptInterface(new JavascriptBridge(this.presenter), "Android");
        this.getSettings().setMediaPlaybackRequiresUserGesture(false);
    }

    public void finishDisplayingAd() {
        this.finishDisplayingAdInternal(true);
    }

    public void finishDisplayingAdInternal(boolean isFinishByExternalApi) {
        if (this.presenter != null) {
            int flag = 2 | (isFinishByExternalApi ? 4 : 0);
            this.presenter.detach(flag);
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            this.listener.onError(new VungleException(25), this.request.getPlacementId());
        }
        if (isFinishByExternalApi) {
            SessionData.Builder sessionData = new SessionData.Builder().setEvent(SessionEvent.DISMISS_AD);
            if (this.request != null && this.request.getEventId() != null) {
                sessionData.addData(SessionAttribute.EVENT_ID, this.request.getEventId());
            }
            SessionTracker.getInstance().trackEvent(sessionData.build());
        }
        this.destroyAdView(0L);
    }

    public View renderBannerView() {
        return this;
    }

    public void setAdVisibility(boolean isVisible) {
        if (this.presenter != null) {
            this.presenter.setAdVisibility(isVisible);
        } else {
            this.isAdVisible.set(isVisible);
        }
    }

    @Override
    public void setPresenter(@NonNull WebAdContract.WebAdPresenter presenter) {
    }

    @Override
    public void setOrientation(int orientation) {
    }

    @Override
    public void showWebsite(@NonNull String url) {
        this.loadUrl(url);
    }

    @Override
    public String getWebsiteUrl() {
        return this.getUrl();
    }

    @Override
    public void close() {
        if (this.presenter != null) {
            this.finishDisplayingAdInternal(false);
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            this.listener.onError(new VungleException(25), this.request.getPlacementId());
        }
    }

    @Override
    public void destroyAdView(long webViewDestroyDelay) {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.presenter = null;
        this.presenterFactory = null;
        this.removeJavascriptInterface("Android");
        this.setWebChromeClient(null);
        Runnable destroyRunnable = new Runnable(){

            @Override
            public void run() {
                VungleBannerView.this.stopLoading();
                VungleBannerView.this.setWebViewClient(null);
                if (Build.VERSION.SDK_INT >= 29) {
                    VungleBannerView.this.setWebViewRenderProcessClient(null);
                }
                VungleBannerView.this.loadUrl("about:blank");
            }
        };
        if (webViewDestroyDelay <= 0L) {
            destroyRunnable.run();
        } else {
            new HandlerScheduler().schedule(destroyRunnable, webViewDestroyDelay);
        }
    }

    @Override
    public boolean hasWebView() {
        return true;
    }

    @Override
    public void showCloseButton() {
        throw new UnsupportedOperationException("VungleBannerView does not implement a close button");
    }

    @Override
    public void open(String deeplinkUrl, @NonNull String url, ActivityManager.LeftApplicationCallback leftApplicationCallback, PresenterAdOpenCallback adOpenCallback) {
        Log.d((String)TAG, (String)("Opening " + url));
        if (!ExternalRouter.launch(deeplinkUrl, url, this.getContext(), leftApplicationCallback, true, adOpenCallback)) {
            Log.e((String)TAG, (String)("Cannot open url " + url));
        }
    }

    @Override
    public void showDialog(@Nullable String dialogTitle, @Nullable String dialogBody, @NonNull String dialogContinue, @NonNull String dialogClose, @Nullable DialogInterface.OnClickListener responseListener) {
        throw new UnsupportedOperationException("VungleBannerView does not implement a dialog.");
    }

    @Override
    public void refreshDialogIfVisible() {
    }

    @Override
    public void setImmersiveMode() {
    }

    @Override
    public void resumeWeb() {
        this.onResume();
    }

    @Override
    public void pauseWeb() {
        this.onPause();
    }

    @Override
    public void removeWebView() {
        ViewParent viewParent = this.getParent();
        if (viewParent instanceof ViewManager) {
            ((ViewManager)viewParent).removeView((View)this);
        }
    }

    @Override
    public void updateWindow() {
    }

    @Override
    public void setVisibility(boolean isVisible) {
        int setVisibilityState = isVisible ? 0 : 4;
        this.setVisibility(setVisibilityState);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.presenterFactory != null && this.presenter == null) {
            this.presenterFactory.getBannerViewPresentation(this.getContext(), this.request, this.config, new CloseDelegate(){

                @Override
                public void close() {
                    VungleBannerView.this.finishDisplayingAdInternal(false);
                }
            }, new PresentationFactory.ViewCallback(){

                @Override
                public void onResult(@NonNull Pair<WebAdContract.WebAdPresenter, VungleWebClient> result, @Nullable VungleException error) {
                    ViewGroup.LayoutParams layoutParams;
                    VungleBannerView.this.presenterFactory = null;
                    if (error != null) {
                        if (VungleBannerView.this.listener != null) {
                            VungleBannerView.this.listener.onError(error, VungleBannerView.this.request.getPlacementId());
                        }
                        return;
                    }
                    VungleBannerView.this.presenter = (WebAdContract.WebAdPresenter)result.first;
                    VungleWebClient webViewClient = (VungleWebClient)result.second;
                    VungleBannerView.this.setWebViewClient(webViewClient);
                    VungleBannerView.this.presenter.setEventListener(VungleBannerView.this.listener);
                    VungleBannerView.this.presenter.attach(VungleBannerView.this, null);
                    VungleBannerView.this.prepare();
                    if (VungleBannerView.this.isAdVisible.get() != null) {
                        VungleBannerView.this.setAdVisibility((Boolean)VungleBannerView.this.isAdVisible.get());
                    }
                    if ((layoutParams = VungleBannerView.this.getLayoutParams()) != null) {
                        layoutParams.height = -1;
                        layoutParams.width = -1;
                    }
                }
            });
        }
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String command = intent.getStringExtra("command");
                if ("stopAll".equalsIgnoreCase(command)) {
                    VungleBannerView.this.finishDisplayingAdInternal(false);
                } else {
                    VungleLogger.warn(VungleBannerView.class.getSimpleName() + "#onAttachedToWindow", String.format("Receiving Invalid Broadcast: %1$s", command));
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.getContext()).registerReceiver(this.broadcastReceiver, new IntentFilter("AdvertisementBus"));
        this.resumeWeb();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.setAdVisibility(hasWindowFocus);
    }

    protected void onDetachedFromWindow() {
        LocalBroadcastManager.getInstance((Context)this.getContext()).unregisterReceiver(this.broadcastReceiver);
        super.onDetachedFromWindow();
        if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
        }
        this.pauseWeb();
    }
}

