/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.util.Base64;
import androidx.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.admarkup.AdMarkup;
import com.vungle.warren.model.admarkup.AdMarkupV1;
import com.vungle.warren.model.admarkup.AdMarkupV2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class AdMarkupDecoder {
    @Nullable
    public static AdMarkup decode(@Nullable String adMarkup) {
        if (adMarkup == null) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)adMarkup);
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            int version = jsonElement.getAsJsonObject().get("version").getAsInt();
            switch (version) {
                case 1: {
                    return AdMarkupV1.fromString(adMarkup);
                }
                case 2: {
                    return AdMarkupDecoder.serializeAdMarkupV2(jsonObject);
                }
            }
        }
        catch (JsonSyntaxException e2) {
            AdMarkupDecoder.logError();
            return null;
        }
        return null;
    }

    private static AdMarkupV2 serializeAdMarkupV2(JsonObject jsonObject) {
        String payload = jsonObject.get("adunit").getAsString();
        JsonArray impressionsJsonArray = jsonObject.get("impression").getAsJsonArray();
        String[] impressions = new String[impressionsJsonArray.size()];
        for (int i = 0; i < impressionsJsonArray.size(); ++i) {
            impressions[i] = impressionsJsonArray.get(i).getAsString();
        }
        byte[] compressed = Base64.decode((String)payload, (int)0);
        try {
            String decoded = AdMarkupDecoder.gzipDecode(compressed);
            JsonObject adUnit = JsonParser.parseString((String)decoded).getAsJsonObject();
            return new AdMarkupV2(adUnit, impressions);
        }
        catch (IOException e2) {
            AdMarkupDecoder.logError();
            return null;
        }
    }

    private static String gzipDecode(byte[] compressed) throws IOException {
        int bytesRead;
        int BUFFER_SIZE = 32;
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
        StringBuilder string = new StringBuilder();
        byte[] data = new byte[32];
        while ((bytesRead = gis.read(data)) != -1) {
            string.append(new String(data, 0, bytesRead));
        }
        gis.close();
        is.close();
        return string.toString();
    }

    private static void logError() {
        VungleLogger.error(AdMarkupDecoder.class.getName(), "Encountered issue serializing models");
    }
}

