/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.AsyncTask;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.utility.SDKExecutors;
import java.io.File;
import java.util.concurrent.Executor;

public class AsyncFileUtils {
    private static volatile Executor taskExecutor = new SDKExecutors().getTaskExecutor();

    public static void setTaskExecutor(Executor executor) {
        taskExecutor = executor;
    }

    public static ExistenceOperation isFileExistAsync(@Nullable File file, @NonNull FileExistCallback callback) {
        FileExistenceTask task = new FileExistenceTask(file, callback);
        ExistenceOperation operation = new ExistenceOperation(task);
        task.executeOnExecutor(taskExecutor, new Void[0]);
        return operation;
    }

    public static class ExistenceOperation {
        private final FileExistenceTask task;

        ExistenceOperation(@NonNull FileExistenceTask task) {
            this.task = task;
        }

        public void cancel() {
            this.task.clear();
            this.task.cancel(true);
        }
    }

    private static class FileExistenceTask
    extends AsyncTask<Void, Void, Boolean> {
        private final File file;
        private FileExistCallback callback;

        public FileExistenceTask(@Nullable File file, @NonNull FileExistCallback callback) {
            this.file = file;
            this.callback = callback;
        }

        protected Boolean doInBackground(Void ... voids) {
            return this.file != null && this.file.exists();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            FileExistenceTask fileExistenceTask = this;
            synchronized (fileExistenceTask) {
                if (this.callback != null) {
                    this.callback.status(result);
                }
            }
        }

        private synchronized void clear() {
            this.callback = null;
        }
    }

    public static interface FileExistCallback {
        public void status(boolean var1);
    }
}

