/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.concurrent.Executor;

public class ImageLoader {
    private static final String TAG = ImageLoader.class.getSimpleName();
    private static final ImageLoader sInstance = new ImageLoader();
    private final LruCache<String, Bitmap> lruCache;
    private Executor ioExecutor;

    private ImageLoader() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 8;
        this.lruCache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap value) {
                return value.getByteCount() / 1024;
            }
        };
    }

    @VisibleForTesting
    ImageLoader(LruCache<String, Bitmap> lruCache) {
        this.lruCache = lruCache;
    }

    public static ImageLoader getInstance() {
        return sInstance;
    }

    public void init(@NonNull Executor ioExecutor) {
        this.ioExecutor = ioExecutor;
    }

    public void displayImage(final @Nullable String uri, final @Nullable ImageLoaderListener listener) {
        if (this.ioExecutor == null) {
            Log.w((String)TAG, (String)"ImageLoader not initialized.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)uri)) {
            Log.w((String)TAG, (String)"the uri is required.");
            return;
        }
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!uri.startsWith("file://")) {
                    return;
                }
                Bitmap cachedBitmap = (Bitmap)ImageLoader.this.lruCache.get((Object)uri);
                if (cachedBitmap != null && !cachedBitmap.isRecycled()) {
                    if (listener != null) {
                        listener.onImageLoaded(cachedBitmap);
                    }
                    return;
                }
                String assetFile = uri.substring("file://".length());
                Bitmap bitmap = BitmapFactory.decodeFile((String)assetFile);
                if (bitmap != null) {
                    ImageLoader.this.lruCache.put((Object)uri, (Object)bitmap);
                    if (listener != null) {
                        listener.onImageLoaded(bitmap);
                    }
                } else {
                    Log.w((String)TAG, (String)"decode bitmap failed.");
                }
            }
        });
    }

    public static interface ImageLoaderListener {
        public void onImageLoaded(Bitmap var1);
    }
}

