/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.NamedThreadFactory;
import com.vungle.warren.utility.VungleThreadPoolExecutor;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public class SDKExecutors
implements Executors {
    private static final int SINGLE_CORE_POOL_SIZE = 1;
    private static final int IO_KEEP_ALIVE_TIME_SECONDS = 5;
    private static final int VUNGLE_KEEP_ALIVE_TIME_SECONDS = 10;
    private static final int JOBS_KEEP_ALIVE_TIME_SECONDS = 1;
    private static int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final VungleThreadPoolExecutor IO_EXECUTOR;
    private static final VungleThreadPoolExecutor BACKGROUND_EXECUTOR;
    private static final VungleThreadPoolExecutor JOB_EXECUTOR;
    private static final ExecutorService UI_EXECUTOR;
    private static final VungleThreadPoolExecutor API_EXECUTOR;
    private static final VungleThreadPoolExecutor LOGGER_EXECUTOR;
    private static final VungleThreadPoolExecutor TASK_EXECUTOR;
    private static final VungleThreadPoolExecutor UA_EXECUTOR;
    private static final VungleThreadPoolExecutor DOWNLOADER_EXECUTOR;
    private static final VungleThreadPoolExecutor OFFLOAD_EXECUTOR;
    private static final VungleThreadPoolExecutor SESSION_DATA_EXECUTOR;

    @Override
    public ExecutorService getUIExecutor() {
        return UI_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getBackgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getIOExecutor() {
        return IO_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getJobExecutor() {
        return JOB_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getApiExecutor() {
        return API_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getLoggerExecutor() {
        return LOGGER_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getTaskExecutor() {
        return TASK_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getOffloadExecutor() {
        return OFFLOAD_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getUAExecutor() {
        return UA_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getDownloaderExecutor() {
        return DOWNLOADER_EXECUTOR;
    }

    @Override
    public VungleThreadPoolExecutor getSessionDataExecutor() {
        return SESSION_DATA_EXECUTOR;
    }

    static {
        UI_EXECUTOR = new AbstractExecutorService(){
            private final Handler UIHandler = new Handler(Looper.getMainLooper());

            @Override
            public void shutdown() {
            }

            @Override
            public List<Runnable> shutdownNow() {
                return null;
            }

            @Override
            public boolean isShutdown() {
                return false;
            }

            @Override
            public boolean isTerminated() {
                return false;
            }

            @Override
            public boolean awaitTermination(long timeout, @NonNull TimeUnit unit) {
                return false;
            }

            @Override
            public void execute(@NonNull Runnable command) {
                this.UIHandler.post(command);
            }
        };
        JOB_EXECUTOR = new VungleThreadPoolExecutor(NUMBER_OF_CORES, NUMBER_OF_CORES, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new NamedThreadFactory("vng_jr"));
        IO_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_io"));
        LOGGER_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_logger"));
        BACKGROUND_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_background"));
        API_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_api"));
        TASK_EXECUTOR = new VungleThreadPoolExecutor(1, 20, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("vng_task"));
        UA_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_ua"));
        DOWNLOADER_EXECUTOR = new VungleThreadPoolExecutor(4, 4, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new NamedThreadFactory("vng_down"));
        OFFLOAD_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_ol"));
        SESSION_DATA_EXECUTOR = new VungleThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("vng_session"));
    }
}

