/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.List;

class SafeObjectInputStream
extends ObjectInputStream {
    private final List<Class<?>> allowed;

    SafeObjectInputStream(InputStream in, List<Class<?>> allowed) throws IOException {
        super(in);
        this.allowed = allowed;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
        Class<?> c2 = super.resolveClass(desc);
        if (this.allowed == null || Number.class.isAssignableFrom(c2) || String.class.equals(c2) || Boolean.class.equals(c2) || c2.isArray() || this.allowed.contains(c2)) {
            return c2;
        }
        throw new IOException("Deserialization is not allowed for " + desc.getName());
    }
}

