/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.utility.FileUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnzipUtility {
    private static final int BUFFER_SIZE = 4096;
    private static final String TAG = UnzipUtility.class.getCanonicalName();

    public static List<File> unzip(String zipFilePath, String destDirectory) throws IOException {
        return UnzipUtility.unzip(zipFilePath, destDirectory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unzip(String zipFilePath, String destDirectory, Filter filter) throws IOException {
        if (TextUtils.isEmpty((CharSequence)zipFilePath)) {
            throw new IOException("Path is empty");
        }
        File src = new File(zipFilePath);
        if (!src.exists()) {
            throw new IOException("File does not exist");
        }
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipFile zipFile = null;
        ArrayList<File> extractedFiles = new ArrayList<File>();
        try {
            zipFile = new ZipFile(src);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String filePath = destDirectory + File.separator + entry.getName();
                if (filter != null && !filter.matches(filePath)) continue;
                UnzipUtility.validateFilename(filePath, destDirectory);
                if (entry.isDirectory()) {
                    File dir = new File(filePath);
                    if (dir.exists()) continue;
                    dir.mkdir();
                    continue;
                }
                UnzipUtility.extractFile(zipFile.getInputStream(entry), filePath);
                extractedFiles.add(new File(filePath));
            }
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return extractedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void extractFile(InputStream zipIn, String filePath) throws IOException {
        File dest = new File(filePath);
        FileUtility.delete(dest);
        File parentDir = dest.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            int read;
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);
            byte[] bytesIn = new byte[4096];
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
        catch (Throwable throwable) {
            FileUtility.closeQuietly(zipIn);
            FileUtility.closeQuietly(bos);
            FileUtility.closeQuietly(fos);
            throw throwable;
        }
        FileUtility.closeQuietly(zipIn);
        FileUtility.closeQuietly(bos);
        FileUtility.closeQuietly(fos);
    }

    private static String validateFilename(String filename, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File f2 = new File(filename);
        String canonicalPath = f2.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return canonicalPath;
        }
        String msg = "File is outside extraction target directory.";
        Log.e((String)TAG, (String)"File is outside extraction target directory.");
        throw new ZipSecurityException("File is outside extraction target directory.");
    }

    public static interface Filter {
        public boolean matches(String var1);
    }

    static class ZipSecurityException
    extends IOException {
        ZipSecurityException(String message) {
            super(message);
        }
    }
}

