package com.vungle.ads.internal.model

import com.vungle.ads.internal.bidding.BidTokenEncoder
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class RtbTokens(val device: Device, val request: Request, val consent: Consent) {

    @Serializable
    data class CCPA(val status: String)

    @Serializable
    data class GDPR(
        val status: String,
        val source: String,
        @SerialName("message_version") val messageVersion: String,
        val timestamp: Long
    )

    @Serializable
    data class COPPA(@SerialName("is_coppa") val isCoppa: Boolean? )

    @Serializable
    data class Consent(val ccpa: CCPA, val gdpr: GDPR, val coppa: COPPA)

    @Serializable
    data class Extension(
        @SerialName("is_sideload_enabled") val isSideLoadEnabled: Boolean,
        @SerialName("sd_card_available") val sdCardAvailable: Boolean,
        @SerialName("sound_enabled") val soundEnabled: Boolean
    )

    @Serializable
    data class Device(
        @SerialName("battery_saver_enabled") val batterySaverEnabled: Boolean,
        @SerialName("time_zone") val timezone: String,
        @SerialName("volume_level") val volumeLevel: Float,
        @SerialName("ifa") val ifa: String?,
        @SerialName("amazon") val amazonInfo: BidTokenEncoder.AndroidInfo?,
        @SerialName("android") val androidInfo: BidTokenEncoder.AndroidInfo?,
        val language: String,
        val extension: Extension
    )

    @Serializable
    data class Request(
        @SerialName("config_extension") val configExtension: String?,
        @SerialName("ordinal_view") val ordinalView: Int,
        @SerialName("sdk_user_agent") val sdkUserAgent: String,
        @SerialName("precached_tokens") val preCachedToken: List<String> = emptyList()
    )
}
