package com.vungle.ads.internal.network

import android.util.Log
import com.vungle.ads.AnalyticsClient
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor
import com.vungle.ads.internal.protos.Sdk
import java.util.concurrent.Executor

class TpatSender(
    val vungleApiClient: VungleApiClient,
    val placementId: String?,
    val creativeId: String?,
    val eventId: String?,
) {
    companion object {
        private const val TAG: String = "TpatSender"
    }
    fun sendWinNotification(urlString: String, executor: VungleThreadPoolExecutor) {
        executor.execute {
            val error = vungleApiClient.pingTPAT(urlString)
            if (error != null) {
                AnalyticsClient.logError(
                    Sdk.SDKError.Reason.AD_WIN_NOTIFICATION_ERROR,
                    "Fail to send $urlString, error: ${error.description}",
                    placementId, creativeId, eventId
                )
            }
        }
    }

    fun sendTpat(urlString: String, executor: Executor) {
        executor.execute {
            val error = vungleApiClient.pingTPAT(urlString)
            if (error != null) {
                Log.e(TAG, "TPAT failed with ${error.description}, url:$urlString")
                AnalyticsClient.logError(
                    Sdk.SDKError.Reason.TPAT_ERROR,
                    "Fail to send $urlString, error: ${error.description}",
                    placementId, creativeId, eventId
                )
            }
        }
    }
}
