package com.vungle.ads.internal.util

import android.content.Context
import android.os.Build
import android.os.StatFs
import java.io.File

class PathProvider(val context: Context) {
    /** root directory for Vungle */
    internal val vungleDir: File = File(
        context.applicationInfo.dataDir,
        VUNGLE_FOLDER
    ) 
    internal val downloadsDir: File = File(
        vungleDir,
        DOWNLOADS_FOLDER
    )
    private val jsDir: File = File(
        vungleDir,
        JS_FOLDER
    )

    companion object {
        const val VUNGLE_FOLDER = "vungle"
        const val DOWNLOADS_FOLDER = "downloads"
        const val JS_FOLDER = "js"
    }

    init {
        listOf(vungleDir, downloadsDir, jsDir).forEach {
            if (!it.exists()) {
                it.mkdirs()
            }
        }
    }

    /** @return root directory for js assets */
    fun getJsDir() = jsDir

    /** @return directory for assets of specific js */
    fun getJsAssetDir(jsVersion: String): File {
        val jsAssetDir = File(jsDir, jsVersion)
        if (!jsAssetDir.exists()) {
            jsAssetDir.mkdirs()
        }
        return jsAssetDir
    }

    /** @return directory for assets of specific ad(determined by adId(eventId)) */
    fun getDownloadsDirForAd(adId: String?): File? {
        if (adId.isNullOrEmpty()) {
            return null
        }
        val vungleDir = downloadsDir
        val adDir = File(vungleDir.path + File.separator + adId)
        if (!adDir.exists()) {
            adDir.mkdirs()
        }
        return adDir
    }

    fun getSharedPrefsDir(): File = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
        context.noBackupFilesDir
    } else {
        context.filesDir
    }

    fun getAvailableBytes(path: String): Long {
        val stats = StatFs(path)

        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR2) {
            stats.availableBytes
        } else {
            stats.availableBlocks * stats.blockSize.toLong()
        }
    }
}
