/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.net.Uri;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.internal.model.CleverCache;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.util.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u001b\u001a\u00020\u0007J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0004J\u0006\u0010\u001f\u001a\u00020\u0011J\b\u0010 \u001a\u0004\u0018\u00010\u0007J\b\u0010!\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\u0007J\b\u0010%\u001a\u0004\u0018\u00010\u0007J\u0006\u0010&\u001a\u00020\u0015J\u0006\u0010'\u001a\u00020\u0015J\u0006\u0010(\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020*2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010+\u001a\u00020\u0011J\u0006\u0010,\u001a\u00020\u0011J\u0006\u0010-\u001a\u00020\u0011J\u0006\u0010.\u001a\u00020\u0011J\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJ\u0006\u0010/\u001a\u00020\u0011J\u0006\u00100\u001a\u00020\u0011J\u0006\u00101\u001a\u00020\u0011J\u0010\u00102\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010\u0007J\u0006\u00104\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/vungle/ads/internal/ConfigManager;", "", "()V", "DEFAULT_SESSION_TIMEOUT_SECONDS", "", "DEFAULT_SIGNALS_SESSION_TIMEOUT_SECONDS", "TAG", "", "config", "Lcom/vungle/ads/internal/model/ConfigPayload;", "configExt", "endpoints", "Lcom/vungle/ads/internal/model/ConfigPayload$Endpoints;", "placements", "", "Lcom/vungle/ads/internal/model/Placement;", "adLoadOptimizationEnabled", "", "getAdsEndpoint", "getCleverCacheDiskPercentage", "getCleverCacheDiskSize", "", "getConfigExtension", "getErrorLoggingEndpoint", "getGDPRButtonAccept", "getGDPRButtonDeny", "getGDPRConsentMessage", "getGDPRConsentMessageVersion", "getGDPRConsentTitle", "getGDPRIsCountryDataProtected", "getLogLevel", "getMetricsEnabled", "getMetricsEndpoint", "getMraidEndpoint", "getMraidJsVersion", "getPlacement", "id", "getRiEndpoint", "getSessionTimeout", "getSignalsSessionTimeout", "heartbeatEnabled", "initWithConfig", "", "isCacheableAssetsRequired", "isCleverCacheEnabled", "isReportIncentivizedEnabled", "omEnabled", "rtaDebuggingEnabled", "shouldDisableAdId", "signalsDisabled", "updateConfigExtension", "ext", "validateEndpoints", "vungle-ads_release"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    public static final String TAG = "ConfigManager";
    private static final int DEFAULT_SESSION_TIMEOUT_SECONDS = 900;
    private static final int DEFAULT_SIGNALS_SESSION_TIMEOUT_SECONDS = 1800;
    @Nullable
    private static ConfigPayload config;
    @Nullable
    private static ConfigPayload.Endpoints endpoints;
    @Nullable
    private static List<Placement> placements;
    @Nullable
    private static String configExt;

    private ConfigManager() {
    }

    public final void initWithConfig(@NotNull ConfigPayload config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ConfigManager.config = config;
        endpoints = config.getEndpoints();
        placements = config.getPlacements();
    }

    @Nullable
    public final List<Placement> placements() {
        return placements;
    }

    @Nullable
    public final Placement getPlacement(@NotNull String id) {
        Placement placement;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<Placement> list = placements;
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    Placement it = (Placement)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getReferenceId(), (Object)id)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            placement = v1;
        } else {
            placement = null;
        }
        return placement;
    }

    @Nullable
    public final String getAdsEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getAdsEndpoint() : null;
    }

    @Nullable
    public final String getRiEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getRiEndpoint() : null;
    }

    @Nullable
    public final String getMraidEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getMraidEndpoint() : null;
    }

    @NotNull
    public final String getMraidJsVersion() {
        String string;
        block3: {
            block2: {
                string = this.getMraidEndpoint();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = "mraid_" + Uri.parse((String)it).getLastPathSegment();
                string = string2;
                if (string2 != null) break block3;
            }
            string = "mraid_1";
        }
        return string;
    }

    @Nullable
    public final String getGDPRConsentMessage() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getConsentMessage() : null;
    }

    @Nullable
    public final String getGDPRConsentTitle() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getConsentTitle() : null;
    }

    @Nullable
    public final String getGDPRButtonAccept() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getButtonAccept() : null;
    }

    @Nullable
    public final String getGDPRButtonDeny() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getButtonDeny() : null;
    }

    @NotNull
    public final String getGDPRConsentMessageVersion() {
        Object object = config;
        if (object == null || (object = ((ConfigPayload)object).getGdpr()) == null || (object = ((ConfigPayload.GDPRSettings)object).getConsentMessageVersion()) == null) {
            object = "";
        }
        return object;
    }

    public final boolean getGDPRIsCountryDataProtected() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).isCountryDataProtected() : false;
    }

    public final boolean shouldDisableAdId() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getDisableAdId()) != null ? (Boolean)object : true;
    }

    public final boolean adLoadOptimizationEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isAdDownloadOptEnabled()) != null ? ((ConfigPayload.LoadOptimizationSettings)object).getEnabled() : false;
    }

    public final boolean isReportIncentivizedEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isReportIncentivizedEnabled()) != null ? ((ConfigPayload.ReportIncentivizedSettings)object).getEnabled() : false;
    }

    @NotNull
    public final String getConfigExtension() {
        String string = configExt;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void updateConfigExtension(@Nullable String ext) {
        configExt = ext;
    }

    public final boolean omEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getViewability()) != null ? ((ConfigPayload.ViewabilitySettings)object).getOm() : false;
    }

    public final boolean heartbeatEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getTemplate()) != null ? ((ConfigPayload.Template)object).getHeartbeatEnabled() : false;
    }

    @Nullable
    public final String getMetricsEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getMetricsEndpoint() : null;
    }

    @Nullable
    public final String getErrorLoggingEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getErrorLogsEndpoint() : null;
    }

    public final boolean getMetricsEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getLogMetricsSettings()) != null ? ((ConfigPayload.LogMetricsSettings)object).getMetricsEnabled() : false;
    }

    public final int getLogLevel() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getLogMetricsSettings()) != null ? ((ConfigPayload.LogMetricsSettings)object).getErrorLogLevel() : AnalyticsClient.LogLevel.ERROR_LOG_LEVEL_ERROR.getLevel();
    }

    public final long getSessionTimeout() {
        Object object = config;
        return (long)(object != null && (object = ((ConfigPayload)object).getSession()) != null ? ((ConfigPayload.Session)object).getTimeout() : 900) * 1000L;
    }

    public final long getSignalsSessionTimeout() {
        Object object = config;
        return (long)(object != null && (object = ((ConfigPayload)object).getSignalSessionTimeout()) != null ? (Integer)object : 1800) * 1000L;
    }

    public final boolean rtaDebuggingEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getRtaDebugging()) != null ? (Boolean)object : false;
    }

    public final boolean isCacheableAssetsRequired() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isCacheableAssetsRequired()) != null ? (Boolean)object : false;
    }

    public final boolean signalsDisabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getSignalsDisabled()) != null ? (Boolean)object : false;
    }

    public final boolean validateEndpoints() {
        boolean valid = true;
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        CharSequence charSequence = endpoints != null ? endpoints.getAdsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 122, "The ads endpoint was not provided in the config.", null, null, null, 28, null);
            valid = false;
        }
        ConfigPayload.Endpoints endpoints2 = ConfigManager.endpoints;
        charSequence = endpoints2 != null ? endpoints2.getRiEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 123, "The ri endpoint was not provided in the config.", null, null, null, 28, null);
        }
        ConfigPayload.Endpoints endpoints3 = ConfigManager.endpoints;
        charSequence = endpoints3 != null ? endpoints3.getMraidEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 130, "The mraid endpoint was not provided in the config.", null, null, null, 28, null);
            valid = false;
        }
        ConfigPayload.Endpoints endpoints4 = ConfigManager.endpoints;
        charSequence = endpoints4 != null ? endpoints4.getMetricsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 125, "The metrics endpoint was not provided in the config.", null, null, null, 28, null);
        }
        ConfigPayload.Endpoints endpoints5 = ConfigManager.endpoints;
        charSequence = endpoints5 != null ? endpoints5.getErrorLogsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            Logger.Companion.e(TAG, "The error logging endpoint was not provided in the config.");
        }
        return valid;
    }

    public final boolean isCleverCacheEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((CleverCache)object).getEnabled()) != null ? (Boolean)object : false;
    }

    public final long getCleverCacheDiskSize() {
        Object object = config;
        if (object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((CleverCache)object).getDiskSize()) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            return it * (long)1024 * (long)1024;
        }
        return 1048576000L;
    }

    public final int getCleverCacheDiskPercentage() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((CleverCache)object).getDiskPercentage()) != null ? (Integer)object : 3;
    }
}

