/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import android.content.Context;
import android.webkit.URLUtil;
import androidx.annotation.WorkerThread;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.AssetDownloadError;
import com.vungle.ads.InternalError;
import com.vungle.ads.MraidJsError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.load.AdLoaderCallback;
import com.vungle.ads.internal.load.AdRequest;
import com.vungle.ads.internal.load.BaseAdLoader;
import com.vungle.ads.internal.load.MraidJsLoader;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.ConfigExtension;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.ui.HackMraid;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import com.vungle.ads.internal.util.UnzipUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b&\u0018\u0000 \\2\u00020\u0001:\u0002\\]B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020:2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0013H\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u0010@\u001a\u00020\u0013H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010?2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0019H\u0002J\u000e\u0010G\u001a\u00020:2\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010H\u001a\u00020=2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010I\u001a\u00020=2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J\u000e\u0010L\u001a\u00020:2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010M\u001a\u00020:2\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020:H&J\b\u0010Q\u001a\u00020:H\u0002J\u001a\u0010R\u001a\u00020:2\u0006\u0010S\u001a\u00020\u000f2\b\u0010T\u001a\u0004\u0018\u00010KH\u0017J\u001a\u0010U\u001a\u00020=2\u0006\u0010V\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010W\u001a\u00020:H$J\b\u0010X\u001a\u00020:H\u0002J\u0018\u0010Y\u001a\u00020=2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010Z\u001a\u00020?H\u0002J\u0012\u0010[\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020\u0019H\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010)\u001a&\u0012\f\u0012\n +*\u0004\u0018\u00010*0* +*\u0012\u0012\f\u0012\n +*\u0004\u0018\u00010*0*\u0018\u00010,0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006^\u00b2\u0006\n\u0010_\u001a\u00020`X\u008a\u0084\u0002\u00b2\u0006\n\u0010a\u001a\u00020bX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader;", "", "context", "Landroid/content/Context;", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/Executors;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "adRequest", "Lcom/vungle/ads/internal/load/AdRequest;", "(Landroid/content/Context;Lcom/vungle/ads/internal/network/VungleApiClient;Lcom/vungle/ads/internal/executor/Executors;Lcom/vungle/ads/internal/omsdk/OMInjector;Lcom/vungle/ads/internal/downloader/Downloader;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/load/AdRequest;)V", "adAssets", "", "Lcom/vungle/ads/internal/model/AdAsset;", "adLoaderCallback", "Lcom/vungle/ads/internal/load/AdLoaderCallback;", "getAdRequest", "()Lcom/vungle/ads/internal/load/AdRequest;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "getAdvertisement$vungle_ads_release", "()Lcom/vungle/ads/internal/model/AdPayload;", "setAdvertisement$vungle_ads_release", "(Lcom/vungle/ads/internal/model/AdPayload;)V", "assetDownloadDurationMetric", "Lcom/vungle/ads/TimeIntervalMetric;", "assetDownloadListener", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "getAssetDownloadListener", "()Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "getContext", "()Landroid/content/Context;", "downloadCount", "Ljava/util/concurrent/atomic/AtomicLong;", "downloadRequiredCount", "errors", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener$DownloadError;", "kotlin.jvm.PlatformType", "", "mainVideoSizeMetric", "Lcom/vungle/ads/SingleValueMetric;", "notifyFailed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "notifySuccess", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "getSdkExecutors", "()Lcom/vungle/ads/internal/executor/Executors;", "templateSizeMetric", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "cancel", "", "downloadAssets", "fileIsValid", "", "file", "Ljava/io/File;", "adAsset", "getAssetPriority", "Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;", "getDestinationDir", "getErrorInfo", "Lcom/vungle/ads/internal/load/BaseAdLoader$ErrorInfo;", "adPayload", "handleAdMetaData", "injectOMIfNeeded", "isUrlValid", "url", "", "loadAd", "onAdLoadFailed", "error", "Lcom/vungle/ads/VungleError;", "onAdLoadReady", "onAdReady", "onDownloadCompleted", "request", "advertisementId", "processTemplate", "asset", "requestAd", "requestAdInBackground", "unzipFile", "downloadedFile", "validateAdMetadata", "Companion", "ErrorInfo", "vungle-ads_release", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;"})
public abstract class BaseAdLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final VungleApiClient vungleApiClient;
    @NotNull
    private final Executors sdkExecutors;
    @NotNull
    private final OMInjector omInjector;
    @NotNull
    private final Downloader downloader;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    private final AdRequest adRequest;
    @NotNull
    private final AtomicLong downloadCount;
    @NotNull
    private final AtomicLong downloadRequiredCount;
    @Nullable
    private AdLoaderCallback adLoaderCallback;
    @NotNull
    private AtomicBoolean notifySuccess;
    @NotNull
    private AtomicBoolean notifyFailed;
    @NotNull
    private final List<AdAsset> adAssets;
    @Nullable
    private AdPayload advertisement;
    private final List<AssetDownloadListener.DownloadError> errors;
    @NotNull
    private SingleValueMetric mainVideoSizeMetric;
    @NotNull
    private SingleValueMetric templateSizeMetric;
    @NotNull
    private TimeIntervalMetric assetDownloadDurationMetric;
    @NotNull
    private static final String TAG = "BaseAdLoader";
    @NotNull
    private static final String DOWNLOADED_FILE_NOT_FOUND = "Downloaded file not found!";

    public BaseAdLoader(@NotNull Context context, @NotNull VungleApiClient vungleApiClient, @NotNull Executors sdkExecutors, @NotNull OMInjector omInjector, @NotNull Downloader downloader, @NotNull PathProvider pathProvider, @NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)sdkExecutors, (String)"sdkExecutors");
        Intrinsics.checkNotNullParameter((Object)omInjector, (String)"omInjector");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        this.context = context;
        this.vungleApiClient = vungleApiClient;
        this.sdkExecutors = sdkExecutors;
        this.omInjector = omInjector;
        this.downloader = downloader;
        this.pathProvider = pathProvider;
        this.adRequest = adRequest;
        this.downloadCount = new AtomicLong(0L);
        this.downloadRequiredCount = new AtomicLong(0L);
        this.notifySuccess = new AtomicBoolean(false);
        this.notifyFailed = new AtomicBoolean(false);
        this.adAssets = new ArrayList();
        this.errors = Collections.synchronizedList(new ArrayList());
        this.mainVideoSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.ASSET_FILE_SIZE);
        this.templateSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.TEMPLATE_ZIP_SIZE);
        this.assetDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.ASSET_DOWNLOAD_DURATION_MS);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final VungleApiClient getVungleApiClient() {
        return this.vungleApiClient;
    }

    @NotNull
    public final Executors getSdkExecutors() {
        return this.sdkExecutors;
    }

    @NotNull
    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    @NotNull
    public final AdRequest getAdRequest() {
        return this.adRequest;
    }

    @Nullable
    public final AdPayload getAdvertisement$vungle_ads_release() {
        return this.advertisement;
    }

    public final void setAdvertisement$vungle_ads_release(@Nullable AdPayload adPayload) {
        this.advertisement = adPayload;
    }

    private final AssetDownloadListener getAssetDownloadListener() {
        return new AssetDownloadListener(this){
            final /* synthetic */ BaseAdLoader this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@Nullable AssetDownloadListener.DownloadError error, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                AssetDownloadListener.DownloadError downloadError = error;
                AssetDownloadListener.DownloadError downloadError2 = error;
                Logger.Companion.e("BaseAdLoader", "onError called: reason " + (downloadError != null ? Integer.valueOf(downloadError.getReason()) : null) + "; cause " + (downloadError2 != null ? downloadError2.getCause() : null));
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onError$lambda-0(error, this.this$0, downloadRequest));
            }

            public void onSuccess(@NotNull File file, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onSuccess$lambda-1(file, this, downloadRequest, this.this$0));
            }

            private static final void onError$lambda-0(AssetDownloadListener.DownloadError $error, BaseAdLoader this$0, DownloadRequest $downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                if ($error != null) {
                    BaseAdLoader.access$getErrors$p(this$0).add($error);
                } else {
                    BaseAdLoader.access$getErrors$p(this$0).add(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), AssetDownloadListener.DownloadError.ErrorReason.Companion.getREQUEST_ERROR()));
                }
                if ($downloadRequest.getAsset().isRequired() && BaseAdLoader.access$getDownloadRequiredCount$p(this$0).decrementAndGet() <= 0L) {
                    this$0.onAdLoadFailed(new AssetDownloadError());
                    this$0.cancel();
                    return;
                }
                if (BaseAdLoader.access$getDownloadCount$p(this$0).decrementAndGet() <= 0L) {
                    this$0.onAdLoadFailed(new AssetDownloadError());
                }
            }

            private static final void onSuccess$lambda-1(File $file, assetDownloadListener.1 this$0, DownloadRequest $downloadRequest, BaseAdLoader this$1) {
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                if (!$file.exists()) {
                    this$0.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), AssetDownloadListener.DownloadError.ErrorReason.Companion.getFILE_NOT_FOUND_ERROR()), $downloadRequest);
                    return;
                }
                AdAsset adAsset = $downloadRequest.getAsset();
                adAsset.setFileSize($file.length());
                adAsset.setStatus(AdAsset.Status.DOWNLOAD_SUCCESS);
                if ($downloadRequest.isTemplate()) {
                    $downloadRequest.stopRecord();
                    BaseAdLoader.access$getTemplateSizeMetric$p(this$1).setValue($file.length());
                    AdPayload adPayload = this$1.getAdvertisement$vungle_ads_release();
                    AdPayload adPayload2 = this$1.getAdvertisement$vungle_ads_release();
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(BaseAdLoader.access$getTemplateSizeMetric$p(this$1), this$1.getAdRequest().getPlacement().getReferenceId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload2 != null ? adPayload2.eventId() : null, adAsset.getServerPath());
                } else if ($downloadRequest.isMainVideo()) {
                    BaseAdLoader.access$getMainVideoSizeMetric$p(this$1).setValue($file.length());
                    AdPayload adPayload = this$1.getAdvertisement$vungle_ads_release();
                    AdPayload adPayload3 = this$1.getAdvertisement$vungle_ads_release();
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(BaseAdLoader.access$getMainVideoSizeMetric$p(this$1), this$1.getAdRequest().getPlacement().getReferenceId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload3 != null ? adPayload3.eventId() : null, adAsset.getServerPath());
                }
                AdPayload adPayload = this$1.getAdvertisement$vungle_ads_release();
                if (adPayload != null) {
                    adPayload.updateAdAssetPath(adAsset);
                }
                if ($downloadRequest.isTemplate()) {
                    BaseAdLoader.access$injectOMIfNeeded(this$1, this$1.getAdvertisement$vungle_ads_release());
                    if (!BaseAdLoader.access$processTemplate(this$1, adAsset, this$1.getAdvertisement$vungle_ads_release())) {
                        BaseAdLoader.access$getErrors$p(this$1).add(new AssetDownloadListener.DownloadError(-1, new AssetDownloadError(), AssetDownloadListener.DownloadError.ErrorReason.Companion.getINTERNAL_ERROR()));
                    }
                }
                if (adAsset.isRequired() && BaseAdLoader.access$getDownloadRequiredCount$p(this$1).decrementAndGet() <= 0L) {
                    if (BaseAdLoader.access$getErrors$p(this$1).isEmpty()) {
                        BaseAdLoader.access$onAdReady(this$1);
                    } else {
                        this$1.onAdLoadFailed(new AssetDownloadError());
                        this$1.cancel();
                        return;
                    }
                }
                if (BaseAdLoader.access$getDownloadCount$p(this$1).decrementAndGet() <= 0L) {
                    if (BaseAdLoader.access$getErrors$p(this$1).isEmpty()) {
                        AdPayload adPayload4 = this$1.getAdvertisement$vungle_ads_release();
                        this$1.onDownloadCompleted(this$1.getAdRequest(), adPayload4 != null ? adPayload4.eventId() : null);
                    } else {
                        this$1.onAdLoadFailed(new AssetDownloadError());
                    }
                }
            }
        };
    }

    public final void loadAd(@NotNull AdLoaderCallback adLoaderCallback) {
        Intrinsics.checkNotNullParameter((Object)adLoaderCallback, (String)"adLoaderCallback");
        this.adLoaderCallback = adLoaderCallback;
        this.sdkExecutors.getBackgroundExecutor().execute(() -> BaseAdLoader.loadAd$lambda-0(this, adLoaderCallback));
    }

    private final void requestAdInBackground() {
        this.sdkExecutors.getBackgroundExecutor().execute(() -> BaseAdLoader.requestAdInBackground$lambda-1(this));
    }

    protected abstract void requestAd();

    public abstract void onAdLoadReady();

    public final void cancel() {
        this.downloader.cancelAll();
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadAssets(AdPayload advertisement) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        this.assetDownloadDurationMetric.markStart();
        this.downloadCount.set(this.adAssets.size());
        Iterable iterable = this.adAssets;
        AtomicLong atomicLong = this.downloadRequiredCount;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AdAsset it = (AdAsset)element$iv$iv;
            boolean bl = false;
            if (!it.isRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        atomicLong.set(((List)destination$iv$iv).size());
        for (AdAsset asset : this.adAssets) {
            DownloadRequest downloadRequest = new DownloadRequest(this.getAssetPriority(asset), asset, this.adRequest.getPlacement().getReferenceId(), advertisement.getCreativeId(), advertisement.eventId());
            if (downloadRequest.isTemplate()) {
                downloadRequest.startRecord();
            }
            this.downloader.download(downloadRequest, this.getAssetDownloadListener());
        }
    }

    public final void onAdLoadFailed(@NotNull VungleError error) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (this.notifySuccess.get() || !this.notifyFailed.compareAndSet(false, true)) break block1;
            AdLoaderCallback adLoaderCallback = this.adLoaderCallback;
            if (adLoaderCallback != null) {
                adLoaderCallback.onFailure(error);
            }
        }
    }

    private final void onAdReady() {
        block2: {
            AdPayload adPayload = this.advertisement;
            if (adPayload == null) break block2;
            AdPayload it = adPayload;
            boolean bl = false;
            if (!this.notifyFailed.get() && this.notifySuccess.compareAndSet(false, true)) {
                this.onAdLoadReady();
                AdLoaderCallback adLoaderCallback = this.adLoaderCallback;
                if (adLoaderCallback != null) {
                    adLoaderCallback.onSuccess(it);
                }
            }
        }
    }

    private final boolean isUrlValid(String url) {
        CharSequence charSequence = url;
        return !(charSequence == null || charSequence.length() == 0) && (URLUtil.isHttpsUrl((String)url) || URLUtil.isHttpUrl((String)url));
    }

    private final boolean fileIsValid(File file, AdAsset adAsset) {
        return file.exists() && file.length() == adAsset.getFileSize();
    }

    private final boolean unzipFile(AdPayload advertisement, File downloadedFile) {
        List existingPaths = new ArrayList();
        for (AdAsset asset : this.adAssets) {
            if (asset.getFileType() != AdAsset.FileType.ASSET) continue;
            existingPaths.add(asset.getLocalPath());
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory()) {
            throw new IOException("Unable to access Destination Directory");
        }
        try {
            String string = downloadedFile.getPath();
            String string2 = destinationDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destinationDir.path");
            UnzipUtility.INSTANCE.unzip(string, string2, new UnzipUtility.Filter(existingPaths){
                final /* synthetic */ List<String> $existingPaths;
                {
                    this.$existingPaths = $existingPaths;
                }

                public boolean matches(@Nullable String extractPath) {
                    CharSequence charSequence = extractPath;
                    if (charSequence == null || charSequence.length() == 0) {
                        return true;
                    }
                    File toExtract = new File(extractPath);
                    for (String existing : this.$existingPaths) {
                        File existingFile = new File(existing);
                        if (Intrinsics.areEqual((Object)existingFile, (Object)toExtract)) {
                            return false;
                        }
                        String string = toExtract.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExtract.path");
                        if (!StringsKt.startsWith$default((String)string, (String)(existingFile.getPath() + File.separator), (boolean)false, (int)2, null)) continue;
                        return false;
                    }
                    return true;
                }
            });
            File file = new File(destinationDir.getPath() + File.separator + "index.html");
            if (!file.exists()) {
                AnalyticsClient.INSTANCE.logError$vungle_ads_release(115, "Failed to retrieve indexFileUrl from the Ad.", this.adRequest.getPlacement().getReferenceId(), advertisement.getCreativeId(), advertisement.eventId());
                return false;
            }
        }
        catch (Exception ex) {
            AnalyticsClient.INSTANCE.logError$vungle_ads_release(109, "Unzip failed: " + ex.getMessage(), this.adRequest.getPlacement().getReferenceId(), advertisement.getCreativeId(), advertisement.eventId());
            return false;
        }
        if (Intrinsics.areEqual((Object)downloadedFile.getName(), (Object)"template")) {
            boolean created;
            File mraidJS = new File(destinationDir.getPath() + File.separator + "mraid.js");
            if (!mraidJS.exists() && !(created = mraidJS.createNewFile())) {
                throw new IOException("mraid.js can not be created");
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(mraidJS, true)));
            HackMraid.INSTANCE.apply(this.pathProvider, out);
            out.close();
        }
        FileUtility.printDirectoryTree(destinationDir);
        FileUtility.delete(downloadedFile);
        return true;
    }

    private final File getDestinationDir(AdPayload advertisement) {
        return this.pathProvider.getDownloadsDirForAd(advertisement.eventId());
    }

    private final boolean injectOMIfNeeded(AdPayload advertisement) {
        if (advertisement == null) {
            return false;
        }
        if (advertisement.omEnabled()) {
            try {
                File destinationDir = this.getDestinationDir(advertisement);
                if (destinationDir == null || !destinationDir.isDirectory()) {
                    this.onAdLoadFailed(new AssetDownloadError());
                    return false;
                }
                this.omInjector.injectJsFiles(destinationDir);
            }
            catch (IOException e2) {
                this.onAdLoadFailed(new AssetDownloadError());
                return false;
            }
        }
        return true;
    }

    private final boolean processTemplate(AdAsset asset, AdPayload advertisement) {
        if (advertisement == null) {
            return false;
        }
        if (asset.getStatus() != AdAsset.Status.DOWNLOAD_SUCCESS) {
            return false;
        }
        if (((CharSequence)asset.getLocalPath()).length() == 0) {
            return false;
        }
        File f2 = new File(asset.getLocalPath());
        if (!this.fileIsValid(f2, asset)) {
            return false;
        }
        return asset.getFileType() != AdAsset.FileType.ZIP || this.unzipFile(advertisement, f2);
    }

    @WorkerThread
    public void onDownloadCompleted(@NotNull AdRequest request, @Nullable String advertisementId) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Logger.Companion.d(TAG, "download completed " + request);
        AdPayload adPayload = this.advertisement;
        if (adPayload != null) {
            adPayload.setAssetFullyDownloaded();
        }
        this.onAdReady();
        this.assetDownloadDurationMetric.markEnd();
        AdPayload adPayload2 = this.advertisement;
        String placementId = adPayload2 != null ? adPayload2.placementId() : null;
        AdPayload adPayload3 = this.advertisement;
        String creativeId = adPayload3 != null ? adPayload3.getCreativeId() : null;
        AdPayload adPayload4 = this.advertisement;
        String eventId = adPayload4 != null ? adPayload4.eventId() : null;
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.assetDownloadDurationMetric, placementId, creativeId, eventId, null, 16, null);
    }

    public final void handleAdMetaData(@NotNull AdPayload advertisement) {
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        this.advertisement = advertisement;
        ErrorInfo error = this.validateAdMetadata(advertisement);
        if (error != null) {
            AnalyticsClient.INSTANCE.logError$vungle_ads_release(error.getReason(), error.getDescription(), this.adRequest.getPlacement().getReferenceId(), advertisement.getCreativeId(), advertisement.eventId());
            this.onAdLoadFailed(new InternalError(error.getReason(), error.getDescriptionExternal()));
            return;
        }
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        ConfigExtension configExtension = advertisement.configExt();
        if (configExtension != null) {
            ConfigExtension it = configExtension;
            boolean bl = false;
            String string = it.getConfigExt();
            if (string != null) {
                String ext = string;
                boolean bl2 = false;
                ConfigManager.INSTANCE.updateConfigExtension(ext);
                BaseAdLoader.handleAdMetaData$lambda-4((Lazy<FilePreferences>)filePreferences$delegate).put("config_extension", ext).apply();
            }
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory() || !destinationDir.exists()) {
            this.onAdLoadFailed(new AssetDownloadError());
            return;
        }
        ServiceLocator.Companion it = ServiceLocator.Companion;
        Context context$iv2 = this.context;
        boolean $i$f$inject2 = false;
        Lazy signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context$iv2){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SignalManager invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
            }
        }));
        Object object = advertisement.adUnit();
        if (object != null && (object = ((AdPayload.AdUnit)object).getLoadAdUrls()) != null) {
            Object object2;
            Object loadAdUrls = object2 = object;
            boolean bl = false;
            TpatSender tpatSender = new TpatSender(this.vungleApiClient, advertisement.placementId(), advertisement.getCreativeId(), advertisement.eventId(), this.sdkExecutors.getIoExecutor(), this.pathProvider, BaseAdLoader.handleAdMetaData$lambda-7((Lazy<SignalManager>)signalManager$delegate));
            Iterable $this$forEach$iv = (Iterable)loadAdUrls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl3 = false;
                tpatSender.sendTpat(it2, this.sdkExecutors.getJobExecutor());
            }
        }
        if (!((Collection)this.adAssets).isEmpty()) {
            this.adAssets.clear();
        }
        this.adAssets.addAll((Collection<AdAsset>)advertisement.getDownloadableAssets(destinationDir));
        this.downloadAssets(advertisement);
    }

    private final DownloadRequest.Priority getAssetPriority(AdAsset adAsset) {
        return adAsset.isRequired() ? DownloadRequest.Priority.CRITICAL : DownloadRequest.Priority.HIGHEST;
    }

    private final ErrorInfo validateAdMetadata(AdPayload adPayload) {
        block15: {
            CharSequence templateUrl;
            Object it;
            AdPayload.TemplateSettings templateSettings;
            int reason = 0;
            String description = null;
            AdPayload.AdUnit adUnit = adPayload.adUnit();
            if ((adUnit != null ? adUnit.getSleep() : null) != null) {
                return this.getErrorInfo(adPayload);
            }
            AdPayload adPayload2 = this.advertisement;
            if (!Intrinsics.areEqual((Object)this.adRequest.getPlacement().getReferenceId(), (Object)(adPayload2 != null ? adPayload2.placementId() : null))) {
                reason = 215;
                description = "The ad response is missing placement reference id.";
                return new ErrorInfo(reason, description, null, false, 12, null);
            }
            AdPayload adPayload3 = this.advertisement;
            if (!CollectionsKt.contains((Iterable)this.adRequest.getPlacement().getSupportedTemplateTypes(), (Object)(adPayload3 != null ? adPayload3.templateType() : null))) {
                reason = 216;
                description = "The ad response has an unexpected template type.";
                return new ErrorInfo(reason, description, null, false, 12, null);
            }
            AdPayload.AdUnit adUnit2 = adPayload.adUnit();
            AdPayload.TemplateSettings templateSettings2 = templateSettings = adUnit2 != null ? adUnit2.getTemplateSettings() : null;
            if (templateSettings == null) {
                reason = 113;
                description = "Missing assets URLs";
                return new ErrorInfo(reason, description, null, false, 12, null);
            }
            Map<String, AdPayload.CacheableReplacement> cacheableReplacements = templateSettings.getCacheableReplacements();
            if (adPayload.isNativeTemplateType()) {
                Map<String, AdPayload.CacheableReplacement> map = cacheableReplacements;
                if (map != null) {
                    it = map;
                    boolean bl = false;
                    AdPayload.CacheableReplacement cacheableReplacement = it.get("MAIN_IMAGE");
                    if ((cacheableReplacement != null ? cacheableReplacement.getUrl() : null) == null) {
                        reason = 600;
                        description = "Unable to load main image.";
                        return new ErrorInfo(reason, description, null, false, 12, null);
                    }
                    AdPayload.CacheableReplacement cacheableReplacement2 = (AdPayload.CacheableReplacement)it.get("VUNGLE_PRIVACY_ICON_URL");
                    if ((cacheableReplacement2 != null ? cacheableReplacement2.getUrl() : null) == null) {
                        reason = 600;
                        description = "Unable to load privacy image.";
                        return new ErrorInfo(reason, description, null, false, 12, null);
                    }
                }
            } else {
                AdPayload.AdUnit adUnit3 = adPayload.adUnit();
                templateUrl = adUnit3 != null ? adUnit3.getTemplateURL() : null;
                it = templateUrl;
                if (it == null || it.length() == 0) {
                    reason = 105;
                    description = "Failed to prepare URL for template download.";
                    return new ErrorInfo(reason, description, null, false, 12, null);
                }
                if (!this.isUrlValid((String)templateUrl)) {
                    reason = 112;
                    description = "Failed to load template asset.";
                    return new ErrorInfo(reason, description, null, false, 12, null);
                }
            }
            if (adPayload.hasExpired()) {
                reason = 304;
                description = "The ad markup has expired for playback.";
                return new ErrorInfo(reason, description, null, false, 12, null);
            }
            templateUrl = adPayload.eventId();
            if (templateUrl == null || templateUrl.length() == 0) {
                reason = 200;
                description = "Event id is invalid.";
                return new ErrorInfo(reason, description, null, false, 12, null);
            }
            Map<String, AdPayload.CacheableReplacement> map = cacheableReplacements;
            if (map == null) break block15;
            Map<String, AdPayload.CacheableReplacement> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, AdPayload.CacheableReplacement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, AdPayload.CacheableReplacement> element$iv;
                Map.Entry<String, AdPayload.CacheableReplacement> it2 = element$iv = iterator.next();
                boolean bl = false;
                String httpUrl = it2.getValue().getUrl();
                CharSequence charSequence = httpUrl;
                if (charSequence == null || charSequence.length() == 0) {
                    reason = 111;
                    description = "Invalid asset URL " + httpUrl;
                    return new ErrorInfo(reason, description, null, false, 12, null);
                }
                if (this.isUrlValid(httpUrl)) continue;
                reason = 112;
                description = "Invalid asset URL " + httpUrl;
                return new ErrorInfo(reason, description, null, false, 12, null);
            }
        }
        return null;
    }

    private final ErrorInfo getErrorInfo(AdPayload adPayload) {
        Object object = adPayload.adUnit();
        int errorCode = object != null && (object = ((AdPayload.AdUnit)object).getErrorCode()) != null ? (Integer)object : 212;
        AdPayload.AdUnit adUnit = adPayload.adUnit();
        Integer sleep = adUnit != null ? adUnit.getSleep() : null;
        AdPayload.AdUnit adUnit2 = adPayload.adUnit();
        String info = adUnit2 != null ? adUnit2.getInfo() : null;
        switch (errorCode) {
            case 10001: 
            case 10002: 
            case 20001: 
            case 30001: 
            case 30002: {
                return new ErrorInfo(errorCode, "Response error: " + sleep, "Request failed with error: " + errorCode + ", " + info, false, 8, null);
            }
        }
        return new ErrorInfo(212, "Response error: " + sleep, "Request failed with error: 212, " + info, false, 8, null);
    }

    private static final void loadAd$lambda-0(BaseAdLoader this$0, AdLoaderCallback $adLoaderCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$adLoaderCallback, (String)"$adLoaderCallback");
        MraidJsLoader.INSTANCE.downloadJs(this$0.pathProvider, this$0.downloader, this$0.sdkExecutors.getIoExecutor(), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this$0, $adLoaderCallback){
            final /* synthetic */ BaseAdLoader this$0;
            final /* synthetic */ AdLoaderCallback $adLoaderCallback;
            {
                this.this$0 = $receiver;
                this.$adLoaderCallback = $adLoaderCallback;
                super(1);
            }

            public final void invoke(int it) {
                switch (it) {
                    case 10: 
                    case 13: {
                        if (it == 10) {
                            AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, Sdk.SDKMetric.SDKMetricType.MRAID_DOWNLOAD_JS_RETRY_SUCCESS, 0L, this.this$0.getAdRequest().getPlacement().getReferenceId(), null, null, null, 58, null);
                        }
                        BaseAdLoader.access$requestAdInBackground(this.this$0);
                        break;
                    }
                    default: {
                        this.$adLoaderCallback.onFailure(new MraidJsError(null, 1, null));
                    }
                }
            }
        }));
    }

    private static final void requestAdInBackground$lambda-1(BaseAdLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestAd();
    }

    private static final FilePreferences handleAdMetaData$lambda-4(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final SignalManager handleAdMetaData$lambda-7(Lazy<SignalManager> $signalManager$delegate) {
        Lazy<SignalManager> lazy = $signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    public static final /* synthetic */ List access$getErrors$p(BaseAdLoader $this) {
        return $this.errors;
    }

    public static final /* synthetic */ AtomicLong access$getDownloadRequiredCount$p(BaseAdLoader $this) {
        return $this.downloadRequiredCount;
    }

    public static final /* synthetic */ AtomicLong access$getDownloadCount$p(BaseAdLoader $this) {
        return $this.downloadCount;
    }

    public static final /* synthetic */ SingleValueMetric access$getTemplateSizeMetric$p(BaseAdLoader $this) {
        return $this.templateSizeMetric;
    }

    public static final /* synthetic */ SingleValueMetric access$getMainVideoSizeMetric$p(BaseAdLoader $this) {
        return $this.mainVideoSizeMetric;
    }

    public static final /* synthetic */ boolean access$injectOMIfNeeded(BaseAdLoader $this, AdPayload advertisement) {
        return $this.injectOMIfNeeded(advertisement);
    }

    public static final /* synthetic */ boolean access$processTemplate(BaseAdLoader $this, AdAsset asset, AdPayload advertisement) {
        return $this.processTemplate(asset, advertisement);
    }

    public static final /* synthetic */ void access$onAdReady(BaseAdLoader $this) {
        $this.onAdReady();
    }

    public static final /* synthetic */ void access$requestAdInBackground(BaseAdLoader $this) {
        $this.requestAdInBackground();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader$Companion;", "", "()V", "DOWNLOADED_FILE_NOT_FOUND", "", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader$ErrorInfo;", "", "reason", "", "description", "", "descriptionExternal", "errorIsTerminal", "", "(ILjava/lang/String;Ljava/lang/String;Z)V", "getDescription", "()Ljava/lang/String;", "getDescriptionExternal", "getErrorIsTerminal", "()Z", "getReason", "()I", "vungle-ads_release"})
    public static final class ErrorInfo {
        private final int reason;
        @NotNull
        private final String description;
        @NotNull
        private final String descriptionExternal;
        private final boolean errorIsTerminal;

        public ErrorInfo(int reason, @NotNull String description, @NotNull String descriptionExternal, boolean errorIsTerminal) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)descriptionExternal, (String)"descriptionExternal");
            this.reason = reason;
            this.description = description;
            this.descriptionExternal = descriptionExternal;
            this.errorIsTerminal = errorIsTerminal;
        }

        public /* synthetic */ ErrorInfo(int n, String string, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string2 = string;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(n, string, string2, bl);
        }

        public final int getReason() {
            return this.reason;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getDescriptionExternal() {
            return this.descriptionExternal;
        }

        public final boolean getErrorIsTerminal() {
            return this.errorIsTerminal;
        }
    }
}

