/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.MraidJsError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.load.MraidJsLoader;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u000b0\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/vungle/ads/internal/load/MraidJsLoader;", "", "()V", "MRAID_AVAILABLE", "", "MRAID_DOWNLOADED", "MRAID_DOWNLOAD_FAILED", "MRAID_INVALID_ENDPOINT", "TAG", "", "downloadJs", "", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;", "ioExecutor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "onDownloadResult", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "downloadState", "vungle-ads_release"})
public final class MraidJsLoader {
    @NotNull
    public static final MraidJsLoader INSTANCE = new MraidJsLoader();
    @NotNull
    private static final String TAG = "MraidJsLoader";
    public static final int MRAID_DOWNLOADED = 10;
    public static final int MRAID_INVALID_ENDPOINT = 11;
    public static final int MRAID_DOWNLOAD_FAILED = 12;
    public static final int MRAID_AVAILABLE = 13;

    private MraidJsLoader() {
    }

    public final void downloadJs(@NotNull PathProvider pathProvider, @NotNull Downloader downloader, @NotNull VungleThreadPoolExecutor ioExecutor, @NotNull Function1<? super Integer, Unit> onDownloadResult) {
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
        Intrinsics.checkNotNullParameter(onDownloadResult, (String)"onDownloadResult");
        String mraidEndpoint = ConfigManager.INSTANCE.getMraidEndpoint();
        CharSequence charSequence = mraidEndpoint;
        if (charSequence == null || charSequence.length() == 0) {
            onDownloadResult.invoke((Object)11);
            return;
        }
        File mraidJsPath = pathProvider.getJsAssetDir(ConfigManager.INSTANCE.getMraidJsVersion());
        File mraidJsFile = new File(mraidJsPath, "mraid.min.js");
        if (mraidJsFile.exists()) {
            onDownloadResult.invoke((Object)13);
            return;
        }
        File jsPath = pathProvider.getJsDir();
        FileUtility.deleteContents(jsPath);
        File tempFilePath = new File(mraidJsFile.getAbsolutePath() + '-' + System.currentTimeMillis() + ".tmp");
        String string = mraidEndpoint + "/mraid.min.js";
        String string2 = tempFilePath.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tempFilePath.absolutePath");
        AdAsset mraidJsAsset = new AdAsset("mraid.min.js", string, string2, AdAsset.FileType.ASSET, true);
        DownloadRequest mraidDownloadRequest = new DownloadRequest(DownloadRequest.Priority.HIGH, mraidJsAsset, null, null, null, 28, null);
        downloader.download(mraidDownloadRequest, new AssetDownloadListener(ioExecutor, jsPath, onDownloadResult, mraidJsFile){
            final /* synthetic */ VungleThreadPoolExecutor $ioExecutor;
            final /* synthetic */ File $jsPath;
            final /* synthetic */ Function1<Integer, Unit> $onDownloadResult;
            final /* synthetic */ File $mraidJsFile;
            {
                this.$ioExecutor = $ioExecutor;
                this.$jsPath = $jsPath;
                this.$onDownloadResult = $onDownloadResult;
                this.$mraidJsFile = $mraidJsFile;
            }

            public void onError(@Nullable AssetDownloadListener.DownloadError error, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                this.$ioExecutor.execute(() -> downloadJs.1.onError$lambda-0(error, downloadRequest, this.$jsPath, this.$onDownloadResult));
            }

            public void onSuccess(@NotNull File file, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                this.$ioExecutor.execute(() -> downloadJs.1.onSuccess$lambda-1(this.$mraidJsFile, this.$onDownloadResult, file, this.$jsPath));
            }

            private static final void onError$lambda-0(AssetDownloadListener.DownloadError $error, DownloadRequest $downloadRequest, File $jsPath, Function1 $onDownloadResult) {
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                Intrinsics.checkNotNullParameter((Object)$jsPath, (String)"$jsPath");
                Intrinsics.checkNotNullParameter((Object)$onDownloadResult, (String)"$onDownloadResult");
                AssetDownloadListener.DownloadError downloadError = $error;
                String errorMessage = "download mraid js error: " + (downloadError != null ? Integer.valueOf(downloadError.getServerCode()) : null) + ". Failed to load asset " + $downloadRequest.getAsset().getServerPath();
                Logger.Companion.d("MraidJsLoader", errorMessage);
                new MraidJsError(errorMessage).logErrorNoReturnValue$vungle_ads_release();
                FileUtility.deleteContents($jsPath);
                $onDownloadResult.invoke((Object)12);
            }

            private static final void onSuccess$lambda-1(File $mraidJsFile, Function1 $onDownloadResult, File $file, File $jsPath) {
                Intrinsics.checkNotNullParameter((Object)$mraidJsFile, (String)"$mraidJsFile");
                Intrinsics.checkNotNullParameter((Object)$onDownloadResult, (String)"$onDownloadResult");
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)$jsPath, (String)"$jsPath");
                if ($mraidJsFile.exists()) {
                    Logger.Companion.w("MraidJsLoader", "mraid js file already exists!");
                    $onDownloadResult.invoke((Object)10);
                    return;
                }
                if ($file.exists() && $file.length() > 0L) {
                    FilesKt.copyTo$default((File)$file, (File)$mraidJsFile, (boolean)true, (int)0, (int)4, null);
                    FileUtility.deleteAndLogIfFailed($file);
                }
                if ($mraidJsFile.exists() && $mraidJsFile.length() > 0L) {
                    $onDownloadResult.invoke((Object)10);
                } else {
                    AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 131, "Mraid js downloaded but write failure: " + $mraidJsFile.getAbsolutePath(), null, null, null, 28, null);
                    FileUtility.deleteContents($jsPath);
                    $onDownloadResult.invoke((Object)12);
                }
            }
        });
    }
}

