/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.network;

import android.app.UiModeManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.PowerManager;
import android.security.NetworkSecurityPolicy;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.URLUtil;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.PermissionChecker;
import androidx.core.util.Consumer;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.protobuf.GeneratedMessageLite;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.VungleAds;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.load.BaseAdLoader;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.AdvertisingInfo;
import com.vungle.ads.internal.model.AppNode;
import com.vungle.ads.internal.model.CommonRequestBody;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.model.DeviceNode;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Callback;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.VungleApi;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.network.VungleApiImpl;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.platform.AndroidPlatform;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.privacy.COPPA;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import java.io.IOException;
import java.lang.annotation.RetentionPolicy;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 t2\u00020\u0001:\u0003tuvB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001eH\u0007J\u0012\u00109\u001a\u00020\u00142\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u000e\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u0014J\u000e\u0010>\u001a\n\u0012\u0004\u0012\u00020@\u0018\u00010?J\u0010\u0010A\u001a\u00020B2\u0006\u0010:\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u00162\u0006\u0010E\u001a\u00020\u0003H\u0002J\n\u0010F\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010G\u001a\u0004\u0018\u00010\u0014J\u000e\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020\u0016H\u0002J\u0015\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u001eH\u0001\u00a2\u0006\u0002\bLJ\u0014\u0010M\u001a\u0004\u0018\u00010N2\b\b\u0002\u0010O\u001a\u00020\u001eH\u0002J\u0012\u0010P\u001a\u00020\u00142\b\u0010Q\u001a\u0004\u0018\u00010;H\u0002J\u000f\u0010R\u001a\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010SJ\u000f\u0010T\u001a\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010SJ\u000e\u0010U\u001a\u00020)2\u0006\u0010=\u001a\u00020\u0014J\b\u0010V\u001a\u00020WH\u0002J\b\u0010X\u001a\u000207H\u0002J\u000e\u0010Y\u001a\u0002072\u0006\u0010Z\u001a\u00020\u0014J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007\u00a2\u0006\u0002\u0010SJ\u0010\u0010[\u001a\u0004\u0018\u00010\\2\u0006\u0010]\u001a\u00020\u0014J\u001c\u0010^\u001a\u0002072\f\u0010_\u001a\b\u0012\u0004\u0012\u00020a0`2\u0006\u0010b\u001a\u00020cJ\u001c\u0010d\u001a\u0002072\f\u0010e\u001a\b\u0012\u0004\u0012\u00020f0`2\u0006\u0010b\u001a\u00020cJ(\u0010g\u001a\n\u0012\u0004\u0012\u00020h\u0018\u00010?2\u0006\u0010i\u001a\u00020\u00142\b\u0010j\u001a\u0004\u0018\u00010\u00142\u0006\u0010k\u001a\u00020\u001eJ\u0010\u0010l\u001a\u00020m2\b\b\u0002\u0010O\u001a\u00020\u001eJ\u0016\u0010n\u001a\n\u0012\u0004\u0012\u00020o\u0018\u00010?2\u0006\u0010:\u001a\u00020pJ\u0016\u0010q\u001a\u0002072\u0006\u0010r\u001a\u00020\u00142\u0006\u0010s\u001a\u00020\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\n8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020!8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010\u000e\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R0\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020)0(8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b*\u0010\u000e\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001b\u0010/\u001a\u0002008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b1\u00102R\u0010\u00105\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/vungle/ads/internal/network/VungleApiClient;", "", "applicationContext", "Landroid/content/Context;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "(Landroid/content/Context;Lcom/vungle/ads/internal/platform/Platform;Lcom/vungle/ads/internal/persistence/FilePreferences;)V", "api", "Lcom/vungle/ads/internal/network/VungleApi;", "appBody", "Lcom/vungle/ads/internal/model/AppNode;", "getAppBody$vungle_ads_release$annotations", "()V", "getAppBody$vungle_ads_release", "()Lcom/vungle/ads/internal/model/AppNode;", "setAppBody$vungle_ads_release", "(Lcom/vungle/ads/internal/model/AppNode;)V", "appSetId", "", "baseDeviceInfo", "Lcom/vungle/ads/internal/model/DeviceNode;", "gzipApi", "getGzipApi$vungle_ads_release$annotations", "getGzipApi$vungle_ads_release", "()Lcom/vungle/ads/internal/network/VungleApi;", "setGzipApi$vungle_ads_release", "(Lcom/vungle/ads/internal/network/VungleApi;)V", "isGooglePlayServicesAvailable", "", "Ljava/lang/Boolean;", "responseInterceptor", "Lokhttp3/Interceptor;", "getResponseInterceptor$vungle_ads_release$annotations", "getResponseInterceptor$vungle_ads_release", "()Lokhttp3/Interceptor;", "setResponseInterceptor$vungle_ads_release", "(Lokhttp3/Interceptor;)V", "retryAfterDataMap", "", "", "getRetryAfterDataMap$vungle_ads_release$annotations", "getRetryAfterDataMap$vungle_ads_release", "()Ljava/util/Map;", "setRetryAfterDataMap$vungle_ads_release", "(Ljava/util/Map;)V", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "signalManager$delegate", "Lkotlin/Lazy;", "uaString", "addPlaySvcAvailabilityInCookie", "", "isPlaySvcAvailable", "bodyToString", "request", "Lokhttp3/RequestBody;", "checkIsRetryAfterActive", "placementID", "config", "Lcom/vungle/ads/internal/network/Call;", "Lcom/vungle/ads/internal/model/ConfigPayload;", "defaultErrorResponse", "Lokhttp3/Response;", "Lokhttp3/Request;", "getBasicDeviceBody", "context", "getConnectionType", "getConnectionTypeDetail", "type", "", "getDeviceBody", "explicitBlock", "getDeviceBody$vungle_ads_release", "getExtBody", "Lcom/vungle/ads/internal/model/CommonRequestBody$RequestExt;", "withSignals", "getPlacementID", "body", "getPlayServicesAvailabilityFromAPI", "()Ljava/lang/Boolean;", "getPlayServicesAvailabilityFromCookie", "getRetryAfterHeaderValue", "getUserBody", "Lcom/vungle/ads/internal/model/CommonRequestBody$User;", "initUserAgentLazy", "initialize", "appId", "pingTPAT", "Lcom/vungle/ads/internal/load/BaseAdLoader$ErrorInfo;", "url", "reportErrors", "errors", "Ljava/util/concurrent/BlockingQueue;", "Lcom/vungle/ads/internal/protos/Sdk$SDKError$Builder;", "requestListener", "Lcom/vungle/ads/AnalyticsClient$RequestListener;", "reportMetrics", "metrics", "Lcom/vungle/ads/internal/protos/Sdk$SDKMetric$Builder;", "requestAd", "Lcom/vungle/ads/internal/model/AdPayload;", "placement", "adSize", "isHeaderBiddingEnable", "requestBody", "Lcom/vungle/ads/internal/model/CommonRequestBody;", "ri", "Ljava/lang/Void;", "Lcom/vungle/ads/internal/model/CommonRequestBody$RequestParam;", "sendAdMarkup", "adMarkup", "endpoint", "Companion", "ConnectionTypeDetail", "GzipRequestInterceptor", "vungle-ads_release"})
public final class VungleApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Platform platform;
    @NotNull
    private final FilePreferences filePreferences;
    @NotNull
    private VungleApi gzipApi;
    @NotNull
    private VungleApi api;
    @Nullable
    private DeviceNode baseDeviceInfo;
    @Nullable
    private AppNode appBody;
    @Nullable
    private String uaString;
    @Nullable
    private Boolean isGooglePlayServicesAvailable;
    @Nullable
    private String appSetId;
    @NotNull
    private final Lazy signalManager$delegate;
    @NotNull
    private Map<String, Long> retryAfterDataMap;
    @NotNull
    private Interceptor responseInterceptor;
    @NotNull
    private static final String TAG = "VungleApiClient";
    @NotNull
    private static final String MANUFACTURER_AMAZON = "Amazon";
    @NotNull
    private static final String BASE_URL = "https://config.ads.vungle.com/";
    @Nullable
    private static VungleAds.WrapperFramework WRAPPER_FRAMEWORK_SELECTED;
    @NotNull
    private static String headerUa;
    @NotNull
    private static final Set<Interceptor> networkInterceptors;
    @NotNull
    private static final Set<Interceptor> logInterceptors;
    @NotNull
    private static final Json json;

    public VungleApiClient(@NotNull Context applicationContext, @NotNull Platform platform, @NotNull FilePreferences filePreferences) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)filePreferences, (String)"filePreferences");
        this.applicationContext = applicationContext;
        this.platform = platform;
        this.filePreferences = filePreferences;
        this.uaString = System.getProperty("http.agent");
        this.appSetId = "";
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.applicationContext;
        boolean $i$f$inject = false;
        this.signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SignalManager invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
            }
        }));
        this.retryAfterDataMap = new ConcurrentHashMap();
        this.responseInterceptor = arg_0 -> VungleApiClient.responseInterceptor$lambda-0(this, arg_0);
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder().addInterceptor(this.responseInterceptor).proxySelector(new ProxySelector(){

            @NotNull
            public List<Proxy> select(@Nullable URI uri) {
                List<Proxy> list;
                try {
                    List<Proxy> list2 = ProxySelector.getDefault().select(uri);
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"{\n                      \u2026ri)\n                    }");
                    list = list2;
                }
                catch (Exception e2) {
                    list = CollectionsKt.listOf((Object)Proxy.NO_PROXY);
                }
                return list;
            }

            public void connectFailed(@Nullable URI uri, @Nullable SocketAddress sa, @Nullable IOException ioe) {
                try {
                    ProxySelector.getDefault().connectFailed(uri, sa, ioe);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        OkHttpClient client = builder2.build();
        OkHttpClient gzipClient = builder2.addInterceptor((Interceptor)new GzipRequestInterceptor()).build();
        this.api = new VungleApiImpl((Call.Factory)client);
        this.gzipApi = new VungleApiImpl((Call.Factory)gzipClient);
    }

    @NotNull
    public final VungleApi getGzipApi$vungle_ads_release() {
        return this.gzipApi;
    }

    public final void setGzipApi$vungle_ads_release(@NotNull VungleApi vungleApi) {
        Intrinsics.checkNotNullParameter((Object)vungleApi, (String)"<set-?>");
        this.gzipApi = vungleApi;
    }

    @VisibleForTesting
    public static /* synthetic */ void getGzipApi$vungle_ads_release$annotations() {
    }

    @Nullable
    public final AppNode getAppBody$vungle_ads_release() {
        return this.appBody;
    }

    public final void setAppBody$vungle_ads_release(@Nullable AppNode appNode) {
        this.appBody = appNode;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAppBody$vungle_ads_release$annotations() {
    }

    private final SignalManager getSignalManager() {
        Lazy lazy = this.signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    @NotNull
    public final Map<String, Long> getRetryAfterDataMap$vungle_ads_release() {
        return this.retryAfterDataMap;
    }

    public final void setRetryAfterDataMap$vungle_ads_release(@NotNull Map<String, Long> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.retryAfterDataMap = map;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRetryAfterDataMap$vungle_ads_release$annotations() {
    }

    @NotNull
    public final Interceptor getResponseInterceptor$vungle_ads_release() {
        return this.responseInterceptor;
    }

    public final void setResponseInterceptor$vungle_ads_release(@NotNull Interceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"<set-?>");
        this.responseInterceptor = interceptor;
    }

    @VisibleForTesting
    public static /* synthetic */ void getResponseInterceptor$vungle_ads_release$annotations() {
    }

    private final okhttp3.Response defaultErrorResponse(Request request) {
        return new Response.Builder().request(request).code(500).protocol(Protocol.HTTP_1_1).message("Server is busy").body(ResponseBody.Companion.create("{\"Error\":\"Server is busy\"}", MediaType.Companion.parse("application/json; charset=utf-8"))).build();
    }

    /*
     * WARNING - void declaration
     */
    private final String getPlacementID(RequestBody body) {
        Object object;
        try {
            void $this$decodeFromString$iv;
            StringFormat stringFormat = (StringFormat)json;
            String string$iv = this.bodyToString(body);
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(CommonRequestBody.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            CommonRequestBody adRequestBody = (CommonRequestBody)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            Object object2 = adRequestBody.getRequest();
            if (object2 == null || (object2 = ((CommonRequestBody.RequestParam)object2).getPlacements()) == null || (object2 = (String)object2.get(0)) == null) {
                object2 = "";
            }
            object = object2;
        }
        catch (Exception _) {
            object = "";
        }
        return object;
    }

    private final String bodyToString(RequestBody request) {
        String string;
        try {
            Buffer buffer = new Buffer();
            if (request == null) {
                return "";
            }
            request.writeTo((BufferedSink)buffer);
            string = buffer.readUtf8();
        }
        catch (Exception _) {
            string = "";
        }
        return string;
    }

    public final boolean checkIsRetryAfterActive(@NotNull String placementID) {
        boolean bl;
        long retryAfterValue;
        Intrinsics.checkNotNullParameter((Object)placementID, (String)"placementID");
        Long l = this.retryAfterDataMap.get(placementID);
        long l2 = retryAfterValue = l != null ? l : 0L;
        if (retryAfterValue > System.currentTimeMillis()) {
            bl = true;
        } else {
            this.retryAfterDataMap.remove(placementID);
            bl = false;
        }
        return bl;
    }

    public final long getRetryAfterHeaderValue(@NotNull String placementID) {
        Intrinsics.checkNotNullParameter((Object)placementID, (String)"placementID");
        Long l = this.retryAfterDataMap.get(placementID);
        return l != null ? l : 0L;
    }

    public final synchronized void initialize(@NotNull String appId) {
        AppNode app;
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.api.setAppId(appId);
        this.gzipApi.setAppId(appId);
        String versionName = "1.0";
        try {
            PackageInfo packageInfo;
            if (Build.VERSION.SDK_INT >= 33) {
                PackageInfo packageInfo2 = this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
                packageInfo = packageInfo2;
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"{\n                    ap\u2026      )\n                }");
            } else {
                PackageInfo packageInfo3 = this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), 0);
                packageInfo = packageInfo3;
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo3, (String)"{\n                    ap\u2026      )\n                }");
            }
            PackageInfo packageInfo4 = packageInfo;
            String string = packageInfo4.versionName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageInfo.versionName");
            versionName = string;
        }
        catch (Exception packageInfo4) {
            // empty catch block
        }
        this.baseDeviceInfo = this.getBasicDeviceBody(this.applicationContext);
        String string = this.applicationContext.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationContext.packageName");
        this.appBody = app = new AppNode(string, versionName, appId);
        this.isGooglePlayServicesAvailable = this.getPlayServicesAvailabilityFromAPI();
    }

    @Nullable
    public final Call<ConfigPayload> config() throws IOException {
        String baseUrl;
        CommonRequestBody.RequestExt extBody;
        AppNode appNode = this.appBody;
        if (appNode == null) {
            return null;
        }
        AppNode appInfo = appNode;
        CommonRequestBody requestBody = new CommonRequestBody(this.getDeviceBody$vungle_ads_release(true), appInfo, this.getUserBody(), null, null, 24, null);
        CommonRequestBody.RequestExt requestExt = extBody = VungleApiClient.getExtBody$default(this, false, 1, null);
        if (requestExt != null) {
            CommonRequestBody.RequestExt $this$config_u24lambda_u2d1 = requestExt;
            boolean bl = false;
            requestBody.setExt(extBody);
        }
        String string = baseUrl = FileUtility.INSTANCE.isValidUrl(BASE_URL) ? BASE_URL : "https://config.ads.vungle.com/";
        if (!StringsKt.endsWith$default((String)baseUrl, (String)"/", (boolean)false, (int)2, null)) {
            baseUrl = baseUrl + '/';
        }
        return this.api.config(headerUa, baseUrl + "config", requestBody);
    }

    @Nullable
    public final Call<AdPayload> requestAd(@NotNull String placement, @Nullable String adSize, boolean isHeaderBiddingEnable) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        String adsEndpoint = ConfigManager.INSTANCE.getAdsEndpoint();
        CharSequence charSequence = adsEndpoint;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        CommonRequestBody body = this.requestBody(!ConfigManager.INSTANCE.signalsDisabled());
        CommonRequestBody.RequestParam request = new CommonRequestBody.RequestParam(CollectionsKt.listOf((Object)placement), isHeaderBiddingEnable, null, null, null, null, null, 124, null);
        CharSequence charSequence2 = adSize;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            request.setAdSize(adSize);
        }
        body.setRequest(request);
        return this.gzipApi.ads(headerUa, adsEndpoint, body);
    }

    @Nullable
    public final Call<Void> ri(@NotNull CommonRequestBody.RequestParam request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String riEndpoint = ConfigManager.INSTANCE.getRiEndpoint();
        CharSequence charSequence = riEndpoint;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        AppNode appNode = this.appBody;
        if (appNode == null) {
            return null;
        }
        AppNode appInfo = appNode;
        DeviceNode device = this.getDeviceBody();
        CommonRequestBody.User userBody = this.getUserBody();
        CommonRequestBody body = new CommonRequestBody(device, appInfo, userBody, null, null, 24, null);
        body.setRequest(request);
        CommonRequestBody.RequestExt extBody = VungleApiClient.getExtBody$default(this, false, 1, null);
        if (extBody != null) {
            body.setExt(extBody);
        }
        return this.api.ri(headerUa, riEndpoint, body);
    }

    @Nullable
    public final BaseAdLoader.ErrorInfo pingTPAT(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (((CharSequence)url).length() == 0 || HttpUrl.Companion.parse(url) == null) {
            return new BaseAdLoader.ErrorInfo(121, "Invalid URL : " + url, null, true, 4, null);
        }
        boolean clearTextTrafficPermitted = false;
        try {
            string = new URL(url).getHost();
        }
        catch (MalformedURLException e2) {
            String string2 = e2.getLocalizedMessage();
            if (string2 == null) {
                string2 = "MalformedURLException";
            }
            return new BaseAdLoader.ErrorInfo(121, string2, null, true, 4, null);
        }
        String host = string;
        boolean bl = Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(host) : (clearTextTrafficPermitted = Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true);
        if (!clearTextTrafficPermitted && URLUtil.isHttpUrl((String)url)) {
            return new BaseAdLoader.ErrorInfo(121, "Clear Text Traffic is blocked", null, false, 12, null);
        }
        try {
            String ua;
            okhttp3.Response response;
            String string3 = this.uaString;
            if (string3 == null) {
                string3 = "";
            }
            if ((response = this.api.pingTPAT(ua = string3, url).execute()) == null || !response.isSuccessful()) {
                okhttp3.Response response2 = response;
                Integer code = response2 != null && (response2 = response2.raw()) != null ? Integer.valueOf(response2.code()) : null;
                Object[] objectArray = new Integer[]{301, 302, 307, 308};
                if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)code)) {
                    return new BaseAdLoader.ErrorInfo(29, "Tpat ping was redirected with code " + code, null, false, 12, null);
                }
                return new BaseAdLoader.ErrorInfo(121, "Tpat ping was not successful", null, false, 12, null);
            }
        }
        catch (Exception e3) {
            String string4 = e3.getLocalizedMessage();
            if (string4 == null) {
                string4 = "IOException";
            }
            return new BaseAdLoader.ErrorInfo(121, string4, null, false, 12, null);
        }
        return null;
    }

    public final void reportMetrics(@NotNull BlockingQueue<Sdk.SDKMetric.Builder> metrics, @NotNull AnalyticsClient.RequestListener requestListener) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)requestListener, (String)"requestListener");
        String metricsEndpoint = ConfigManager.INSTANCE.getMetricsEndpoint();
        CharSequence charSequence = metricsEndpoint;
        if (charSequence == null || charSequence.length() == 0) {
            requestListener.onFailure();
            return;
        }
        for (Sdk.SDKMetric.Builder builder2 : metrics) {
            String it;
            boolean bl;
            if (this.getConnectionType() != null) {
                bl = false;
                builder2.setConnectionType(it);
            }
            if (this.getConnectionTypeDetail() == null) continue;
            bl = false;
            builder2.setConnectionTypeDetail(it);
        }
        ArrayList<GeneratedMessageLite> metricsList = new ArrayList<GeneratedMessageLite>();
        for (Sdk.SDKMetric.Builder metric : metrics) {
            metricsList.add(metric.build());
        }
        Sdk.MetricBatch metricBatch = (Sdk.MetricBatch)Sdk.MetricBatch.newBuilder().addAllMetrics((Iterable<? extends Sdk.SDKMetric>)metricsList).build();
        MediaType mediaType = MediaType.Companion.parse("application/x-protobuf");
        byte[] byArray = metricBatch.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"batch.toByteArray()");
        RequestBody requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (MediaType)mediaType, (byte[])byArray, (int)0, (int)0, (int)12, null);
        this.api.sendMetrics(headerUa, metricsEndpoint, requestBody).enqueue(new Callback<Void>(requestListener){
            final /* synthetic */ AnalyticsClient.RequestListener $requestListener;
            {
                this.$requestListener = $requestListener;
            }

            public void onResponse(@Nullable Call<Void> call, @Nullable Response<Void> response) {
                this.$requestListener.onSuccess();
            }

            public void onFailure(@Nullable Call<Void> call, @Nullable Throwable t) {
                this.$requestListener.onFailure();
            }
        });
    }

    public final void reportErrors(@NotNull BlockingQueue<Sdk.SDKError.Builder> errors, @NotNull AnalyticsClient.RequestListener requestListener) {
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Intrinsics.checkNotNullParameter((Object)requestListener, (String)"requestListener");
        String loggingEndpoint = ConfigManager.INSTANCE.getErrorLoggingEndpoint();
        CharSequence charSequence = loggingEndpoint;
        if (charSequence == null || charSequence.length() == 0) {
            requestListener.onFailure();
            return;
        }
        for (Sdk.SDKError.Builder builder2 : errors) {
            String it;
            boolean bl;
            if (this.getConnectionType() != null) {
                bl = false;
                builder2.setConnectionType(it);
            }
            if (this.getConnectionTypeDetail() == null) continue;
            bl = false;
            builder2.setConnectionTypeDetail(it);
            builder2.setConnectionTypeDetailAndroid(it);
        }
        ArrayList<GeneratedMessageLite> errorsList = new ArrayList<GeneratedMessageLite>();
        for (Sdk.SDKError.Builder error : errors) {
            errorsList.add(error.build());
        }
        Sdk.SDKErrorBatch sDKErrorBatch = (Sdk.SDKErrorBatch)Sdk.SDKErrorBatch.newBuilder().addAllErrors((Iterable<? extends Sdk.SDKError>)errorsList).build();
        byte[] byArray = sDKErrorBatch.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"batch.toByteArray()");
        RequestBody requestBody = RequestBody.Companion.create(byArray, MediaType.Companion.parse("application/x-protobuf"), 0, sDKErrorBatch.toByteArray().length);
        this.api.sendErrors(headerUa, loggingEndpoint, requestBody).enqueue(new Callback<Void>(requestListener){
            final /* synthetic */ AnalyticsClient.RequestListener $requestListener;
            {
                this.$requestListener = $requestListener;
            }

            public void onResponse(@Nullable Call<Void> call, @Nullable Response<Void> response) {
                this.$requestListener.onSuccess();
            }

            public void onFailure(@Nullable Call<Void> call, @Nullable Throwable t) {
                this.$requestListener.onFailure();
            }
        });
    }

    public final void sendAdMarkup(@NotNull String adMarkup, @NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)adMarkup, (String)"adMarkup");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.api.sendAdMarkup(endpoint, RequestBody.Companion.create(adMarkup, MediaType.Companion.parse("application/json"))).enqueue(new Callback<Void>(){

            public void onResponse(@Nullable Call<Void> call, @Nullable Response<Void> response) {
            }

            public void onFailure(@Nullable Call<Void> call, @Nullable Throwable t) {
            }
        });
    }

    private final void initUserAgentLazy() {
        TimeIntervalMetric uaMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.USER_AGENT_LOAD_DURATION_MS);
        uaMetric.markStart();
        this.platform.getUserAgentLazy((Consumer<String>)((Consumer)new Consumer<String>(uaMetric, this){
            final /* synthetic */ TimeIntervalMetric $uaMetric;
            final /* synthetic */ VungleApiClient this$0;
            {
                this.$uaMetric = $uaMetric;
                this.this$0 = $receiver;
            }

            public void accept(@Nullable String uaString) {
                if (uaString == null) {
                    Logger.Companion.e("VungleApiClient", "Cannot Get UserAgent. Setting Default Device UserAgent");
                    AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 7, "Fail to get user agent.", null, null, null, 28, null);
                    return;
                }
                this.$uaMetric.markEnd();
                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.$uaMetric.getMetricType(), this.$uaMetric.calculateIntervalDuration(), null, null, null, null, 60, null);
                VungleApiClient.access$setUaString$p(this.this$0, uaString);
            }
        }));
    }

    @VisibleForTesting
    public final void addPlaySvcAvailabilityInCookie(boolean isPlaySvcAvailable) {
        this.filePreferences.put("isPlaySvcAvailable", isPlaySvcAvailable).apply();
    }

    @VisibleForTesting
    @Nullable
    public final Boolean getPlayServicesAvailabilityFromCookie() {
        return this.filePreferences.getBoolean("isPlaySvcAvailable");
    }

    @VisibleForTesting
    @Nullable
    public final Boolean getPlayServicesAvailabilityFromAPI() {
        Boolean result = null;
        try {
            GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)googleApiAvailabilityLight, (String)"getInstance()");
            GoogleApiAvailabilityLight googleApiAvailabilityLight2 = googleApiAvailabilityLight;
            result = googleApiAvailabilityLight2.isGooglePlayServicesAvailable(this.applicationContext) == 0;
            this.addPlaySvcAvailabilityInCookie(result);
        }
        catch (NoClassDefFoundError error) {
            Logger.Companion.w(TAG, "Play services Not available");
            result = false;
            try {
                this.addPlaySvcAvailabilityInCookie(result);
            }
            catch (Exception e2) {
                Logger.Companion.w(TAG, "Failure to write GPS availability to DB");
            }
        }
        catch (Exception exception) {
            Logger.Companion.w(TAG, "Unexpected exception from Play services lib.");
        }
        return result;
    }

    private final DeviceNode getBasicDeviceBody(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        if (display != null) {
            display.getMetrics(dm);
        }
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        String string2 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
        String string3 = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"RELEASE");
        DeviceNode device = new DeviceNode(string, string2, string3, AndroidPlatform.Companion.getCarrierName$vungle_ads_release(context), Intrinsics.areEqual((Object)MANUFACTURER_AMAZON, (Object)Build.MANUFACTURER) ? "amazon" : "android", dm.widthPixels, dm.heightPixels, this.uaString, null, null, null, 1792, null);
        try {
            this.uaString = this.platform.getUserAgent();
            device.setUa(this.uaString);
            this.initUserAgentLazy();
        }
        catch (Exception ex) {
            Logger.Companion.e(TAG, "Cannot Get UserAgent. Setting Default Device UserAgent." + ex.getLocalizedMessage());
        }
        return device;
    }

    @NotNull
    public final CommonRequestBody requestBody(boolean withSignals) throws IllegalStateException {
        CommonRequestBody body;
        block0: {
            CommonRequestBody.RequestExt extBody;
            DeviceNode device = this.getDeviceBody();
            CommonRequestBody.User userBody = this.getUserBody();
            body = new CommonRequestBody(device, this.appBody, userBody, null, null, 24, null);
            CommonRequestBody.RequestExt requestExt = extBody = this.getExtBody(withSignals);
            if (requestExt == null) break block0;
            CommonRequestBody.RequestExt it = requestExt;
            boolean bl = false;
            body.setExt(it);
        }
        return body;
    }

    public static /* synthetic */ CommonRequestBody requestBody$default(VungleApiClient vungleApiClient, boolean bl, int n, Object object) throws IllegalStateException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return vungleApiClient.requestBody(bl);
    }

    private final DeviceNode getDeviceBody() throws IllegalStateException {
        return this.getDeviceBody$vungle_ads_release(false);
    }

    @VisibleForTesting
    @NotNull
    public final synchronized DeviceNode getDeviceBody$vungle_ads_release(boolean explicitBlock) throws IllegalStateException {
        boolean bl;
        String it;
        Boolean limitAdTracking;
        AdvertisingInfo advertisingInfo;
        DeviceNode basicDeviceInfo = this.baseDeviceInfo;
        if (basicDeviceInfo == null) {
            DeviceNode deviceNode;
            DeviceNode it2 = deviceNode = this.getBasicDeviceBody(this.applicationContext);
            boolean bl2 = false;
            this.baseDeviceInfo = it2;
            basicDeviceInfo = deviceNode;
        }
        DeviceNode deviceBody = DeviceNode.copy$default(basicDeviceInfo, null, null, null, null, null, 0, 0, null, null, null, null, 2047, null);
        DeviceNode.AndroidAmazonExt androidAmazonExt = new DeviceNode.AndroidAmazonExt(null, null, 3, null);
        AdvertisingInfo advertisingInfo2 = advertisingInfo = this.platform.getAdvertisingInfo();
        String advertId = advertisingInfo2 != null ? advertisingInfo2.getAdvertisingId() : null;
        AdvertisingInfo advertisingInfo3 = advertisingInfo;
        Boolean bl3 = limitAdTracking = advertisingInfo3 != null ? Boolean.valueOf(advertisingInfo3.getLimitAdTracking()) : null;
        if (PrivacyManager.INSTANCE.shouldSendAdIds()) {
            if (advertId != null) {
                if (Intrinsics.areEqual((Object)MANUFACTURER_AMAZON, (Object)Build.MANUFACTURER)) {
                    androidAmazonExt.setAmazonAdvertisingId(advertId);
                } else {
                    androidAmazonExt.setGaid(advertId);
                }
                deviceBody.setIfa(advertId);
            } else {
                String androidID = this.platform.getAndroidId();
                String string = androidID;
                if (string == null) {
                    string = "";
                }
                deviceBody.setIfa(string);
                String string2 = androidID;
                if (string2 != null) {
                    String it3 = string2;
                    boolean bl4 = false;
                    androidAmazonExt.setAndroidId(it3);
                }
            }
        }
        if (!PrivacyManager.INSTANCE.shouldSendAdIds() || explicitBlock) {
            deviceBody.setIfa(null);
            androidAmazonExt.setAndroidId(null);
            androidAmazonExt.setGaid(null);
            androidAmazonExt.setAmazonAdvertisingId(null);
        }
        deviceBody.setLmt(Intrinsics.areEqual((Object)limitAdTracking, (Object)true) ? Integer.valueOf(1) : Integer.valueOf(0));
        boolean isGooglePlaySvcAvailable = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)this.isGooglePlayServicesAvailable());
        androidAmazonExt.setGooglePlayServicesAvailable(isGooglePlaySvcAvailable);
        this.appSetId = this.platform.getAppSetId();
        CharSequence charSequence = this.appSetId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            androidAmazonExt.setAppSetId(this.appSetId);
        }
        Intent batteryStatus = this.applicationContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        String batteryState = null;
        if (batteryStatus != null) {
            String string;
            int level = batteryStatus.getIntExtra("level", -1);
            int scale = batteryStatus.getIntExtra("scale", -1);
            if (level > 0 && scale > 0) {
                androidAmazonExt.setBatteryLevel((float)level / (float)scale);
            }
            int status = batteryStatus.getIntExtra("status", -1);
            block0 : switch (status) {
                case -1: {
                    string = "UNKNOWN";
                    break;
                }
                case 2: 
                case 5: {
                    switch (batteryStatus.getIntExtra("plugged", -1)) {
                        case 2: {
                            string = "BATTERY_PLUGGED_USB";
                            break block0;
                        }
                        case 1: {
                            string = "BATTERY_PLUGGED_AC";
                            break block0;
                        }
                        case 4: {
                            string = "BATTERY_PLUGGED_WIRELESS";
                            break block0;
                        }
                    }
                    string = "BATTERY_PLUGGED_OTHERS";
                    break;
                }
                default: {
                    string = "NOT_CHARGING";
                }
            }
            batteryState = string;
        } else {
            batteryState = "UNKNOWN";
        }
        androidAmazonExt.setBatteryState(batteryState);
        Object object = this.applicationContext.getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager powerManager = (PowerManager)object;
        androidAmazonExt.setBatterySaverEnabled(Build.VERSION.SDK_INT >= 21 ? (powerManager.isPowerSaveMode() ? 1 : 0) : 0);
        String string = this.getConnectionType();
        if (string != null) {
            it = string;
            boolean bl5 = false;
            androidAmazonExt.setConnectionType(it);
        }
        String string3 = this.getConnectionTypeDetail();
        if (string3 != null) {
            it = string3;
            boolean bl6 = false;
            androidAmazonExt.setConnectionTypeDetail(it);
        }
        androidAmazonExt.setLocale(Locale.getDefault().toString());
        androidAmazonExt.setLanguage(Locale.getDefault().getLanguage());
        androidAmazonExt.setTimeZone(TimeZone.getDefault().getID());
        androidAmazonExt.setVolumeLevel(this.platform.getVolumeLevel());
        androidAmazonExt.setSoundEnabled(this.platform.isSoundEnabled() ? 1 : 0);
        if (Intrinsics.areEqual((Object)MANUFACTURER_AMAZON, (Object)Build.MANUFACTURER)) {
            bl = this.applicationContext.getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
        } else if (Build.VERSION.SDK_INT >= 23) {
            Object object2 = this.applicationContext.getSystemService("uimode");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.app.UiModeManager");
            UiModeManager uiModeManager = (UiModeManager)object2;
            bl = uiModeManager.getCurrentModeType() == 4;
        } else {
            bl = this.applicationContext.getPackageManager().hasSystemFeature("com.google.android.tv") || !this.applicationContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
        }
        androidAmazonExt.setTv(bl);
        androidAmazonExt.setSideloadEnabled(this.platform.isSideLoaded());
        androidAmazonExt.setSdCardAvailable(this.platform.isSdCardPresent() ? 1 : 0);
        androidAmazonExt.setOsName(Build.FINGERPRINT);
        deviceBody.setUa(this.uaString);
        DeviceNode.VungleExt vungle = Intrinsics.areEqual((Object)MANUFACTURER_AMAZON, (Object)Build.MANUFACTURER) ? new DeviceNode.VungleExt(null, androidAmazonExt, 1, null) : new DeviceNode.VungleExt(androidAmazonExt, null, 2, null);
        DeviceNode.DeviceExt ext = new DeviceNode.DeviceExt(vungle);
        deviceBody.setExt(ext);
        return deviceBody;
    }

    private final CommonRequestBody.User getUserBody() {
        CommonRequestBody.User userBody = new CommonRequestBody.User(null, null, null, 7, null);
        String status = PrivacyManager.INSTANCE.getConsentStatus();
        String source = PrivacyManager.INSTANCE.getConsentSource();
        String messageVersion = PrivacyManager.INSTANCE.getConsentMessageVersion();
        long timestamp = PrivacyManager.INSTANCE.getConsentTimestamp();
        CommonRequestBody.GDPR gdpr = new CommonRequestBody.GDPR(status, source, timestamp, messageVersion);
        userBody.setGdpr(gdpr);
        String ccpaStatus = PrivacyManager.INSTANCE.getCcpaStatus();
        CommonRequestBody.CCPA ccpa = new CommonRequestBody.CCPA(ccpaStatus);
        userBody.setCcpa(ccpa);
        if (PrivacyManager.INSTANCE.getCoppaStatus() != COPPA.COPPA_NOTSET) {
            CommonRequestBody.COPPA coppaStatus = new CommonRequestBody.COPPA(PrivacyManager.INSTANCE.getCoppaStatus().getValue());
            userBody.setCoppa(coppaStatus);
        }
        return userBody;
    }

    private final CommonRequestBody.RequestExt getExtBody(boolean withSignals) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String extension;
        String string = extension = ConfigManager.INSTANCE.getConfigExtension();
        boolean bl = string != null ? ((CharSequence)string).length() == 0 : false;
        if (bl) {
            extension = this.filePreferences.getString("config_extension");
        }
        if (!withSignals) {
            charSequence2 = null;
        } else {
            try {
                charSequence = this.getSignalManager().generateSignals();
            }
            catch (Exception e2) {
                Logger.Companion.e(TAG, "Couldn't convert signals for sending. Error: " + e2.getMessage());
                charSequence = null;
            }
            charSequence2 = charSequence;
        }
        CharSequence signalsToSend = charSequence2;
        charSequence = extension;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = signalsToSend) == null || charSequence.length() == 0)) {
            return null;
        }
        return new CommonRequestBody.RequestExt(extension, (String)signalsToSend);
    }

    static /* synthetic */ CommonRequestBody.RequestExt getExtBody$default(VungleApiClient vungleApiClient, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return vungleApiClient.getExtBody(bl);
    }

    @NotNull
    public final String getConnectionTypeDetail(int type) {
        String string;
        switch (type) {
            case 7: {
                string = "cdma_1xrtt";
                break;
            }
            case 4: {
                string = "wcdma";
                break;
            }
            case 2: {
                string = "edge";
                break;
            }
            case 14: {
                string = "hrpd";
                break;
            }
            case 5: {
                string = "cdma_evdo_0";
                break;
            }
            case 6: {
                string = "cdma_evdo_a";
                break;
            }
            case 12: {
                string = "cdma_evdo_b";
                break;
            }
            case 1: {
                string = "gprs";
                break;
            }
            case 8: {
                string = "hsdpa";
                break;
            }
            case 9: {
                string = "hsupa";
                break;
            }
            case 13: {
                string = "lte";
                break;
            }
            case 20: {
                string = "5g";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isGooglePlayServicesAvailable() {
        if (this.isGooglePlayServicesAvailable == null) {
            this.isGooglePlayServicesAvailable = this.getPlayServicesAvailabilityFromCookie();
        }
        if (this.isGooglePlayServicesAvailable == null) {
            this.isGooglePlayServicesAvailable = this.getPlayServicesAvailabilityFromAPI();
        }
        return this.isGooglePlayServicesAvailable;
    }

    /*
     * WARNING - void declaration
     */
    private final String getConnectionType() {
        if (PermissionChecker.checkCallingOrSelfPermission((Context)this.applicationContext, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            String string;
            Object object = this.applicationContext.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager cm = (ConnectivityManager)object;
            NetworkInfo info = cm.getActiveNetworkInfo();
            if (info != null) {
                void var3_3;
                String string2;
                switch (info.getType()) {
                    case 7: {
                        string2 = "BLUETOOTH";
                        break;
                    }
                    case 9: {
                        string2 = "ETHERNET";
                        break;
                    }
                    case 0: {
                        string2 = "MOBILE";
                        break;
                    }
                    case 1: 
                    case 6: {
                        string2 = "WIFI";
                        break;
                    }
                    default: {
                        string2 = "UNKNOWN";
                    }
                }
                String connectionType = string2;
                string = var3_3;
            } else {
                string = "NONE";
            }
            return string;
        }
        return null;
    }

    @Nullable
    public final String getConnectionTypeDetail() {
        if (PermissionChecker.checkCallingOrSelfPermission((Context)this.applicationContext, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            Object object = this.applicationContext.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager cm = (ConnectivityManager)object;
            NetworkInfo info = cm.getActiveNetworkInfo();
            if (info != null) {
                return this.getConnectionTypeDetail(info.getSubtype());
            }
            return "unknown";
        }
        return null;
    }

    private static final okhttp3.Response responseInterceptor$lambda-0(VungleApiClient this$0, Interceptor.Chain chain) {
        okhttp3.Response response;
        block7: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request request = chain.request();
            response = null;
            try {
                response = chain.proceed(request);
                String retryAfterTimeStr = response.headers().get("Retry-After");
                CharSequence charSequence = retryAfterTimeStr;
                if (charSequence == null || charSequence.length() == 0) break block7;
                try {
                    long retryAfterTimeValue = Long.parseLong(retryAfterTimeStr);
                    if (retryAfterTimeValue > 0L) {
                        String placementID;
                        String urlString = request.url().encodedPath();
                        long retryValue = retryAfterTimeValue * (long)1000 + System.currentTimeMillis();
                        if (StringsKt.endsWith$default((String)urlString, (String)"ads", (boolean)false, (int)2, null) && ((CharSequence)(placementID = this$0.getPlacementID(request.body()))).length() > 0) {
                            Long l = retryValue;
                            this$0.retryAfterDataMap.put(placementID, l);
                        }
                    }
                }
                catch (Exception _) {
                    Logger.Companion.d(TAG, "Retry-After value is not an valid value");
                }
            }
            catch (OutOfMemoryError e2) {
                Logger.Companion.e(TAG, "OOM for " + request.url());
                response = this$0.defaultErrorResponse(request);
            }
            catch (Exception e3) {
                Logger.Companion.e(TAG, "Exception: " + e3.getMessage() + " for " + request.url());
                response = this$0.defaultErrorResponse(request);
            }
        }
        return response;
    }

    public static final /* synthetic */ void access$setUaString$p(VungleApiClient $this, String string) {
        $this.uaString = string;
    }

    static {
        headerUa = VungleApiClient.Companion.defaultHeader();
        networkInterceptors = new HashSet();
        logInterceptors = new HashSet();
        json = JsonKt.Json$default(null, (Function1)Companion.json.1.INSTANCE, (int)1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/vungle/ads/internal/network/VungleApiClient$Companion;", "", "()V", "BASE_URL", "", "getBASE_URL$vungle_ads_release", "()Ljava/lang/String;", "MANUFACTURER_AMAZON", "TAG", "WRAPPER_FRAMEWORK_SELECTED", "Lcom/vungle/ads/VungleAds$WrapperFramework;", "getWRAPPER_FRAMEWORK_SELECTED$vungle_ads_release", "()Lcom/vungle/ads/VungleAds$WrapperFramework;", "setWRAPPER_FRAMEWORK_SELECTED$vungle_ads_release", "(Lcom/vungle/ads/VungleAds$WrapperFramework;)V", "headerUa", "getHeaderUa", "setHeaderUa", "(Ljava/lang/String;)V", "json", "Lkotlinx/serialization/json/Json;", "logInterceptors", "", "Lokhttp3/Interceptor;", "networkInterceptors", "defaultHeader", "reset", "", "reset$vungle_ads_release", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getBASE_URL$vungle_ads_release() {
            return BASE_URL;
        }

        @Nullable
        public final VungleAds.WrapperFramework getWRAPPER_FRAMEWORK_SELECTED$vungle_ads_release() {
            return WRAPPER_FRAMEWORK_SELECTED;
        }

        public final void setWRAPPER_FRAMEWORK_SELECTED$vungle_ads_release(@Nullable VungleAds.WrapperFramework wrapperFramework) {
            WRAPPER_FRAMEWORK_SELECTED = wrapperFramework;
        }

        @NotNull
        public final String getHeaderUa() {
            return headerUa;
        }

        public final void setHeaderUa(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            headerUa = string;
        }

        private final String defaultHeader() {
            return (Intrinsics.areEqual((Object)VungleApiClient.MANUFACTURER_AMAZON, (Object)Build.MANUFACTURER) ? "VungleAmazon/" : "VungleDroid/") + "7.3.1";
        }

        public final void reset$vungle_ads_release() {
            this.setWRAPPER_FRAMEWORK_SELECTED$vungle_ads_release(null);
            this.setHeaderUa(this.defaultHeader());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/vungle/ads/internal/network/VungleApiClient$GzipRequestInterceptor;", "Lokhttp3/Interceptor;", "()V", "gzip", "Lokhttp3/RequestBody;", "requestBody", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "vungle-ads_release"})
    public static final class GzipRequestInterceptor
    implements Interceptor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String CONTENT_ENCODING = "Content-Encoding";
        @NotNull
        private static final String GZIP = "gzip";

        @NotNull
        public okhttp3.Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request originalRequest = chain.request();
            RequestBody originalReqBody = originalRequest.body();
            if (originalReqBody == null || originalRequest.header(CONTENT_ENCODING) != null) {
                return chain.proceed(originalRequest);
            }
            Request compressedRequest = originalRequest.newBuilder().header(CONTENT_ENCODING, GZIP).method(originalRequest.method(), this.gzip(originalReqBody)).build();
            return chain.proceed(compressedRequest);
        }

        private final RequestBody gzip(RequestBody requestBody) throws IOException {
            Buffer output = new Buffer();
            BufferedSink gzipSink = Okio.buffer((Sink)((Sink)new GzipSink((Sink)output)));
            requestBody.writeTo(gzipSink);
            gzipSink.close();
            return new RequestBody(requestBody, output){
                final /* synthetic */ RequestBody $requestBody;
                final /* synthetic */ Buffer $output;
                {
                    this.$requestBody = $requestBody;
                    this.$output = $output;
                }

                @Nullable
                public MediaType contentType() {
                    return this.$requestBody.contentType();
                }

                public long contentLength() {
                    return this.$output.size();
                }

                public void writeTo(@NotNull BufferedSink sink) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    sink.write(this.$output.snapshot());
                }
            };
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/network/VungleApiClient$GzipRequestInterceptor$Companion;", "", "()V", "CONTENT_ENCODING", "", "GZIP", "vungle-ads_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/vungle/ads/internal/network/VungleApiClient$ConnectionTypeDetail;", "", "Companion", "vungle-ads_release"})
    public static @interface ConnectionTypeDetail {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String UNKNOWN = "unknown";
        @NotNull
        public static final String CDMA_1XRTT = "cdma_1xrtt";
        @NotNull
        public static final String WCDMA = "wcdma";
        @NotNull
        public static final String EDGE = "edge";
        @NotNull
        public static final String HRPD = "hrpd";
        @NotNull
        public static final String CDMA_EVDO_0 = "cdma_evdo_0";
        @NotNull
        public static final String CDMA_EVDO_A = "cdma_evdo_a";
        @NotNull
        public static final String CDMA_EVDO_B = "cdma_evdo_b";
        @NotNull
        public static final String GPRS = "gprs";
        @NotNull
        public static final String HSDPA = "hsdpa";
        @NotNull
        public static final String HSUPA = "hsupa";
        @NotNull
        public static final String LTE = "lte";
        @NotNull
        public static final String FIFTH_G = "5g";

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/vungle/ads/internal/network/VungleApiClient$ConnectionTypeDetail$Companion;", "", "()V", "CDMA_1XRTT", "", "CDMA_EVDO_0", "CDMA_EVDO_A", "CDMA_EVDO_B", "EDGE", "FIFTH_G", "GPRS", "HRPD", "HSDPA", "HSUPA", "LTE", "UNKNOWN", "WCDMA", "vungle-ads_release"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            public static final String UNKNOWN = "unknown";
            @NotNull
            public static final String CDMA_1XRTT = "cdma_1xrtt";
            @NotNull
            public static final String WCDMA = "wcdma";
            @NotNull
            public static final String EDGE = "edge";
            @NotNull
            public static final String HRPD = "hrpd";
            @NotNull
            public static final String CDMA_EVDO_0 = "cdma_evdo_0";
            @NotNull
            public static final String CDMA_EVDO_A = "cdma_evdo_a";
            @NotNull
            public static final String CDMA_EVDO_B = "cdma_evdo_b";
            @NotNull
            public static final String GPRS = "gprs";
            @NotNull
            public static final String HSDPA = "hsdpa";
            @NotNull
            public static final String HSUPA = "hsupa";
            @NotNull
            public static final String LTE = "lte";
            @NotNull
            public static final String FIFTH_G = "5g";

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

