package com.vungle.ads.internal.task

import com.vungle.ads.internal.executor.VungleThreadPoolExecutor

abstract class PriorityRunnable : VungleThreadPoolExecutor.ComparableRunnable {
    //Higher priority goes first
    override operator fun compareTo(other: Any): Int {
        if (other is PriorityRunnable) {
            val current = priority
            val incoming = other.priority
            return incoming.compareTo(current)
        }
        return -1
    }

    abstract val priority: Int
}
