package com.vungle.ads.internal.util

import android.util.Base64
import java.io.ByteArrayOutputStream
import java.io.IOException
import java.util.zip.GZIPOutputStream
import kotlin.jvm.Throws

object InputOutputUtils {

    /**
     * Function that takes passed String and converts it for sending to backend(usually).
     * Implementation does GZip it and then Base64 encoding.
     * */
    @Throws(IOException::class)
    fun convertForSending(stringToConvert: String): String {
        ByteArrayOutputStream(stringToConvert.length).use { os ->
            GZIPOutputStream(os).use { gos ->
                gos.write(stringToConvert.toByteArray())
                gos.close()
                val compressed = os.toByteArray()
                return Base64.encodeToString(compressed, Base64.NO_WRAP)
            }
        }
    }
}
