package com.vungle.ads

import android.content.Context
import com.vungle.ads.internal.AdInternal
import com.vungle.ads.internal.BannerAdInternal
import com.vungle.ads.internal.presenter.AdPlayCallback
import com.vungle.ads.internal.protos.Sdk
import com.vungle.ads.internal.util.Logger
import com.vungle.ads.internal.util.ThreadUtil

@Deprecated("Use VungleBannerView instead")
class BannerAd private constructor(
    context: Context,
    placementId: String,
    private val adSize: VungleAdSize,
    adConfig: AdConfig
) :
    BaseAd(context, placementId, adConfig) {

    constructor(context: Context, placementId: String, adSize: VungleAdSize) : this(
        context,
        placementId,
        adSize,
        AdConfig()
    )

    @Deprecated("Use VungleAdSize instead")
    constructor(context: Context, placementId: String, adSize: BannerAdSize) : this(
        context,
        placementId,
        VungleAdSize.run {
            when (adSize) {
                BannerAdSize.BANNER -> BANNER
                BannerAdSize.BANNER_SHORT -> BANNER_SHORT
                BannerAdSize.BANNER_LEADERBOARD -> BANNER_LEADERBOARD
                BannerAdSize.VUNGLE_MREC -> MREC
            }
        },
        AdConfig()
    )

    private var bannerView: BannerView? = null

    fun getAdViewSize(): VungleAdSize {
        return (adInternal as BannerAdInternal).updatedAdSize ?: adSize
    }

    override fun constructAdInternal(context: Context): BannerAdInternal =
        BannerAdInternal(context, adSize)

    private val adPlayCallback = (adInternal as BannerAdInternal).wrapCallback(
        object : AdPlayCallback {
            override fun onAdStart(id: String?) {
                signalManager.increaseSessionDepthCounter()
                ThreadUtil.runOnUiThread {
                    adListener?.onAdStart(this@BannerAd)
                }
            }

            override fun onAdImpression(id: String?) {
                ThreadUtil.runOnUiThread {
                    adListener?.onAdImpression(this@BannerAd)
                }
                showToDisplayMetric.markEnd()
                AnalyticsClient.logMetric(showToDisplayMetric, placementId, creativeId, eventId)
                displayToClickMetric.markStart()
            }

            override fun onAdEnd(id: String?) {
                ThreadUtil.runOnUiThread {
                    adListener?.onAdEnd(this@BannerAd)
                }
            }

            override fun onAdClick(id: String?) {
                ThreadUtil.runOnUiThread {
                    adListener?.onAdClicked(this@BannerAd)
                }
                displayToClickMetric.markEnd()
                AnalyticsClient.logMetric(displayToClickMetric, placementId, creativeId, eventId)
            }

            override fun onAdRewarded(id: String?) {
                // no-op
            }

            override fun onAdLeftApplication(id: String?) {
                ThreadUtil.runOnUiThread {
                    adListener?.onAdLeftApplication(this@BannerAd)
                }
            }

            override fun onFailure(error: VungleError) {
                ThreadUtil.runOnUiThread {
                    adListener?.onAdFailedToPlay(this@BannerAd, error)
                }
            }
        })

    fun finishAd() {
        bannerView?.finishAdInternal(true)
    }

    fun getBannerView(): BannerView? {
        AnalyticsClient.logMetric(
            SingleValueMetric(Sdk.SDKMetric.SDKMetricType.PLAY_AD_API),
            placementId, creativeId, eventId
        )
        if (bannerView != null) {
            return bannerView
        }
        val error = adInternal.canPlayAd(true)
        if (error != null) {
            if (adInternal.isErrorTerminal(error.code)) {
                adInternal.adState = AdInternal.AdState.ERROR
            }
            ThreadUtil.runOnUiThread {
                adListener?.onAdFailedToPlay(
                    this@BannerAd,
                    error
                )
            }
            return null
        }

        // the advertisement already be checked in canPlayAd() function
        val advertisement = adInternal.advertisement ?: return null
        val placement = adInternal.placement ?: return null

        adInternal.cancelDownload()

        val fixedAdSize = getAdViewSize()
        try {
            bannerView = BannerView(
                context,
                placement,
                advertisement,
                fixedAdSize,
                adConfig,
                adPlayCallback,
                adInternal.bidPayload
            )
        } catch (ex: InstantiationException) {
            Logger.e("BannerAd", "Can not create banner view: ${ex.message}", ex)
            return null
        } finally {
            responseToShowMetric.markEnd()
            AnalyticsClient.logMetric(responseToShowMetric, placementId, creativeId, eventId)
        }

        showToDisplayMetric.markStart()

        return bannerView
    }

}
