package com.vungle.ads

import android.content.Context
import android.content.IntentFilter
import android.media.AudioManager
import android.view.ViewGroup
import com.vungle.ads.internal.util.Logger
import android.widget.RelativeLayout
import com.vungle.ads.ServiceLocator.Companion.inject
import com.vungle.ads.internal.ConfigManager
import com.vungle.ads.internal.ImpressionTracker
import com.vungle.ads.internal.executor.Executors
import com.vungle.ads.internal.model.AdPayload
import com.vungle.ads.internal.model.BidPayload
import com.vungle.ads.internal.model.Placement
import com.vungle.ads.internal.omsdk.OMTracker
import com.vungle.ads.internal.platform.Platform
import com.vungle.ads.internal.presenter.AdEventListener
import com.vungle.ads.internal.presenter.AdPlayCallback
import com.vungle.ads.internal.presenter.MRAIDPresenter
import com.vungle.ads.internal.protos.Sdk
import com.vungle.ads.internal.ui.VungleWebClient
import com.vungle.ads.internal.ui.WatermarkView
import com.vungle.ads.internal.ui.view.MRAIDAdWidget
import com.vungle.ads.internal.util.ViewUtility.dpToPixels
import java.util.concurrent.atomic.AtomicBoolean

@Deprecated("This class is deprecated and will be removed in a future release.")
class BannerView @Throws(InstantiationException::class) constructor(
    context: Context,
    val placement: Placement,
    val advertisement: AdPayload,
    adSize: VungleAdSize,
    adConfig: AdConfig,
    adPlayCallback: AdPlayCallback,
    bidPayload: BidPayload?
) : RelativeLayout(context) {

    private var calculatedPixelWidth = 0
    private var calculatedPixelHeight = 0

    private var adWidget: MRAIDAdWidget? = null
    private var presenter: MRAIDPresenter? = null
    private var imageView: WatermarkView? = null

    private var isOnImpressionCalled: Boolean = false
    private val destroyed = AtomicBoolean(false)
    private val presenterStarted = AtomicBoolean(false)

    private val impressionTracker by lazy { ImpressionTracker(context) }

    override fun onWindowVisibilityChanged(visibility: Int) {
        super.onWindowVisibilityChanged(visibility)

        setAdVisibility(visibility == VISIBLE)
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        Logger.d(TAG, "onAttachedToWindow()")
        if (!presenterStarted.getAndSet(true)) {
            presenter?.prepare()

            impressionTracker.addView(this) {
                Logger.d(TAG, "ImpressionTracker checked the banner view become visible.")
                isOnImpressionCalled = true
                checkHardwareAcceleration()
                presenter?.start()
            }
        }

        renderAd()
    }

    private fun setAdVisibility(isVisible: Boolean) {
        if (!isOnImpressionCalled) {
            return
        }

        // The visibility change must be triggered after impression fired.
        if (!destroyed.get()) {
            presenter?.setAdVisibility(isVisible)
        }
    }

    private fun checkHardwareAcceleration() {
        Logger.w(TAG, "hardwareAccelerated = $isHardwareAccelerated")
        if (!isHardwareAccelerated) {
            AnalyticsClient.logMetric(
                Sdk.SDKMetric.SDKMetricType.HARDWARE_ACCELERATE_DISABLED,
                placementId = placement.referenceId,
                creativeId = advertisement.getCreativeId(),
                eventId = advertisement.eventId(),
            )
        }
    }

    fun finishAdInternal(isFinishedByApi: Boolean) {
        if (destroyed.get()) {
            return
        }
        destroyed.set(true)
        val flag = (MRAIDAdWidget.AdStopReason.IS_AD_FINISHING
                or if (isFinishedByApi) MRAIDAdWidget.AdStopReason.IS_AD_FINISHED_BY_API else 0)
        presenter?.stop()
        presenter?.detach(flag)
        impressionTracker.destroy()
        try {
            parent?.let {
                if (it is ViewGroup) {
                    it.removeView(this)
                }
            }
            removeAllViews()
        } catch (e: Exception) {
            Logger.d(TAG, "Removing webView error: $e")
        }
    }

    private fun renderAd() {
        if (adWidget != null && adWidget?.parent != this) {
            addView(adWidget, calculatedPixelWidth, calculatedPixelHeight)
            if (imageView != null) {
                addView(imageView, calculatedPixelWidth, calculatedPixelHeight)
                imageView?.bringToFront()
            }
        }

        val bannerLayoutParams = layoutParams
        if (bannerLayoutParams != null) {
            //Set Ad Size when Banner Ad is attached to Window
            bannerLayoutParams.height = calculatedPixelHeight
            bannerLayoutParams.width = calculatedPixelWidth
            requestLayout()
        }
    }

    companion object {
        private const val TAG = "BannerView"
    }

    init {
        //set Ad Size
        calculatedPixelHeight = dpToPixels(context, adSize.height)
        calculatedPixelWidth = dpToPixels(context, adSize.width)
        val adEventListener = object : AdEventListener(
            adPlayCallback,
            placement
        ) {}

        val adWidget: MRAIDAdWidget?
        try {
            adWidget = MRAIDAdWidget(context)
        } catch (ex: InstantiationException) {
            adEventListener.onError(
                AdCantPlayWithoutWebView().apply {
                    setPlacementId(placement.referenceId)
                    setEventId(advertisement.eventId())
                    setCreativeId(advertisement.getCreativeId())
                }.logError(),
                placement.referenceId
            )
            throw ex
        }
        this.adWidget = adWidget

        adWidget.setCloseDelegate(object : MRAIDAdWidget.CloseDelegate {
            override fun close() {
                finishAdInternal(false)
            }
        })

        val executors: Executors by inject(context)
        val omTrackerFactory: OMTracker.Factory by inject(context)
        val omTracker =
            omTrackerFactory.make(ConfigManager.omEnabled() && advertisement.omEnabled())
        val platform: Platform by inject(context)
        val webClient = VungleWebClient(
            advertisement,
            placement,
            executors.offloadExecutor,
            platform = platform
        )
        webClient.setWebViewObserver(omTracker)
        presenter =
            MRAIDPresenter(
                adWidget,
                advertisement,
                placement,
                webClient,
                executors.jobExecutor,
                omTracker,
                bidPayload,
                platform,
            ).apply {
                setEventListener(adEventListener)
            }

        adConfig.getWatermark()?.let {
            imageView = WatermarkView(context, it)
        }

    }

}
