package com.vungle.ads.fpd

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import java.util.concurrent.ConcurrentHashMap

@Serializable
class FirstPartyData {
    @SerialName("session_context")
    @Volatile
    private var _sessionContext: SessionContext? = null
    val sessionContext: SessionContext
        @Synchronized get() {
            return _sessionContext ?: SessionContext().also { _sessionContext = it }
        }

    @SerialName("demographic")
    @Volatile
    private var _demographic: Demographic? = null
    val demographic: Demographic
        @Synchronized get() {
            return _demographic ?: Demographic().also { _demographic = it }
        }

    @SerialName("location")
    @Volatile
    private var _location: Location? = null
    val location: Location
        @Synchronized get() {
            return _location ?: Location().also { _location = it }
        }

    @SerialName("revenue")
    @Volatile
    private var _revenue: Revenue? = null
    val revenue: Revenue
        @Synchronized get() {
            return _revenue ?: Revenue().also { _revenue = it }
        }

    @SerialName("custom_data")
    private var _customData: MutableMap<String, String>? = null
    val customData: MutableMap<String, String>
        @Synchronized get() {
            return _customData ?: ConcurrentHashMap<String, String>().also { _customData = it }
        }

    @Synchronized
    fun clearAll() {
        _sessionContext = null
        _demographic = null
        _location = null
        _revenue = null
        _customData?.clear()
        _customData = null
    }
}



