package com.vungle.ads.fpd

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
class Location {

    @SerialName("country")
    private var country: String? = null

    @SerialName("region_state")
    private var regionState: String? = null

    @SerialName("postal_code")
    private var postalCode: String? = null

    @SerialName("dma")
    private var dma: Int? = null

    @SerialName("latitude")
    private var latitude: Float? = null

    @SerialName("longitude")
    private var longitude: Float? = null

    @SerialName("location_source")
    private var locationSource: Int? = null

    @SerialName("is_traveling")
    private var isTraveling: Boolean? = null

    // Setter methods
    fun setCountry(country: String): Location {
        this.country = country
        return this
    }

    fun setRegionState(regionState: String): Location {
        this.regionState = regionState
        return this
    }

    fun setPostalCode(postalCode: String): Location {
        this.postalCode = postalCode
        return this
    }

    fun setDma(dma: Int): Location {
        this.dma = dma
        return this
    }

    fun setLatitude(latitude: Float): Location {
        this.latitude = latitude
        return this
    }

    fun setLongitude(longitude: Float): Location {
        this.longitude = longitude
        return this
    }

    fun setLocationSource(locationSource: LocationSource): Location {
        this.locationSource = locationSource.id
        return this
    }

    fun setIsTraveling(isTraveling: Boolean): Location {
        this.isTraveling = isTraveling
        return this
    }
}

enum class LocationSource(val id: Int, val method: String) {
    OTHER(0, "Other"),
    GPS(1, "GPS"),
    IP_ADDRESS(2, "IP address"),
    USER_INPUT(3, "User input"),
    MOBILE_NETWORK(4, "Mobile network"),
    WIFI(5, "Wi-Fi"),
    BEACON(6, "Beacon"),
    RFID(7, "RFID"),
    GEOFENCING(8, "Geofencing"),
    SENSOR(9, "Sensor")
}
