package com.vungle.ads.internal.signals

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.Transient


@Serializable
data class SignaledAd(
    @Transient val lastAdLoadTime: Long? = 0L,
    @Transient val loadAdTime: Long = 0L
) {
    @SerialName("${SignalKey.TEMPLATE_SIGNAL}")
    var templateSignals: String? = null

    @SerialName("${SignalKey.DURATION_AFTER_PREVIOUS_LOAD}")
    val timeSinceLastAdLoad: Long

    @SerialName("${SignalKey.EVENT_ID}")
    var eventId: String? = null

    @SerialName("${SignalKey.AD_LOADED_PLAYED_DURATION}")
    var timeBetweenAdAvailabilityAndPlayAd = 0L

    @SerialName("${SignalKey.SCREEN_ORIENTATION}")
    var screenOrientation: Int = 0

    @Transient
    var adAvailabilityCallbackTime: Long = 0L
    @Transient
    var playAdTime: Long = 0L

    init {
        timeSinceLastAdLoad = getTimeDifference(lastAdLoadTime, loadAdTime)
    }

    fun calculateTimeBetweenAdAvailabilityAndPlayAd() {
        timeBetweenAdAvailabilityAndPlayAd =
            getTimeDifference(adAvailabilityCallbackTime, playAdTime)
    }

    private fun getTimeDifference(lastAdLoadTime: Long?, loadAdTime: Long): Long {
        if (lastAdLoadTime != null) {
            val diff = loadAdTime - lastAdLoadTime
            return if (diff < 0) -1 else diff
        }
        return -1
    }
}
