/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ConfigurationError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.executor.SDKExecutors;
import com.vungle.ads.internal.model.ConfigExtension;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.util.Logger;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007J\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0007J\b\u0010!\u001a\u0004\u0018\u00010\u0007J\b\u0010\"\u001a\u0004\u0018\u00010\u0007J\b\u0010#\u001a\u0004\u0018\u00010\u0007J\b\u0010$\u001a\u0004\u0018\u00010\u0007J\u0006\u0010%\u001a\u00020\u0007J\b\u0010&\u001a\u0004\u0018\u00010\u0007J\u0006\u0010'\u001a\u00020\u0017J\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010)\u001a\u00020\u0017J\b\u0010*\u001a\u0004\u0018\u00010\u0007J\b\u0010+\u001a\u0004\u0018\u00010\u0007J\u0006\u0010,\u001a\u00020\u0007J\u0010\u0010-\u001a\u0004\u0018\u00010\u00112\u0006\u0010.\u001a\u00020\u0007J\b\u0010/\u001a\u0004\u0018\u00010\u0007J\u0006\u00100\u001a\u00020\u001fJ\u0006\u00101\u001a\u00020\u001fJ*\u00102\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00172\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0007J\u0006\u00105\u001a\u00020\u0017J\u0006\u00106\u001a\u00020\u0017J\u0006\u00107\u001a\u00020\u0017J\u0006\u00108\u001a\u00020\u0017J\u001d\u00109\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b<J\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010J\u0006\u0010=\u001a\u00020\u0017J\u0006\u0010>\u001a\u00020\u0017J\u0006\u0010?\u001a\u00020\u0017J\"\u0010@\u001a\u0002032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0007J\u001d\u0010A\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\bBJ\u0010\u0010C\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0019\u0010D\u001a\u00020\u00172\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0001\u00a2\u0006\u0002\bER\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F\u00b2\u0006\n\u0010G\u001a\u00020HX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001a\u001a\u00020\u001bX\u008a\u0084\u0002\u00b2\u0006\n\u0010I\u001a\u00020JX\u008a\u0084\u0002\u00b2\u0006\n\u0010I\u001a\u00020JX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001a\u001a\u00020\u001bX\u008a\u0084\u0002\u00b2\u0006\n\u0010K\u001a\u00020LX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/ConfigManager;", "", "()V", "DEFAULT_SESSION_TIMEOUT_SECONDS", "", "DEFAULT_SIGNALS_SESSION_TIMEOUT_SECONDS", "TAG", "", "config", "Lcom/vungle/ads/internal/model/ConfigPayload;", "configExt", "endpoints", "Lcom/vungle/ads/internal/model/ConfigPayload$Endpoints;", "json", "Lkotlinx/serialization/json/Json;", "placements", "", "Lcom/vungle/ads/internal/model/Placement;", "fetchConfig", "context", "Landroid/content/Context;", "fetchConfig$vungle_ads_release", "fpdEnabled", "", "getAdsEndpoint", "getCachedConfig", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "appId", "getCleverCacheDiskPercentage", "getCleverCacheDiskSize", "", "getConfigExtension", "getErrorLoggingEndpoint", "getGDPRButtonAccept", "getGDPRButtonDeny", "getGDPRConsentMessage", "getGDPRConsentMessageVersion", "getGDPRConsentTitle", "getGDPRIsCountryDataProtected", "getLogLevel", "getMetricsEnabled", "getMetricsEndpoint", "getMraidEndpoint", "getMraidJsVersion", "getPlacement", "id", "getRiEndpoint", "getSessionTimeout", "getSignalsSessionTimeout", "initWithConfig", "", "fromCachedConfig", "isCacheableAssetsRequired", "isCleverCacheEnabled", "isReportIncentivizedEnabled", "omEnabled", "onConfigExtensionReceived", "ext", "Lcom/vungle/ads/internal/model/ConfigExtension;", "onConfigExtensionReceived$vungle_ads_release", "rtaDebuggingEnabled", "shouldDisableAdId", "signalsDisabled", "updateCachedConfig", "updateConfigExtension", "updateConfigExtension$vungle_ads_release", "updateConfigSwitchThread", "validateEndpoints", "validateEndpoints$vungle_ads_release", "vungle-ads_release", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/SDKExecutors;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    public static final String TAG = "ConfigManager";
    private static final int DEFAULT_SESSION_TIMEOUT_SECONDS = 900;
    private static final int DEFAULT_SIGNALS_SESSION_TIMEOUT_SECONDS = 1800;
    @Nullable
    private static ConfigPayload config;
    @Nullable
    private static ConfigPayload.Endpoints endpoints;
    @Nullable
    private static List<Placement> placements;
    @Nullable
    private static String configExt;
    @NotNull
    private static final Json json;

    private ConfigManager() {
    }

    @Nullable
    public final ConfigPayload fetchConfig$vungle_ads_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        try {
            Response<ConfigPayload> response;
            Call<ConfigPayload> call = ConfigManager.fetchConfig$lambda-0((Lazy<VungleApiClient>)vungleApiClient$delegate).config();
            Response<ConfigPayload> response2 = response = call != null ? call.execute() : null;
            if (response == null || !response.isSuccessful()) {
                return null;
            }
            ConfigPayload configPayload = response.body();
            if (configPayload == null) {
                return null;
            }
            ConfigPayload configPayload2 = configPayload;
            if (configPayload2.getEndpoints() == null || !this.validateEndpoints$vungle_ads_release(configPayload2.getEndpoints()) || configPayload2.getPlacements() == null) {
                return null;
            }
            return configPayload2;
        }
        catch (Throwable throwable) {
            Logger.Companion.e(TAG, "Error while fetching config: " + throwable.getMessage());
            return null;
        }
    }

    @VisibleForTesting
    public final void updateConfigExtension$vungle_ads_release(@NotNull Context context, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        configExt = ext;
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        ConfigManager.updateConfigExtension$lambda-1((Lazy<FilePreferences>)filePreferences$delegate).put("config_extension", ext).apply();
    }

    private final void updateConfigSwitchThread(Context context) {
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SDKExecutors>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SDKExecutors invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SDKExecutors.class);
            }
        }));
        ConfigManager.updateConfigSwitchThread$lambda-2((Lazy<SDKExecutors>)sdkExecutors$delegate).getBackgroundExecutor().execute(() -> ConfigManager.updateConfigSwitchThread$lambda-3(context));
    }

    public final void onConfigExtensionReceived$vungle_ads_release(@NotNull Context context, @NotNull ConfigExtension ext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        String string = ext.getConfigExt();
        if (string != null) {
            String extString = string;
            boolean bl = false;
            ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
            boolean $i$f$inject = false;
            Lazy sdkExecutors$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SDKExecutors>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final SDKExecutors invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(SDKExecutors.class);
                }
            }));
            ConfigManager.onConfigExtensionReceived$lambda-6$lambda-4((Lazy<SDKExecutors>)sdkExecutors$delegate).getBackgroundExecutor().execute(() -> ConfigManager.onConfigExtensionReceived$lambda-6$lambda-5(context, extString));
        }
        if (Intrinsics.areEqual((Object)ext.getNeedRefresh(), (Object)true)) {
            this.updateConfigSwitchThread(context);
        }
    }

    public final void initWithConfig(@NotNull Context context, @NotNull ConfigPayload config, boolean fromCachedConfig, @Nullable String appId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ConfigManager.config = config;
        endpoints = config.getEndpoints();
        placements = config.getPlacements();
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        if (!fromCachedConfig) {
            this.updateCachedConfig(config, ConfigManager.initWithConfig$lambda-7((Lazy<FilePreferences>)filePreferences$delegate), appId);
        }
        String string = config.getConfigExtension();
        if (string != null) {
            String it = string;
            boolean bl = false;
            INSTANCE.updateConfigExtension$vungle_ads_release(context, it);
        }
        if (this.omEnabled()) {
            ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
            boolean $i$f$inject2 = false;
            Lazy omInjector$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<OMInjector>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final OMInjector invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(OMInjector.class);
                }
            }));
            ConfigManager.initWithConfig$lambda-9((Lazy<OMInjector>)omInjector$delegate).init();
        }
        PrivacyManager.INSTANCE.updateDisableAdId(this.shouldDisableAdId());
    }

    public static /* synthetic */ void initWithConfig$default(ConfigManager configManager, Context context, ConfigPayload configPayload, boolean bl, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        configManager.initWithConfig(context, configPayload, bl, string);
    }

    @Nullable
    public final List<Placement> placements() {
        return placements;
    }

    @Nullable
    public final Placement getPlacement(@NotNull String id) {
        Placement placement;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<Placement> list = placements;
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    Placement it = (Placement)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getReferenceId(), (Object)id)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            placement = v1;
        } else {
            placement = null;
        }
        return placement;
    }

    @Nullable
    public final String getAdsEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getAdsEndpoint() : null;
    }

    @Nullable
    public final String getRiEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getRiEndpoint() : null;
    }

    @Nullable
    public final String getMraidEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getMraidEndpoint() : null;
    }

    @NotNull
    public final String getMraidJsVersion() {
        String string;
        block3: {
            block2: {
                string = this.getMraidEndpoint();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = "mraid_" + Uri.parse((String)it).getLastPathSegment();
                string = string2;
                if (string2 != null) break block3;
            }
            string = "mraid_1";
        }
        return string;
    }

    @Nullable
    public final String getGDPRConsentMessage() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getConsentMessage() : null;
    }

    @Nullable
    public final String getGDPRConsentTitle() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getConsentTitle() : null;
    }

    @Nullable
    public final String getGDPRButtonAccept() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getButtonAccept() : null;
    }

    @Nullable
    public final String getGDPRButtonDeny() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getButtonDeny() : null;
    }

    @NotNull
    public final String getGDPRConsentMessageVersion() {
        Object object = config;
        if (object == null || (object = ((ConfigPayload)object).getUserPrivacy()) == null || (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) == null || (object = ((ConfigPayload.GDPRSettings)object).getConsentMessageVersion()) == null) {
            object = "";
        }
        return object;
    }

    public final boolean getGDPRIsCountryDataProtected() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null && (object = ((ConfigPayload.GDPRSettings)object).isCountryDataProtected()) != null ? (Boolean)object : false;
    }

    public final boolean shouldDisableAdId() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getDisableAdId()) != null ? (Boolean)object : true;
    }

    public final boolean isReportIncentivizedEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isReportIncentivizedEnabled()) != null ? (Boolean)object : false;
    }

    @NotNull
    public final String getConfigExtension() {
        String string = configExt;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final boolean omEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getViewAbility()) != null && (object = ((ConfigPayload.ViewAbilitySettings)object).getOm()) != null ? (Boolean)object : false;
    }

    @Nullable
    public final String getMetricsEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getMetricsEndpoint() : null;
    }

    @Nullable
    public final String getErrorLoggingEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getErrorLogsEndpoint() : null;
    }

    public final boolean getMetricsEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getLogMetricsSettings()) != null && (object = ((ConfigPayload.LogMetricsSettings)object).getMetricsEnabled()) != null ? (Boolean)object : false;
    }

    public final int getLogLevel() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getLogMetricsSettings()) != null && (object = ((ConfigPayload.LogMetricsSettings)object).getErrorLogLevel()) != null ? ((Integer)object).intValue() : AnalyticsClient.LogLevel.ERROR_LOG_LEVEL_ERROR.getLevel();
    }

    public final long getSessionTimeout() {
        Object object = config;
        return (long)(object != null && (object = ((ConfigPayload)object).getSessionTimeout()) != null ? (Integer)object : 900) * 1000L;
    }

    public final long getSignalsSessionTimeout() {
        Object object = config;
        return (long)(object != null && (object = ((ConfigPayload)object).getSignalSessionTimeout()) != null ? (Integer)object : 1800) * 1000L;
    }

    public final boolean rtaDebuggingEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getRtaDebugging()) != null ? (Boolean)object : false;
    }

    public final boolean isCacheableAssetsRequired() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isCacheableAssetsRequired()) != null ? (Boolean)object : false;
    }

    public final boolean signalsDisabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getSignalsDisabled()) != null ? (Boolean)object : false;
    }

    public final boolean fpdEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getFpdEnabled()) != null ? (Boolean)object : true;
    }

    @VisibleForTesting
    public final boolean validateEndpoints$vungle_ads_release(@Nullable ConfigPayload.Endpoints endpoints) {
        boolean valid = true;
        ConfigPayload.Endpoints endpoints2 = endpoints;
        CharSequence charSequence = endpoints2 != null ? endpoints2.getAdsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 122, "The ads endpoint was not provided in the config.", null, null, null, 28, null);
            valid = false;
        }
        ConfigPayload.Endpoints endpoints3 = endpoints;
        charSequence = endpoints3 != null ? endpoints3.getRiEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 123, "The ri endpoint was not provided in the config.", null, null, null, 28, null);
        }
        ConfigPayload.Endpoints endpoints4 = endpoints;
        charSequence = endpoints4 != null ? endpoints4.getMraidEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 130, "The mraid endpoint was not provided in the config.", null, null, null, 28, null);
            valid = false;
        }
        ConfigPayload.Endpoints endpoints5 = endpoints;
        charSequence = endpoints5 != null ? endpoints5.getMetricsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 125, "The metrics endpoint was not provided in the config.", null, null, null, 28, null);
        }
        ConfigPayload.Endpoints endpoints6 = endpoints;
        charSequence = endpoints6 != null ? endpoints6.getErrorLogsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            Logger.Companion.e(TAG, "The error logging endpoint was not provided in the config.");
        }
        return valid;
    }

    public static /* synthetic */ boolean validateEndpoints$vungle_ads_release$default(ConfigManager configManager, ConfigPayload.Endpoints endpoints, int n, Object object) {
        if ((n & 1) != 0) {
            endpoints = ConfigManager.endpoints;
        }
        return configManager.validateEndpoints$vungle_ads_release(endpoints);
    }

    public final boolean isCleverCacheEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((ConfigPayload.CleverCache)object).getEnabled()) != null ? (Boolean)object : false;
    }

    public final long getCleverCacheDiskSize() {
        Object object = config;
        if (object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((ConfigPayload.CleverCache)object).getDiskSize()) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            return it * (long)1024 * (long)1024;
        }
        return 1048576000L;
    }

    public final int getCleverCacheDiskPercentage() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((ConfigPayload.CleverCache)object).getDiskPercentage()) != null ? (Integer)object : 3;
    }

    @Nullable
    public final ConfigPayload getCachedConfig(@NotNull FilePreferences filePreferences, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)filePreferences, (String)"filePreferences");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        try {
            String localAppId = filePreferences.getString("config_app_id");
            CharSequence charSequence = localAppId;
            if (charSequence == null || charSequence.length() == 0 || !StringsKt.equals((String)localAppId, (String)appId, (boolean)true)) {
                Logger.Companion.w(TAG, "app id mismatch, re-config");
                return null;
            }
            charSequence = filePreferences.getString("config_response");
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl = false;
                long configLastUpdateTime = filePreferences.getLong("config_update_time", 0L);
                StringFormat $this$decodeFromString$iv = (StringFormat)json;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ConfigPayload.class));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                ConfigPayload localConfig = (ConfigPayload)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, (String)it);
                Object object = localConfig.getConfigSettings();
                if ((object != null && (object = ((ConfigPayload.ConfigSettings)object).getRefreshTime()) != null ? (Long)object : -1L) + configLastUpdateTime < System.currentTimeMillis()) {
                    Logger.Companion.w(TAG, "cache config expired. re-config");
                    return null;
                }
                Logger.Companion.w(TAG, "use cache config.");
                return localConfig;
            }
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Error while parsing cached config: " + e2.getMessage());
            return null;
        }
        return null;
    }

    public final void updateCachedConfig(@NotNull ConfigPayload config, @NotNull FilePreferences filePreferences, @Nullable String appId) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)filePreferences, (String)"filePreferences");
        try {
            String string = appId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                filePreferences.put("config_app_id", appId);
            }
            filePreferences.put("config_update_time", System.currentTimeMillis());
            StringFormat $this$encodeToString$iv = (StringFormat)json;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ConfigPayload.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            filePreferences.put("config_response", $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)config));
            filePreferences.apply();
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Exception: " + e2.getMessage() + " for updating cached config");
        }
    }

    public static /* synthetic */ void updateCachedConfig$default(ConfigManager configManager, ConfigPayload configPayload, FilePreferences filePreferences, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        configManager.updateCachedConfig(configPayload, filePreferences, string);
    }

    private static final VungleApiClient fetchConfig$lambda-0(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private static final FilePreferences updateConfigExtension$lambda-1(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final SDKExecutors updateConfigSwitchThread$lambda-2(Lazy<SDKExecutors> $sdkExecutors$delegate) {
        Lazy<SDKExecutors> lazy = $sdkExecutors$delegate;
        return (SDKExecutors)lazy.getValue();
    }

    private static final void updateConfigSwitchThread$lambda-3(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        ConfigPayload newConfigPayload = INSTANCE.fetchConfig$vungle_ads_release($context);
        if (newConfigPayload != null) {
            ConfigManager.initWithConfig$default(INSTANCE, $context, newConfigPayload, false, null, 8, null);
        } else {
            new ConfigurationError().logErrorNoReturnValue$vungle_ads_release();
        }
    }

    private static final SDKExecutors onConfigExtensionReceived$lambda-6$lambda-4(Lazy<SDKExecutors> $sdkExecutors$delegate) {
        Lazy<SDKExecutors> lazy = $sdkExecutors$delegate;
        return (SDKExecutors)lazy.getValue();
    }

    private static final void onConfigExtensionReceived$lambda-6$lambda-5(Context $context, String $extString) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$extString, (String)"$extString");
        INSTANCE.updateConfigExtension$vungle_ads_release($context, $extString);
    }

    private static final FilePreferences initWithConfig$lambda-7(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final OMInjector initWithConfig$lambda-9(Lazy<OMInjector> $omInjector$delegate) {
        Lazy<OMInjector> lazy = $omInjector$delegate;
        return (OMInjector)lazy.getValue();
    }

    static {
        json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }
}

