/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ConfigurationError;
import com.vungle.ads.Metric;
import com.vungle.ads.NetworkUnreachable;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.Constants;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Callback;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.util.Logger;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0001\u00a2\u0006\u0002\b\u001aJ\r\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dJ\u0006\u0010\u001e\u001a\u00020\u0007J8\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u001c0#H\u0000\u00a2\u0006\u0002\b(J\u0006\u0010)\u001a\u00020$J\u0006\u0010*\u001a\u00020\fJ\u0018\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\fJ\u0006\u0010/\u001a\u00020\u0004J\u0006\u00100\u001a\u00020\u0007J\u0006\u00101\u001a\u00020\fJ\u0006\u00102\u001a\u00020\fJ\b\u00103\u001a\u0004\u0018\u00010\fJ\b\u00104\u001a\u0004\u0018\u00010\fJ\b\u00105\u001a\u0004\u0018\u00010\fJ\u0006\u00106\u001a\u00020\fJ\b\u00107\u001a\u0004\u0018\u00010\fJ\u0006\u00108\u001a\u00020$J\u0006\u00109\u001a\u00020\u0004J\u0006\u0010:\u001a\u00020$J\u0006\u0010;\u001a\u00020\fJ\b\u0010<\u001a\u0004\u0018\u00010\fJ\u0006\u0010=\u001a\u00020\fJ\u0010\u0010>\u001a\u0004\u0018\u00010\u00172\u0006\u0010?\u001a\u00020\fJ\b\u0010@\u001a\u0004\u0018\u00010\fJ\u0006\u0010A\u001a\u00020\u0007J\u0006\u0010B\u001a\u00020\u0007J\b\u0010C\u001a\u0004\u0018\u00010DJ3\u0010E\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010F\u001a\u00020$2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010HH\u0000\u00a2\u0006\u0002\bIJ\u0006\u0010J\u001a\u00020$J\u0006\u0010K\u001a\u00020$J\u0006\u0010L\u001a\u00020$J\u0006\u0010M\u001a\u00020$J\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016J\u0006\u0010N\u001a\u00020$J\u0015\u0010O\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bPJ\u0006\u0010Q\u001a\u00020$J\u0006\u0010R\u001a\u00020$J\u0016\u0010S\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020-J\u001d\u0010T\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010U\u001a\u00020\fH\u0001\u00a2\u0006\u0002\bVJ\u0017\u0010W\u001a\u00020$2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0001\u00a2\u0006\u0002\bXJ\u0019\u0010Y\u001a\u00020$2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0001\u00a2\u0006\u0002\bZR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006[\u00b2\u0006\n\u0010\\\u001a\u00020]X\u008a\u0084\u0002\u00b2\u0006\n\u0010,\u001a\u00020-X\u008a\u0084\u0002\u00b2\u0006\n\u0010,\u001a\u00020-X\u008a\u0084\u0002\u00b2\u0006\n\u0010^\u001a\u00020_X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/ConfigManager;", "", "()V", "CONFIG_ALL_DATA", "", "CONFIG_LAST_VALIDATED_TIMESTAMP_ONLY", "CONFIG_LAST_VALIDATE_TS_DEFAULT", "", "CONFIG_NOT_AVAILABLE", "DEFAULT_SESSION_TIMEOUT_SECONDS", "DEFAULT_SIGNALS_SESSION_TIMEOUT_SECONDS", "TAG", "", "applicationId", "config", "Lcom/vungle/ads/internal/model/ConfigPayload;", "configExt", "endpoints", "Lcom/vungle/ads/internal/model/ConfigPayload$Endpoints;", "json", "Lkotlinx/serialization/json/Json;", "placements", "", "Lcom/vungle/ads/internal/model/Placement;", "checkConfigPayload", "configPayload", "checkConfigPayload$vungle_ads_release", "clearConfig", "", "clearConfig$vungle_ads_release", "configLastValidatedTimestamp", "fetchConfigAsync", "context", "Landroid/content/Context;", "onComplete", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "result", "fetchConfigAsync$vungle_ads_release", "fpdEnabled", "getAdsEndpoint", "getCachedConfig", "filePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "appId", "getCleverCacheDiskPercentage", "getCleverCacheDiskSize", "getConfigExtension", "getErrorLoggingEndpoint", "getGDPRButtonAccept", "getGDPRButtonDeny", "getGDPRConsentMessage", "getGDPRConsentMessageVersion", "getGDPRConsentTitle", "getGDPRIsCountryDataProtected", "getLogLevel", "getMetricsEnabled", "getMetricsEndpoint", "getMraidEndpoint", "getMraidJsVersion", "getPlacement", "id", "getRiEndpoint", "getSessionTimeout", "getSignalsSessionTimeout", "getTcfStatus", "Lcom/vungle/ads/internal/model/ConfigPayload$IABSettings$TcfStatus;", "initWithConfig", "fromCachedConfig", "metric", "Lcom/vungle/ads/SingleValueMetric;", "initWithConfig$vungle_ads_release", "isCacheableAssetsRequired", "isCleverCacheEnabled", "isReportIncentivizedEnabled", "omEnabled", "rtaDebuggingEnabled", "setAppId", "setAppId$vungle_ads_release", "shouldDisableAdId", "signalsDisabled", "updateCachedConfig", "updateConfigExtension", "ext", "updateConfigExtension$vungle_ads_release", "validateConfig", "validateConfig$vungle_ads_release", "validateEndpoints", "validateEndpoints$vungle_ads_release", "vungle-ads_release", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;"})
public final class ConfigManager {
    @NotNull
    public static final ConfigManager INSTANCE = new ConfigManager();
    @NotNull
    public static final String TAG = "ConfigManager";
    public static final long CONFIG_LAST_VALIDATE_TS_DEFAULT = -1L;
    private static final int DEFAULT_SESSION_TIMEOUT_SECONDS = 900;
    private static final int DEFAULT_SIGNALS_SESSION_TIMEOUT_SECONDS = 1800;
    private static final int CONFIG_NOT_AVAILABLE = 0;
    private static final int CONFIG_LAST_VALIDATED_TIMESTAMP_ONLY = 1;
    private static final int CONFIG_ALL_DATA = 2;
    @Nullable
    private static ConfigPayload config;
    @Nullable
    private static ConfigPayload.Endpoints endpoints;
    @Nullable
    private static List<Placement> placements;
    @Nullable
    private static String configExt;
    @NotNull
    private static final Json json;
    private static String applicationId;

    private ConfigManager() {
    }

    public final void setAppId$vungle_ads_release(@NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        ConfigManager.applicationId = applicationId;
    }

    public final void fetchConfigAsync$vungle_ads_release(@NotNull Context context, @NotNull Function1<? super Boolean, Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        try {
            TimeIntervalMetric initRequestToResponseMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.INIT_REQUEST_TO_RESPONSE_DURATION_MS);
            initRequestToResponseMetric.markStart();
            Call<ConfigPayload> call = ConfigManager.fetchConfigAsync$lambda-0((Lazy<VungleApiClient>)vungleApiClient$delegate).config();
            if (call != null) {
                call.enqueue(new Callback<ConfigPayload>(initRequestToResponseMetric, context, onComplete){
                    final /* synthetic */ TimeIntervalMetric $initRequestToResponseMetric;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ Function1<Boolean, Unit> $onComplete;
                    {
                        this.$initRequestToResponseMetric = $initRequestToResponseMetric;
                        this.$context = $context;
                        this.$onComplete = $onComplete;
                    }

                    public void onResponse(@Nullable Call<ConfigPayload> call, @Nullable Response<ConfigPayload> response) {
                        this.$initRequestToResponseMetric.markEnd();
                        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, (Metric)this.$initRequestToResponseMetric, null, null, null, VungleApiClient.Companion.getBASE_URL$vungle_ads_release(), 14, null);
                        if (response == null || !response.isSuccessful() || response.body() == null) {
                            new ConfigurationError().logErrorNoReturnValue$vungle_ads_release();
                            return;
                        }
                        ConfigPayload configPayload = response.body();
                        SingleValueMetric configSrcMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.CONFIG_LOADED_FROM_INIT);
                        ConfigManager.INSTANCE.initWithConfig$vungle_ads_release(this.$context, configPayload, false, configSrcMetric);
                        this.$onComplete.invoke((Object)true);
                    }

                    public void onFailure(@Nullable Call<ConfigPayload> call, @Nullable Throwable t) {
                        this.$initRequestToResponseMetric.markEnd();
                        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, (Metric)this.$initRequestToResponseMetric, null, null, null, VungleApiClient.Companion.getBASE_URL$vungle_ads_release(), 14, null);
                        new ConfigurationError().logErrorNoReturnValue$vungle_ads_release();
                        Throwable throwable = t;
                        Logger.Companion.e("ConfigManager", "Error while fetching config: " + (throwable != null ? throwable.getMessage() : null));
                        this.$onComplete.invoke((Object)false);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UnknownHostException ? true : throwable2 instanceof SecurityException) {
                new NetworkUnreachable().logErrorNoReturnValue$vungle_ads_release();
            } else {
                new ConfigurationError().logErrorNoReturnValue$vungle_ads_release();
            }
            onComplete.invoke((Object)false);
        }
    }

    @VisibleForTesting
    public final void updateConfigExtension$vungle_ads_release(@NotNull Context context, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        configExt = ext;
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        boolean $i$f$inject = false;
        Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final FilePreferences invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
            }
        }));
        ConfigManager.updateConfigExtension$lambda-1((Lazy<FilePreferences>)filePreferences$delegate).put("config_extension", ext).apply();
    }

    public final synchronized void initWithConfig$vungle_ads_release(@NotNull Context context, @Nullable ConfigPayload config, boolean fromCachedConfig, @Nullable SingleValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
            boolean $i$f$inject = false;
            Lazy filePreferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<FilePreferences>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final FilePreferences invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(FilePreferences.class);
                }
            }));
            int configStatus = this.checkConfigPayload$vungle_ads_release(config);
            switch (configStatus) {
                case 0: {
                    Logger.Companion.e(TAG, "Config is not available.");
                    return;
                }
                case 1: {
                    if (!fromCachedConfig && config != null) {
                        Long l = config.getConfigLastValidatedTimestamp();
                        long timestamp = l != null ? l : -1L;
                        ConfigPayload configPayload = ConfigManager.config;
                        if (configPayload != null) {
                            configPayload.setConfigLastValidatedTimestamp(timestamp);
                        }
                        ConfigPayload configPayload2 = ConfigManager.config;
                        if (configPayload2 != null) {
                            ConfigPayload it = configPayload2;
                            boolean bl = false;
                            INSTANCE.updateCachedConfig(it, ConfigManager.initWithConfig$lambda-2((Lazy<FilePreferences>)filePreferences$delegate));
                        }
                    }
                    return;
                }
            }
            ConfigManager.config = config;
            ConfigPayload configPayload = config;
            endpoints = configPayload != null ? configPayload.getEndpoints() : null;
            ConfigPayload configPayload3 = config;
            placements = configPayload3 != null ? configPayload3.getPlacements() : null;
            AnalyticsClient.INSTANCE.updateErrorLevelAndMetricEnabled$vungle_ads_release(this.getLogLevel(), this.getMetricsEnabled());
            if (!fromCachedConfig && config != null) {
                this.updateCachedConfig(config, ConfigManager.initWithConfig$lambda-2((Lazy<FilePreferences>)filePreferences$delegate));
                String string = config.getConfigExtension();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    INSTANCE.updateConfigExtension$vungle_ads_release(context, it);
                }
            }
            if (this.omEnabled()) {
                ServiceLocator.Companion this_$iv2 = ServiceLocator.Companion;
                boolean $i$f$inject2 = false;
                Lazy omInjector$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<OMInjector>(context){
                    final /* synthetic */ Context $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @NotNull
                    public final OMInjector invoke() {
                        return ServiceLocator.Companion.getInstance(this.$context).getService(OMInjector.class);
                    }
                }));
                ConfigManager.initWithConfig$lambda-5((Lazy<OMInjector>)omInjector$delegate).init();
            }
            SingleValueMetric singleValueMetric = metric;
            if (singleValueMetric != null) {
                SingleValueMetric it = singleValueMetric;
                boolean bl = false;
                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, metric, null, null, null, null, 30, null);
            }
            PrivacyManager.INSTANCE.updateDisableAdId(this.shouldDisableAdId());
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Error while validating config: " + e2.getMessage());
            return;
        }
    }

    public static /* synthetic */ void initWithConfig$vungle_ads_release$default(ConfigManager configManager, Context context, ConfigPayload configPayload, boolean bl, SingleValueMetric singleValueMetric, int n, Object object) {
        if ((n & 8) != 0) {
            singleValueMetric = null;
        }
        configManager.initWithConfig$vungle_ads_release(context, configPayload, bl, singleValueMetric);
    }

    @Nullable
    public final List<Placement> placements() {
        return placements;
    }

    @Nullable
    public final Placement getPlacement(@NotNull String id) {
        Placement placement;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<Placement> list = placements;
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    Placement it = (Placement)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getReferenceId(), (Object)id)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            placement = v1;
        } else {
            placement = null;
        }
        return placement;
    }

    @NotNull
    public final String getAdsEndpoint() {
        String string;
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        String it = string = endpoints != null ? endpoints.getAdsEndpoint() : null;
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            string2 = Constants.DEFAULT_ADS_ENDPOINT;
        }
        return string2;
    }

    @Nullable
    public final String getRiEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getRiEndpoint() : null;
    }

    @Nullable
    public final String getMraidEndpoint() {
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        return endpoints != null ? endpoints.getMraidEndpoint() : null;
    }

    @NotNull
    public final String getMraidJsVersion() {
        String string;
        block3: {
            block2: {
                string = this.getMraidEndpoint();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = "mraid_" + Uri.parse((String)it).getLastPathSegment();
                string = string2;
                if (string2 != null) break block3;
            }
            string = "mraid_1";
        }
        return string;
    }

    @Nullable
    public final String getGDPRConsentMessage() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getConsentMessage() : null;
    }

    @Nullable
    public final String getGDPRConsentTitle() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getConsentTitle() : null;
    }

    @Nullable
    public final String getGDPRButtonAccept() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getButtonAccept() : null;
    }

    @Nullable
    public final String getGDPRButtonDeny() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null ? ((ConfigPayload.GDPRSettings)object).getButtonDeny() : null;
    }

    @NotNull
    public final String getGDPRConsentMessageVersion() {
        Object object = config;
        if (object == null || (object = ((ConfigPayload)object).getUserPrivacy()) == null || (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) == null || (object = ((ConfigPayload.GDPRSettings)object).getConsentMessageVersion()) == null) {
            object = "";
        }
        return object;
    }

    public final boolean getGDPRIsCountryDataProtected() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getGdpr()) != null && (object = ((ConfigPayload.GDPRSettings)object).isCountryDataProtected()) != null ? (Boolean)object : false;
    }

    @Nullable
    public final ConfigPayload.IABSettings.TcfStatus getTcfStatus() {
        Object object = config;
        return ConfigPayload.IABSettings.TcfStatus.Companion.fromRawValue(object != null && (object = ((ConfigPayload)object).getUserPrivacy()) != null && (object = ((ConfigPayload.UserPrivacy)object).getIab()) != null ? ((ConfigPayload.IABSettings)object).getTcfStatus() : null);
    }

    public final boolean shouldDisableAdId() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getDisableAdId()) != null ? (Boolean)object : true;
    }

    public final boolean isReportIncentivizedEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isReportIncentivizedEnabled()) != null ? (Boolean)object : false;
    }

    @NotNull
    public final String getConfigExtension() {
        String string = configExt;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final long configLastValidatedTimestamp() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getConfigLastValidatedTimestamp()) != null ? (Long)object : -1L;
    }

    public final boolean omEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getViewAbility()) != null && (object = ((ConfigPayload.ViewAbilitySettings)object).getOm()) != null ? (Boolean)object : false;
    }

    @NotNull
    public final String getMetricsEndpoint() {
        String string;
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        String it = string = endpoints != null ? endpoints.getMetricsEndpoint() : null;
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            string2 = Constants.DEFAULT_METRICS_ENDPOINT;
        }
        return string2;
    }

    @NotNull
    public final String getErrorLoggingEndpoint() {
        String string;
        ConfigPayload.Endpoints endpoints = ConfigManager.endpoints;
        String it = string = endpoints != null ? endpoints.getErrorLogsEndpoint() : null;
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            string2 = Constants.DEFAULT_ERROR_LOGS_ENDPOINT;
        }
        return string2;
    }

    public final boolean getMetricsEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getLogMetricsSettings()) != null && (object = ((ConfigPayload.LogMetricsSettings)object).getMetricsEnabled()) != null ? (Boolean)object : false;
    }

    public final int getLogLevel() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getLogMetricsSettings()) != null && (object = ((ConfigPayload.LogMetricsSettings)object).getErrorLogLevel()) != null ? ((Integer)object).intValue() : AnalyticsClient.LogLevel.ERROR_LOG_LEVEL_ERROR.getLevel();
    }

    public final long getSessionTimeout() {
        Object object = config;
        return (long)(object != null && (object = ((ConfigPayload)object).getSessionTimeout()) != null ? (Integer)object : 900) * 1000L;
    }

    public final long getSignalsSessionTimeout() {
        Object object = config;
        return (long)(object != null && (object = ((ConfigPayload)object).getSignalSessionTimeout()) != null ? (Integer)object : 1800) * 1000L;
    }

    public final boolean rtaDebuggingEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getRtaDebugging()) != null ? (Boolean)object : false;
    }

    public final boolean isCacheableAssetsRequired() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).isCacheableAssetsRequired()) != null ? (Boolean)object : false;
    }

    public final boolean signalsDisabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getSignalsDisabled()) != null ? (Boolean)object : false;
    }

    public final boolean fpdEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getFpdEnabled()) != null ? (Boolean)object : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public final int checkConfigPayload$vungle_ads_release(@Nullable ConfigPayload configPayload) {
        if (configPayload == null) {
            return 0;
        }
        if (configPayload.getConfigLastValidatedTimestamp() == null) return 0;
        Long l = configPayload.getConfigLastValidatedTimestamp();
        long l2 = -1L;
        if (l != null && l == l2) {
            return 0;
        }
        if (configPayload.getEndpoints() != null) return 2;
        return 1;
    }

    @VisibleForTesting
    public final boolean validateConfig$vungle_ads_release(@Nullable ConfigPayload configPayload) {
        ConfigPayload configPayload2 = configPayload;
        return (configPayload2 != null ? configPayload2.getEndpoints() : null) != null && this.validateEndpoints$vungle_ads_release(configPayload.getEndpoints()) && configPayload.getPlacements() != null;
    }

    @VisibleForTesting
    public final boolean validateEndpoints$vungle_ads_release(@Nullable ConfigPayload.Endpoints endpoints) {
        boolean valid = true;
        ConfigPayload.Endpoints endpoints2 = endpoints;
        CharSequence charSequence = endpoints2 != null ? endpoints2.getAdsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 122, "The ads endpoint was not provided in the config.", null, null, null, 28, null);
            valid = false;
        }
        ConfigPayload.Endpoints endpoints3 = endpoints;
        charSequence = endpoints3 != null ? endpoints3.getRiEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 123, "The ri endpoint was not provided in the config.", null, null, null, 28, null);
        }
        ConfigPayload.Endpoints endpoints4 = endpoints;
        charSequence = endpoints4 != null ? endpoints4.getMraidEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 130, "The mraid endpoint was not provided in the config.", null, null, null, 28, null);
            valid = false;
        }
        ConfigPayload.Endpoints endpoints5 = endpoints;
        charSequence = endpoints5 != null ? endpoints5.getMetricsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 125, "The metrics endpoint was not provided in the config.", null, null, null, 28, null);
        }
        ConfigPayload.Endpoints endpoints6 = endpoints;
        charSequence = endpoints6 != null ? endpoints6.getErrorLogsEndpoint() : null;
        if (charSequence == null || charSequence.length() == 0) {
            Logger.Companion.e(TAG, "The error logging endpoint was not provided in the config.");
        }
        return valid;
    }

    public static /* synthetic */ boolean validateEndpoints$vungle_ads_release$default(ConfigManager configManager, ConfigPayload.Endpoints endpoints, int n, Object object) {
        if ((n & 1) != 0) {
            endpoints = ConfigManager.endpoints;
        }
        return configManager.validateEndpoints$vungle_ads_release(endpoints);
    }

    public final boolean isCleverCacheEnabled() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((ConfigPayload.CleverCache)object).getEnabled()) != null ? (Boolean)object : false;
    }

    public final long getCleverCacheDiskSize() {
        Object object = config;
        if (object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((ConfigPayload.CleverCache)object).getDiskSize()) != null) {
            long it = ((Number)object).longValue();
            boolean bl = false;
            return it * (long)1024 * (long)1024;
        }
        return 1048576000L;
    }

    public final int getCleverCacheDiskPercentage() {
        Object object = config;
        return object != null && (object = ((ConfigPayload)object).getCleverCache()) != null && (object = ((ConfigPayload.CleverCache)object).getDiskPercentage()) != null ? (Integer)object : 3;
    }

    @Nullable
    public final ConfigPayload getCachedConfig(@NotNull FilePreferences filePreferences, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)filePreferences, (String)"filePreferences");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        try {
            String localAppId = filePreferences.getString("config_app_id");
            CharSequence charSequence = localAppId;
            if (charSequence == null || charSequence.length() == 0 || !StringsKt.equals((String)localAppId, (String)appId, (boolean)true)) {
                Logger.Companion.w(TAG, "app id mismatch, re-config");
                return null;
            }
            charSequence = filePreferences.getString("config_response");
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl = false;
                long configLastUpdateTime = filePreferences.getLong("config_update_time", 0L);
                StringFormat $this$decodeFromString$iv = (StringFormat)json;
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ConfigPayload.class));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                ConfigPayload localConfig = (ConfigPayload)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, (String)it);
                Object object = localConfig.getConfigSettings();
                if ((object != null && (object = ((ConfigPayload.ConfigSettings)object).getRefreshTime()) != null ? (Long)object : -1L) + configLastUpdateTime < System.currentTimeMillis()) {
                    Logger.Companion.w(TAG, "cache config expired. re-config");
                    return null;
                }
                Logger.Companion.w(TAG, "use cache config.");
                return localConfig;
            }
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Error while parsing cached config: " + e2.getMessage());
            return null;
        }
        return null;
    }

    public final void updateCachedConfig(@NotNull ConfigPayload config, @NotNull FilePreferences filePreferences) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)filePreferences, (String)"filePreferences");
        try {
            String string = applicationId;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
                string = null;
            }
            filePreferences.put("config_app_id", string);
            filePreferences.put("config_update_time", System.currentTimeMillis());
            StringFormat $this$encodeToString$iv = (StringFormat)json;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(ConfigPayload.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            filePreferences.put("config_response", $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)config));
            filePreferences.apply();
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Exception: " + e2.getMessage() + " for updating cached config");
        }
    }

    @VisibleForTesting
    public final void clearConfig$vungle_ads_release() {
        endpoints = null;
        placements = null;
        config = null;
    }

    private static final VungleApiClient fetchConfigAsync$lambda-0(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private static final FilePreferences updateConfigExtension$lambda-1(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final FilePreferences initWithConfig$lambda-2(Lazy<FilePreferences> $filePreferences$delegate) {
        Lazy<FilePreferences> lazy = $filePreferences$delegate;
        return (FilePreferences)lazy.getValue();
    }

    private static final OMInjector initWithConfig$lambda-5(Lazy<OMInjector> $omInjector$delegate) {
        Lazy<OMInjector> lazy = $omInjector$delegate;
        return (OMInjector)lazy.getValue();
    }

    static {
        json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }
}

