/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.bidding;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.bidding.BidTokenEncoder;
import com.vungle.ads.internal.model.CommonRequestBody;
import com.vungle.ads.internal.model.RtbRequest;
import com.vungle.ads.internal.model.RtbToken;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.InputOutputUtils;
import com.vungle.ads.internal.util.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\bR$\u0010\u0010\u001a\u00020\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\"\u00b2\u0006\n\u0010#\u001a\u00020$X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/bidding/BidTokenEncoder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "enterBackgroundTime", "", "getEnterBackgroundTime$vungle_ads_release$annotations", "()V", "getEnterBackgroundTime$vungle_ads_release", "()J", "setEnterBackgroundTime$vungle_ads_release", "(J)V", "json", "Lkotlinx/serialization/json/Json;", "getJson$annotations", "ordinalView", "", "getOrdinalView$vungle_ads_release$annotations", "getOrdinalView$vungle_ads_release", "()I", "setOrdinalView$vungle_ads_release", "(I)V", "constructV6Token", "", "constructV6Token$vungle_ads_release", "encode", "generateBidToken", "onPause", "", "onPause$vungle_ads_release", "onResume", "onResume$vungle_ads_release", "Companion", "vungle-ads_release", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;"})
public final class BidTokenEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private int ordinalView;
    @NotNull
    private final Json json;
    private long enterBackgroundTime;
    public static final int TOKEN_VERSION = 6;

    public BidTokenEncoder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        ActivityManager.Companion.addLifecycleListener(new ActivityManager.LifeCycleCallback(){

            @Override
            public void onResume() {
                super.onResume();
                this.onResume$vungle_ads_release();
            }

            @Override
            public void onPause() {
                super.onPause();
                this.onPause$vungle_ads_release();
            }
        });
    }

    public final int getOrdinalView$vungle_ads_release() {
        return this.ordinalView;
    }

    public final void setOrdinalView$vungle_ads_release(int n) {
        this.ordinalView = n;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getOrdinalView$vungle_ads_release$annotations() {
    }

    private static /* synthetic */ void getJson$annotations() {
    }

    public final long getEnterBackgroundTime$vungle_ads_release() {
        return this.enterBackgroundTime;
    }

    public final void setEnterBackgroundTime$vungle_ads_release(long l) {
        this.enterBackgroundTime = l;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getEnterBackgroundTime$vungle_ads_release$annotations() {
    }

    @VisibleForTesting(otherwise=2)
    public final void onResume$vungle_ads_release() {
        long sessionTimeout;
        if (this.enterBackgroundTime == 0L) {
            Logger.Companion.d("BidTokenEncoder", "BidTokenEncoder#onResume skipped");
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > this.enterBackgroundTime + (sessionTimeout = ConfigManager.INSTANCE.getSessionTimeout())) {
            this.ordinalView = 0;
            this.enterBackgroundTime = 0L;
        }
    }

    @VisibleForTesting(otherwise=2)
    public final void onPause$vungle_ads_release() {
        this.enterBackgroundTime = System.currentTimeMillis();
    }

    @Nullable
    public final String encode() {
        int n = this.ordinalView;
        this.ordinalView = n + 1;
        return this.generateBidToken();
    }

    private final String generateBidToken() {
        String string;
        try {
            String token = this.constructV6Token$vungle_ads_release();
            Logger.Companion.d("BidTokenEncoder", "BidToken: " + token);
            String converted = InputOutputUtils.INSTANCE.convertForSending(token);
            Logger.Companion.d("BidTokenEncoder", "After conversion: 6:" + converted);
            string = "6:" + converted;
        }
        catch (Exception e2) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 116, "Fail to gzip bidtoken " + e2.getLocalizedMessage(), null, null, null, 28, null);
            string = null;
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final String constructV6Token$vungle_ads_release() {
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        CommonRequestBody commonRequestBody = BidTokenEncoder.constructV6Token$lambda-0((Lazy<VungleApiClient>)vungleApiClient$delegate).requestBody(!ConfigManager.INSTANCE.signalsDisabled(), ConfigManager.INSTANCE.fpdEnabled());
        RtbToken body = new RtbToken(commonRequestBody.getDevice(), commonRequestBody.getUser(), commonRequestBody.getExt(), new RtbRequest(VungleApiClient.Companion.getHeaderUa()), this.ordinalView);
        StringFormat $this$encodeToString$iv = (StringFormat)this.json;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(RtbToken.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)body);
    }

    private static final VungleApiClient constructV6Token$lambda-0(Lazy<VungleApiClient> $vungleApiClient$delegate) {
        Lazy<VungleApiClient> lazy = $vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vungle/ads/internal/bidding/BidTokenEncoder$Companion;", "", "()V", "TOKEN_VERSION", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

