/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.downloader;

import android.os.Build;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.AssetDownloadError;
import com.vungle.ads.AssetFailedStatusCodeError;
import com.vungle.ads.InternalError;
import com.vungle.ads.OutOfMemory;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.task.PriorityRunnable;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\"\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0002J\u001c\u0010 \u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010!\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001a\u0010$\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/vungle/ads/internal/downloader/AssetDownloader;", "Lcom/vungle/ads/internal/downloader/Downloader;", "downloadExecutor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "(Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;Lcom/vungle/ads/internal/util/PathProvider;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "transitioning", "", "Lcom/vungle/ads/internal/downloader/DownloadRequest;", "cancel", "", "request", "cancelAll", "checkSpaceAvailable", "", "decodeGzipIfNeeded", "Lokhttp3/ResponseBody;", "networkResponse", "Lokhttp3/Response;", "deliverError", "downloadRequest", "downloadListener", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "downloadError", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener$DownloadError;", "deliverSuccess", "file", "Ljava/io/File;", "listener", "download", "isValidUrl", "httpUrl", "", "launchRequest", "Companion", "vungle-ads_release"})
public final class AssetDownloader
implements Downloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VungleThreadPoolExecutor downloadExecutor;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    private OkHttpClient okHttpClient;
    @NotNull
    private final List<DownloadRequest> transitioning;
    @NotNull
    private static final String TAG = "AssetDownloader";
    private static final int MINIMUM_SPACE_REQUIRED_MB = 0x1400000;
    private static final int DOWNLOAD_CHUNK_SIZE = 2048;
    private static final int TIMEOUT = 30;
    @NotNull
    private static final String CONTENT_ENCODING = "Content-Encoding";
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    private static final String GZIP = "gzip";
    @NotNull
    private static final String IDENTITY = "identity";

    public AssetDownloader(@NotNull VungleThreadPoolExecutor downloadExecutor, @NotNull PathProvider pathProvider) {
        Intrinsics.checkNotNullParameter((Object)downloadExecutor, (String)"downloadExecutor");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.downloadExecutor = downloadExecutor;
        this.pathProvider = pathProvider;
        this.transitioning = new ArrayList();
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).cache(null).followRedirects(true).followSslRedirects(true);
        if (ConfigManager.INSTANCE.isCleverCacheEnabled()) {
            long diskSize = ConfigManager.INSTANCE.getCleverCacheDiskSize();
            int diskPercentage = ConfigManager.INSTANCE.getCleverCacheDiskPercentage();
            String string = this.pathProvider.getCleverCacheDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathProvider.getCleverCacheDir().absolutePath");
            long maxDiskCapacity = this.pathProvider.getAvailableBytes(string) * (long)diskPercentage / (long)100;
            long diskCapacity = Long.min(diskSize, maxDiskCapacity);
            if (diskCapacity > 0L) {
                builder2.cache(new Cache(this.pathProvider.getCleverCacheDir(), diskCapacity));
            } else {
                Logger.Companion.w(TAG, "cache disk capacity size <=0, no clever cache active.");
            }
        }
        this.okHttpClient = builder2.build();
    }

    @Override
    public void download(@Nullable DownloadRequest downloadRequest, @Nullable AssetDownloadListener downloadListener) {
        if (downloadRequest == null) {
            return;
        }
        this.transitioning.add(downloadRequest);
        this.downloadExecutor.execute(new PriorityRunnable(this, downloadRequest, downloadListener){
            final /* synthetic */ AssetDownloader this$0;
            final /* synthetic */ DownloadRequest $downloadRequest;
            final /* synthetic */ AssetDownloadListener $downloadListener;
            {
                this.this$0 = $receiver;
                this.$downloadRequest = $downloadRequest;
                this.$downloadListener = $downloadListener;
            }

            public void run() {
                AssetDownloader.access$launchRequest(this.this$0, this.$downloadRequest, this.$downloadListener);
            }

            public int getPriority() {
                return this.$downloadRequest.getPriority();
            }
        }, () -> AssetDownloader.download$lambda-0(this, downloadRequest, downloadListener));
    }

    private final void deliverError(DownloadRequest downloadRequest, AssetDownloadListener downloadListener, AssetDownloadListener.DownloadError downloadError) {
        block0: {
            AssetDownloadListener assetDownloadListener2 = downloadListener;
            if (assetDownloadListener2 == null) break block0;
            assetDownloadListener2.onError(downloadError, downloadRequest);
        }
    }

    @Override
    public void cancel(@Nullable DownloadRequest request) {
        if (request == null || request.isCancelled()) {
            return;
        }
        request.cancel();
    }

    @Override
    public void cancelAll() {
        Iterable $this$forEach$iv = this.transitioning;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadRequest it = (DownloadRequest)element$iv;
            boolean bl = false;
            this.cancel(it);
        }
        this.transitioning.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void launchRequest(DownloadRequest downloadRequest, AssetDownloadListener downloadListener) {
        Logger.Companion.d(TAG, "launch request in thread: " + Thread.currentThread().getId() + " request: " + downloadRequest.getAsset().getServerPath());
        if (downloadRequest.isCancelled()) {
            Logger.Companion.d(TAG, "Request " + downloadRequest.getAsset().getServerPath() + " is cancelled before starting");
            AssetDownloadListener.Progress progress = new AssetDownloadListener.Progress();
            progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED());
            return;
        }
        boolean done = false;
        AssetDownloadListener.Progress progress = new AssetDownloadListener.Progress();
        progress.setTimestampDownloadStart(System.currentTimeMillis());
        AssetDownloadListener.DownloadError downloadError = null;
        String url = downloadRequest.getAsset().getServerPath();
        String path = downloadRequest.getAsset().getLocalPath();
        if (((CharSequence)url).length() == 0 || !this.isValidUrl(url)) {
            this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new AssetDownloadError(), AssetDownloadListener.DownloadError.ErrorReason.Companion.getINTERNAL_ERROR()));
            return;
        }
        if (((CharSequence)path).length() == 0) {
            this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new AssetDownloadError(), AssetDownloadListener.DownloadError.ErrorReason.Companion.getFILE_NOT_FOUND_ERROR()));
            return;
        }
        if (Build.VERSION.SDK_INT >= 18 && !this.checkSpaceAvailable()) {
            this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new InternalError(10019, null, 2, null), AssetDownloadListener.DownloadError.ErrorReason.Companion.getDISK_ERROR()));
            return;
        }
        File file = new File(path);
        while (!done) {
            Unit unit;
            Response response;
            done = true;
            BufferedSink sink = null;
            BufferedSource source = null;
            long totalRead = 0L;
            Call call = null;
            long downloaded = 0L;
            int code = -1;
            Response response2 = null;
            try {
                ResponseBody body;
                Unit unit2;
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                downloaded = file.exists() ? file.length() : 0L;
                Request.Builder requestBuilder = new Request.Builder().url(url);
                call = this.okHttpClient.newCall(requestBuilder.build());
                response2 = call.execute();
                code = response2.code();
                if (!response2.isSuccessful()) {
                    new AssetFailedStatusCodeError(url, code, downloadRequest.getPlacementId(), null, 8, null).logErrorNoReturnValue$vungle_ads_release();
                    throw new Downloader.RequestException("Code: " + code);
                }
                if (response2.cacheResponse() != null) {
                    boolean bl = false;
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.CACHED_ASSETS_USED), downloadRequest.getPlacementId(), downloadRequest.getCreativeId(), downloadRequest.getEventId(), url);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Headers headers = response2.headers();
                String contentEncoding = headers.get(CONTENT_ENCODING);
                if (contentEncoding != null && !StringsKt.equals((String)GZIP, (String)contentEncoding, (boolean)true) && !StringsKt.equals((String)IDENTITY, (String)contentEncoding, (boolean)true)) {
                    Logger.Companion.w(TAG, "loadAd: Unknown Content-Encoding " + contentEncoding);
                    throw new IOException("Unknown Content-Encoding " + contentEncoding);
                }
                ResponseBody responseBody = body = this.decodeGzipIfNeeded(response2);
                source = responseBody != null ? responseBody.source() : null;
                Logger.Companion.d(TAG, "Start download from bytes:" + downloaded + ", url: " + url);
                long offset = downloaded;
                sink = Okio.buffer((Sink)(offset == 0L ? Okio.sink$default((File)file, (boolean)false, (int)1, null) : Okio.appendingSink((File)file)));
                long read = 0L;
                progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED());
                ResponseBody responseBody2 = body;
                progress.setSizeBytes(responseBody2 != null ? responseBody2.contentLength() : 0L);
                progress.setStartBytes(offset);
                while (true) {
                    long l;
                    BufferedSource bufferedSource = source;
                    long $this$launchRequest_u24lambda_u2d3 = l = bufferedSource != null ? bufferedSource.read(sink.getBuffer(), 2048L) : -1L;
                    boolean bl = false;
                    read = $this$launchRequest_u24lambda_u2d3;
                    if (l <= 0L) break;
                    if (!file.exists()) {
                        AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 114, "Asset save error " + url, null, null, null, 28, null);
                        throw new Downloader.RequestException("File is not existing");
                    }
                    if (downloadRequest.isCancelled()) {
                        progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED());
                        break;
                    }
                    progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getIN_PROGRESS());
                    sink.emit();
                    totalRead += read;
                }
                sink.flush();
                if (progress.getStatus() == AssetDownloadListener.Progress.ProgressStatus.Companion.getIN_PROGRESS()) {
                    progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getDONE());
                }
                response = response2;
            }
            catch (Exception ex) {
                Unit unit3;
                Response response3;
                try {
                    Logger.Companion.e(TAG, String.valueOf(ex));
                    if (ex instanceof ProtocolException) {
                        AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 112, "Failed to load asset: " + downloadRequest.getAsset().getServerPath(), null, null, null, 28, null);
                    } else if (ex instanceof UnknownHostException || ex instanceof IOException) {
                        new AssetFailedStatusCodeError(url, null, downloadRequest.getPlacementId(), ex.getMessage(), 2, null).logErrorNoReturnValue$vungle_ads_release();
                    }
                    progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR());
                    downloadError = new AssetDownloadListener.DownloadError(code, ex, AssetDownloadListener.DownloadError.ErrorReason.Companion.getREQUEST_ERROR());
                    response3 = response2;
                }
                catch (Throwable throwable) {
                    Unit unit4;
                    Response response4 = response2;
                    if ((response4 != null ? response4.body() : null) != null) {
                        Unit unit5;
                        ResponseBody responseBody = response2.body();
                        if (responseBody != null) {
                            responseBody.close();
                            unit5 = Unit.INSTANCE;
                        } else {
                            unit5 = null;
                        }
                    }
                    Call call2 = call;
                    if (call2 != null) {
                        call2.cancel();
                        unit4 = Unit.INSTANCE;
                    } else {
                        unit4 = null;
                    }
                    FileUtility.INSTANCE.closeQuietly((Closeable)sink);
                    FileUtility.INSTANCE.closeQuietly((Closeable)source);
                    Logger.Companion.d(TAG, "download status: " + progress.getStatus());
                    int n = progress.getStatus();
                    if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR() ? true : n == AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED()) {
                        this.deliverError(downloadRequest, downloadListener, downloadError);
                    } else if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED()) {
                        Logger.Companion.d(TAG, "On cancel " + downloadRequest);
                    } else {
                        this.deliverSuccess(file, downloadRequest, downloadListener);
                    }
                    throw throwable;
                }
                if ((response3 != null ? response3.body() : null) != null) {
                    Unit unit6;
                    ResponseBody responseBody = response2.body();
                    if (responseBody != null) {
                        responseBody.close();
                        unit6 = Unit.INSTANCE;
                    } else {
                        unit6 = null;
                    }
                }
                Call call3 = call;
                if (call3 != null) {
                    call3.cancel();
                    unit3 = Unit.INSTANCE;
                } else {
                    unit3 = null;
                }
                FileUtility.INSTANCE.closeQuietly((Closeable)sink);
                FileUtility.INSTANCE.closeQuietly((Closeable)source);
                Logger.Companion.d(TAG, "download status: " + progress.getStatus());
                int n = progress.getStatus();
                if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR() ? true : n == AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED()) {
                    this.deliverError(downloadRequest, downloadListener, downloadError);
                    continue;
                }
                if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED()) {
                    Logger.Companion.d(TAG, "On cancel " + downloadRequest);
                    continue;
                }
                this.deliverSuccess(file, downloadRequest, downloadListener);
                continue;
            }
            if ((response != null ? response.body() : null) != null) {
                Unit unit7;
                ResponseBody responseBody = response2.body();
                if (responseBody != null) {
                    responseBody.close();
                    unit7 = Unit.INSTANCE;
                } else {
                    unit7 = null;
                }
            }
            Call call4 = call;
            if (call4 != null) {
                call4.cancel();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            FileUtility.INSTANCE.closeQuietly((Closeable)sink);
            FileUtility.INSTANCE.closeQuietly((Closeable)source);
            Logger.Companion.d(TAG, "download status: " + progress.getStatus());
            int parentFile = progress.getStatus();
            if (parentFile == AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR() ? true : parentFile == AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED()) {
                this.deliverError(downloadRequest, downloadListener, downloadError);
                continue;
            }
            if (parentFile == AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED()) {
                Logger.Companion.d(TAG, "On cancel " + downloadRequest);
                continue;
            }
            this.deliverSuccess(file, downloadRequest, downloadListener);
        }
    }

    private final ResponseBody decodeGzipIfNeeded(Response networkResponse) {
        ResponseBody resp = networkResponse.body();
        if (StringsKt.equals((String)GZIP, (String)Response.header$default((Response)networkResponse, (String)CONTENT_ENCODING, null, (int)2, null), (boolean)true) && resp != null) {
            GzipSource responseBody = new GzipSource((Source)resp.source());
            String contentType = Response.header$default((Response)networkResponse, (String)CONTENT_TYPE, null, (int)2, null);
            return (ResponseBody)new RealResponseBody(contentType, -1L, Okio.buffer((Source)((Source)responseBody)));
        }
        return resp;
    }

    private final void deliverSuccess(File file, DownloadRequest downloadRequest, AssetDownloadListener listener) {
        block0: {
            Logger.Companion.d(TAG, "On success " + downloadRequest);
            AssetDownloadListener assetDownloadListener2 = listener;
            if (assetDownloadListener2 == null) break block0;
            assetDownloadListener2.onSuccess(file, downloadRequest);
        }
    }

    private final boolean checkSpaceAvailable() {
        String string = this.pathProvider.getVungleDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathProvider.getVungleDir().absolutePath");
        long availableBytes = this.pathProvider.getAvailableBytes(string);
        if (availableBytes < 0x1400000L) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 126, "Insufficient space " + availableBytes, null, null, null, 28, null);
            return false;
        }
        return true;
    }

    private final boolean isValidUrl(String httpUrl) {
        CharSequence charSequence = httpUrl;
        return !(charSequence == null || charSequence.length() == 0) && HttpUrl.Companion.parse(httpUrl) != null;
    }

    private static final void download$lambda-0(AssetDownloader this$0, DownloadRequest $downloadRequest, AssetDownloadListener $downloadListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.deliverError($downloadRequest, $downloadListener, new AssetDownloadListener.DownloadError(-1, new OutOfMemory("Cannot complete " + $downloadRequest + " : Out of Memory"), AssetDownloadListener.DownloadError.ErrorReason.Companion.getINTERNAL_ERROR()));
    }

    public static final /* synthetic */ void access$launchRequest(AssetDownloader $this, DownloadRequest downloadRequest, AssetDownloadListener downloadListener) {
        $this.launchRequest(downloadRequest, downloadListener);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vungle/ads/internal/downloader/AssetDownloader$Companion;", "", "()V", "CONTENT_ENCODING", "", "CONTENT_TYPE", "DOWNLOAD_CHUNK_SIZE", "", "GZIP", "IDENTITY", "MINIMUM_SPACE_REQUIRED_MB", "TAG", "TIMEOUT", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

