/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import android.content.Context;
import com.vungle.ads.AdFailedToDownloadError;
import com.vungle.ads.AdRetryActiveError;
import com.vungle.ads.AdRetryError;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.InternalError;
import com.vungle.ads.NoServeError;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.VungleAdSize;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.load.AdRequest;
import com.vungle.ads.internal.load.BaseAdLoader;
import com.vungle.ads.internal.load.DefaultAdLoader;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Callback;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.util.PathProvider;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0014J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/vungle/ads/internal/load/DefaultAdLoader;", "Lcom/vungle/ads/internal/load/BaseAdLoader;", "context", "Landroid/content/Context;", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/Executors;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "adRequest", "Lcom/vungle/ads/internal/load/AdRequest;", "(Landroid/content/Context;Lcom/vungle/ads/internal/network/VungleApiClient;Lcom/vungle/ads/internal/executor/Executors;Lcom/vungle/ads/internal/omsdk/OMInjector;Lcom/vungle/ads/internal/downloader/Downloader;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/load/AdRequest;)V", "fetchAdMetadata", "", "adSize", "Lcom/vungle/ads/VungleAdSize;", "placement", "Lcom/vungle/ads/internal/model/Placement;", "onAdLoadReady", "requestAd", "retrofitToVungleError", "Lcom/vungle/ads/VungleError;", "throwable", "", "vungle-ads_release"})
public final class DefaultAdLoader
extends BaseAdLoader {
    public DefaultAdLoader(@NotNull Context context, @NotNull VungleApiClient vungleApiClient, @NotNull Executors sdkExecutors, @NotNull OMInjector omInjector, @NotNull Downloader downloader, @NotNull PathProvider pathProvider, @NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)sdkExecutors, (String)"sdkExecutors");
        Intrinsics.checkNotNullParameter((Object)omInjector, (String)"omInjector");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        super(context, vungleApiClient, sdkExecutors, omInjector, downloader, pathProvider, adRequest);
    }

    @Override
    protected void requestAd() {
        this.fetchAdMetadata(this.getAdRequest().getRequestAdSize(), this.getAdRequest().getPlacement());
    }

    @Override
    public void onAdLoadReady() {
    }

    private final void fetchAdMetadata(VungleAdSize adSize, Placement placement) {
        if (this.getVungleApiClient().checkIsRetryAfterActive(placement.getReferenceId())) {
            this.onAdLoadFailed(new AdRetryActiveError().logError$vungle_ads_release());
            return;
        }
        Call<AdPayload> adsCall = this.getVungleApiClient().requestAd(placement.getReferenceId(), adSize);
        if (adsCall == null) {
            this.onAdLoadFailed(new AdFailedToDownloadError());
            return;
        }
        adsCall.enqueue(new Callback<AdPayload>(this, placement){
            final /* synthetic */ DefaultAdLoader this$0;
            final /* synthetic */ Placement $placement;
            {
                this.this$0 = $receiver;
                this.$placement = $placement;
            }

            public void onResponse(@Nullable Call<AdPayload> call, @Nullable Response<AdPayload> response) {
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> fetchAdMetadata.1.onResponse$lambda-0(this.this$0, this.$placement, response));
            }

            public void onFailure(@Nullable Call<AdPayload> call, @Nullable Throwable t) {
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> fetchAdMetadata.1.onFailure$lambda-1(this.this$0, t, this.$placement));
            }

            private static final void onResponse$lambda-0(DefaultAdLoader this$0, Placement $placement, Response $response) {
                AdPayload adPayload;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$placement, (String)"$placement");
                if (this$0.getVungleApiClient().getRetryAfterHeaderValue($placement.getReferenceId()) > 0L) {
                    this$0.onAdLoadFailed(new AdRetryError().logError$vungle_ads_release());
                    return;
                }
                Response response = $response;
                boolean bl = response != null ? !response.isSuccessful() : false;
                if (bl) {
                    AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 104, "Failed to get a successful response from the API call", $placement.getReferenceId(), null, null, 24, null);
                    this$0.onAdLoadFailed(new NoServeError());
                    return;
                }
                Response response2 = $response;
                AdPayload adPayload2 = adPayload = response2 != null ? (AdPayload)response2.body() : null;
                if ((adPayload2 != null ? adPayload2.adUnit() : null) == null) {
                    AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 215, "Ad response is empty.", $placement.getReferenceId(), null, null, 24, null);
                    this$0.onAdLoadFailed(new NoServeError());
                    return;
                }
                this$0.handleAdMetaData$vungle_ads_release(adPayload, new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.CONFIG_LOADED_FROM_AD_LOAD));
            }

            private static final void onFailure$lambda-1(DefaultAdLoader this$0, Throwable $t, Placement $placement) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$placement, (String)"$placement");
                VungleError error = DefaultAdLoader.access$retrofitToVungleError(this$0, $t);
                this$0.onAdLoadFailed(error);
                switch (error.getCode()) {
                    case 10047: {
                        AdPayload adPayload = this$0.getAdvertisement$vungle_ads_release();
                        AdPayload adPayload2 = this$0.getAdvertisement$vungle_ads_release();
                        AnalyticsClient.INSTANCE.logError$vungle_ads_release(217, "Timeout for ads call.", $placement.getReferenceId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload2 != null ? adPayload2.eventId() : null);
                        break;
                    }
                    case 10020: {
                        AdPayload adPayload = this$0.getAdvertisement$vungle_ads_release();
                        AdPayload adPayload3 = this$0.getAdvertisement$vungle_ads_release();
                        AnalyticsClient.INSTANCE.logError$vungle_ads_release(101, "Ads request error.", $placement.getReferenceId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload3 != null ? adPayload3.eventId() : null);
                        break;
                    }
                    default: {
                        AdPayload adPayload = this$0.getAdvertisement$vungle_ads_release();
                        AdPayload adPayload4 = this$0.getAdvertisement$vungle_ads_release();
                        AnalyticsClient.INSTANCE.logError$vungle_ads_release(103, "Unable to decode ads response.", $placement.getReferenceId(), adPayload != null ? adPayload.getCreativeId() : null, adPayload4 != null ? adPayload4.eventId() : null);
                    }
                }
            }
        });
    }

    private final VungleError retrofitToVungleError(Throwable throwable) {
        Throwable throwable2 = throwable;
        return throwable2 instanceof UnknownHostException ? (VungleError)new AdFailedToDownloadError() : (throwable2 instanceof SocketTimeoutException ? (VungleError)new InternalError(10047, null, 2, null) : (throwable2 instanceof IOException ? (VungleError)new InternalError(10020, null, 2, null) : (VungleError)new AdFailedToDownloadError()));
    }

    public static final /* synthetic */ VungleError access$retrofitToVungleError(DefaultAdLoader $this, Throwable throwable) {
        return $this.retrofitToVungleError(throwable);
    }
}

