/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.Logger;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/vungle/ads/internal/util/ExternalRouter;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getIntentFromUrl", "Landroid/content/Intent;", "url", "contextIsNotActivity", "", "launch", "deeplinkUrl", "context", "Landroid/content/Context;", "leftApplicationCallback", "Lcom/vungle/ads/internal/util/ActivityManager$LeftApplicationCallback;", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "vungle-ads_release"})
public final class ExternalRouter {
    @NotNull
    public static final ExternalRouter INSTANCE = new ExternalRouter();
    private static final String TAG = ExternalRouter.class.getSimpleName();

    private ExternalRouter() {
    }

    @JvmStatic
    public static final boolean launch(@Nullable String deeplinkUrl, @Nullable String url, @NotNull Context context, @Nullable ActivityManager.LeftApplicationCallback leftApplicationCallback, @Nullable PresenterAdOpenCallback adOpenCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = deeplinkUrl;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)url) == null || charSequence.length() == 0)) {
            return false;
        }
        boolean contextIsNotActivity = !(context instanceof Activity);
        try {
            Intent deeplinkIntent = INSTANCE.getIntentFromUrl(deeplinkUrl, contextIsNotActivity);
            Intent fallbackIntent = INSTANCE.getIntentFromUrl(url, contextIsNotActivity);
            ActivityManager.Companion.startWhenForeground(context, deeplinkIntent, fallbackIntent, leftApplicationCallback, adOpenCallback);
            return true;
        }
        catch (Exception e2) {
            CharSequence charSequence2 = deeplinkUrl;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 312, "Fail to open " + deeplinkUrl, "", null, null, 24, null);
            } else {
                AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 314, "Fail to open " + url, "", null, null, 24, null);
            }
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.e(string, "Error while opening url" + e2.getLocalizedMessage());
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            Logger.Companion.d(string2, "Cannot open url " + url);
            return false;
        }
    }

    private final Intent getIntentFromUrl(String url, boolean contextIsNotActivity) {
        Intent intent = null;
        try {
            CharSequence charSequence = url;
            Intent intent2 = intent = charSequence == null || charSequence.length() == 0 ? null : Intent.parseUri((String)url, (int)0);
            if (intent != null && contextIsNotActivity) {
                intent.setFlags(0x10000000);
            }
        }
        catch (URISyntaxException e2) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.e(string, "url format is not correct " + e2.getLocalizedMessage());
        }
        return intent;
    }
}

