/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.network;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.CommonRequestBody;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.OkHttpCall;
import com.vungle.ads.internal.network.VungleApi;
import com.vungle.ads.internal.network.VungleApiImpl;
import com.vungle.ads.internal.network.converters.EmptyResponseConverter;
import com.vungle.ads.internal.network.converters.JsonConverter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J(\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/vungle/ads/internal/network/VungleApiImpl;", "Lcom/vungle/ads/internal/network/VungleApi;", "okHttpClient", "Lokhttp3/Call$Factory;", "(Lokhttp3/Call$Factory;)V", "appId", "", "emptyResponseConverter", "Lcom/vungle/ads/internal/network/converters/EmptyResponseConverter;", "getOkHttpClient$vungle_ads_release", "()Lokhttp3/Call$Factory;", "ads", "Lcom/vungle/ads/internal/network/Call;", "Lcom/vungle/ads/internal/model/AdPayload;", "ua", "path", "body", "Lcom/vungle/ads/internal/model/CommonRequestBody;", "config", "Lcom/vungle/ads/internal/model/ConfigPayload;", "defaultBuilder", "Lokhttp3/Request$Builder;", "placementReferenceId", "defaultProtoBufBuilder", "pingTPAT", "Ljava/lang/Void;", "url", "ri", "sendAdMarkup", "requestBody", "Lokhttp3/RequestBody;", "sendErrors", "sendMetrics", "setAppId", "", "Companion", "vungle-ads_release"})
public final class VungleApiImpl
implements VungleApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Call.Factory okHttpClient;
    @Nullable
    private String appId;
    @NotNull
    private final EmptyResponseConverter emptyResponseConverter;
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)Companion.json.1.INSTANCE, (int)1, null);
    @NotNull
    private static final String VUNGLE_VERSION = "7.1.0";

    public VungleApiImpl(@NotNull Call.Factory okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        this.okHttpClient = okHttpClient;
        this.emptyResponseConverter = new EmptyResponseConverter();
    }

    @VisibleForTesting
    @NotNull
    public final Call.Factory getOkHttpClient$vungle_ads_release() {
        return this.okHttpClient;
    }

    @Override
    public void setAppId(@NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.appId = appId;
    }

    private final Request.Builder defaultBuilder(String ua, String path, String placementReferenceId) {
        Request.Builder builder2;
        block1: {
            builder2 = new Request.Builder().url(path).addHeader("User-Agent", ua).addHeader("Vungle-Version", VUNGLE_VERSION).addHeader("Content-Type", "application/json");
            String string = this.appId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                builder2.addHeader("X-Vungle-App-Id", it);
            }
            String string2 = placementReferenceId;
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            builder2.addHeader("X-Vungle-Placement-Ref-Id", it);
        }
        return builder2;
    }

    static /* synthetic */ Request.Builder defaultBuilder$default(VungleApiImpl vungleApiImpl, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return vungleApiImpl.defaultBuilder(string, string2, string3);
    }

    private final Request.Builder defaultProtoBufBuilder(String ua, String path) {
        Request.Builder builder2;
        block0: {
            builder2 = new Request.Builder().url(path).addHeader("User-Agent", ua).addHeader("Vungle-Version", VUNGLE_VERSION).addHeader("Content-Type", "application/x-protobuf");
            String string = this.appId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            builder2.addHeader("X-Vungle-App-Id", it);
        }
        return builder2;
    }

    @Override
    @Nullable
    public Call<ConfigPayload> config(@NotNull String ua, @NotNull String path, @NotNull CommonRequestBody body) {
        Call call;
        Intrinsics.checkNotNullParameter((Object)ua, (String)"ua");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        try {
            StringFormat $this$encodeToString$iv = (StringFormat)json;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(CommonRequestBody.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            String requestBody = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)body);
            Request request = VungleApiImpl.defaultBuilder$default(this, ua, path, null, 4, null).post(RequestBody.Companion.create(requestBody, null)).build();
            call = new OkHttpCall(this.okHttpClient.newCall(request), new JsonConverter(Reflection.typeOf(ConfigPayload.class)));
        }
        catch (Exception e2) {
            call = null;
        }
        return call;
    }

    @Override
    @Nullable
    public Call<AdPayload> ads(@NotNull String ua, @NotNull String path, @NotNull CommonRequestBody body) {
        Call call;
        Intrinsics.checkNotNullParameter((Object)ua, (String)"ua");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        try {
            StringFormat $this$encodeToString$iv = (StringFormat)json;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(CommonRequestBody.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            String requestBody = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)body);
            Object object = body.getRequest();
            String placementReferenceId = object != null && (object = ((CommonRequestBody.RequestParam)object).getPlacements()) != null ? (String)CollectionsKt.firstOrNull((List)object) : null;
            Request request = this.defaultBuilder(ua, path, placementReferenceId).post(RequestBody.Companion.create(requestBody, null)).build();
            call = new OkHttpCall(this.okHttpClient.newCall(request), new JsonConverter(Reflection.typeOf(AdPayload.class)));
        }
        catch (Exception e2) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 101, "Error with url: " + path, null, null, null, 28, null);
            call = null;
        }
        return call;
    }

    @Override
    @Nullable
    public Call<Void> ri(@NotNull String ua, @NotNull String path, @NotNull CommonRequestBody body) {
        Call call;
        Intrinsics.checkNotNullParameter((Object)ua, (String)"ua");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        try {
            StringFormat $this$encodeToString$iv = (StringFormat)json;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(CommonRequestBody.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            String requestBody = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)body);
            Request request = VungleApiImpl.defaultBuilder$default(this, ua, path, null, 4, null).post(RequestBody.Companion.create(requestBody, null)).build();
            call = new OkHttpCall(this.okHttpClient.newCall(request), this.emptyResponseConverter);
        }
        catch (Exception e2) {
            AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 101, "Error with url: " + path, null, null, null, 28, null);
            call = null;
        }
        return call;
    }

    @Override
    @NotNull
    public Call<Void> pingTPAT(@NotNull String ua, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)ua, (String)"ua");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl.Builder urlBuilder = HttpUrl.Companion.get(url).newBuilder();
        Request request = VungleApiImpl.defaultBuilder$default(this, ua, urlBuilder.build().toString(), null, 4, null).get().build();
        return new OkHttpCall(this.okHttpClient.newCall(request), this.emptyResponseConverter);
    }

    @Override
    @NotNull
    public Call<Void> sendMetrics(@NotNull String ua, @NotNull String path, @NotNull RequestBody requestBody) {
        Intrinsics.checkNotNullParameter((Object)ua, (String)"ua");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        HttpUrl.Builder urlBuilder = HttpUrl.Companion.get(path).newBuilder();
        Request request = this.defaultProtoBufBuilder(ua, urlBuilder.build().toString()).post(requestBody).build();
        return new OkHttpCall(this.okHttpClient.newCall(request), this.emptyResponseConverter);
    }

    @Override
    @NotNull
    public Call<Void> sendErrors(@NotNull String ua, @NotNull String path, @NotNull RequestBody requestBody) {
        Intrinsics.checkNotNullParameter((Object)ua, (String)"ua");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        HttpUrl.Builder urlBuilder = HttpUrl.Companion.get(path).newBuilder();
        Request request = this.defaultProtoBufBuilder(ua, urlBuilder.build().toString()).post(requestBody).build();
        return new OkHttpCall(this.okHttpClient.newCall(request), this.emptyResponseConverter);
    }

    @Override
    @NotNull
    public Call<Void> sendAdMarkup(@NotNull String url, @NotNull RequestBody requestBody) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        HttpUrl.Builder urlBuilder = HttpUrl.Companion.get(url).newBuilder();
        Request request = VungleApiImpl.defaultBuilder$default(this, "debug", urlBuilder.build().toString(), null, 4, null).post(requestBody).build();
        return new OkHttpCall(this.okHttpClient.newCall(request), this.emptyResponseConverter);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vungle/ads/internal/network/VungleApiImpl$Companion;", "", "()V", "VUNGLE_VERSION", "", "json", "Lkotlinx/serialization/json/Json;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

