/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.Logger;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 :2\u00020\u0001:\u0004:;<=B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006J\u0010\u0010%\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u0005J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020\u000eH\u0002J\u000e\u0010+\u001a\u00020#2\u0006\u0010(\u001a\u00020)J\u001a\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0010\u00101\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00103\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u00104\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u00105\u001a\u000200H\u0016J\u0010\u00106\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00107\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u00108\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0012\u00109\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u0005H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "adLeftCallbacks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/vungle/ads/internal/util/ActivityManager$LeftApplicationCallback;", "Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "callbacks", "Ljava/util/concurrent/CopyOnWriteArraySet;", "configChangeRunnable", "Ljava/lang/Runnable;", "handler", "Landroid/os/Handler;", "isAppForeground", "", "()Z", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastStoppedActivityName", "", "noResumedActivities", "getNoResumedActivities", "noStartedActivities", "getNoStartedActivities", "resumedActivities", "resumedActivitiesCount", "", "getResumedActivitiesCount", "()I", "startedActivities", "startedActivitiesCount", "getStartedActivitiesCount", "state", "Lcom/vungle/ads/internal/util/ActivityManager$State;", "addListener", "", "callback", "addOnNextAppLeftCallback", "leftCallback", "deInit", "context", "Landroid/content/Context;", "inForeground", "init", "onActivityCreated", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "removeListener", "removeOnNextAppLeftCallback", "Companion", "LeftApplicationCallback", "LifeCycleCallback", "State", "vungle-ads_release"})
public final class ActivityManager
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = State.UNKNOWN;
    @NotNull
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    @NotNull
    private final CopyOnWriteArraySet<String> startedActivities = new CopyOnWriteArraySet();
    @NotNull
    private final CopyOnWriteArraySet<String> resumedActivities = new CopyOnWriteArraySet();
    @Nullable
    private String lastStoppedActivityName;
    @NotNull
    private final CopyOnWriteArraySet<LifeCycleCallback> callbacks = new CopyOnWriteArraySet();
    @NotNull
    private final ConcurrentHashMap<LeftApplicationCallback, LifeCycleCallback> adLeftCallbacks = new ConcurrentHashMap();
    @Nullable
    private Handler handler;
    @NotNull
    private final Runnable configChangeRunnable = () -> ActivityManager.configChangeRunnable$lambda-0(this);
    private static final String TAG = ActivityManager.class.getSimpleName();
    @NotNull
    private static final ActivityManager instance = new ActivityManager();
    private static final long TIMEOUT = 3000L;
    private static final long CONFIG_CHANGE_DELAY = 700L;

    private ActivityManager() {
    }

    private final int getStartedActivitiesCount() {
        return this.startedActivities.size();
    }

    private final int getResumedActivitiesCount() {
        return this.resumedActivities.size();
    }

    private final boolean isAppForeground() {
        return !((Collection)this.resumedActivities).isEmpty();
    }

    private final boolean getNoResumedActivities() {
        return this.resumedActivities.isEmpty();
    }

    private final boolean getNoStartedActivities() {
        return this.startedActivities.isEmpty();
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        try {
            Handler handler = this.handler = new Handler(Looper.getMainLooper());
            if (handler != null) {
                handler.post(() -> ActivityManager.init$lambda-1(context, this));
            }
        }
        catch (Exception e2) {
            String string = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            Logger.Companion.e(string, "Error initializing ActivityManager", e2);
            this.isInitialized.set(false);
        }
    }

    @VisibleForTesting
    public final void deInit(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
        Application app = (Application)context2;
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.startedActivities.clear();
        this.resumedActivities.clear();
        this.isInitialized.set(false);
        this.callbacks.clear();
        this.adLeftCallbacks.clear();
    }

    private final boolean inForeground() {
        return !this.isInitialized.get() || this.lastStoppedActivityName == null || this.isAppForeground();
    }

    public final void addListener(@NotNull LifeCycleCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.callbacks.add(callback2);
    }

    private final void removeListener(LifeCycleCallback callback2) {
        this.callbacks.remove(callback2);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.startedActivities.add(activity.toString());
        if (this.getStartedActivitiesCount() == 1) {
            State[] stateArray = new State[]{State.STARTED, State.RESUMED};
            if (!CollectionsKt.listOf((Object[])stateArray).contains((Object)this.state)) {
                this.state = State.STARTED;
                for (LifeCycleCallback callback2 : this.callbacks) {
                    callback2.onStart();
                }
            }
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.lastStoppedActivityName = activity.toString();
            this.startedActivities.remove(activity.toString());
            if (!this.getNoStartedActivities()) break block1;
            Handler handler = this.handler;
            if (handler != null) {
                Handler handler2;
                Handler $this$onActivityStopped_u24lambda_u2d2 = handler2 = handler;
                boolean bl = false;
                $this$onActivityStopped_u24lambda_u2d2.removeCallbacks(this.configChangeRunnable);
                $this$onActivityStopped_u24lambda_u2d2.postDelayed(this.configChangeRunnable, CONFIG_CHANGE_DELAY);
            }
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        block1: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                boolean wasPaused = this.getNoResumedActivities();
                this.resumedActivities.add(activity.toString());
                if (this.getResumedActivitiesCount() != 1) break block1;
                if (!wasPaused || CollectionsKt.listOf((Object)((Object)State.RESUMED)).contains((Object)this.state)) break block2;
                this.state = State.RESUMED;
                for (LifeCycleCallback callback2 : this.callbacks) {
                    callback2.onResume();
                }
                break block1;
            }
            Handler handler = this.handler;
            if (handler == null) break block1;
            handler.removeCallbacks(this.configChangeRunnable);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.resumedActivities.remove(activity.toString());
            if (!this.getNoResumedActivities()) break block2;
            Handler handler = this.handler;
            if (handler != null) {
                handler.removeCallbacks(this.configChangeRunnable);
            }
            Handler handler2 = this.handler;
            if (handler2 != null) {
                handler2.postDelayed(this.configChangeRunnable, CONFIG_CHANGE_DELAY);
            }
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public final void addOnNextAppLeftCallback(@Nullable LeftApplicationCallback leftCallback) {
        if (leftCallback == null) {
            return;
        }
        if (!this.isInitialized.get()) {
            leftCallback.onLeftApplication();
            return;
        }
        WeakReference<LeftApplicationCallback> weakCallback = new WeakReference<LeftApplicationCallback>(leftCallback);
        Runnable cancelRunnable2 = new Runnable(this, weakCallback){
            final /* synthetic */ ActivityManager this$0;
            final /* synthetic */ WeakReference<LeftApplicationCallback> $weakCallback;
            {
                this.this$0 = $receiver;
                this.$weakCallback = $weakCallback;
            }

            public void run() {
                Handler handler = ActivityManager.access$getHandler$p(this.this$0);
                if (handler != null) {
                    handler.removeCallbacks((Runnable)this);
                }
                ActivityManager.access$removeOnNextAppLeftCallback(this.this$0, (LeftApplicationCallback)this.$weakCallback.get());
            }
        };
        LifeCycleCallback callback2 = new LifeCycleCallback(weakCallback, this, cancelRunnable2){
            private boolean wasPaused;
            final /* synthetic */ WeakReference<LeftApplicationCallback> $weakCallback;
            final /* synthetic */ ActivityManager this$0;
            final /* synthetic */ Runnable $cancelRunnable;
            {
                this.$weakCallback = $weakCallback;
                this.this$0 = $receiver;
                this.$cancelRunnable = $cancelRunnable;
            }

            public final boolean getWasPaused() {
                return this.wasPaused;
            }

            public final void setWasPaused(boolean bl) {
                this.wasPaused = bl;
            }

            public void onStop() {
                block1: {
                    super.onStop();
                    LeftApplicationCallback leftCallback = (LeftApplicationCallback)this.$weakCallback.get();
                    if (this.wasPaused && leftCallback != null && ActivityManager.access$getAdLeftCallbacks$p(this.this$0).containsKey(leftCallback)) {
                        leftCallback.onLeftApplication();
                    }
                    ActivityManager.access$removeOnNextAppLeftCallback(this.this$0, leftCallback);
                    Handler handler = ActivityManager.access$getHandler$p(this.this$0);
                    if (handler == null) break block1;
                    handler.removeCallbacks(this.$cancelRunnable);
                }
            }

            public void onResume() {
                block0: {
                    super.onResume();
                    Handler handler = ActivityManager.access$getHandler$p(this.this$0);
                    if (handler == null) break block0;
                    handler.postDelayed(this.$cancelRunnable, ActivityManager.Companion.getCONFIG_CHANGE_DELAY() * (long)2);
                }
            }

            public void onPause() {
                block0: {
                    super.onPause();
                    this.wasPaused = true;
                    Handler handler = ActivityManager.access$getHandler$p(this.this$0);
                    if (handler == null) break block0;
                    handler.removeCallbacks(this.$cancelRunnable);
                }
            }
        };
        ((Map)this.adLeftCallbacks).put(leftCallback, callback2);
        if (this.inForeground()) {
            Handler handler = this.handler;
            if (handler != null) {
                handler.postDelayed(cancelRunnable2, TIMEOUT);
            }
            this.addListener(callback2);
        } else {
            instance.addListener(new LifeCycleCallback(this, weakCallback, cancelRunnable2){
                final /* synthetic */ ActivityManager this$0;
                final /* synthetic */ WeakReference<LeftApplicationCallback> $weakCallback;
                final /* synthetic */ Runnable $cancelRunnable;
                {
                    this.this$0 = $receiver;
                    this.$weakCallback = $weakCallback;
                    this.$cancelRunnable = $cancelRunnable;
                }

                public void onStart() {
                    ActivityManager.access$removeListener(ActivityManager.Companion.getInstance$vungle_ads_release(), this);
                    LifeCycleCallback callback2 = (LifeCycleCallback)((Map)ActivityManager.access$getAdLeftCallbacks$p(this.this$0)).get(this.$weakCallback.get());
                    if (callback2 != null) {
                        Handler handler = ActivityManager.access$getHandler$p(this.this$0);
                        if (handler != null) {
                            handler.postDelayed(this.$cancelRunnable, ActivityManager.Companion.getTIMEOUT());
                        }
                        this.this$0.addListener(callback2);
                    }
                }
            });
        }
    }

    private final void removeOnNextAppLeftCallback(LeftApplicationCallback leftCallback) {
        block1: {
            LifeCycleCallback callback2;
            if (leftCallback == null) {
                return;
            }
            LifeCycleCallback lifeCycleCallback = callback2 = this.adLeftCallbacks.remove(leftCallback);
            if (lifeCycleCallback == null) break block1;
            LifeCycleCallback it = lifeCycleCallback;
            boolean bl = false;
            this.removeListener(it);
        }
    }

    private static final void configChangeRunnable$lambda-0(ActivityManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.getNoResumedActivities() && this$0.state != State.PAUSED) {
            this$0.state = State.PAUSED;
            for (LifeCycleCallback callback2 : this$0.callbacks) {
                callback2.onPause();
            }
        }
        if (this$0.getNoStartedActivities() && this$0.state == State.PAUSED) {
            this$0.state = State.STOPPED;
            for (LifeCycleCallback callback2 : this$0.callbacks) {
                callback2.onStop();
            }
        }
    }

    private static final void init$lambda-1(Context $context, ActivityManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Context context = $context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Application");
        Application app = (Application)context;
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this$0);
    }

    public static final /* synthetic */ Handler access$getHandler$p(ActivityManager $this) {
        return $this.handler;
    }

    public static final /* synthetic */ void access$removeOnNextAppLeftCallback(ActivityManager $this, LeftApplicationCallback leftCallback) {
        $this.removeOnNextAppLeftCallback(leftCallback);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getAdLeftCallbacks$p(ActivityManager $this) {
        return $this.adLeftCallbacks;
    }

    public static final /* synthetic */ void access$removeListener(ActivityManager $this, LifeCycleCallback callback2) {
        $this.removeListener(callback2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "", "()V", "onPause", "", "onResume", "onStart", "onStop", "vungle-ads_release"})
    public static class LifeCycleCallback {
        public void onStart() {
        }

        public void onStop() {
        }

        public void onResume() {
        }

        public void onPause() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$LeftApplicationCallback;", "", "onLeftApplication", "", "vungle-ads_release"})
    public static interface LeftApplicationCallback {
        public void onLeftApplication();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$State;", "", "(Ljava/lang/String;I)V", "STARTED", "RESUMED", "PAUSED", "STOPPED", "UNKNOWN", "vungle-ads_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State RESUMED = new State();
        public static final /* enum */ State PAUSED = new State();
        public static final /* enum */ State STOPPED = new State();
        public static final /* enum */ State UNKNOWN = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.STARTED, State.RESUMED, State.PAUSED, State.STOPPED, State.UNKNOWN};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ.\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J,\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010'J6\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\"\u001a\u0004\u0018\u00010#R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0007R\u001c\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$Companion;", "", "()V", "CONFIG_CHANGE_DELAY", "", "getCONFIG_CHANGE_DELAY$annotations", "getCONFIG_CHANGE_DELAY", "()J", "TAG", "", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "TIMEOUT", "getTIMEOUT$annotations", "getTIMEOUT", "instance", "Lcom/vungle/ads/internal/util/ActivityManager;", "getInstance$vungle_ads_release$annotations", "getInstance$vungle_ads_release", "()Lcom/vungle/ads/internal/util/ActivityManager;", "addLifecycleListener", "", "listener", "Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "init", "context", "Landroid/content/Context;", "isForeground", "", "startActivityHandleException", "deepLinkOverrideIntent", "Landroid/content/Intent;", "defaultIntent", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "startWhenForeground", "deeplinkOverrideIntent", "leftCallback", "Lcom/vungle/ads/internal/util/ActivityManager$LeftApplicationCallback;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final ActivityManager getInstance$vungle_ads_release() {
            return instance;
        }

        @VisibleForTesting(otherwise=2)
        public static /* synthetic */ void getInstance$vungle_ads_release$annotations() {
        }

        public final long getTIMEOUT() {
            return TIMEOUT;
        }

        @VisibleForTesting
        public static /* synthetic */ void getTIMEOUT$annotations() {
        }

        public final long getCONFIG_CHANGE_DELAY() {
            return CONFIG_CHANGE_DELAY;
        }

        @VisibleForTesting
        public static /* synthetic */ void getCONFIG_CHANGE_DELAY$annotations() {
        }

        public final void startWhenForeground(@NotNull Context context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable LeftApplicationCallback leftCallback, @Nullable PresenterAdOpenCallback adOpenCallback) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            WeakReference<Context> weakContext = new WeakReference<Context>(context);
            if (this.getInstance$vungle_ads_release().inForeground()) {
                if (this.startActivityHandleException(context, deepLinkOverrideIntent, defaultIntent, adOpenCallback)) {
                    this.getInstance$vungle_ads_release().addOnNextAppLeftCallback(leftCallback);
                }
            } else {
                this.getInstance$vungle_ads_release().addListener(new LifeCycleCallback(weakContext, deepLinkOverrideIntent, defaultIntent, adOpenCallback, leftCallback){
                    final /* synthetic */ WeakReference<Context> $weakContext;
                    final /* synthetic */ Intent $deepLinkOverrideIntent;
                    final /* synthetic */ Intent $defaultIntent;
                    final /* synthetic */ PresenterAdOpenCallback $adOpenCallback;
                    final /* synthetic */ LeftApplicationCallback $leftCallback;
                    {
                        this.$weakContext = $weakContext;
                        this.$deepLinkOverrideIntent = $deepLinkOverrideIntent;
                        this.$defaultIntent = $defaultIntent;
                        this.$adOpenCallback = $adOpenCallback;
                        this.$leftCallback = $leftCallback;
                    }

                    public void onStart() {
                        super.onStart();
                        ActivityManager.access$removeListener(ActivityManager.Companion.getInstance$vungle_ads_release(), this);
                        Context context = (Context)this.$weakContext.get();
                        if (context != null && com.vungle.ads.internal.util.ActivityManager$Companion.access$startActivityHandleException(ActivityManager.Companion, context, this.$deepLinkOverrideIntent, this.$defaultIntent, this.$adOpenCallback)) {
                            ActivityManager.Companion.getInstance$vungle_ads_release().addOnNextAppLeftCallback(this.$leftCallback);
                        }
                    }
                });
            }
        }

        public final void startWhenForeground(@NotNull Context context, @Nullable Intent deeplinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable LeftApplicationCallback leftCallback) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.startWhenForeground(context, deeplinkOverrideIntent, defaultIntent, leftCallback, null);
        }

        private final boolean startActivityHandleException(Context context, Intent deepLinkOverrideIntent, Intent defaultIntent, PresenterAdOpenCallback adOpenCallback) {
            if (deepLinkOverrideIntent == null && defaultIntent == null) {
                return false;
            }
            try {
                if (deepLinkOverrideIntent != null) {
                    context.startActivity(deepLinkOverrideIntent);
                    PresenterAdOpenCallback presenterAdOpenCallback = adOpenCallback;
                    if (presenterAdOpenCallback != null) {
                        presenterAdOpenCallback.onDeeplinkClick(true);
                    }
                } else {
                    context.startActivity(defaultIntent);
                }
            }
            catch (Exception exception) {
                String string = this.getTAG();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                Logger.Companion.e(string, "Cannot launch/find activity to handle the Implicit intent: " + exception);
                try {
                    if (deepLinkOverrideIntent != null) {
                        AnalyticsClient.logError$vungle_ads_release$default(AnalyticsClient.INSTANCE, 312, "Fail to open " + deepLinkOverrideIntent.getDataString(), "", null, null, 24, null);
                        PresenterAdOpenCallback presenterAdOpenCallback = adOpenCallback;
                        if (presenterAdOpenCallback != null) {
                            presenterAdOpenCallback.onDeeplinkClick(false);
                        }
                    }
                    if (deepLinkOverrideIntent == null || defaultIntent == null) {
                        return false;
                    }
                    context.startActivity(defaultIntent);
                }
                catch (Exception exception2) {
                    return false;
                }
                return true;
            }
            return true;
        }

        public final void init(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance$vungle_ads_release().init(context);
        }

        public final boolean isForeground() {
            return this.getInstance$vungle_ads_release().inForeground();
        }

        public final void addLifecycleListener(@NotNull LifeCycleCallback listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.getInstance$vungle_ads_release().addListener(listener);
        }

        public static final /* synthetic */ boolean access$startActivityHandleException(Companion $this, Context context, Intent deepLinkOverrideIntent, Intent defaultIntent, PresenterAdOpenCallback adOpenCallback) {
            return $this.startActivityHandleException(context, deepLinkOverrideIntent, defaultIntent, adOpenCallback);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

