package com.vungle.ads.internal.omsdk

import android.content.Context
import android.os.Handler
import android.os.Looper
import com.vungle.ads.internal.util.Logger
import androidx.annotation.WorkerThread
import com.iab.omid.library.vungle.Omid
import java.io.File
import java.io.FileWriter
import java.io.IOException
import java.util.ArrayList
import java.util.concurrent.atomic.AtomicReference

class OMInjector(context: Context) {
    private val uiHandler = Handler(Looper.getMainLooper())
    private val contextRef = AtomicReference(context.applicationContext)
    fun init() {
        uiHandler.post {
            runCatching {
                if (!Omid.isActive()) {
                    Omid.activate(contextRef.get())
                }
            }.onFailure { error ->
                Logger.e("OMSDK", "error: ${error.localizedMessage}")
            }
        }
    }

    @WorkerThread
    internal fun injectJsFiles(dir: File): List<File> {
        val list = ArrayList<File>()
        list.add(writeToFile(Res.OM_JS, File(dir, OM_SDK_JS)))
        list.add(writeToFile(Res.OM_SESSION_JS, File(dir, OM_SESSION_JS)))
        return list
    }

    private fun writeToFile(lines: String?, outputFile: File): File {
        if (lines == null) throw IOException("omsdk js must not be null")
        return FileWriter(outputFile).use { writer ->
            writer.write(lines)
            writer.flush()
            outputFile
        }
    }

    companion object {
        private const val OM_SDK_JS = "omsdk.js"
        private const val OM_SESSION_JS = "omsdk-session.js"
    }

}
