package com.vungle.ads.internal.util

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.vungle.ads.LinkError
import com.vungle.ads.internal.protos.Sdk.SDKError
import com.vungle.ads.internal.ui.PresenterAdOpenCallback
import java.lang.Exception
import java.net.URISyntaxException

object ExternalRouter {

    private const val TAG = "ExternalRouter"

    @JvmStatic
    fun launch(
        deeplinkUrl: String? = null,
        url: String? = null,
        context: Context,
        logEntry: LogEntry? = null,
        adOpenCallback: PresenterAdOpenCallback? = null
    ): Boolean {
        if (deeplinkUrl.isNullOrEmpty() && url.isNullOrEmpty()) {
            return false
        }
        val contextIsNotActivity = context !is Activity
        try {
            val deeplinkIntent = getIntentFromUrl(deeplinkUrl, contextIsNotActivity)
            val fallbackIntent = getIntentFromUrl(url, contextIsNotActivity)
            return ActivityManager.startWhenForeground(
                context,
                deeplinkIntent,
                fallbackIntent,
                adOpenCallback
            )
        } catch (e: Exception) {
            if (!deeplinkUrl.isNullOrEmpty()) {
                LinkError(
                    SDKError.Reason.DEEPLINK_OPEN_FAILED,
                    "Fail to open $deeplinkUrl",
                ).setLogEntry(logEntry).logErrorNoReturnValue()
            } else {
                LinkError(
                    SDKError.Reason.LINK_COMMAND_OPEN_FAILED,
                    "Fail to open $url",
                ).setLogEntry(logEntry).logErrorNoReturnValue()
            }
            Logger.e(TAG, "Error while opening url" + e.localizedMessage)
        }
        Logger.d(TAG, "Cannot open url $url")
        return false
    }

    private fun getIntentFromUrl(url: String?, contextIsNotActivity: Boolean): Intent? {
        var intent: Intent? = null
        try {
            intent = if (url.isNullOrEmpty()) null else Intent.parseUri(url, 0)
            if (intent != null && contextIsNotActivity) {
                intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
            }
        } catch (e: URISyntaxException) {
            Logger.e(TAG, "url format is not correct " + e.localizedMessage)
        }
        return intent
    }
}
