/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.downloader;

import android.os.Build;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.AssetDownloadError;
import com.vungle.ads.AssetFailedStatusCodeError;
import com.vungle.ads.AssetRequestError;
import com.vungle.ads.AssetWriteError;
import com.vungle.ads.NoSpaceError;
import com.vungle.ads.OutOfMemory;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.VungleThreadPoolExecutor;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.task.PriorityRunnable;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\"\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u001dH\u0002J\u001c\u0010$\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u001a\u0010(\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/vungle/ads/internal/downloader/AssetDownloader;", "Lcom/vungle/ads/internal/downloader/Downloader;", "downloadExecutor", "Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "(Lcom/vungle/ads/internal/executor/VungleThreadPoolExecutor;Lcom/vungle/ads/internal/util/PathProvider;)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "okHttpClient$delegate", "Lkotlin/Lazy;", "transitioning", "", "Lcom/vungle/ads/internal/downloader/DownloadRequest;", "cancel", "", "request", "cancelAll", "checkSpaceAvailable", "", "downloadRequest", "decodeGzipIfNeeded", "Lokhttp3/ResponseBody;", "networkResponse", "Lokhttp3/Response;", "deliverError", "downloadListener", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "downloadError", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener$DownloadError;", "deliverSuccess", "file", "Ljava/io/File;", "listener", "download", "isValidUrl", "httpUrl", "", "launchRequest", "Companion", "OkHttpSingleton", "vungle-ads_release"})
public final class AssetDownloader
implements Downloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VungleThreadPoolExecutor downloadExecutor;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    private final Lazy okHttpClient$delegate;
    @NotNull
    private final List<DownloadRequest> transitioning;
    @NotNull
    private static final String TAG = "AssetDownloader";
    private static final int MINIMUM_SPACE_REQUIRED_MB = 0x1400000;
    private static final int DOWNLOAD_CHUNK_SIZE = 2048;
    @NotNull
    private static final String CONTENT_ENCODING = "Content-Encoding";
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    private static final String GZIP = "gzip";

    public AssetDownloader(@NotNull VungleThreadPoolExecutor downloadExecutor, @NotNull PathProvider pathProvider) {
        Intrinsics.checkNotNullParameter((Object)downloadExecutor, (String)"downloadExecutor");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.downloadExecutor = downloadExecutor;
        this.pathProvider = pathProvider;
        this.okHttpClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OkHttpClient>(this){
            final /* synthetic */ AssetDownloader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OkHttpClient invoke() {
                return OkHttpSingleton.INSTANCE.createOkHttpClient(AssetDownloader.access$getPathProvider$p(this.this$0));
            }
        }));
        this.transitioning = new ArrayList();
    }

    private final OkHttpClient getOkHttpClient() {
        Lazy lazy = this.okHttpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @Override
    public void download(@Nullable DownloadRequest downloadRequest, @Nullable AssetDownloadListener downloadListener) {
        if (downloadRequest == null) {
            return;
        }
        this.transitioning.add(downloadRequest);
        this.downloadExecutor.execute(new PriorityRunnable(this, downloadRequest, downloadListener){
            final /* synthetic */ AssetDownloader this$0;
            final /* synthetic */ DownloadRequest $downloadRequest;
            final /* synthetic */ AssetDownloadListener $downloadListener;
            {
                this.this$0 = $receiver;
                this.$downloadRequest = $downloadRequest;
                this.$downloadListener = $downloadListener;
            }

            public void run() {
                AssetDownloader.access$launchRequest(this.this$0, this.$downloadRequest, this.$downloadListener);
            }

            public int getPriority() {
                return this.$downloadRequest.getPriority();
            }
        }, () -> AssetDownloader.download$lambda-0(this, downloadRequest, downloadListener));
    }

    private final void deliverError(DownloadRequest downloadRequest, AssetDownloadListener downloadListener, AssetDownloadListener.DownloadError downloadError) {
        block0: {
            AssetDownloadListener assetDownloadListener2 = downloadListener;
            if (assetDownloadListener2 == null) break block0;
            assetDownloadListener2.onError(downloadError, downloadRequest);
        }
    }

    @Override
    public void cancel(@Nullable DownloadRequest request) {
        if (request == null || request.isCancelled()) {
            return;
        }
        request.cancel();
    }

    @Override
    public void cancelAll() {
        Iterable $this$forEach$iv = this.transitioning;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadRequest it = (DownloadRequest)element$iv;
            boolean bl = false;
            this.cancel(it);
        }
        this.transitioning.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void launchRequest(DownloadRequest downloadRequest, AssetDownloadListener downloadListener) {
        Logger.Companion.d(TAG, "launch request in thread: " + Thread.currentThread().getId() + " request: " + downloadRequest.getAsset().getServerPath());
        if (downloadRequest.isCancelled()) {
            Logger.Companion.d(TAG, "Request " + downloadRequest.getAsset().getServerPath() + " is cancelled before starting");
            AssetDownloadListener.Progress progress = new AssetDownloadListener.Progress();
            progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED());
            return;
        }
        boolean done = false;
        AssetDownloadListener.Progress progress = new AssetDownloadListener.Progress();
        progress.setTimestampDownloadStart(System.currentTimeMillis());
        AssetDownloadListener.DownloadError downloadError = null;
        String url = downloadRequest.getAsset().getServerPath();
        String path = downloadRequest.getAsset().getLocalPath();
        if (((CharSequence)url).length() == 0 || !this.isValidUrl(url)) {
            this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new AssetDownloadError(Sdk.SDKError.Reason.INVALID_ASSET_URL, "invalid url: " + url).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logError$vungle_ads_release(), AssetDownloadListener.DownloadError.ErrorReason.Companion.getINTERNAL_ERROR()));
            return;
        }
        if (((CharSequence)path).length() == 0) {
            this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new AssetDownloadError(Sdk.SDKError.Reason.ASSET_WRITE_ERROR, "invalid path: " + path).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logError$vungle_ads_release(), AssetDownloadListener.DownloadError.ErrorReason.Companion.getFILE_NOT_FOUND_ERROR()));
            return;
        }
        if (Build.VERSION.SDK_INT >= 18 && !this.checkSpaceAvailable(downloadRequest)) {
            this.deliverError(downloadRequest, downloadListener, new AssetDownloadListener.DownloadError(-1, new NoSpaceError(null, 1, null).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logError$vungle_ads_release(), AssetDownloadListener.DownloadError.ErrorReason.Companion.getDISK_ERROR()));
            return;
        }
        File file = new File(path);
        while (!done) {
            Unit unit;
            Response response;
            done = true;
            BufferedSink sink = null;
            BufferedSource source = null;
            long totalRead = 0L;
            Call call = null;
            long downloaded = 0L;
            int code = -1;
            Response response2 = null;
            try {
                ResponseBody body;
                Unit unit2;
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                downloaded = file.exists() ? file.length() : 0L;
                Request.Builder requestBuilder = new Request.Builder().url(url);
                call = this.getOkHttpClient().newCall(requestBuilder.build());
                response2 = call.execute();
                code = response2.code();
                if (!response2.isSuccessful()) {
                    new AssetFailedStatusCodeError(url, code, "Asset download does not success: " + response2.message()).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
                    throw new Downloader.RequestException("Code: " + code);
                }
                if (response2.cacheResponse() != null) {
                    boolean bl = false;
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.CACHED_ASSETS_USED), downloadRequest.getLogEntry$vungle_ads_release(), url);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                ResponseBody responseBody = body = this.decodeGzipIfNeeded(response2);
                source = responseBody != null ? responseBody.source() : null;
                Logger.Companion.d(TAG, "Start download from bytes:" + downloaded + ", url: " + url);
                long offset = downloaded;
                sink = Okio.buffer((Sink)(offset == 0L ? Okio.sink$default((File)file, (boolean)false, (int)1, null) : Okio.appendingSink((File)file)));
                long read = 0L;
                progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED());
                ResponseBody responseBody2 = body;
                progress.setSizeBytes(responseBody2 != null ? responseBody2.contentLength() : 0L);
                progress.setStartBytes(offset);
                while (true) {
                    long l;
                    BufferedSource bufferedSource = source;
                    long $this$launchRequest_u24lambda_u2d3 = l = bufferedSource != null ? bufferedSource.read(sink.getBuffer(), 2048L) : -1L;
                    boolean bl = false;
                    read = $this$launchRequest_u24lambda_u2d3;
                    if (l <= 0L) break;
                    if (!file.exists()) {
                        new AssetWriteError("Asset save error " + url).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
                        throw new Downloader.RequestException("File is not existing");
                    }
                    if (downloadRequest.isCancelled()) {
                        progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED());
                        break;
                    }
                    progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getIN_PROGRESS());
                    sink.emit();
                    totalRead += read;
                }
                sink.flush();
                if (progress.getStatus() == AssetDownloadListener.Progress.ProgressStatus.Companion.getIN_PROGRESS()) {
                    progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getDONE());
                }
                response = response2;
            }
            catch (Exception ex) {
                Unit unit3;
                Response response3;
                try {
                    Logger.Companion.e(TAG, String.valueOf(ex));
                    if (ex instanceof ProtocolException) {
                        new AssetRequestError("Failed to load asset: " + downloadRequest.getAsset().getServerPath()).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
                    } else if (ex instanceof UnknownHostException || ex instanceof IOException) {
                        new AssetFailedStatusCodeError(url, code, ex.getMessage()).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
                    }
                    progress.setStatus(AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR());
                    downloadError = new AssetDownloadListener.DownloadError(code, ex, AssetDownloadListener.DownloadError.ErrorReason.Companion.getREQUEST_ERROR());
                    response3 = response2;
                }
                catch (Throwable throwable) {
                    Unit unit4;
                    Response response4 = response2;
                    if ((response4 != null ? response4.body() : null) != null) {
                        Unit unit5;
                        ResponseBody responseBody = response2.body();
                        if (responseBody != null) {
                            responseBody.close();
                            unit5 = Unit.INSTANCE;
                        } else {
                            unit5 = null;
                        }
                    }
                    Call call2 = call;
                    if (call2 != null) {
                        call2.cancel();
                        unit4 = Unit.INSTANCE;
                    } else {
                        unit4 = null;
                    }
                    FileUtility.INSTANCE.closeQuietly((Closeable)sink);
                    FileUtility.INSTANCE.closeQuietly((Closeable)source);
                    Logger.Companion.d(TAG, "download status: " + progress.getStatus());
                    int n = progress.getStatus();
                    if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR() ? true : n == AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED()) {
                        this.deliverError(downloadRequest, downloadListener, downloadError);
                    } else if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED()) {
                        Logger.Companion.d(TAG, "On cancel " + downloadRequest);
                    } else {
                        this.deliverSuccess(file, downloadRequest, downloadListener);
                    }
                    throw throwable;
                }
                if ((response3 != null ? response3.body() : null) != null) {
                    Unit unit6;
                    ResponseBody responseBody = response2.body();
                    if (responseBody != null) {
                        responseBody.close();
                        unit6 = Unit.INSTANCE;
                    } else {
                        unit6 = null;
                    }
                }
                Call call3 = call;
                if (call3 != null) {
                    call3.cancel();
                    unit3 = Unit.INSTANCE;
                } else {
                    unit3 = null;
                }
                FileUtility.INSTANCE.closeQuietly((Closeable)sink);
                FileUtility.INSTANCE.closeQuietly((Closeable)source);
                Logger.Companion.d(TAG, "download status: " + progress.getStatus());
                int n = progress.getStatus();
                if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR() ? true : n == AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED()) {
                    this.deliverError(downloadRequest, downloadListener, downloadError);
                    continue;
                }
                if (n == AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED()) {
                    Logger.Companion.d(TAG, "On cancel " + downloadRequest);
                    continue;
                }
                this.deliverSuccess(file, downloadRequest, downloadListener);
                continue;
            }
            if ((response != null ? response.body() : null) != null) {
                Unit unit7;
                ResponseBody responseBody = response2.body();
                if (responseBody != null) {
                    responseBody.close();
                    unit7 = Unit.INSTANCE;
                } else {
                    unit7 = null;
                }
            }
            Call call4 = call;
            if (call4 != null) {
                call4.cancel();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            FileUtility.INSTANCE.closeQuietly((Closeable)sink);
            FileUtility.INSTANCE.closeQuietly((Closeable)source);
            Logger.Companion.d(TAG, "download status: " + progress.getStatus());
            int parentFile = progress.getStatus();
            if (parentFile == AssetDownloadListener.Progress.ProgressStatus.Companion.getERROR() ? true : parentFile == AssetDownloadListener.Progress.ProgressStatus.Companion.getSTARTED()) {
                this.deliverError(downloadRequest, downloadListener, downloadError);
                continue;
            }
            if (parentFile == AssetDownloadListener.Progress.ProgressStatus.Companion.getCANCELLED()) {
                Logger.Companion.d(TAG, "On cancel " + downloadRequest);
                continue;
            }
            this.deliverSuccess(file, downloadRequest, downloadListener);
        }
    }

    private final ResponseBody decodeGzipIfNeeded(Response networkResponse) {
        ResponseBody resp = networkResponse.body();
        if (StringsKt.equals((String)GZIP, (String)Response.header$default((Response)networkResponse, (String)CONTENT_ENCODING, null, (int)2, null), (boolean)true) && resp != null) {
            GzipSource responseBody = new GzipSource((Source)resp.source());
            String contentType = Response.header$default((Response)networkResponse, (String)CONTENT_TYPE, null, (int)2, null);
            return (ResponseBody)new RealResponseBody(contentType, -1L, Okio.buffer((Source)((Source)responseBody)));
        }
        return resp;
    }

    private final void deliverSuccess(File file, DownloadRequest downloadRequest, AssetDownloadListener listener) {
        block0: {
            Logger.Companion.d(TAG, "On success " + downloadRequest);
            AssetDownloadListener assetDownloadListener2 = listener;
            if (assetDownloadListener2 == null) break block0;
            assetDownloadListener2.onSuccess(file, downloadRequest);
        }
    }

    private final boolean checkSpaceAvailable(DownloadRequest downloadRequest) {
        String string = this.pathProvider.getVungleDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathProvider.getVungleDir().absolutePath");
        long availableBytes = this.pathProvider.getAvailableBytes(string);
        if (availableBytes < 0x1400000L) {
            new NoSpaceError("Insufficient space " + availableBytes).setLogEntry$vungle_ads_release(downloadRequest.getLogEntry$vungle_ads_release()).logErrorNoReturnValue$vungle_ads_release();
            return false;
        }
        return true;
    }

    private final boolean isValidUrl(String httpUrl) {
        CharSequence charSequence = httpUrl;
        return !(charSequence == null || charSequence.length() == 0) && HttpUrl.Companion.parse(httpUrl) != null;
    }

    private static final void download$lambda-0(AssetDownloader this$0, DownloadRequest $downloadRequest, AssetDownloadListener $downloadListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.deliverError($downloadRequest, $downloadListener, new AssetDownloadListener.DownloadError(-1, new OutOfMemory("Cannot complete " + $downloadRequest + " : Out of Memory"), AssetDownloadListener.DownloadError.ErrorReason.Companion.getINTERNAL_ERROR()));
    }

    public static final /* synthetic */ void access$launchRequest(AssetDownloader $this, DownloadRequest downloadRequest, AssetDownloadListener downloadListener) {
        $this.launchRequest(downloadRequest, downloadListener);
    }

    public static final /* synthetic */ PathProvider access$getPathProvider$p(AssetDownloader $this) {
        return $this.pathProvider;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/vungle/ads/internal/downloader/AssetDownloader$Companion;", "", "()V", "CONTENT_ENCODING", "", "CONTENT_TYPE", "DOWNLOAD_CHUNK_SIZE", "", "GZIP", "MINIMUM_SPACE_REQUIRED_MB", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vungle/ads/internal/downloader/AssetDownloader$OkHttpSingleton;", "", "()V", "client", "Lokhttp3/OkHttpClient;", "createOkHttpClient", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "vungle-ads_release"})
    private static final class OkHttpSingleton {
        @NotNull
        public static final OkHttpSingleton INSTANCE = new OkHttpSingleton();
        @Nullable
        private static OkHttpClient client;

        private OkHttpSingleton() {
        }

        @NotNull
        public final OkHttpClient createOkHttpClient(@NotNull PathProvider pathProvider) {
            Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
            OkHttpClient okHttpClient2 = client;
            if (okHttpClient2 == null) {
                OkHttpClient okHttpClient3;
                OkHttpSingleton $this$createOkHttpClient_u24lambda_u2d0 = this;
                boolean bl = false;
                OkHttpClient.Builder builder2 = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).cache(null).followRedirects(true).followSslRedirects(true);
                if (ConfigManager.INSTANCE.isCleverCacheEnabled()) {
                    long diskSize = ConfigManager.INSTANCE.getCleverCacheDiskSize();
                    int diskPercentage = ConfigManager.INSTANCE.getCleverCacheDiskPercentage();
                    String string = pathProvider.getCleverCacheDir().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathProvider.getCleverCacheDir().absolutePath");
                    long maxDiskCapacity = pathProvider.getAvailableBytes(string) * (long)diskPercentage / (long)100;
                    long diskCapacity = Long.min(diskSize, maxDiskCapacity);
                    if (diskCapacity > 0L) {
                        builder2.cache(new Cache(pathProvider.getCleverCacheDir(), diskCapacity));
                    } else {
                        Logger.Companion.w("OkHttpClientWrapper", "cache disk capacity size <=0, no clever cache active.");
                    }
                }
                OkHttpClient it = okHttpClient3 = builder2.build();
                boolean bl2 = false;
                client = it;
                okHttpClient2 = okHttpClient3;
            }
            return okHttpClient2;
        }
    }
}

