/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.load;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.vungle.ads.AdExpiredError;
import com.vungle.ads.AdPayloadError;
import com.vungle.ads.AdResponseEmptyError;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.AssetDownloadError;
import com.vungle.ads.AssetRequestError;
import com.vungle.ads.AssetResponseDataError;
import com.vungle.ads.IndexHtmlError;
import com.vungle.ads.InvalidAssetUrlError;
import com.vungle.ads.InvalidEventIdError;
import com.vungle.ads.InvalidTemplateURLError;
import com.vungle.ads.MraidJsError;
import com.vungle.ads.NativeAssetError;
import com.vungle.ads.OmSdkJsError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TemplateUnzipError;
import com.vungle.ads.TimeIntervalMetric;
import com.vungle.ads.VungleError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.downloader.AssetDownloadListener;
import com.vungle.ads.internal.downloader.DownloadRequest;
import com.vungle.ads.internal.downloader.Downloader;
import com.vungle.ads.internal.executor.Executors;
import com.vungle.ads.internal.load.AdLoaderCallback;
import com.vungle.ads.internal.load.AdRequest;
import com.vungle.ads.internal.load.BaseAdLoader;
import com.vungle.ads.internal.load.MraidJsLoader;
import com.vungle.ads.internal.model.AdAsset;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.ConfigPayload;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import com.vungle.ads.internal.util.UnzipUtility;
import com.vungle.ads.internal.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\b&\u0018\u0000 b2\u00020\u0001:\u0001bB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010@\u001a\u00020AJ\b\u0010B\u001a\u00020AH\u0002J\u0018\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0013H\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010G\u001a\u00020\u0013H\u0002J\u0012\u0010J\u001a\u0004\u0018\u00010F2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u001cH\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020\u001cH\u0002J!\u0010O\u001a\u00020A2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010P\u001a\u0004\u0018\u000104H\u0000\u00a2\u0006\u0002\bQJ\u0010\u0010R\u001a\u00020D2\u0006\u0010S\u001a\u00020FH\u0002J\u000e\u0010T\u001a\u00020A2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010U\u001a\u00020A2\u0006\u0010V\u001a\u00020LJ\b\u0010W\u001a\u00020AH&J\b\u0010X\u001a\u00020AH\u0002J\u0010\u0010Y\u001a\u00020A2\u0006\u0010Z\u001a\u00020\u000fH\u0003J\b\u0010[\u001a\u00020AH\u0002J\u001a\u0010\\\u001a\u00020D2\u0006\u0010]\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010^\u001a\u00020AH$J\u0018\u0010_\u001a\u00020D2\u0006\u0010`\u001a\u00020F2\u0006\u0010S\u001a\u00020FH\u0002J\u0012\u0010a\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020\u001cH\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006c\u00b2\u0006\n\u0010d\u001a\u00020eX\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader;", "", "context", "Landroid/content/Context;", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "sdkExecutors", "Lcom/vungle/ads/internal/executor/Executors;", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;", "downloader", "Lcom/vungle/ads/internal/downloader/Downloader;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "adRequest", "Lcom/vungle/ads/internal/load/AdRequest;", "(Landroid/content/Context;Lcom/vungle/ads/internal/network/VungleApiClient;Lcom/vungle/ads/internal/executor/Executors;Lcom/vungle/ads/internal/omsdk/OMInjector;Lcom/vungle/ads/internal/downloader/Downloader;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/load/AdRequest;)V", "adAssets", "", "Lcom/vungle/ads/internal/model/AdAsset;", "adLoaderCallback", "Lcom/vungle/ads/internal/load/AdLoaderCallback;", "adOptionalDownloadDurationMetric", "Lcom/vungle/ads/TimeIntervalMetric;", "getAdRequest", "()Lcom/vungle/ads/internal/load/AdRequest;", "adRequiredDownloadDurationMetric", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "getAdvertisement$vungle_ads_release", "()Lcom/vungle/ads/internal/model/AdPayload;", "setAdvertisement$vungle_ads_release", "(Lcom/vungle/ads/internal/model/AdPayload;)V", "assetDownloadDurationMetric", "assetDownloadListener", "Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "getAssetDownloadListener", "()Lcom/vungle/ads/internal/downloader/AssetDownloadListener;", "getContext", "()Landroid/content/Context;", "downloadCount", "Ljava/util/concurrent/atomic/AtomicLong;", "downloadRequiredCount", "fullyDownloaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry$vungle_ads_release", "()Lcom/vungle/ads/internal/util/LogEntry;", "setLogEntry$vungle_ads_release", "(Lcom/vungle/ads/internal/util/LogEntry;)V", "mainVideoSizeMetric", "Lcom/vungle/ads/SingleValueMetric;", "notifyFailed", "notifySuccess", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "requiredAssetDownloaded", "getSdkExecutors", "()Lcom/vungle/ads/internal/executor/Executors;", "templateHtmlSizeMetric", "templateSizeMetric", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "cancel", "", "downloadAssets", "fileIsValid", "", "file", "Ljava/io/File;", "adAsset", "getAssetPriority", "Lcom/vungle/ads/internal/downloader/DownloadRequest$Priority;", "getDestinationDir", "getErrorInfo", "Lcom/vungle/ads/VungleError;", "adPayload", "getTemplateError", "handleAdMetaData", "metric", "handleAdMetaData$vungle_ads_release", "injectMraidJS", "destinationDir", "loadAd", "onAdLoadFailed", "error", "onAdLoadReady", "onAdReady", "onDownloadCompleted", "request", "onRequiredDownloadCompleted", "processVmTemplate", "asset", "requestAd", "unzipFile", "downloadedFile", "validateAdMetadata", "Companion", "vungle-ads_release", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;"})
public abstract class BaseAdLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final VungleApiClient vungleApiClient;
    @NotNull
    private final Executors sdkExecutors;
    @NotNull
    private final OMInjector omInjector;
    @NotNull
    private final Downloader downloader;
    @NotNull
    private final PathProvider pathProvider;
    @NotNull
    private final AdRequest adRequest;
    @NotNull
    private final AtomicLong downloadCount;
    @NotNull
    private final AtomicLong downloadRequiredCount;
    @Nullable
    private AdLoaderCallback adLoaderCallback;
    @NotNull
    private AtomicBoolean notifySuccess;
    @NotNull
    private AtomicBoolean notifyFailed;
    @NotNull
    private final List<AdAsset> adAssets;
    @Nullable
    private AdPayload advertisement;
    @NotNull
    private AtomicBoolean fullyDownloaded;
    @NotNull
    private AtomicBoolean requiredAssetDownloaded;
    @NotNull
    private SingleValueMetric mainVideoSizeMetric;
    @NotNull
    private SingleValueMetric templateSizeMetric;
    @NotNull
    private SingleValueMetric templateHtmlSizeMetric;
    @NotNull
    private TimeIntervalMetric assetDownloadDurationMetric;
    @NotNull
    private TimeIntervalMetric adRequiredDownloadDurationMetric;
    @NotNull
    private TimeIntervalMetric adOptionalDownloadDurationMetric;
    @Nullable
    private LogEntry logEntry;
    @NotNull
    private static final String TAG = "BaseAdLoader";
    @NotNull
    private static final String DOWNLOADED_FILE_NOT_FOUND = "Downloaded file not found!";

    public BaseAdLoader(@NotNull Context context, @NotNull VungleApiClient vungleApiClient, @NotNull Executors sdkExecutors, @NotNull OMInjector omInjector, @NotNull Downloader downloader, @NotNull PathProvider pathProvider, @NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)sdkExecutors, (String)"sdkExecutors");
        Intrinsics.checkNotNullParameter((Object)omInjector, (String)"omInjector");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        this.context = context;
        this.vungleApiClient = vungleApiClient;
        this.sdkExecutors = sdkExecutors;
        this.omInjector = omInjector;
        this.downloader = downloader;
        this.pathProvider = pathProvider;
        this.adRequest = adRequest;
        this.downloadCount = new AtomicLong(0L);
        this.downloadRequiredCount = new AtomicLong(0L);
        this.notifySuccess = new AtomicBoolean(false);
        this.notifyFailed = new AtomicBoolean(false);
        this.adAssets = new ArrayList();
        this.fullyDownloaded = new AtomicBoolean(true);
        this.requiredAssetDownloaded = new AtomicBoolean(true);
        this.mainVideoSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.ASSET_FILE_SIZE);
        this.templateSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.TEMPLATE_ZIP_SIZE);
        this.templateHtmlSizeMetric = new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.TEMPLATE_HTML_SIZE);
        this.assetDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.ASSET_DOWNLOAD_DURATION_MS);
        this.adRequiredDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.AD_REQUIRED_DOWNLOAD_DURATION_MS);
        this.adOptionalDownloadDurationMetric = new TimeIntervalMetric(Sdk.SDKMetric.SDKMetricType.AD_OPTIONAL_DOWNLOAD_DURATION_MS);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final VungleApiClient getVungleApiClient() {
        return this.vungleApiClient;
    }

    @NotNull
    public final Executors getSdkExecutors() {
        return this.sdkExecutors;
    }

    @NotNull
    public final PathProvider getPathProvider() {
        return this.pathProvider;
    }

    @NotNull
    public final AdRequest getAdRequest() {
        return this.adRequest;
    }

    @Nullable
    public final AdPayload getAdvertisement$vungle_ads_release() {
        return this.advertisement;
    }

    public final void setAdvertisement$vungle_ads_release(@Nullable AdPayload adPayload) {
        this.advertisement = adPayload;
    }

    @Nullable
    public final LogEntry getLogEntry$vungle_ads_release() {
        return this.logEntry;
    }

    public final void setLogEntry$vungle_ads_release(@Nullable LogEntry logEntry2) {
        this.logEntry = logEntry2;
    }

    private final AssetDownloadListener getAssetDownloadListener() {
        return new AssetDownloadListener(this){
            final /* synthetic */ BaseAdLoader this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@Nullable AssetDownloadListener.DownloadError error, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                AssetDownloadListener.DownloadError downloadError = error;
                AssetDownloadListener.DownloadError downloadError2 = error;
                Logger.Companion.e("BaseAdLoader", "onError called: reason " + (downloadError != null ? Integer.valueOf(downloadError.getReason()) : null) + "; cause " + (downloadError2 != null ? downloadError2.getCause() : null));
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onError$lambda-0(this.this$0, downloadRequest, error));
            }

            public void onSuccess(@NotNull File file, @NotNull DownloadRequest downloadRequest) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)downloadRequest, (String)"downloadRequest");
                this.this$0.getSdkExecutors().getBackgroundExecutor().execute(() -> assetDownloadListener.1.onSuccess$lambda-1(file, this, downloadRequest, this.this$0));
            }

            private static final void onError$lambda-0(BaseAdLoader this$0, DownloadRequest $downloadRequest, AssetDownloadListener.DownloadError $error) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                BaseAdLoader.access$getFullyDownloaded$p(this$0).set(false);
                if ($downloadRequest.getAsset().isRequired()) {
                    BaseAdLoader.access$getRequiredAssetDownloaded$p(this$0).set(false);
                }
                AssetDownloadListener.DownloadError downloadError = $error;
                AssetDownloadListener.DownloadError downloadError2 = $error;
                String errorMsg = "Failed to download assets. required=" + $downloadRequest.getAsset().isRequired() + " reason=" + (downloadError != null ? Integer.valueOf(downloadError.getReason()) : null) + " cause=" + (downloadError2 != null ? downloadError2.getCause() : null);
                if ($downloadRequest.getAsset().isRequired() && BaseAdLoader.access$getDownloadRequiredCount$p(this$0).decrementAndGet() <= 0L) {
                    this$0.onAdLoadFailed(new AssetDownloadError(Sdk.SDKError.Reason.ASSET_RESPONSE_DATA_ERROR, errorMsg).setLogEntry$vungle_ads_release(this$0.getLogEntry$vungle_ads_release()).logError$vungle_ads_release());
                    this$0.cancel();
                    return;
                }
                if (BaseAdLoader.access$getDownloadCount$p(this$0).decrementAndGet() <= 0L) {
                    this$0.onAdLoadFailed(new AssetDownloadError(Sdk.SDKError.Reason.ASSET_RESPONSE_DATA_ERROR, errorMsg).setLogEntry$vungle_ads_release(this$0.getLogEntry$vungle_ads_release()).logError$vungle_ads_release());
                }
            }

            private static final void onSuccess$lambda-1(File $file, assetDownloadListener.1 this$0, DownloadRequest $downloadRequest, BaseAdLoader this$1) {
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$downloadRequest, (String)"$downloadRequest");
                Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                if (!$file.exists()) {
                    this$0.onError(new AssetDownloadListener.DownloadError(-1, new IOException("Downloaded file not found!"), AssetDownloadListener.DownloadError.ErrorReason.Companion.getFILE_NOT_FOUND_ERROR()), $downloadRequest);
                    return;
                }
                AdAsset adAsset = $downloadRequest.getAsset();
                adAsset.setFileSize($file.length());
                adAsset.setStatus(AdAsset.Status.DOWNLOAD_SUCCESS);
                if ($downloadRequest.isTemplate()) {
                    $downloadRequest.stopRecord();
                    SingleValueMetric templateFileSizeMetric = $downloadRequest.isHtmlTemplate() ? BaseAdLoader.access$getTemplateHtmlSizeMetric$p(this$1) : BaseAdLoader.access$getTemplateSizeMetric$p(this$1);
                    templateFileSizeMetric.setValue($file.length());
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(templateFileSizeMetric, this$1.getLogEntry$vungle_ads_release(), adAsset.getServerPath());
                } else if ($downloadRequest.isMainVideo()) {
                    BaseAdLoader.access$getMainVideoSizeMetric$p(this$1).setValue($file.length());
                    AnalyticsClient.INSTANCE.logMetric$vungle_ads_release(BaseAdLoader.access$getMainVideoSizeMetric$p(this$1), this$1.getLogEntry$vungle_ads_release(), adAsset.getServerPath());
                }
                AdPayload adPayload = this$1.getAdvertisement$vungle_ads_release();
                if (adPayload != null) {
                    adPayload.updateAdAssetPath(adAsset);
                }
                if ($downloadRequest.isTemplate() && !BaseAdLoader.access$processVmTemplate(this$1, adAsset, this$1.getAdvertisement$vungle_ads_release())) {
                    BaseAdLoader.access$getFullyDownloaded$p(this$1).set(false);
                    if (adAsset.isRequired()) {
                        BaseAdLoader.access$getRequiredAssetDownloaded$p(this$1).set(false);
                    }
                }
                if (adAsset.isRequired() && BaseAdLoader.access$getDownloadRequiredCount$p(this$1).decrementAndGet() <= 0L) {
                    if (BaseAdLoader.access$getRequiredAssetDownloaded$p(this$1).get()) {
                        BaseAdLoader.access$onRequiredDownloadCompleted(this$1);
                    } else {
                        this$1.onAdLoadFailed(new AssetDownloadError(Sdk.SDKError.Reason.ASSET_RESPONSE_DATA_ERROR, "Failed to download required assets.").setLogEntry$vungle_ads_release(this$1.getLogEntry$vungle_ads_release()).logError$vungle_ads_release());
                        this$1.cancel();
                        return;
                    }
                }
                if (BaseAdLoader.access$getDownloadCount$p(this$1).decrementAndGet() <= 0L) {
                    if (BaseAdLoader.access$getFullyDownloaded$p(this$1).get()) {
                        BaseAdLoader.access$onDownloadCompleted(this$1, this$1.getAdRequest());
                    } else {
                        this$1.onAdLoadFailed(new AssetDownloadError(Sdk.SDKError.Reason.ASSET_RESPONSE_DATA_ERROR, "Failed to download assets.").setLogEntry$vungle_ads_release(this$1.getLogEntry$vungle_ads_release()).logError$vungle_ads_release());
                    }
                }
            }
        };
    }

    public final void loadAd(@NotNull AdLoaderCallback adLoaderCallback) {
        Intrinsics.checkNotNullParameter((Object)adLoaderCallback, (String)"adLoaderCallback");
        this.adLoaderCallback = adLoaderCallback;
        this.sdkExecutors.getBackgroundExecutor().execute(() -> BaseAdLoader.loadAd$lambda-0(this));
    }

    protected abstract void requestAd();

    public abstract void onAdLoadReady();

    public final void cancel() {
        this.downloader.cancelAll();
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadAssets() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        this.assetDownloadDurationMetric.markStart();
        this.adRequiredDownloadDurationMetric.markStart();
        this.adOptionalDownloadDurationMetric.markStart();
        this.downloadCount.set(this.adAssets.size());
        Iterable iterable = this.adAssets;
        AtomicLong atomicLong = this.downloadRequiredCount;
        boolean $i$f$filter = false;
        void var3_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AdAsset it = (AdAsset)element$iv$iv;
            boolean bl = false;
            if (!it.isRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        atomicLong.set(((List)destination$iv$iv).size());
        for (AdAsset asset : this.adAssets) {
            DownloadRequest downloadRequest = new DownloadRequest(this.getAssetPriority(asset), asset, this.logEntry);
            if (downloadRequest.isTemplate()) {
                downloadRequest.startRecord();
            }
            this.downloader.download(downloadRequest, this.getAssetDownloadListener());
        }
    }

    public final void onAdLoadFailed(@NotNull VungleError error) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (this.notifySuccess.get() || !this.notifyFailed.compareAndSet(false, true)) break block1;
            AdLoaderCallback adLoaderCallback = this.adLoaderCallback;
            if (adLoaderCallback != null) {
                adLoaderCallback.onFailure(error);
            }
        }
    }

    private final void onAdReady() {
        block2: {
            AdPayload adPayload = this.advertisement;
            if (adPayload == null) break block2;
            AdPayload it = adPayload;
            boolean bl = false;
            if (!this.notifyFailed.get() && this.notifySuccess.compareAndSet(false, true)) {
                this.onAdLoadReady();
                AdLoaderCallback adLoaderCallback = this.adLoaderCallback;
                if (adLoaderCallback != null) {
                    adLoaderCallback.onSuccess(it);
                }
            }
        }
    }

    private final boolean fileIsValid(File file, AdAsset adAsset) {
        return file.exists() && file.length() == adAsset.getFileSize();
    }

    private final boolean unzipFile(File downloadedFile, File destinationDir) {
        List existingPaths = new ArrayList();
        for (AdAsset asset : this.adAssets) {
            if (asset.getFileType() != AdAsset.FileType.ASSET) continue;
            existingPaths.add(asset.getLocalPath());
        }
        try {
            String string = downloadedFile.getPath();
            String string2 = destinationDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destinationDir.path");
            UnzipUtility.INSTANCE.unzip(string, string2, new UnzipUtility.Filter(existingPaths){
                final /* synthetic */ List<String> $existingPaths;
                {
                    this.$existingPaths = $existingPaths;
                }

                public boolean matches(@Nullable String extractPath) {
                    CharSequence charSequence = extractPath;
                    if (charSequence == null || charSequence.length() == 0) {
                        return true;
                    }
                    File toExtract = new File(extractPath);
                    for (String existing : this.$existingPaths) {
                        File existingFile = new File(existing);
                        if (Intrinsics.areEqual((Object)existingFile, (Object)toExtract)) {
                            return false;
                        }
                        String string = toExtract.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExtract.path");
                        if (!StringsKt.startsWith$default((String)string, (String)(existingFile.getPath() + File.separator), (boolean)false, (int)2, null)) continue;
                        return false;
                    }
                    return true;
                }
            });
            File file = new File(destinationDir.getPath(), "index.html");
            if (!file.exists()) {
                new IndexHtmlError(Sdk.SDKError.Reason.INVALID_INDEX_URL, "Failed to retrieve indexFileUrl from the Ad").setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
                return false;
            }
        }
        catch (Exception ex) {
            new TemplateUnzipError("Unzip failed: " + ex.getMessage()).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
            return false;
        }
        FileUtility.delete(downloadedFile);
        return true;
    }

    private final File getDestinationDir(AdPayload advertisement) {
        return this.pathProvider.getDownloadsDirForAd(advertisement.eventId());
    }

    private final boolean injectMraidJS(File destinationDir) {
        try {
            File adMraidJS = new File(destinationDir.getPath(), "mraid.js");
            File mraidJsPath = this.pathProvider.getJsAssetDir(ConfigManager.INSTANCE.getMraidJsVersion());
            File mraidJsFile = new File(mraidJsPath, "mraid.min.js");
            if (!mraidJsFile.exists()) {
                new MraidJsError(Sdk.SDKError.Reason.MRAID_JS_DOES_NOT_EXIST, "mraid js source file not exist.").setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
                return false;
            }
            FilesKt.copyTo$default((File)mraidJsFile, (File)adMraidJS, (boolean)true, (int)0, (int)4, null);
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Failed to inject mraid.js: " + e2.getMessage());
            new MraidJsError(Sdk.SDKError.Reason.MRAID_JS_COPY_FAILED, "Failed to copy mraid js to ad folder: " + e2.getMessage()).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
            return false;
        }
        return true;
    }

    private final boolean processVmTemplate(AdAsset asset, AdPayload advertisement) {
        boolean bl;
        if (advertisement == null) {
            return false;
        }
        if (asset.getStatus() != AdAsset.Status.DOWNLOAD_SUCCESS) {
            return false;
        }
        if (((CharSequence)asset.getLocalPath()).length() == 0) {
            return false;
        }
        File vmTemplate = new File(asset.getLocalPath());
        if (!this.fileIsValid(vmTemplate, asset)) {
            return false;
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory()) {
            Logger.Companion.e(TAG, "Unable to access Destination Directory");
            return false;
        }
        if (asset.getFileType() == AdAsset.FileType.ZIP && !this.unzipFile(vmTemplate, destinationDir)) {
            return false;
        }
        if (advertisement.omEnabled()) {
            try {
                this.omInjector.injectJsFiles$vungle_ads_release(destinationDir);
            }
            catch (Exception e2) {
                Logger.Companion.e(TAG, "Failed to inject OMSDK: " + e2.getMessage());
                new OmSdkJsError(Sdk.SDKError.Reason.OMSDK_JS_WRITE_FAILED, "Failed to inject OMSDK: " + e2.getMessage()).setLogEntry$vungle_ads_release(this.logEntry).logErrorNoReturnValue$vungle_ads_release();
            }
        }
        boolean it = bl = this.injectMraidJS(destinationDir);
        boolean bl2 = false;
        FileUtility.printDirectoryTree(destinationDir);
        return bl;
    }

    private final void onRequiredDownloadCompleted() {
        this.adRequiredDownloadDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.adRequiredDownloadDurationMetric, this.logEntry, null, 4, null);
        this.onAdReady();
    }

    @WorkerThread
    private final void onDownloadCompleted(AdRequest request) {
        Logger.Companion.d(TAG, "All download completed " + request);
        AdPayload adPayload = this.advertisement;
        if (adPayload != null) {
            adPayload.setAssetFullyDownloaded();
        }
        this.onAdReady();
        this.assetDownloadDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.assetDownloadDurationMetric, this.logEntry, null, 4, null);
        this.adOptionalDownloadDurationMetric.markEnd();
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, this.adOptionalDownloadDurationMetric, this.logEntry, null, 4, null);
    }

    public final void handleAdMetaData$vungle_ads_release(@NotNull AdPayload advertisement, @Nullable SingleValueMetric metric) {
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        this.advertisement = advertisement;
        advertisement.setLogEntry$vungle_ads_release(this.logEntry);
        LogEntry logEntry2 = this.logEntry;
        if (logEntry2 != null) {
            logEntry2.setEventId$vungle_ads_release(advertisement.eventId());
        }
        LogEntry logEntry3 = this.logEntry;
        if (logEntry3 != null) {
            logEntry3.setCreativeId$vungle_ads_release(advertisement.getCreativeId());
        }
        LogEntry logEntry4 = this.logEntry;
        if (logEntry4 != null) {
            logEntry4.setAdSource$vungle_ads_release(advertisement.getAdSource());
        }
        ConfigPayload configPayload = advertisement.config();
        if (configPayload != null) {
            ConfigPayload config = configPayload;
            boolean bl = false;
            ConfigManager.INSTANCE.initWithConfig$vungle_ads_release(this.context, config, false, metric);
        }
        VungleError error = this.validateAdMetadata(advertisement);
        if (error != null) {
            this.onAdLoadFailed(error.setLogEntry$vungle_ads_release(this.logEntry).logError$vungle_ads_release());
            return;
        }
        File destinationDir = this.getDestinationDir(advertisement);
        if (destinationDir == null || !destinationDir.isDirectory() || !destinationDir.exists()) {
            this.onAdLoadFailed(new AssetDownloadError(Sdk.SDKError.Reason.ASSET_WRITE_ERROR, "Invalid directory. " + destinationDir).setLogEntry$vungle_ads_release(this.logEntry).logError$vungle_ads_release());
            return;
        }
        ServiceLocator.Companion bl = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        Lazy signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SignalManager invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
            }
        }));
        Object object = advertisement.adUnit();
        if (object != null && (object = ((AdPayload.AdUnit)object).getLoadAdUrls()) != null) {
            Object object2;
            Object loadAdUrls = object2 = object;
            boolean bl2 = false;
            TpatSender tpatSender = new TpatSender(this.vungleApiClient, this.logEntry, this.sdkExecutors.getIoExecutor(), this.pathProvider, BaseAdLoader.handleAdMetaData$lambda-5((Lazy<SignalManager>)signalManager$delegate));
            Iterable $this$forEach$iv = (Iterable)loadAdUrls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                tpatSender.sendTpat(it, this.sdkExecutors.getJobExecutor());
            }
        }
        if (!((Collection)this.adAssets).isEmpty()) {
            this.adAssets.clear();
        }
        this.adAssets.addAll((Collection<AdAsset>)advertisement.getDownloadableAssets(destinationDir));
        if (this.adAssets.isEmpty()) {
            this.onAdLoadFailed(new AssetDownloadError(Sdk.SDKError.Reason.INVALID_ASSET_URL, "No assets to download.").setLogEntry$vungle_ads_release(this.logEntry).logError$vungle_ads_release());
            return;
        }
        MraidJsLoader.INSTANCE.downloadJs(this.pathProvider, this.downloader, this.sdkExecutors.getBackgroundExecutor(), new MraidJsLoader.DownloadResultListener(this){
            final /* synthetic */ BaseAdLoader this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDownloadResult(int downloadResult) {
                switch (downloadResult) {
                    case 10: 
                    case 13: {
                        if (downloadResult == 10) {
                            AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, Sdk.SDKMetric.SDKMetricType.MRAID_DOWNLOAD_JS_RETRY_SUCCESS, 0L, this.this$0.getLogEntry$vungle_ads_release(), null, 10, null);
                        }
                        BaseAdLoader.access$downloadAssets(this.this$0);
                        break;
                    }
                    default: {
                        AdLoaderCallback adLoaderCallback = BaseAdLoader.access$getAdLoaderCallback$p(this.this$0);
                        if (adLoaderCallback == null) break;
                        adLoaderCallback.onFailure(new MraidJsError(Sdk.SDKError.Reason.MRAID_DOWNLOAD_JS_ERROR, "Failed to download mraid.js."));
                        break;
                    }
                }
            }
        }, advertisement);
    }

    public static /* synthetic */ void handleAdMetaData$vungle_ads_release$default(BaseAdLoader baseAdLoader, AdPayload adPayload, SingleValueMetric singleValueMetric, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleAdMetaData");
        }
        if ((n & 2) != 0) {
            singleValueMetric = null;
        }
        baseAdLoader.handleAdMetaData$vungle_ads_release(adPayload, singleValueMetric);
    }

    private final DownloadRequest.Priority getAssetPriority(AdAsset adAsset) {
        return adAsset.isRequired() ? DownloadRequest.Priority.CRITICAL : DownloadRequest.Priority.HIGHEST;
    }

    private final VungleError validateAdMetadata(AdPayload adPayload) {
        Object object;
        AdPayload.AdUnit adUnit = adPayload.adUnit();
        if (adUnit != null && (object = adUnit.getSleep()) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            return this.getErrorInfo(adPayload);
        }
        AdPayload adPayload2 = this.advertisement;
        if (!Intrinsics.areEqual((Object)this.adRequest.getPlacement().getReferenceId(), (Object)(adPayload2 != null ? adPayload2.placementId() : null))) {
            AdPayload adPayload3 = this.advertisement;
            String description = "Requests and responses don't match " + (adPayload3 != null ? adPayload3.placementId() : null) + '.';
            return new AdResponseEmptyError(description);
        }
        VungleError templateSettingsError = this.getTemplateError(adPayload);
        if (templateSettingsError != null) {
            return templateSettingsError;
        }
        if (adPayload.hasExpired()) {
            return new AdExpiredError("The ad markup has expired for playback.");
        }
        object = adPayload.eventId();
        if (object == null || object.length() == 0) {
            return new InvalidEventIdError("Event id is invalid.");
        }
        return null;
    }

    private final VungleError getTemplateError(AdPayload adPayload) {
        block11: {
            AdPayload.TemplateSettings templateSettings;
            AdPayload.AdUnit adUnit = adPayload.adUnit();
            AdPayload.TemplateSettings templateSettings2 = templateSettings = adUnit != null ? adUnit.getTemplateSettings() : null;
            if (templateSettings == null) {
                String description = "Missing template settings";
                return new AssetResponseDataError(description);
            }
            Map<String, AdPayload.CacheableReplacement> cacheableReplacements = templateSettings.getCacheableReplacements();
            if (adPayload.isNativeTemplateType()) {
                Map<String, AdPayload.CacheableReplacement> map = cacheableReplacements;
                if (map != null) {
                    Map<String, AdPayload.CacheableReplacement> it = map;
                    boolean bl = false;
                    AdPayload.CacheableReplacement cacheableReplacement = it.get("MAIN_IMAGE");
                    if ((cacheableReplacement != null ? cacheableReplacement.getUrl() : null) == null) {
                        return new NativeAssetError("Unable to load null main image.");
                    }
                    AdPayload.CacheableReplacement cacheableReplacement2 = it.get("VUNGLE_PRIVACY_ICON_URL");
                    if ((cacheableReplacement2 != null ? cacheableReplacement2.getUrl() : null) == null) {
                        return new NativeAssetError("Unable to load null privacy image.");
                    }
                }
            } else {
                CharSequence description;
                AdPayload.AdUnit adUnit2 = adPayload.adUnit();
                String templateUrl = adUnit2 != null ? adUnit2.getTemplateURL() : null;
                AdPayload.AdUnit adUnit3 = adPayload.adUnit();
                String vmUrl = adUnit3 != null ? adUnit3.getVmURL() : null;
                CharSequence bl = templateUrl;
                if ((bl == null || bl.length() == 0) && ((bl = (CharSequence)vmUrl) == null || bl.length() == 0)) {
                    description = "Failed to prepare null vmURL or templateURL for downloading.";
                    return new InvalidTemplateURLError((String)description);
                }
                description = templateUrl;
                if (!(description == null || description.length() == 0) && !Utils.INSTANCE.isUrlValid(templateUrl)) {
                    description = "Failed to load template: " + templateUrl;
                    return new AssetRequestError((String)description);
                }
                description = vmUrl;
                if (!(description == null || description.length() == 0) && !Utils.INSTANCE.isUrlValid(vmUrl)) {
                    description = "Failed to load vm url: " + vmUrl;
                    return new AssetRequestError((String)description);
                }
            }
            Map<String, AdPayload.CacheableReplacement> map = cacheableReplacements;
            if (map == null) break block11;
            Map<String, AdPayload.CacheableReplacement> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, AdPayload.CacheableReplacement>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, AdPayload.CacheableReplacement> element$iv;
                Map.Entry<String, AdPayload.CacheableReplacement> it = element$iv = iterator.next();
                boolean bl = false;
                String httpUrl = it.getValue().getUrl();
                CharSequence charSequence = httpUrl;
                if (charSequence == null || charSequence.length() == 0) {
                    return new InvalidAssetUrlError("Invalid asset URL " + httpUrl);
                }
                if (Utils.INSTANCE.isUrlValid(httpUrl)) continue;
                return new AssetRequestError("Invalid asset URL " + httpUrl);
            }
        }
        return null;
    }

    private final VungleError getErrorInfo(AdPayload adPayload) {
        VungleError vungleError;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        Integer n;
        AdPayload.AdUnit adUnit = adPayload.adUnit();
        Integer errorCode = adUnit != null ? adUnit.getErrorCode() : null;
        AdPayload.AdUnit adUnit2 = adPayload.adUnit();
        Integer sleep = adUnit2 != null ? adUnit2.getSleep() : null;
        AdPayload.AdUnit adUnit3 = adPayload.adUnit();
        String info = adUnit3 != null ? adUnit3.getInfo() : null;
        String errorMsg = "Response error: " + sleep + ", Request failed with error: " + errorCode + ", " + info;
        Integer n2 = n = errorCode;
        int n3 = 10001;
        if (n2 != null && n2 == n3) {
            bl4 = true;
        } else {
            Integer n4 = n;
            n3 = 10002;
            bl4 = n4 != null && n4 == n3;
        }
        if (bl4) {
            bl3 = true;
        } else {
            Integer n5 = n;
            n3 = 20001;
            bl3 = n5 != null && n5 == n3;
        }
        if (bl3) {
            bl2 = true;
        } else {
            Integer n6 = n;
            n3 = 30001;
            bl2 = n6 != null && n6 == n3;
        }
        if (bl2) {
            bl = true;
        } else {
            Integer n7 = n;
            n3 = 30002;
            bl = n7 != null && n7 == n3;
        }
        if (bl) {
            Sdk.SDKError.Reason reason = Sdk.SDKError.Reason.forNumber(errorCode);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)reason), (String)"forNumber(errorCode)");
            vungleError = new AdPayloadError(reason, errorMsg);
        } else {
            vungleError = new AdPayloadError(Sdk.SDKError.Reason.PLACEMENT_SLEEP, errorMsg);
        }
        return vungleError;
    }

    private static final void loadAd$lambda-0(BaseAdLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.requestAd();
    }

    private static final SignalManager handleAdMetaData$lambda-5(Lazy<SignalManager> $signalManager$delegate) {
        Lazy<SignalManager> lazy = $signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    public static final /* synthetic */ AtomicBoolean access$getFullyDownloaded$p(BaseAdLoader $this) {
        return $this.fullyDownloaded;
    }

    public static final /* synthetic */ AtomicBoolean access$getRequiredAssetDownloaded$p(BaseAdLoader $this) {
        return $this.requiredAssetDownloaded;
    }

    public static final /* synthetic */ AtomicLong access$getDownloadRequiredCount$p(BaseAdLoader $this) {
        return $this.downloadRequiredCount;
    }

    public static final /* synthetic */ AtomicLong access$getDownloadCount$p(BaseAdLoader $this) {
        return $this.downloadCount;
    }

    public static final /* synthetic */ SingleValueMetric access$getTemplateHtmlSizeMetric$p(BaseAdLoader $this) {
        return $this.templateHtmlSizeMetric;
    }

    public static final /* synthetic */ SingleValueMetric access$getTemplateSizeMetric$p(BaseAdLoader $this) {
        return $this.templateSizeMetric;
    }

    public static final /* synthetic */ SingleValueMetric access$getMainVideoSizeMetric$p(BaseAdLoader $this) {
        return $this.mainVideoSizeMetric;
    }

    public static final /* synthetic */ boolean access$processVmTemplate(BaseAdLoader $this, AdAsset asset, AdPayload advertisement) {
        return $this.processVmTemplate(asset, advertisement);
    }

    public static final /* synthetic */ void access$onRequiredDownloadCompleted(BaseAdLoader $this) {
        $this.onRequiredDownloadCompleted();
    }

    public static final /* synthetic */ void access$onDownloadCompleted(BaseAdLoader $this, AdRequest request) {
        $this.onDownloadCompleted(request);
    }

    public static final /* synthetic */ void access$downloadAssets(BaseAdLoader $this) {
        $this.downloadAssets();
    }

    public static final /* synthetic */ AdLoaderCallback access$getAdLoaderCallback$p(BaseAdLoader $this) {
        return $this.adLoaderCallback;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/load/BaseAdLoader$Companion;", "", "()V", "DOWNLOADED_FILE_NOT_FOUND", "", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

