/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.network;

import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Callback;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.converters.Converter;
import com.vungle.ads.internal.util.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u0018\u0019\u001aB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0016J\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/vungle/ads/internal/network/OkHttpCall;", "T", "Lcom/vungle/ads/internal/network/Call;", "rawCall", "Lokhttp3/Call;", "responseConverter", "Lcom/vungle/ads/internal/network/converters/Converter;", "Lokhttp3/ResponseBody;", "(Lokhttp3/Call;Lcom/vungle/ads/internal/network/converters/Converter;)V", "canceled", "", "buffer", "body", "cancel", "", "enqueue", "callback", "Lcom/vungle/ads/internal/network/Callback;", "execute", "Lcom/vungle/ads/internal/network/Response;", "isCanceled", "parseResponse", "rawResp", "Lokhttp3/Response;", "Companion", "ExceptionCatchingResponseBody", "NoContentResponseBody", "vungle-ads_release"})
public final class OkHttpCall<T>
implements Call<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final okhttp3.Call rawCall;
    @NotNull
    private final Converter<ResponseBody, T> responseConverter;
    private volatile boolean canceled;
    @NotNull
    private static final String TAG = "OkHttpCall";

    public OkHttpCall(@NotNull okhttp3.Call rawCall, @NotNull Converter<ResponseBody, T> responseConverter) {
        Intrinsics.checkNotNullParameter((Object)rawCall, (String)"rawCall");
        Intrinsics.checkNotNullParameter(responseConverter, (String)"responseConverter");
        this.rawCall = rawCall;
        this.responseConverter = responseConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(@NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Objects.requireNonNull(callback, "callback == null");
        okhttp3.Call call = null;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            boolean bl = false;
            call = this.rawCall;
            Unit unit = Unit.INSTANCE;
        }
        if (this.canceled) {
            call.cancel();
        }
        call.enqueue(new okhttp3.Callback(this, callback){
            final /* synthetic */ OkHttpCall<T> this$0;
            final /* synthetic */ Callback<T> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onResponse(@NotNull okhttp3.Call call, @NotNull okhttp3.Response response) {
                Response<T> response2;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                try {
                    response2 = this.this$0.parseResponse(response);
                }
                catch (Throwable e2) {
                    com.vungle.ads.internal.network.OkHttpCall$Companion.access$throwIfFatal(OkHttpCall.Companion, e2);
                    this.callFailure(e2);
                    return;
                }
                Response<T> resp = response2;
                try {
                    this.$callback.onResponse(this.this$0, resp);
                }
                catch (Throwable t) {
                    com.vungle.ads.internal.network.OkHttpCall$Companion.access$throwIfFatal(OkHttpCall.Companion, t);
                    Logger.Companion.e("OkHttpCall", "Cannot pass response to callback", t);
                }
            }

            public void onFailure(@NotNull okhttp3.Call call, @NotNull IOException e2) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                this.callFailure(e2);
            }

            private final void callFailure(Throwable e2) {
                try {
                    this.$callback.onFailure(this.this$0, e2);
                }
                catch (Throwable t) {
                    com.vungle.ads.internal.network.OkHttpCall$Companion.access$throwIfFatal(OkHttpCall.Companion, t);
                    Logger.Companion.e("OkHttpCall", "Cannot pass failure to callback", t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Response<T> execute() throws IOException {
        okhttp3.Call call = null;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            boolean bl = false;
            call = this.rawCall;
            Unit unit = Unit.INSTANCE;
        }
        if (this.canceled) {
            call.cancel();
        }
        return this.parseResponse(call.execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Response<T> parseResponse(@NotNull okhttp3.Response rawResp) throws IOException {
        Response<T> response;
        Intrinsics.checkNotNullParameter((Object)rawResp, (String)"rawResp");
        ResponseBody responseBody = rawResp.body();
        if (responseBody == null) {
            return null;
        }
        ResponseBody rawBody = responseBody;
        okhttp3.Response rawResponse = rawResp.newBuilder().body((ResponseBody)new NoContentResponseBody(rawBody.contentType(), rawBody.contentLength())).build();
        int code = rawResponse.code();
        if (code < 200 || code >= 300) {
            Closeable closeable = (Closeable)rawBody;
            Throwable throwable = null;
            try {
                Object it = (ResponseBody)closeable;
                boolean bl = false;
                ResponseBody bufferedBody = this.buffer((ResponseBody)it);
                it = Response.Companion.error(bufferedBody, rawResponse);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return it;
        }
        switch (code) {
            case 204: 
            case 205: {
                rawBody.close();
                return Response.Companion.success(null, rawResponse);
            }
        }
        ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody(rawBody);
        try {
            T body = this.responseConverter.convert(catchingBody);
            response = Response.Companion.success(body, rawResponse);
        }
        catch (RuntimeException e2) {
            catchingBody.throwIfCaught();
            throw e2;
        }
        return response;
    }

    private final ResponseBody buffer(ResponseBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.source().readAll((Sink)buffer);
        return ResponseBody.Companion.create((BufferedSource)buffer, body.contentType(), body.contentLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.canceled = true;
        okhttp3.Call call = null;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            boolean bl = false;
            call = this.rawCall;
            Unit unit = Unit.INSTANCE;
        }
        call.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            boolean bl = false;
            boolean bl2 = this.rawCall.isCanceled();
            return bl2;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/network/OkHttpCall$NoContentResponseBody;", "Lokhttp3/ResponseBody;", "contentType", "Lokhttp3/MediaType;", "contentLength", "", "(Lokhttp3/MediaType;J)V", "source", "Lokio/BufferedSource;", "vungle-ads_release"})
    public static final class NoContentResponseBody
    extends ResponseBody {
        @Nullable
        private final MediaType contentType;
        private final long contentLength;

        public NoContentResponseBody(@Nullable MediaType contentType, long contentLength) {
            this.contentType = contentType;
            this.contentLength = contentLength;
        }

        @Nullable
        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        @NotNull
        public BufferedSource source() {
            throw new IllegalStateException("Cannot read raw response body of a converted body.");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/vungle/ads/internal/network/OkHttpCall$ExceptionCatchingResponseBody;", "Lokhttp3/ResponseBody;", "delegate", "(Lokhttp3/ResponseBody;)V", "delegateSource", "Lokio/BufferedSource;", "thrownException", "Ljava/io/IOException;", "getThrownException", "()Ljava/io/IOException;", "setThrownException", "(Ljava/io/IOException;)V", "close", "", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "source", "throwIfCaught", "vungle-ads_release"})
    public static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        @NotNull
        private final ResponseBody delegate;
        @NotNull
        private final BufferedSource delegateSource;
        @Nullable
        private IOException thrownException;

        public ExceptionCatchingResponseBody(@NotNull ResponseBody delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            BufferedSource bufferedSource = this.delegate.source();
            this.delegateSource = Okio.buffer((Source)((Source)new ForwardingSource(bufferedSource){

                public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                    long l;
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    try {
                        l = super.read(sink, byteCount);
                    }
                    catch (IOException e2) {
                        this.setThrownException(e2);
                        throw e2;
                    }
                    return l;
                }
            }));
        }

        @Nullable
        public final IOException getThrownException() {
            return this.thrownException;
        }

        public final void setThrownException(@Nullable IOException iOException) {
            this.thrownException = iOException;
        }

        @Nullable
        public MediaType contentType() {
            return this.delegate.contentType();
        }

        public long contentLength() {
            return this.delegate.contentLength();
        }

        @NotNull
        public BufferedSource source() {
            return this.delegateSource;
        }

        public void close() {
            this.delegate.close();
        }

        public final void throwIfCaught() throws IOException {
            IOException iOException = this.thrownException;
            if (iOException != null) {
                IOException it = iOException;
                boolean bl = false;
                throw it;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vungle/ads/internal/network/OkHttpCall$Companion;", "", "()V", "TAG", "", "throwIfFatal", "", "t", "", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void throwIfFatal(Throwable t) {
            Throwable throwable = t;
            if (throwable instanceof VirtualMachineError) {
                throw t;
            }
            if (throwable instanceof ThreadDeath) {
                throw t;
            }
            if (throwable instanceof LinkageError) {
                throw t;
            }
        }

        public static final /* synthetic */ void access$throwIfFatal(Companion $this, Throwable t) {
            $this.throwIfFatal(t);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

