/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.ThreadUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 &2\u00020\u0001:\u0003&'(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0015\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\u001a\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001eH\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "()V", "callbacks", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "inBackground", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isAppForeground", "", "()Z", "isInitialized", "lastStoppedActivityName", "", "startedActivities", "targetActivityInfo", "Lcom/vungle/ads/internal/util/ActivityManager$TargetActivityInfo;", "addListener", "", "callback", "deInit", "context", "Landroid/content/Context;", "deInit$vungle_ads_release", "init", "isAppInForeground", "onActivityCreated", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "Companion", "LifeCycleCallback", "TargetActivityInfo", "vungle-ads_release"})
public final class ActivityManager
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    @Nullable
    private TargetActivityInfo targetActivityInfo;
    @NotNull
    private final CopyOnWriteArraySet<String> startedActivities = new CopyOnWriteArraySet();
    @Nullable
    private String lastStoppedActivityName;
    @NotNull
    private final CopyOnWriteArraySet<LifeCycleCallback> callbacks = new CopyOnWriteArraySet();
    @NotNull
    private final AtomicBoolean inBackground = new AtomicBoolean(false);
    @NotNull
    private static final String TAG = "ActivityManager";
    @NotNull
    private static final ActivityManager instance = new ActivityManager();

    private ActivityManager() {
    }

    private final boolean isAppForeground() {
        return !((Collection)this.startedActivities).isEmpty();
    }

    private final void init(Context context) {
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        try {
            ThreadUtil.INSTANCE.runOnUiThread(() -> ActivityManager.init$lambda-0(context, this));
        }
        catch (Exception e2) {
            Logger.Companion.e(TAG, "Error initializing ActivityManager", e2);
            this.isInitialized.set(false);
        }
    }

    public final void deInit$vungle_ads_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
        Application app = (Application)context2;
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.startedActivities.clear();
        this.isInitialized.set(false);
        this.callbacks.clear();
    }

    private final boolean isAppInForeground() {
        return !this.isInitialized.get() || this.lastStoppedActivityName == null || this.isAppForeground();
    }

    public final void addListener(@NotNull LifeCycleCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStarted(@NotNull Activity activity) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.startedActivities.add(activity.toString());
            if (!this.inBackground.getAndSet(false)) {
                return;
            }
            for (LifeCycleCallback callback : this.callbacks) {
                callback.onForeground();
            }
            TargetActivityInfo targetActivityInfo = this.targetActivityInfo;
            if (targetActivityInfo == null) break block3;
            TargetActivityInfo it = targetActivityInfo;
            boolean bl = false;
            Context context = (Context)it.getContext().get();
            if (context != null) {
                Companion.startWhenForeground(context, it.getDeepLinkOverrideIntent(), it.getDefaultIntent(), it.getAdOpenCallback());
            }
            this.targetActivityInfo = null;
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.lastStoppedActivityName = activity.toString();
        this.startedActivities.remove(activity.toString());
        boolean foreground = this.isAppInForeground();
        this.inBackground.set(!foreground);
        if (foreground) {
            return;
        }
        for (LifeCycleCallback callback : this.callbacks) {
            callback.onBackground();
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    private static final void init$lambda-0(Context $context, ActivityManager this$0) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Context context = $context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Application");
        Application app = (Application)context;
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this$0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "", "()V", "onBackground", "", "onForeground", "vungle-ads_release"})
    public static class LifeCycleCallback {
        public void onForeground() {
        }

        public void onBackground() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$TargetActivityInfo;", "", "context", "Ljava/lang/ref/WeakReference;", "Landroid/content/Context;", "deepLinkOverrideIntent", "Landroid/content/Intent;", "defaultIntent", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "(Ljava/lang/ref/WeakReference;Landroid/content/Intent;Landroid/content/Intent;Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;)V", "getAdOpenCallback", "()Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "getContext", "()Ljava/lang/ref/WeakReference;", "getDeepLinkOverrideIntent", "()Landroid/content/Intent;", "getDefaultIntent", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vungle-ads_release"})
    private static final class TargetActivityInfo {
        @NotNull
        private final WeakReference<Context> context;
        @Nullable
        private final Intent deepLinkOverrideIntent;
        @Nullable
        private final Intent defaultIntent;
        @Nullable
        private final PresenterAdOpenCallback adOpenCallback;

        public TargetActivityInfo(@NotNull WeakReference<Context> context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable PresenterAdOpenCallback adOpenCallback) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            this.context = context;
            this.deepLinkOverrideIntent = deepLinkOverrideIntent;
            this.defaultIntent = defaultIntent;
            this.adOpenCallback = adOpenCallback;
        }

        @NotNull
        public final WeakReference<Context> getContext() {
            return this.context;
        }

        @Nullable
        public final Intent getDeepLinkOverrideIntent() {
            return this.deepLinkOverrideIntent;
        }

        @Nullable
        public final Intent getDefaultIntent() {
            return this.defaultIntent;
        }

        @Nullable
        public final PresenterAdOpenCallback getAdOpenCallback() {
            return this.adOpenCallback;
        }

        @NotNull
        public final WeakReference<Context> component1() {
            return this.context;
        }

        @Nullable
        public final Intent component2() {
            return this.deepLinkOverrideIntent;
        }

        @Nullable
        public final Intent component3() {
            return this.defaultIntent;
        }

        @Nullable
        public final PresenterAdOpenCallback component4() {
            return this.adOpenCallback;
        }

        @NotNull
        public final TargetActivityInfo copy(@NotNull WeakReference<Context> context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable PresenterAdOpenCallback adOpenCallback) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return new TargetActivityInfo(context, deepLinkOverrideIntent, defaultIntent, adOpenCallback);
        }

        public static /* synthetic */ TargetActivityInfo copy$default(TargetActivityInfo targetActivityInfo, WeakReference weakReference, Intent intent, Intent intent2, PresenterAdOpenCallback presenterAdOpenCallback, int n, Object object) {
            if ((n & 1) != 0) {
                weakReference = targetActivityInfo.context;
            }
            if ((n & 2) != 0) {
                intent = targetActivityInfo.deepLinkOverrideIntent;
            }
            if ((n & 4) != 0) {
                intent2 = targetActivityInfo.defaultIntent;
            }
            if ((n & 8) != 0) {
                presenterAdOpenCallback = targetActivityInfo.adOpenCallback;
            }
            return targetActivityInfo.copy(weakReference, intent, intent2, presenterAdOpenCallback);
        }

        @NotNull
        public String toString() {
            return "TargetActivityInfo(context=" + this.context + ", deepLinkOverrideIntent=" + this.deepLinkOverrideIntent + ", defaultIntent=" + this.defaultIntent + ", adOpenCallback=" + this.adOpenCallback + ')';
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = result * 31 + (this.deepLinkOverrideIntent == null ? 0 : this.deepLinkOverrideIntent.hashCode());
            result = result * 31 + (this.defaultIntent == null ? 0 : this.defaultIntent.hashCode());
            result = result * 31 + (this.adOpenCallback == null ? 0 : this.adOpenCallback.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TargetActivityInfo)) {
                return false;
            }
            TargetActivityInfo targetActivityInfo = (TargetActivityInfo)other;
            if (!Intrinsics.areEqual(this.context, targetActivityInfo.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.deepLinkOverrideIntent, (Object)targetActivityInfo.deepLinkOverrideIntent)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultIntent, (Object)targetActivityInfo.defaultIntent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.adOpenCallback, (Object)targetActivityInfo.adOpenCallback);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/vungle/ads/internal/util/ActivityManager$Companion;", "", "()V", "TAG", "", "instance", "Lcom/vungle/ads/internal/util/ActivityManager;", "getInstance$vungle_ads_release$annotations", "getInstance$vungle_ads_release", "()Lcom/vungle/ads/internal/util/ActivityManager;", "addLifecycleListener", "", "listener", "Lcom/vungle/ads/internal/util/ActivityManager$LifeCycleCallback;", "deInit", "context", "Landroid/content/Context;", "init", "isForeground", "", "startActivityHandleException", "deepLinkOverrideIntent", "Landroid/content/Intent;", "defaultIntent", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "startWhenForeground", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActivityManager getInstance$vungle_ads_release() {
            return instance;
        }

        @VisibleForTesting
        public static /* synthetic */ void getInstance$vungle_ads_release$annotations() {
        }

        public final boolean startWhenForeground(@NotNull Context context, @Nullable Intent deepLinkOverrideIntent, @Nullable Intent defaultIntent, @Nullable PresenterAdOpenCallback adOpenCallback) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!this.isForeground()) {
                this.getInstance$vungle_ads_release().targetActivityInfo = new TargetActivityInfo(new WeakReference<Context>(context), deepLinkOverrideIntent, defaultIntent, adOpenCallback);
                return false;
            }
            return this.startActivityHandleException(context, deepLinkOverrideIntent, defaultIntent, adOpenCallback);
        }

        private final boolean startActivityHandleException(Context context, Intent deepLinkOverrideIntent, Intent defaultIntent, PresenterAdOpenCallback adOpenCallback) {
            if (deepLinkOverrideIntent == null && defaultIntent == null) {
                return false;
            }
            try {
                if (deepLinkOverrideIntent != null) {
                    context.startActivity(deepLinkOverrideIntent);
                    PresenterAdOpenCallback presenterAdOpenCallback = adOpenCallback;
                    if (presenterAdOpenCallback != null) {
                        presenterAdOpenCallback.onDeeplinkClick(true);
                    }
                } else {
                    context.startActivity(defaultIntent);
                }
            }
            catch (Exception exception) {
                Logger.Companion.e(ActivityManager.TAG, "Cannot launch/find activity to handle the Implicit intent: " + exception);
                try {
                    if (deepLinkOverrideIntent != null) {
                        PresenterAdOpenCallback presenterAdOpenCallback = adOpenCallback;
                        if (presenterAdOpenCallback != null) {
                            presenterAdOpenCallback.onDeeplinkClick(false);
                        }
                    }
                    if (deepLinkOverrideIntent == null || defaultIntent == null) {
                        return false;
                    }
                    context.startActivity(defaultIntent);
                }
                catch (Exception exception2) {
                    return false;
                }
            }
            return true;
        }

        public final void init(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance$vungle_ads_release().init(context);
        }

        public final boolean isForeground() {
            boolean foreground = this.getInstance$vungle_ads_release().isAppInForeground();
            return foreground;
        }

        public final void addLifecycleListener(@NotNull LifeCycleCallback listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.getInstance$vungle_ads_release().addListener(listener);
        }

        public final void deInit(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.getInstance$vungle_ads_release().deInit$vungle_ads_release(context);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

