package com.vungle.ads

import android.content.Context
import com.vungle.ads.internal.RewardedAdInternal

class RewardedAd(context: Context, placementId: String, adConfig: AdConfig = AdConfig()) :
    BaseFullscreenAd(context, placementId, adConfig) {

    override fun constructAdInternal(context: Context) = RewardedAdInternal(context)

    private val rewardedAdInternal
        get() = adInternal as RewardedAdInternal

    fun setUserId(userId: String) {
        rewardedAdInternal.userId = userId
    }

    fun setAlertTitleText(titleText: String) {
        rewardedAdInternal.alertTitleText = titleText
    }

    fun setAlertBodyText(bodyText: String) {
        rewardedAdInternal.alertBodyText = bodyText
    }

    fun setAlertCloseButtonText(closeButtonText: String) {
        rewardedAdInternal.alertCloseButtonText = closeButtonText
    }

    fun setAlertContinueButtonText(continueButtonText: String) {
        rewardedAdInternal.alertContinueButtonText = continueButtonText
    }

}
