package com.vungle.ads.internal

import android.content.Context
import com.vungle.ads.VungleAdSize
import com.vungle.ads.internal.model.Placement
import com.vungle.ads.internal.presenter.NativePresenterDelegate

internal class NativeAdInternal(context: Context) : AdInternal(context), NativePresenterDelegate {
    companion object {
        const val TOKEN_APP_NAME = "APP_NAME"
        const val TOKEN_APP_DESCRIPTION = "APP_DESCRIPTION"
        const val TOKEN_CTA_BUTTON_TEXT = "CTA_BUTTON_TEXT"
        const val TOKEN_CTA_BUTTON_URL = "CTA_BUTTON_URL"
        const val TOKEN_APP_RATING_VALUE = "APP_RATING_VALUE"
        const val TOKEN_SPONSORED_BY = "SPONSORED_BY"
        const val TOKEN_VUNGLE_PRIVACY_ICON_URL = "VUNGLE_PRIVACY_ICON_URL"
        const val TOKEN_VUNGLE_PRIVACY_URL = "VUNGLE_PRIVACY_URL"
        const val TOKEN_APP_ICON = "APP_ICON"
        const val TOKEN_MAIN_IMAGE = "MAIN_IMAGE"
        const val TOKEN_OM_SDK_DATA = "OM_SDK_DATA"
    }

    override fun getPlacementRefId(): String? {
        return placement?.referenceId
    }

    override fun getImpressionUrls(): List<String>? {
        return bidPayload?.impression
    }

    override fun isValidAdTypeForPlacement(placement: Placement): Boolean {
        return placement.isNative()
    }

    override fun isValidAdSize(adSize: VungleAdSize?): Boolean {
        return true // Don't care about the adSize for native ad type
    }

    override fun getAdSizeForAdRequest(): VungleAdSize? {
        return null
    }
}
