/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.network;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.TpatError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.model.ErrorInfo;
import com.vungle.ads.internal.network.FailedTpat;
import com.vungle.ads.internal.network.TpatRequest;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.persistence.FilePreferences;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.Regex;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 -2\u00020\u0001:\u0001-B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\r\u0010'\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b(J\u001c\u0010)\u001a\u00020\u001f2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010,\u001a\u00020\u001cR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lcom/vungle/ads/internal/network/TpatSender;", "", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "ioExecutor", "Ljava/util/concurrent/Executor;", "jobExecutor", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "(Lcom/vungle/ads/internal/network/VungleApiClient;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/util/PathProvider;Lcom/vungle/ads/internal/signals/SignalManager;)V", "getJobExecutor", "()Ljava/util/concurrent/Executor;", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "tpatFilePreferences", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "tpatLock", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "getStoredTpats", "", "", "Lcom/vungle/ads/internal/network/FailedTpat;", "injectSessionIdToUrl", "url", "isPriorityTpat", "", "event", "logTpatError", "", "request", "Lcom/vungle/ads/internal/network/TpatRequest;", "error", "Lcom/vungle/ads/internal/model/ErrorInfo;", "reason", "Lcom/vungle/ads/internal/protos/Sdk$SDKError$Reason;", "performPriorityRetry", "resendStoredTpats", "resendStoredTpats$vungle_ads_release", "saveStoredTpats", "tpats", "sendTpat", "fromFailedTpat", "Companion", "vungle-ads_release"})
public final class TpatSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VungleApiClient vungleApiClient;
    @NotNull
    private final Executor jobExecutor;
    @Nullable
    private final SignalManager signalManager;
    @NotNull
    private final FilePreferences tpatFilePreferences;
    @NotNull
    private final Object tpatLock;
    @NotNull
    private static final String TAG = "TpatSender";
    @NotNull
    private static final String FAILED_TPATS = "FAILED_TPATS";

    public TpatSender(@NotNull VungleApiClient vungleApiClient, @NotNull Executor ioExecutor, @NotNull Executor jobExecutor, @NotNull PathProvider pathProvider, @Nullable SignalManager signalManager) {
        Intrinsics.checkNotNullParameter((Object)vungleApiClient, (String)"vungleApiClient");
        Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
        Intrinsics.checkNotNullParameter((Object)jobExecutor, (String)"jobExecutor");
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.vungleApiClient = vungleApiClient;
        this.jobExecutor = jobExecutor;
        this.signalManager = signalManager;
        this.tpatFilePreferences = FilePreferences.Companion.get(ioExecutor, pathProvider, "vngFailedTpats");
        this.tpatLock = new Object();
    }

    public /* synthetic */ TpatSender(VungleApiClient vungleApiClient, Executor executor, Executor executor2, PathProvider pathProvider, SignalManager signalManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            signalManager = null;
        }
        this(vungleApiClient, executor, executor2, pathProvider, signalManager);
    }

    @NotNull
    public final VungleApiClient getVungleApiClient() {
        return this.vungleApiClient;
    }

    @NotNull
    public final Executor getJobExecutor() {
        return this.jobExecutor;
    }

    @Nullable
    public final SignalManager getSignalManager() {
        return this.signalManager;
    }

    public final void sendTpat(@NotNull TpatRequest request, boolean fromFailedTpat) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String urlWithSessionId = this.injectSessionIdToUrl(request.getUrl());
        this.jobExecutor.execute(() -> TpatSender.sendTpat$lambda-1(this, request, urlWithSessionId, fromFailedTpat));
    }

    public static /* synthetic */ void sendTpat$default(TpatSender tpatSender, TpatRequest tpatRequest, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        tpatSender.sendTpat(tpatRequest, bl);
    }

    private final boolean isPriorityTpat(String event) {
        return Intrinsics.areEqual((Object)event, (Object)"checkpoint.0") || Intrinsics.areEqual((Object)event, (Object)"clickUrl") || Intrinsics.areEqual((Object)event, (Object)"impression") || Intrinsics.areEqual((Object)event, (Object)"load_ad");
    }

    private final ErrorInfo performPriorityRetry(TpatRequest request, String url) {
        boolean bl;
        Boolean bl2 = request.getPriorityRetry();
        boolean priorityTpat = bl2 != null ? bl2.booleanValue() : this.isPriorityTpat(request.getTpatKey());
        boolean priorityRetryEnabled = ConfigManager.INSTANCE.retryPriorityTPATs() && priorityTpat;
        int attempt = 0;
        ErrorInfo error = null;
        do {
            error = this.vungleApiClient.pingTPAT(url, request.getHeaders(), request.getBody(), request.getMethod(), request.getLogEntry());
            if (!priorityRetryEnabled) break;
            ErrorInfo errorInfo = error;
            if (errorInfo != null) {
                if (errorInfo.isRetryCode()) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (bl && ++attempt < request.getPriorityRetryCount());
        if (error != null) {
            Sdk.SDKError.Reason reason = attempt >= request.getPriorityRetryCount() ? Sdk.SDKError.Reason.TPAT_RETRY_FAILED : Sdk.SDKError.Reason.TPAT_ERROR;
            this.logTpatError(request, url, error, reason);
        }
        return error;
    }

    private final void logTpatError(TpatRequest request, String url, ErrorInfo error, Sdk.SDKError.Reason reason) {
        String msg = "tpat key: " + request.getTpatKey() + ", error: " + error.getDescription() + ", errorIsTerminal: " + error.getErrorIsTerminal() + " url: " + url;
        Logger.Companion.e(TAG, msg);
        new TpatError(reason, msg).setLogEntry$vungle_ads_release(request.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
    }

    private final Map<String, FailedTpat> getStoredTpats() {
        Object object;
        block9: {
            block8: {
                Object object2;
                Object $this$getStoredTpats_u24lambda_u2d5_u24lambda_u2d2;
                String storedTpats = this.tpatFilePreferences.getString(FAILED_TPATS);
                object = storedTpats;
                if (object == null) break block8;
                String it = object;
                boolean bl = false;
                Object object3 = this;
                try {
                    $this$getStoredTpats_u24lambda_u2d5_u24lambda_u2d2 = object3;
                    boolean bl2 = false;
                    StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                    boolean $i$f$serializer = false;
                    KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.mutableCollectionType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(FailedTpat.class)))));
                    boolean $i$f$cast = false;
                    Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                    $this$getStoredTpats_u24lambda_u2d5_u24lambda_u2d2 = Result.constructor-impl((Object)((Map)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, it)));
                }
                catch (Throwable bl2) {
                    $this$getStoredTpats_u24lambda_u2d5_u24lambda_u2d2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object3 = $this$getStoredTpats_u24lambda_u2d5_u24lambda_u2d2;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable != null) {
                    Object it2 = $this$getStoredTpats_u24lambda_u2d5_u24lambda_u2d2 = throwable;
                    boolean bl3 = false;
                    Logger.Companion.e(TAG, "Failed to decode stored tpats: " + it2);
                }
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
                if (throwable2 == null) {
                    object2 = object3;
                } else {
                    Throwable it3 = throwable2;
                    boolean bl4 = false;
                    object2 = new LinkedHashMap();
                }
                Map map = (Map)object2;
                object = map;
                if (map != null) break block9;
            }
            object = new LinkedHashMap();
        }
        return object;
    }

    private final void saveStoredTpats(Map<String, FailedTpat> tpats) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                TpatSender $this$saveStoredTpats_u24lambda_u2d6 = object2;
                boolean bl = false;
                FilePreferences filePreferences = $this$saveStoredTpats_u24lambda_u2d6.tpatFilePreferences;
                StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.mutableCollectionType((KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(FailedTpat.class)))));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                filePreferences.put(FAILED_TPATS, $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, tpats)).apply();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            Logger.Companion.e(TAG, "Failed to encode the about to storing tpats: " + tpats);
        }
    }

    public final void resendStoredTpats$vungle_ads_release() {
        Map<String, FailedTpat> $this$forEach$iv = this.getStoredTpats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, FailedTpat>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FailedTpat> element$iv;
            Map.Entry<String, FailedTpat> entry = element$iv = iterator.next();
            boolean bl = false;
            String url = entry.getKey();
            FailedTpat failedTpat = entry.getValue();
            TpatRequest tpatRequest = new TpatRequest.Builder(url).regularRetry(true).priorityRetry(false).headers(failedTpat.getHeaders()).body(failedTpat.getBody()).regularRetryCount(failedTpat.getRetryCount()).method(failedTpat.getMethod()).tpatKey(failedTpat.getTpatKey()).build();
            this.sendTpat(tpatRequest, true);
        }
    }

    @VisibleForTesting
    @NotNull
    public final String injectSessionIdToUrl(@NotNull String url) {
        String string;
        String sessionId;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        SignalManager signalManager = this.signalManager;
        String string2 = signalManager != null ? signalManager.getUuid() : null;
        if (string2 == null) {
            string2 = "";
        }
        if (((CharSequence)(sessionId = string2)).length() > 0) {
            CharSequence charSequence = url;
            String string3 = Pattern.quote("{{{session_id}}}");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"quote(Constants.SESSION_ID)");
            String string4 = string3;
            string = new Regex(string4).replace(charSequence, sessionId);
        } else {
            string = url;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendTpat$lambda-1(TpatSender this$0, TpatRequest $request, String $urlWithSessionId, boolean $fromFailedTpat) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$urlWithSessionId, (String)"$urlWithSessionId");
        ErrorInfo error = this$0.performPriorityRetry($request, $urlWithSessionId);
        if (!$request.getRegularRetry()) {
            return;
        }
        ErrorInfo errorInfo = error;
        boolean bl = errorInfo != null ? errorInfo.getErrorIsTerminal() : false;
        if (bl) {
            return;
        }
        if (error == null && !$fromFailedTpat) {
            return;
        }
        Object object = this$0.tpatLock;
        synchronized (object) {
            boolean bl2 = false;
            Map<String, FailedTpat> storedTpats = this$0.getStoredTpats();
            FailedTpat failedTpat = storedTpats.get($request.getUrl());
            int regularRetryAttempt = failedTpat != null ? failedTpat.getRetryAttempt() : 0;
            if (error == null && regularRetryAttempt > 0) {
                storedTpats.remove($request.getUrl());
                this$0.saveStoredTpats(storedTpats);
            } else if (error != null && regularRetryAttempt >= $request.getRegularRetryCount()) {
                storedTpats.remove($request.getUrl());
                this$0.saveStoredTpats(storedTpats);
                this$0.logTpatError($request, $urlWithSessionId, error, Sdk.SDKError.Reason.TPAT_RETRY_FAILED);
            } else if (error != null) {
                FailedTpat failedTpat2 = storedTpats.get($request.getUrl());
                if (failedTpat2 == null || (failedTpat2 = FailedTpat.copy$default(failedTpat2, null, null, null, regularRetryAttempt + 1, 0, null, 55, null)) == null) {
                    failedTpat2 = new FailedTpat($request.getMethod(), $request.getHeaders(), $request.getBody(), 1, $request.getRegularRetryCount(), $request.getTpatKey());
                }
                FailedTpat updated = failedTpat2;
                storedTpats.put($request.getUrl(), updated);
                this$0.saveStoredTpats(storedTpats);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vungle/ads/internal/network/TpatSender$Companion;", "", "()V", "FAILED_TPATS", "", "TAG", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

