/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.persistence;

import androidx.annotation.VisibleForTesting;
import com.vungle.ads.internal.util.CollectionsConcurrencyUtil;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.PathProvider;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0010J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J6\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u001aj\b\u0012\u0004\u0012\u00020\u0007`\u001b2\u0006\u0010\u0011\u001a\u00020\u00072\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u001aj\b\u0012\u0004\u0012\u00020\u0007`\u001bJ\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0010J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0015J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0017J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J*\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00072\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001aj\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\u001bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/vungle/ads/internal/persistence/FilePreferences;", "", "ioExecutor", "Ljava/util/concurrent/Executor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "filename", "", "(Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/util/PathProvider;Ljava/lang/String;)V", "file", "Ljava/io/File;", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "apply", "", "getBoolean", "", "key", "(Ljava/lang/String;)Ljava/lang/Boolean;", "defaultValue", "getInt", "", "getLong", "", "getString", "getStringSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "put", "value", "remove", "Companion", "vungle-ads_release"})
public final class FilePreferences {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor ioExecutor;
    @NotNull
    private final File file;
    @NotNull
    private final ConcurrentHashMap<String, Object> values;
    @NotNull
    public static final String FILENAME = "settings_vungle";
    @NotNull
    public static final String TPAT_FAILED_FILENAME = "vngFailedTpats";
    @NotNull
    private static final ConcurrentHashMap<String, FilePreferences> filePreferenceMap = new ConcurrentHashMap();

    private FilePreferences(Executor ioExecutor, PathProvider pathProvider, String filename) {
        this.ioExecutor = ioExecutor;
        this.file = new File(pathProvider.getSharedPrefsDir(), filename);
        this.values = new ConcurrentHashMap();
        Object saved = FileUtility.readSerializable(this.file);
        if (saved instanceof HashMap) {
            this.values.putAll((HashMap)saved);
        }
    }

    /* synthetic */ FilePreferences(Executor executor, PathProvider pathProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = FILENAME;
        }
        this(executor, pathProvider, string);
    }

    public final void apply() {
        Serializable serializable = new HashMap(this.values);
        this.ioExecutor.execute(() -> FilePreferences.apply$lambda-0(this, serializable));
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Boolean bl = value;
        ((Map)this.values).put(key, bl);
        return this;
    }

    public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object value = this.values.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    @Nullable
    public final Boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object value = this.values.get(key);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.values).put(key, value);
        return this;
    }

    @NotNull
    public final FilePreferences remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.values.containsKey(key)) {
            this.values.remove(key);
        }
        return this;
    }

    @NotNull
    public final String getString(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Object value = this.values.get(key);
        return value instanceof String ? (String)value : defaultValue;
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object value = this.values.get(key);
        return value instanceof String ? (String)value : null;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Integer n = value;
        ((Map)this.values).put(key, n);
        return this;
    }

    public final int getInt(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object value = this.values.get(key);
        return value instanceof Integer ? ((Number)value).intValue() : defaultValue;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, @Nullable HashSet<String> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ((Map)this.values).put(key, CollectionsConcurrencyUtil.getNewHashSet(value));
        return this;
    }

    @NotNull
    public final HashSet<String> getStringSet(@NotNull String key, @NotNull HashSet<String> defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Object value = this.values.get(key);
        return value instanceof HashSet ? CollectionsConcurrencyUtil.getNewHashSet((HashSet)value) : defaultValue;
    }

    @NotNull
    public final FilePreferences put(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Long l = value;
        ((Map)this.values).put(key, l);
        return this;
    }

    public final long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object value = this.values.get(key);
        return value instanceof Long ? ((Number)value).longValue() : defaultValue;
    }

    private static final void apply$lambda-0(FilePreferences this$0, Serializable $serializable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$serializable, (String)"$serializable");
        FileUtility.writeSerializable(this$0.file, $serializable);
    }

    @JvmStatic
    @NotNull
    public static final synchronized FilePreferences get(@NotNull Executor ioExecutor, @NotNull PathProvider pathProvider, @NotNull String filename) {
        return Companion.get(ioExecutor, pathProvider, filename);
    }

    public /* synthetic */ FilePreferences(Executor ioExecutor, PathProvider pathProvider, String filename, DefaultConstructorMarker $constructor_marker) {
        this(ioExecutor, pathProvider, filename);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vungle/ads/internal/persistence/FilePreferences$Companion;", "", "()V", "FILENAME", "", "getFILENAME$annotations", "TPAT_FAILED_FILENAME", "filePreferenceMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/vungle/ads/internal/persistence/FilePreferences;", "get", "ioExecutor", "Ljava/util/concurrent/Executor;", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "filename", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getFILENAME$annotations() {
        }

        @JvmStatic
        @NotNull
        public final synchronized FilePreferences get(@NotNull Executor ioExecutor, @NotNull PathProvider pathProvider, @NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)ioExecutor, (String)"ioExecutor");
            Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            ConcurrentMap $this$getOrPut$iv = filePreferenceMap;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(filename);
            if (object == null) {
                boolean bl = false;
                FilePreferences default$iv = new FilePreferences(ioExecutor, pathProvider, filename, null);
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(filename, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"filePreferenceMap.getOrP\u2026, filename)\n            }");
            return (FilePreferences)object;
        }

        public static /* synthetic */ FilePreferences get$default(Companion companion, Executor executor, PathProvider pathProvider, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = FilePreferences.FILENAME;
            }
            return companion.get(executor, pathProvider, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

