/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.vungle.ads.LinkError;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.ActivityManager;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J@\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/vungle/ads/internal/util/ExternalRouter;", "", "()V", "TAG", "", "getIntentFromUrl", "Landroid/content/Intent;", "url", "contextIsNotActivity", "", "launch", "deeplinkUrl", "context", "Landroid/content/Context;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "adOpenCallback", "Lcom/vungle/ads/internal/ui/PresenterAdOpenCallback;", "vungle-ads_release"})
public final class ExternalRouter {
    @NotNull
    public static final ExternalRouter INSTANCE = new ExternalRouter();
    @NotNull
    private static final String TAG = "ExternalRouter";

    private ExternalRouter() {
    }

    @JvmStatic
    public static final boolean launch(@Nullable String deeplinkUrl, @Nullable String url, @NotNull Context context, @Nullable LogEntry logEntry2, @Nullable PresenterAdOpenCallback adOpenCallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = deeplinkUrl;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)url) == null || charSequence.length() == 0)) {
            return false;
        }
        boolean contextIsNotActivity = !(context instanceof Activity);
        try {
            Intent deeplinkIntent = INSTANCE.getIntentFromUrl(deeplinkUrl, contextIsNotActivity);
            Intent fallbackIntent = INSTANCE.getIntentFromUrl(url, contextIsNotActivity);
            return ActivityManager.Companion.startWhenForeground(context, deeplinkIntent, fallbackIntent, adOpenCallback);
        }
        catch (Exception e2) {
            CharSequence charSequence2 = deeplinkUrl;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                new LinkError(Sdk.SDKError.Reason.DEEPLINK_OPEN_FAILED, "Fail to open " + deeplinkUrl).setLogEntry$vungle_ads_release(logEntry2).logErrorNoReturnValue$vungle_ads_release();
            } else {
                new LinkError(Sdk.SDKError.Reason.LINK_COMMAND_OPEN_FAILED, "Fail to open " + url).setLogEntry$vungle_ads_release(logEntry2).logErrorNoReturnValue$vungle_ads_release();
            }
            Logger.Companion.e(TAG, "Error while opening url" + e2.getLocalizedMessage());
            Logger.Companion.d(TAG, "Cannot open url " + url);
            return false;
        }
    }

    public static /* synthetic */ boolean launch$default(String string, String string2, Context context, LogEntry logEntry2, PresenterAdOpenCallback presenterAdOpenCallback, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            logEntry2 = null;
        }
        if ((n & 0x10) != 0) {
            presenterAdOpenCallback = null;
        }
        return ExternalRouter.launch(string, string2, context, logEntry2, presenterAdOpenCallback);
    }

    private final Intent getIntentFromUrl(String url, boolean contextIsNotActivity) {
        Intent intent = null;
        try {
            CharSequence charSequence = url;
            Intent intent2 = intent = charSequence == null || charSequence.length() == 0 ? null : Intent.parseUri((String)url, (int)0);
            if (intent != null && contextIsNotActivity) {
                intent.setFlags(0x10000000);
            }
        }
        catch (URISyntaxException e2) {
            Logger.Companion.e(TAG, "url format is not correct " + e2.getLocalizedMessage());
        }
        return intent;
    }
}

