package com.vungle.ads

import android.app.Application
import android.content.Context
import com.vungle.ads.fpd.FirstPartyData
import com.vungle.ads.internal.ConfigManager
import com.vungle.ads.internal.VungleInitializer
import com.vungle.ads.internal.VungleInternal

class VungleAds {

    companion object {

        const val TAG: String = "VungleAds"
        private var vungleInternal: VungleInternal = VungleInternal()
        private var initializer: VungleInitializer = VungleInitializer()

        @JvmField
        val firstPartyData: FirstPartyData = FirstPartyData()

        @JvmStatic
        fun init(
            context: Context,
            appId: String,
            callback: InitializationListener
        ) {
            val appContext = if (context !is Application) context.applicationContext else context

            initializer.init(appId, appContext, callback)
        }

        /**
         * @return whether or not VungleAds is initialized. If "true" it can be used normally,
         * if "false" - it needs to be initialized first, otherwise errors and exceptions will
         * be thrown
         */
        @JvmStatic
        fun isInitialized() = initializer.isInitialized()

        /**
         * Will return an encoded string of advertisement bidding token.
         * This method might be called from adapter side and must be called from background thread.
         *
         * @return an encoded string contains available bid tokens digest. In rare cases, this can return empty string
         */
        @JvmStatic
        @Deprecated("Replaced with getBiddingToken(Context, BidTokenCallback) method.")
        fun getBiddingToken(context: Context): String? {
            return vungleInternal.getAvailableBidTokens(context)
        }

        /**
         * Will return an encoded string of advertisement bidding token.
         * This method can be called from any thread.
         * @param context the context of the application
         * @param callback the callback to receive the bid token
         */
        @JvmStatic
        fun getBiddingToken(context: Context, callback: BidTokenCallback) {
            vungleInternal.getAvailableBidTokensAsync(context, callback)
        }

        /**
         * @return version of Vungle SDK currently used, like "7.0.0"
         * */
        @JvmStatic
        fun getSdkVersion() : String = vungleInternal.getSdkVersion()

        /**
         * Check the placement is inline type or not
         * @return whether or not the placement is inline
         */
        @JvmStatic
        fun isInline(placementId: String): Boolean {
            return ConfigManager.getPlacement(placementId)?.isInline() ?: false
        }

        /**
         * Override the info passed from Vungle's Plugins and Adapters
         * This should NOT be used by any Publishers
         * This should be called before calling Vungle.init()
         */
        @JvmStatic
        fun setIntegrationName(
            wrapperFramework: VungleWrapperFramework,
            wrapperFrameworkVersion: String
        ) {
            initializer.setIntegrationName(wrapperFramework, wrapperFrameworkVersion)
        }

        @JvmStatic
        fun deInit(context: Context) {
            initializer.deInit()
        }
    }

}
