package com.vungle.ads.internal.model

import com.vungle.ads.internal.signals.SignalKey
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class UnclosedAd(
    @SerialName("${SignalKey.EVENT_ID}") val eventId: String,
    @SerialName("${SignalKey.SESSION_ID}") var sessionId: String = ""
) {

    override fun equals(other: Any?): Boolean {
        if (other == null || javaClass != other.javaClass) return false
        val unclosedAd = other as UnclosedAd
        return eventId == unclosedAd.eventId && sessionId == unclosedAd.sessionId
    }

    override fun hashCode(): Int {
        var result = eventId.hashCode()
        result = 31 * result + sessionId.hashCode()
        return result
    }
}
