/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.webkit.WebView;
import android.webkit.WebViewRenderProcess;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AdConfig;
import com.vungle.ads.AdNotLoadedCantPlay;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.HeartbeatMissingError;
import com.vungle.ads.IndexHtmlError;
import com.vungle.ads.InvalidCTAUrl;
import com.vungle.ads.LinkError;
import com.vungle.ads.MraidJsError;
import com.vungle.ads.MraidTemplateError;
import com.vungle.ads.NetworkUnreachable;
import com.vungle.ads.PrivacyUrlError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TpatError;
import com.vungle.ads.VungleError;
import com.vungle.ads.WebViewError;
import com.vungle.ads.WebViewRenderProcessUnresponsive;
import com.vungle.ads.WebViewRenderingProcessGone;
import com.vungle.ads.internal.ClickCoordinateTracker;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.model.BidPayload;
import com.vungle.ads.internal.model.CommonRequestBody;
import com.vungle.ads.internal.model.Placement;
import com.vungle.ads.internal.network.Call;
import com.vungle.ads.internal.network.Callback;
import com.vungle.ads.internal.network.Response;
import com.vungle.ads.internal.network.TpatRequest;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.network.VungleApiClient;
import com.vungle.ads.internal.omsdk.OMTracker;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.presenter.AdEventListener;
import com.vungle.ads.internal.presenter.MRAIDPresenter;
import com.vungle.ads.internal.presenter.PresenterDelegate;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.signals.SignalManager;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.ui.VungleWebClient;
import com.vungle.ads.internal.ui.view.MRAIDAdWidget;
import com.vungle.ads.internal.ui.view.WebViewAPI;
import com.vungle.ads.internal.util.ExternalRouter;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.HandlerScheduler;
import com.vungle.ads.internal.util.JsonUtil;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import com.vungle.ads.internal.util.PathProvider;
import com.vungle.ads.internal.util.SuspendableTimer;
import com.vungle.ads.internal.util.ThreadUtil;
import com.vungle.ads.internal.util.Utils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u00a7\u00012\u00020\u00012\u00020\u0002:\u0002\u00a7\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010u\u001a\u00020vH\u0002J\u0010\u0010w\u001a\u00020v2\b\b\u0001\u0010x\u001a\u00020yJ\r\u0010z\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010{\u001a\u00020vJ%\u0010|\u001a\u00020v2\u0006\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020\u001e2\u000b\b\u0002\u0010\u0080\u0001\u001a\u0004\u0018\u00010fH\u0002J\u0015\u0010\u0081\u0001\u001a\u0004\u0018\u00010~2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020v2\u0006\u0010}\u001a\u00020~H\u0002J\u001b\u0010\u0085\u0001\u001a\u00020v2\u0007\u0010\u0086\u0001\u001a\u00020f2\u0007\u0010\u0087\u0001\u001a\u00020\u001eH\u0016J!\u0010\u0088\u0001\u001a\u00020v2\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00012\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001H\u0016J\u0007\u0010\u008d\u0001\u001a\u00020vJ\u0013\u0010\u008e\u0001\u001a\u00020v2\n\u0010\u008f\u0001\u001a\u0005\u0018\u00010\u0090\u0001J&\u0010\u0091\u0001\u001a\u00020\u001e2\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u008a\u00012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J\u0007\u0010\u0094\u0001\u001a\u00020vJ\u001c\u0010\u0095\u0001\u001a\u00020\u001e2\u0007\u0010\u0096\u0001\u001a\u00020f2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0016J\t\u0010\u0099\u0001\u001a\u00020vH\u0002J\u0011\u0010\u009a\u0001\u001a\u00020v2\u0006\u0010}\u001a\u00020~H\u0002J\u0010\u0010\u009b\u0001\u001a\u00020v2\u0007\u0010\u009c\u0001\u001a\u00020\u001eJ\u0012\u0010\u009d\u0001\u001a\u00020v2\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010&J\u0019\u0010\u009f\u0001\u001a\u00020v2\b\u0010M\u001a\u0004\u0018\u00010NH\u0000\u00a2\u0006\u0003\b\u00a0\u0001J\u000f\u0010\u00a1\u0001\u001a\u00020\u001eH\u0000\u00a2\u0006\u0003\b\u00a2\u0001J\u0007\u0010\u00a3\u0001\u001a\u00020vJ\u0007\u0010\u00a4\u0001\u001a\u00020vJ\u0012\u0010\u00a5\u0001\u001a\u00020v2\u0007\u0010\u00a6\u0001\u001a\u00020fH\u0002R(\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\u001c\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020\u001e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b \u0010\u0017\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010%\u001a\u0004\u0018\u00010&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b'\u0010\u0017\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R!\u0010,\u001a\u00020-8@X\u0081\u0084\u0002\u00a2\u0006\u0012\n\u0004\b1\u00102\u0012\u0004\b.\u0010\u0017\u001a\u0004\b/\u00100R\u000e\u00103\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u00020\u001e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b5\u0010\u0017\u001a\u0004\b6\u0010\"\"\u0004\b7\u0010$R\u001c\u00108\u001a\u0002098\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b:\u0010\u0017\u001a\u0004\b;\u0010<R$\u0010=\u001a\u00020\u00158\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b>\u0010\u0017\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001d\u0010C\u001a\u0004\u0018\u00010D8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u00102\u001a\u0004\bE\u0010FR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010H\u001a\u00020I8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u00102\u001a\u0004\bJ\u0010KR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010O\u001a\u00020P8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u00102\u001a\u0004\bQ\u0010RR\u000e\u0010T\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010U\u001a\u00020V8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u00102\u001a\u0004\bW\u0010XR!\u0010Z\u001a\u00020[8@X\u0081\u0084\u0002\u00a2\u0006\u0012\n\u0004\b_\u00102\u0012\u0004\b\\\u0010\u0017\u001a\u0004\b]\u0010^R\u001b\u0010`\u001a\u00020a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bd\u00102\u001a\u0004\bb\u0010cR&\u0010e\u001a\u0004\u0018\u00010f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bg\u0010\u0017\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR$\u0010l\u001a\u00020\u00158\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bm\u0010\u0017\u001a\u0004\bn\u0010@\"\u0004\bo\u0010BR\u001b\u0010p\u001a\u00020q8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u00102\u001a\u0004\br\u0010sR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a8\u0001"}, d2={"Lcom/vungle/ads/internal/presenter/MRAIDPresenter;", "Lcom/vungle/ads/internal/ui/view/WebViewAPI$MraidDelegate;", "Lcom/vungle/ads/internal/ui/view/WebViewAPI$WebClientErrorHandler;", "adWidget", "Lcom/vungle/ads/internal/ui/view/MRAIDAdWidget;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "placement", "Lcom/vungle/ads/internal/model/Placement;", "vungleWebClient", "Lcom/vungle/ads/internal/ui/VungleWebClient;", "executor", "Ljava/util/concurrent/Executor;", "omTracker", "Lcom/vungle/ads/internal/omsdk/OMTracker;", "bidPayload", "Lcom/vungle/ads/internal/model/BidPayload;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "(Lcom/vungle/ads/internal/ui/view/MRAIDAdWidget;Lcom/vungle/ads/internal/model/AdPayload;Lcom/vungle/ads/internal/model/Placement;Lcom/vungle/ads/internal/ui/VungleWebClient;Ljava/util/concurrent/Executor;Lcom/vungle/ads/internal/omsdk/OMTracker;Lcom/vungle/ads/internal/model/BidPayload;Lcom/vungle/ads/internal/platform/Platform;)V", "adStartTime", "", "getAdStartTime$vungle_ads_release$annotations", "()V", "getAdStartTime$vungle_ads_release", "()Ljava/lang/Long;", "setAdStartTime$vungle_ads_release", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "adViewed", "", "backEnabled", "getBackEnabled$vungle_ads_release$annotations", "getBackEnabled$vungle_ads_release", "()Z", "setBackEnabled$vungle_ads_release", "(Z)V", "bus", "Lcom/vungle/ads/internal/presenter/AdEventListener;", "getBus$annotations", "getBus", "()Lcom/vungle/ads/internal/presenter/AdEventListener;", "setBus", "(Lcom/vungle/ads/internal/presenter/AdEventListener;)V", "clickCoordinateTracker", "Lcom/vungle/ads/internal/ClickCoordinateTracker;", "getClickCoordinateTracker$vungle_ads_release$annotations", "getClickCoordinateTracker$vungle_ads_release", "()Lcom/vungle/ads/internal/ClickCoordinateTracker;", "clickCoordinateTracker$delegate", "Lkotlin/Lazy;", "cp0Fired", "heartbeatEnabled", "getHeartbeatEnabled$vungle_ads_release$annotations", "getHeartbeatEnabled$vungle_ads_release", "setHeartbeatEnabled$vungle_ads_release", "isDestroying", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isDestroying$vungle_ads_release$annotations", "isDestroying$vungle_ads_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "lastUserInteractionTimestamp", "getLastUserInteractionTimestamp$vungle_ads_release$annotations", "getLastUserInteractionTimestamp$vungle_ads_release", "()J", "setLastUserInteractionTimestamp$vungle_ads_release", "(J)V", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry", "()Lcom/vungle/ads/internal/util/LogEntry;", "logEntry$delegate", "pathProvider", "Lcom/vungle/ads/internal/util/PathProvider;", "getPathProvider", "()Lcom/vungle/ads/internal/util/PathProvider;", "pathProvider$delegate", "presenterDelegate", "Lcom/vungle/ads/internal/presenter/PresenterDelegate;", "scheduler", "Lcom/vungle/ads/internal/util/HandlerScheduler;", "getScheduler", "()Lcom/vungle/ads/internal/util/HandlerScheduler;", "scheduler$delegate", "sendReportIncentivized", "signalManager", "Lcom/vungle/ads/internal/signals/SignalManager;", "getSignalManager", "()Lcom/vungle/ads/internal/signals/SignalManager;", "signalManager$delegate", "suspendableTimer", "Lcom/vungle/ads/internal/util/SuspendableTimer;", "getSuspendableTimer$vungle_ads_release$annotations", "getSuspendableTimer$vungle_ads_release", "()Lcom/vungle/ads/internal/util/SuspendableTimer;", "suspendableTimer$delegate", "tpatSender", "Lcom/vungle/ads/internal/network/TpatSender;", "getTpatSender", "()Lcom/vungle/ads/internal/network/TpatSender;", "tpatSender$delegate", "userId", "", "getUserId$vungle_ads_release$annotations", "getUserId$vungle_ads_release", "()Ljava/lang/String;", "setUserId$vungle_ads_release", "(Ljava/lang/String;)V", "videoLength", "getVideoLength$vungle_ads_release$annotations", "getVideoLength$vungle_ads_release", "setVideoLength$vungle_ads_release", "vungleApiClient", "Lcom/vungle/ads/internal/network/VungleApiClient;", "getVungleApiClient", "()Lcom/vungle/ads/internal/network/VungleApiClient;", "vungleApiClient$delegate", "closeView", "", "detach", "stopReason", "", "getViewStatus", "handleExit", "handleWebViewException", "reason", "Lcom/vungle/ads/VungleError;", "fatal", "errorMessage", "loadMraidAd", "dest", "Ljava/io/File;", "makeBusError", "onReceivedError", "errorDesc", "didCrash", "onRenderProcessUnresponsive", "webView", "Landroid/webkit/WebView;", "webViewRenderProcess", "Landroid/webkit/WebViewRenderProcess;", "onViewConfigurationChanged", "onViewTouched", "event", "Landroid/view/MotionEvent;", "onWebRenderingProcessGone", "view", "(Landroid/webkit/WebView;Ljava/lang/Boolean;)Z", "prepare", "processCommand", "command", "arguments", "Lkotlinx/serialization/json/JsonObject;", "recordPlayAssetMetric", "reportErrorAndCloseAd", "setAdVisibility", "isViewable", "setEventListener", "listener", "setPresenterDelegate", "setPresenterDelegate$vungle_ads_release", "shouldBlockAutoRedirect", "shouldBlockAutoRedirect$vungle_ads_release", "start", "stop", "triggerEventMetricForTpat", "key", "Companion", "vungle-ads_release"})
public final class MRAIDPresenter
implements WebViewAPI.MraidDelegate,
WebViewAPI.WebClientErrorHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MRAIDAdWidget adWidget;
    @NotNull
    private final AdPayload advertisement;
    @NotNull
    private final Placement placement;
    @NotNull
    private final VungleWebClient vungleWebClient;
    @NotNull
    private Executor executor;
    @NotNull
    private final OMTracker omTracker;
    @Nullable
    private final BidPayload bidPayload;
    @NotNull
    private final Platform platform;
    private long lastUserInteractionTimestamp;
    @Nullable
    private AdEventListener bus;
    private boolean adViewed;
    private boolean cp0Fired;
    @NotNull
    private final AtomicBoolean isDestroying;
    @NotNull
    private final AtomicBoolean sendReportIncentivized;
    @Nullable
    private Long adStartTime;
    @Nullable
    private String userId;
    @NotNull
    private final Lazy vungleApiClient$delegate;
    @NotNull
    private final Lazy pathProvider$delegate;
    @NotNull
    private final Lazy signalManager$delegate;
    @NotNull
    private final Lazy tpatSender$delegate;
    @Nullable
    private PresenterDelegate presenterDelegate;
    @NotNull
    private final Lazy scheduler$delegate;
    @NotNull
    private final Lazy logEntry$delegate;
    private boolean heartbeatEnabled;
    @NotNull
    private final Lazy suspendableTimer$delegate;
    private boolean backEnabled;
    @NotNull
    private final Lazy clickCoordinateTracker$delegate;
    private long videoLength;
    @NotNull
    private static final String TAG = "MRAIDPresenter";
    @NotNull
    public static final String CLOSE = "close";
    @NotNull
    public static final String CONSENT_ACTION = "consentAction";
    @NotNull
    public static final String ACTION_WITH_VALUE = "actionWithValue";
    @NotNull
    public static final String VIDEO_VIEWED = "videoViewed";
    @NotNull
    public static final String VIDEO_LENGTH = "videoLength";
    @NotNull
    public static final String TPAT = "tpat";
    @NotNull
    private static final String ACTION = "action";
    @NotNull
    public static final String PING_URL = "pingUrl";
    @NotNull
    public static final String OPEN = "open";
    @NotNull
    private static final String OPEN_NON_MRAID = "openNonMraid";
    @NotNull
    private static final String USE_CUSTOM_CLOSE = "useCustomClose";
    @NotNull
    private static final String USE_CUSTOM_PRIVACY = "useCustomPrivacy";
    @NotNull
    public static final String OPEN_PRIVACY = "openPrivacy";
    @NotNull
    public static final String SUCCESSFUL_VIEW = "successfulView";
    @NotNull
    public static final String SET_ORIENTATION_PROPERTIES = "setOrientationProperties";
    @NotNull
    public static final String CREATIVE_HEARTBEAT = "creativeHeartbeat";
    @NotNull
    public static final String GET_AVAILABLE_DISK_SPACE = "getAvailableDiskSpace";
    @NotNull
    public static final String UPDATE_SIGNALS = "updateSignals";
    @NotNull
    public static final String ERROR = "error";
    private static final double HEARTBEAT_INTERVAL = 6.0;
    @NotNull
    private static final Map<String, Sdk.SDKMetric.SDKMetricType> eventMap;

    public MRAIDPresenter(@NotNull MRAIDAdWidget adWidget, @NotNull AdPayload advertisement, @NotNull Placement placement, @NotNull VungleWebClient vungleWebClient, @NotNull Executor executor, @NotNull OMTracker omTracker, @Nullable BidPayload bidPayload, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)((Object)adWidget), (String)"adWidget");
        Intrinsics.checkNotNullParameter((Object)advertisement, (String)"advertisement");
        Intrinsics.checkNotNullParameter((Object)placement, (String)"placement");
        Intrinsics.checkNotNullParameter((Object)vungleWebClient, (String)"vungleWebClient");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)omTracker, (String)"omTracker");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.adWidget = adWidget;
        this.advertisement = advertisement;
        this.placement = placement;
        this.vungleWebClient = vungleWebClient;
        this.executor = executor;
        this.omTracker = omTracker;
        this.bidPayload = bidPayload;
        this.platform = platform;
        this.isDestroying = new AtomicBoolean(false);
        this.sendReportIncentivized = new AtomicBoolean(false);
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context = this.adWidget.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"adWidget.context");
        Context context$iv = context;
        boolean $i$f$inject = false;
        this.vungleApiClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<VungleApiClient>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final VungleApiClient invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(VungleApiClient.class);
            }
        }));
        ServiceLocator.Companion this_$iv = ServiceLocator.Companion;
        Context context2 = this.adWidget.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"adWidget.context");
        context$iv = context2;
        $i$f$inject = false;
        this.pathProvider$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<PathProvider>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final PathProvider invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(PathProvider.class);
            }
        }));
        this_$iv = ServiceLocator.Companion;
        Context context3 = this.adWidget.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"adWidget.context");
        context$iv = context3;
        $i$f$inject = false;
        this.signalManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<SignalManager>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final SignalManager invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(SignalManager.class);
            }
        }));
        this_$iv = ServiceLocator.Companion;
        Context context4 = this.adWidget.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"adWidget.context");
        context$iv = context4;
        $i$f$inject = false;
        this.tpatSender$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<TpatSender>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final TpatSender invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(TpatSender.class);
            }
        }));
        this.scheduler$delegate = LazyKt.lazy((Function0)scheduler.2.INSTANCE);
        this.logEntry$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogEntry>(this){
            final /* synthetic */ MRAIDPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LogEntry invoke() {
                return MRAIDPresenter.access$getAdvertisement$p(this.this$0).getLogEntry$vungle_ads_release();
            }
        }));
        this.suspendableTimer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SuspendableTimer>(this){
            final /* synthetic */ MRAIDPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SuspendableTimer invoke() {
                return new SuspendableTimer(6.0, true, null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ MRAIDPresenter this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        MRAIDPresenter.access$reportErrorAndCloseAd(this.this$0, new HeartbeatMissingError());
                    }
                }, 4, null);
            }
        }));
        this.clickCoordinateTracker$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClickCoordinateTracker>(this){
            final /* synthetic */ MRAIDPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ClickCoordinateTracker invoke() {
                Context context = MRAIDPresenter.access$getAdWidget$p(this.this$0).getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"adWidget.context");
                return new ClickCoordinateTracker(context, MRAIDPresenter.access$getAdvertisement$p(this.this$0));
            }
        }));
    }

    public final long getLastUserInteractionTimestamp$vungle_ads_release() {
        return this.lastUserInteractionTimestamp;
    }

    public final void setLastUserInteractionTimestamp$vungle_ads_release(long l) {
        this.lastUserInteractionTimestamp = l;
    }

    @VisibleForTesting
    public static /* synthetic */ void getLastUserInteractionTimestamp$vungle_ads_release$annotations() {
    }

    @Nullable
    public final AdEventListener getBus() {
        return this.bus;
    }

    public final void setBus(@Nullable AdEventListener adEventListener2) {
        this.bus = adEventListener2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBus$annotations() {
    }

    @NotNull
    public final AtomicBoolean isDestroying$vungle_ads_release() {
        return this.isDestroying;
    }

    @VisibleForTesting
    public static /* synthetic */ void isDestroying$vungle_ads_release$annotations() {
    }

    @Nullable
    public final Long getAdStartTime$vungle_ads_release() {
        return this.adStartTime;
    }

    public final void setAdStartTime$vungle_ads_release(@Nullable Long l) {
        this.adStartTime = l;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAdStartTime$vungle_ads_release$annotations() {
    }

    @Nullable
    public final String getUserId$vungle_ads_release() {
        return this.userId;
    }

    public final void setUserId$vungle_ads_release(@Nullable String string) {
        this.userId = string;
    }

    @VisibleForTesting
    public static /* synthetic */ void getUserId$vungle_ads_release$annotations() {
    }

    private final VungleApiClient getVungleApiClient() {
        Lazy lazy = this.vungleApiClient$delegate;
        return (VungleApiClient)lazy.getValue();
    }

    private final PathProvider getPathProvider() {
        Lazy lazy = this.pathProvider$delegate;
        return (PathProvider)lazy.getValue();
    }

    private final SignalManager getSignalManager() {
        Lazy lazy = this.signalManager$delegate;
        return (SignalManager)lazy.getValue();
    }

    private final TpatSender getTpatSender() {
        Lazy lazy = this.tpatSender$delegate;
        return (TpatSender)lazy.getValue();
    }

    private final HandlerScheduler getScheduler() {
        Lazy lazy = this.scheduler$delegate;
        return (HandlerScheduler)lazy.getValue();
    }

    private final LogEntry getLogEntry() {
        Lazy lazy = this.logEntry$delegate;
        return (LogEntry)lazy.getValue();
    }

    public final boolean getHeartbeatEnabled$vungle_ads_release() {
        return this.heartbeatEnabled;
    }

    public final void setHeartbeatEnabled$vungle_ads_release(boolean bl) {
        this.heartbeatEnabled = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void getHeartbeatEnabled$vungle_ads_release$annotations() {
    }

    @NotNull
    public final SuspendableTimer getSuspendableTimer$vungle_ads_release() {
        Lazy lazy = this.suspendableTimer$delegate;
        return (SuspendableTimer)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getSuspendableTimer$vungle_ads_release$annotations() {
    }

    public final boolean getBackEnabled$vungle_ads_release() {
        return this.backEnabled;
    }

    public final void setBackEnabled$vungle_ads_release(boolean bl) {
        this.backEnabled = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBackEnabled$vungle_ads_release$annotations() {
    }

    @NotNull
    public final ClickCoordinateTracker getClickCoordinateTracker$vungle_ads_release() {
        Lazy lazy = this.clickCoordinateTracker$delegate;
        return (ClickCoordinateTracker)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getClickCoordinateTracker$vungle_ads_release$annotations() {
    }

    public final long getVideoLength$vungle_ads_release() {
        return this.videoLength;
    }

    public final void setVideoLength$vungle_ads_release(long l) {
        this.videoLength = l;
    }

    @VisibleForTesting
    public static /* synthetic */ void getVideoLength$vungle_ads_release$annotations() {
    }

    public final void setEventListener(@Nullable AdEventListener listener) {
        this.bus = listener;
    }

    public final void setPresenterDelegate$vungle_ads_release(@Nullable PresenterDelegate presenterDelegate) {
        this.presenterDelegate = presenterDelegate;
    }

    public final void onViewConfigurationChanged() {
        this.vungleWebClient.notifyPropertiesChange(true);
    }

    public final void start() {
        Logger.Companion.d(TAG, "start()");
        this.adWidget.resumeWeb();
        this.setAdVisibility(true);
    }

    public final void stop() {
        Logger.Companion.d(TAG, "stop()");
        this.adWidget.pauseWeb();
        this.setAdVisibility(false);
    }

    public final void detach(@MRAIDAdWidget.AdStopReason int stopReason) {
        Logger.Companion.d(TAG, "detach()");
        boolean isChangingConfigurations = (stopReason & 1) != 0;
        boolean isFinishing = (stopReason & 2) != 0;
        this.vungleWebClient.setWebViewObserver(null);
        this.vungleWebClient.setMraidDelegate(null);
        if (!isChangingConfigurations && isFinishing && !this.isDestroying.getAndSet(true)) {
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 != null) {
                adEventListener2.onNext("end", null, this.placement.getReferenceId());
            }
        }
        long delay = this.omTracker.stop();
        this.adWidget.destroyWebView(delay);
        if (this.heartbeatEnabled) {
            this.getSuspendableTimer$vungle_ads_release().cancel();
        }
    }

    public final void setAdVisibility(boolean isViewable) {
        this.vungleWebClient.setAdVisibility(isViewable);
    }

    public final void onViewTouched(@Nullable MotionEvent event) {
        block0: {
            MotionEvent motionEvent = event;
            if (motionEvent == null) break block0;
            MotionEvent it = motionEvent;
            boolean bl = false;
            Logger.Companion.d(TAG, "user interaction");
            this.lastUserInteractionTimestamp = System.currentTimeMillis();
            this.getClickCoordinateTracker$vungle_ads_release().trackCoordinate(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeView() {
        Long l = this.adStartTime;
        if (l != null) {
            Long l2 = l;
            long it = ((Number)l2).longValue();
            boolean bl = false;
            long duration = System.currentTimeMillis() - it;
            List<String> list = this.advertisement.getTpatUrls("ad.close", String.valueOf(duration), String.valueOf(this.platform.getVolumeLevel()));
            if (list != null) {
                void $this$forEach$iv;
                Iterable iterable = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String url = (String)element$iv;
                    boolean bl2 = false;
                    TpatRequest request = new TpatRequest.Builder(url).tpatKey("ad.close").withLogEntry(this.getLogEntry()).build();
                    TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                }
            }
        }
        ThreadUtil.INSTANCE.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MRAIDPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MRAIDPresenter.access$getAdWidget$p(this.this$0).close();
            }
        }));
    }

    public final void handleExit() {
        if (this.backEnabled) {
            this.adWidget.showWebsite("javascript:window.vungle.mraidBridgeExt.requestMRAIDClose()");
        }
    }

    private final void triggerEventMetricForTpat(String key) {
        Sdk.SDKMetric.SDKMetricType event = eventMap.get(key);
        if (event != null) {
            AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(event), this.getLogEntry(), null, 4, null);
        }
    }

    @Nullable
    public final Long getViewStatus() {
        return !this.adViewed && !this.cp0Fired ? Long.valueOf(3L) : (!this.cp0Fired ? Long.valueOf(1L) : (!this.adViewed ? Long.valueOf(2L) : null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processCommand(@NotNull String command, @NotNull JsonObject arguments) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Handler uiHandler = new Handler(Looper.getMainLooper());
        switch (command) {
            case "close": {
                this.closeView();
                return true;
            }
            case "consentAction": {
                String action = JsonUtil.INSTANCE.getContentStringValue(arguments, "event");
                String consentStatus = Intrinsics.areEqual((Object)action, (Object)PrivacyConsent.OPT_OUT.getValue()) ? PrivacyConsent.OPT_OUT.getValue() : PrivacyConsent.OPT_IN.getValue();
                PrivacyManager.INSTANCE.updateGdprConsent(consentStatus, "vungle_modal", null);
                return true;
            }
            case "actionWithValue": {
                String action = JsonUtil.INSTANCE.getContentStringValue(arguments, "event");
                String value = JsonUtil.INSTANCE.getContentStringValue(arguments, "value");
                if (StringsKt.equals((String)VIDEO_LENGTH, (String)action, (boolean)true)) {
                    Object $this$processCommand_u24lambda_u2d3;
                    Object object = this;
                    MRAIDPresenter mRAIDPresenter = this;
                    try {
                        $this$processCommand_u24lambda_u2d3 = object;
                        boolean bl = false;
                        String string = value;
                        $this$processCommand_u24lambda_u2d3 = Result.constructor-impl((Object)(string != null ? Long.valueOf(Long.parseLong(string)) : null));
                    }
                    catch (Throwable bl) {
                        $this$processCommand_u24lambda_u2d3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = $this$processCommand_u24lambda_u2d3;
                    Long l = (Long)(Result.isFailure-impl((Object)object) ? null : object);
                    long l2 = mRAIDPresenter.videoLength = l != null ? l : 0L;
                }
                if (StringsKt.equals((String)VIDEO_VIEWED, (String)action, (boolean)true)) {
                    float position = 0.0f;
                    try {
                        String string = value;
                        position = string != null ? Float.parseFloat(string) : 0.0f;
                    }
                    catch (NumberFormatException nfe) {
                        Logger.Companion.e(TAG, "value for videoViewed is null !");
                    }
                    if (this.bus != null && position > 0.0f && !this.adViewed) {
                        Unit unit;
                        Object object;
                        Unit unit2;
                        this.adViewed = true;
                        AdEventListener adEventListener2 = this.bus;
                        if (adEventListener2 != null) {
                            adEventListener2.onNext("adViewed", null, this.placement.getReferenceId());
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        if ((object = this.bidPayload) != null && (object = ((BidPayload)object).getImpression()) != null) {
                            Iterable $this$forEach$iv = (Iterable)object;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String url = (String)element$iv;
                                boolean bl = false;
                                TpatRequest request = new TpatRequest.Builder(url).tpatKey("impression").withLogEntry(this.getLogEntry()).build();
                                TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    }
                }
                uiHandler.post(() -> MRAIDPresenter.processCommand$lambda-5(this));
                return true;
            }
            case "tpat": {
                Unit unit;
                String event = JsonUtil.INSTANCE.getContentStringValue(arguments, "event");
                Object value = event;
                if (value == null || value.length() == 0) {
                    new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return true;
                }
                this.triggerEventMetricForTpat(event);
                Object position = event;
                Object object = Intrinsics.areEqual((Object)position, (Object)"checkpoint.0") ? this.advertisement.getTpatUrls(event, this.platform.getCarrierName(), String.valueOf(this.platform.getVolumeLevel())) : (value = Intrinsics.areEqual((Object)position, (Object)"video.length") ? AdPayload.getTpatUrls$default(this.advertisement, event, String.valueOf(this.videoLength), null, 4, null) : AdPayload.getTpatUrls$default(this.advertisement, event, null, null, 6, null));
                if (value != null) {
                    void $this$forEach$iv;
                    position = (Iterable)value;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        TpatRequest request = new TpatRequest.Builder(url).tpatKey(event).withLogEntry(this.getLogEntry()).build();
                        TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (Intrinsics.areEqual((Object)event, (Object)"checkpoint.0")) {
                    this.cp0Fired = true;
                }
                return true;
            }
            case "pingUrl": {
                Unit unit;
                String it;
                String string;
                String string2 = JsonUtil.INSTANCE.getContentStringValue(arguments, "requestType");
                if (string2 != null) {
                    String string3 = string2.toUpperCase(Locale.ROOT);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                } else {
                    string = null;
                }
                String requestType = string;
                Object[] value = new String[]{"GET", "POST"};
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])value), (Object)requestType)) {
                    new TpatError(Sdk.SDKError.Reason.TPAT_ERROR, "Invalid request type: " + requestType + ". Only 'GET' and 'POST' are supported").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return true;
                }
                String url = JsonUtil.INSTANCE.getContentStringValue(arguments, "url");
                String requestBody = JsonUtil.INSTANCE.getContentStringValue(arguments, "requestData");
                boolean retry = Boolean.parseBoolean(JsonUtil.INSTANCE.getContentStringValue(arguments, "retry"));
                String headerString = JsonUtil.INSTANCE.getContentStringValue(arguments, "headers");
                Map headers = null;
                try {
                    Map map;
                    String string4 = headerString;
                    if (string4 != null) {
                        it = string4;
                        boolean bl = false;
                        StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
                        boolean $i$f$decodeFromString = false;
                        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                        boolean $i$f$serializer = false;
                        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))));
                        boolean $i$f$cast = false;
                        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        map = (Map)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, it);
                    } else {
                        map = null;
                    }
                    headers = map;
                }
                catch (Exception e2) {
                    new TpatError(Sdk.SDKError.Reason.TPAT_ERROR, "Failed to decode header: " + headerString).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return true;
                }
                if (!Utils.INSTANCE.isUrlValid(url)) {
                    new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "URL is missing in params from a template for generic tpat").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return true;
                }
                String string5 = url;
                if (string5 != null) {
                    TpatRequest.Builder builder2;
                    it = string5;
                    boolean bl = false;
                    TpatRequest.Builder it2 = builder2 = new TpatRequest.Builder(url).headers(headers).body(requestBody).regularRetry(retry).tpatKey(PING_URL).withLogEntry(this.getLogEntry());
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)requestType, (Object)"GET")) {
                        it2.get();
                    } else {
                        it2.post();
                    }
                    TpatRequest request = builder2.build();
                    TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return true;
            }
            case "action": {
                return true;
            }
            case "openNonMraid": 
            case "open": {
                Unit unit;
                AdPayload.AdUnit adUnit = this.advertisement.adUnit();
                String deeplinkUrl = adUnit != null ? adUnit.getDeeplinkUrl() : null;
                String url2 = JsonUtil.INSTANCE.getContentStringValue(arguments, "url");
                if (!FileUtility.INSTANCE.isValidUrl(url2)) {
                    new InvalidCTAUrl("Unable to open CTA Url (" + url2 + ')').setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                }
                if (this.shouldBlockAutoRedirect$vungle_ads_release()) {
                    this.lastUserInteractionTimestamp = 0L;
                    AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.BANNER_AUTO_REDIRECT), this.getLogEntry(), null, 4, null);
                    return true;
                }
                this.lastUserInteractionTimestamp = 0L;
                Context context = this.adWidget.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"adWidget.context");
                boolean launched2 = ExternalRouter.launch(deeplinkUrl, url2, context, this.getLogEntry(), new PresenterAdOpenCallback(deeplinkUrl, this){
                    final /* synthetic */ String $deeplinkUrl;
                    final /* synthetic */ MRAIDPresenter this$0;
                    {
                        this.$deeplinkUrl = $deeplinkUrl;
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onDeeplinkClick(boolean opened) {
                        block2: {
                            void $this$forEach$iv;
                            List deeplinkClickTpatUrls;
                            if (!opened) {
                                new LinkError(Sdk.SDKError.Reason.DEEPLINK_OPEN_FAILED, "Fail to open " + this.$deeplinkUrl).setLogEntry$vungle_ads_release(MRAIDPresenter.access$getLogEntry(this.this$0)).logErrorNoReturnValue$vungle_ads_release();
                            }
                            List list = deeplinkClickTpatUrls = AdPayload.getTpatUrls$default(MRAIDPresenter.access$getAdvertisement$p(this.this$0), "deeplink.click", String.valueOf(opened), null, 4, null);
                            if (list == null) break block2;
                            Iterable iterable = list;
                            MRAIDPresenter mRAIDPresenter = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                String url = (String)element$iv;
                                boolean bl = false;
                                TpatRequest request = new TpatRequest.Builder(url).tpatKey("deeplink.click").withLogEntry(MRAIDPresenter.access$getLogEntry(mRAIDPresenter)).build();
                                TpatSender.sendTpat$default(MRAIDPresenter.access$getTpatSender(mRAIDPresenter), request, false, 2, null);
                            }
                        }
                    }
                });
                AdEventListener adEventListener3 = this.bus;
                if (adEventListener3 != null) {
                    adEventListener3.onNext(OPEN, "adClick", this.placement.getReferenceId());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (launched2) {
                    Unit unit3;
                    AdEventListener adEventListener4 = this.bus;
                    if (adEventListener4 != null) {
                        adEventListener4.onNext(OPEN, "adLeftApplication", this.placement.getReferenceId());
                        unit3 = Unit.INSTANCE;
                    } else {
                        unit3 = null;
                    }
                }
                return true;
            }
            case "useCustomClose": {
                return true;
            }
            case "useCustomPrivacy": {
                return true;
            }
            case "openPrivacy": {
                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.PRIVACY_URL_OPENED), this.getLogEntry(), null, 4, null);
                String url = JsonUtil.INSTANCE.getContentStringValue(arguments, "url");
                CharSequence url2 = url;
                if (url2 == null || url2.length() == 0 || !FileUtility.INSTANCE.isValidUrl(url)) {
                    String string = url;
                    if (string == null) {
                        string = "nonePrivacyUrl";
                    }
                    new PrivacyUrlError(string).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return true;
                }
                Context context = this.adWidget.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"adWidget.context");
                boolean launched3 = ExternalRouter.launch$default(null, url, context, this.getLogEntry(), null, 16, null);
                if (launched3) {
                    Unit unit;
                    AdEventListener adEventListener5 = this.bus;
                    if (adEventListener5 != null) {
                        adEventListener5.onNext(OPEN, "adLeftApplication", this.placement.getReferenceId());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                } else {
                    new PrivacyUrlError(url).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                }
                return true;
            }
            case "successfulView": {
                Unit unit;
                AdEventListener adEventListener6 = this.bus;
                if (adEventListener6 != null) {
                    adEventListener6.onNext(SUCCESSFUL_VIEW, null, this.placement.getReferenceId());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (this.placement.isRewardedVideo() && ConfigManager.INSTANCE.isReportIncentivizedEnabled() && !this.sendReportIncentivized.getAndSet(true)) {
                    this.executor.execute(() -> MRAIDPresenter.processCommand$lambda-10(this));
                }
                return true;
            }
            case "updateSignals": {
                String signals = JsonUtil.INSTANCE.getContentStringValue(arguments, "signals");
                CharSequence launched3 = signals;
                if (!(launched3 == null || launched3.length() == 0)) {
                    this.getSignalManager().updateTemplateSignals(signals);
                }
                return true;
            }
            case "error": {
                String errorCode = JsonUtil.INSTANCE.getContentStringValue(arguments, "code");
                String fatal = JsonUtil.INSTANCE.getContentStringValue(arguments, "fatal");
                boolean isFatal = Boolean.parseBoolean(fatal);
                String errorMsg = JsonUtil.INSTANCE.getContentStringValue(arguments, "errorMessage");
                Sdk.SDKError.Reason reason = isFatal ? Sdk.SDKError.Reason.AD_CLOSED_TEMPLATE_ERROR : Sdk.SDKError.Reason.MRAID_ERROR;
                String message = errorCode + " : " + errorMsg;
                MraidTemplateError exception = new MraidTemplateError(reason, message);
                ThreadUtil.INSTANCE.runOnUiThread((Function0<Unit>)((Function0)new Function0<Unit>(this, exception, isFatal, message){
                    final /* synthetic */ MRAIDPresenter this$0;
                    final /* synthetic */ MraidTemplateError $exception;
                    final /* synthetic */ boolean $isFatal;
                    final /* synthetic */ String $message;
                    {
                        this.this$0 = $receiver;
                        this.$exception = $exception;
                        this.$isFatal = $isFatal;
                        this.$message = $message;
                        super(0);
                    }

                    public final void invoke() {
                        MRAIDPresenter.access$handleWebViewException(this.this$0, this.$exception, this.$isFatal, this.$message);
                    }
                }));
                return true;
            }
            case "setOrientationProperties": {
                String forceOrientation = JsonUtil.INSTANCE.getContentStringValue(arguments, "forceOrientation");
                CharSequence fatal = forceOrientation;
                if (!(fatal == null || fatal.length() == 0)) {
                    String string = forceOrientation;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string6 = string.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toLowerCase(locale)");
                    fatal = string6;
                    if (Intrinsics.areEqual((Object)fatal, (Object)"landscape")) {
                        this.adWidget.setOrientation(6);
                    } else if (Intrinsics.areEqual((Object)fatal, (Object)"portrait")) {
                        this.adWidget.setOrientation(7);
                    }
                }
                return true;
            }
            case "creativeHeartbeat": {
                if (this.heartbeatEnabled) {
                    uiHandler.post(() -> MRAIDPresenter.processCommand$lambda-11(this));
                }
                return true;
            }
            case "getAvailableDiskSpace": {
                try {
                    File dir = Build.VERSION.SDK_INT >= 21 ? this.adWidget.getContext().getNoBackupFilesDir() : this.adWidget.getContext().getFilesDir();
                    PathProvider pathProvider = this.getPathProvider();
                    String string = dir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.path");
                    long availableDiskSpace = pathProvider.getAvailableBytes(string);
                    uiHandler.post(() -> MRAIDPresenter.processCommand$lambda-12(this, availableDiskSpace));
                }
                catch (Exception _) {
                    Logger.Companion.e(TAG, "Failed to get available disk space");
                }
                return true;
            }
        }
        new MraidJsError(Sdk.SDKError.Reason.MRAID_JS_CALL_EMPTY, "Unknown MRAID Command: " + command).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
        Logger.Companion.w(TAG, "processCommand# Unknown MRAID Command: " + command);
        return true;
    }

    private final void makeBusError(VungleError reason) {
        block0: {
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 == null) break block0;
            adEventListener2.onError(reason, this.placement.getReferenceId());
        }
    }

    private final void reportErrorAndCloseAd(VungleError reason) {
        reason.setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
        this.makeBusError(reason);
        this.closeView();
    }

    @Override
    public void onReceivedError(@NotNull String errorDesc, boolean didCrash) {
        Intrinsics.checkNotNullParameter((Object)errorDesc, (String)"errorDesc");
        if (didCrash) {
            this.reportErrorAndCloseAd(new WebViewError(errorDesc));
        }
    }

    @Override
    public boolean onWebRenderingProcessGone(@Nullable WebView view, @Nullable Boolean didCrash) {
        Boolean bl = didCrash;
        boolean crashed = bl != null ? bl : true;
        WebViewRenderingProcessGone error = new WebViewRenderingProcessGone("didCrash=" + crashed);
        MRAIDPresenter.handleWebViewException$default(this, error, crashed, null, 4, null);
        return true;
    }

    @Override
    public void onRenderProcessUnresponsive(@Nullable WebView webView, @Nullable WebViewRenderProcess webViewRenderProcess) {
        WebViewRenderProcessUnresponsive exception = new WebViewRenderProcessUnresponsive("fatal=true");
        MRAIDPresenter.handleWebViewException$default(this, exception, true, null, 4, null);
    }

    private final void handleWebViewException(VungleError reason, boolean fatal, String errorMessage) {
        Logger.Companion.e(TAG, "handleWebViewException: " + reason.getLocalizedMessage() + ", fatal: " + fatal + ", errorMsg: " + errorMessage);
        reason.setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
        if (fatal) {
            this.makeBusError(reason);
            this.closeView();
        }
    }

    static /* synthetic */ void handleWebViewException$default(MRAIDPresenter mRAIDPresenter, VungleError vungleError, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        mRAIDPresenter.handleWebViewException(vungleError, bl, string);
    }

    private final VungleError loadMraidAd(File dest) {
        File indexHtml = new File(dest.getPath(), "index.html");
        if (!indexHtml.exists()) {
            return new IndexHtmlError(Sdk.SDKError.Reason.AD_HTML_FAILED_TO_LOAD, "Fail to load html " + indexHtml.getPath());
        }
        this.adWidget.showWebsite("file://" + indexHtml.getPath());
        return null;
    }

    public final void prepare() {
        int delay;
        Object object;
        Object continueText;
        Object object2;
        Object bodyText;
        Object object3;
        Object titleText;
        int n;
        Integer n2;
        this.isDestroying.set(false);
        this.adWidget.linkWebView(this.vungleWebClient, this.advertisement.getWebViewSettings());
        AdConfig adConfig = this.advertisement.getAdConfig();
        if (adConfig != null) {
            int it = adConfig.getSettings();
            boolean bl = false;
            if (it > 0) {
                this.backEnabled = (it & 2) == 2;
            }
        }
        this.heartbeatEnabled = this.advertisement.heartbeatEnabled();
        AdConfig adConfig2 = this.advertisement.getAdConfig();
        Integer n3 = n2 = adConfig2 != null ? Integer.valueOf(adConfig2.getAdOrientation()) : null;
        if (n3 != null && n3 == 0) {
            n = 7;
        } else {
            Integer n4 = n2;
            int n5 = 1;
            n = n4 != null && n4 == n5 ? 6 : 4;
        }
        int requestedOrientation = n;
        this.adWidget.setOrientation(requestedOrientation);
        this.omTracker.start();
        this.vungleWebClient.setMraidDelegate(this);
        this.vungleWebClient.setErrorHandler(this);
        File assetDir = this.advertisement.getAssetDirectory();
        if (assetDir == null || !assetDir.exists()) {
            File file = assetDir;
            this.reportErrorAndCloseAd(new AdNotLoadedCantPlay("adv dir not exists: " + (file != null ? file.getPath() : null)));
            return;
        }
        VungleError loadError = this.loadMraidAd(assetDir);
        if (loadError != null) {
            this.reportErrorAndCloseAd(loadError);
            return;
        }
        this.adStartTime = System.currentTimeMillis();
        PresenterDelegate presenterDelegate = this.presenterDelegate;
        this.userId = presenterDelegate != null ? presenterDelegate.getUserId() : null;
        Object object4 = this.presenterDelegate;
        if (object4 == null || (object4 = object4.getAlertTitleText()) == null) {
            object4 = titleText = "";
        }
        if ((object3 = this.presenterDelegate) == null || (object3 = object3.getAlertBodyText()) == null) {
            object3 = bodyText = "";
        }
        if ((object2 = this.presenterDelegate) == null || (object2 = object2.getAlertContinueButtonText()) == null) {
            object2 = continueText = "";
        }
        if ((object = this.presenterDelegate) == null || (object = object.getAlertCloseButtonText()) == null) {
            object = "";
        }
        Object closeText = object;
        this.advertisement.setIncentivizedText((String)titleText, (String)bodyText, (String)continueText, (String)closeText);
        boolean collectedConsent = ConfigManager.INSTANCE.getGDPRIsCountryDataProtected() && Intrinsics.areEqual((Object)"unknown", (Object)PrivacyManager.INSTANCE.getConsentStatus());
        this.vungleWebClient.setConsentStatus(collectedConsent, ConfigManager.INSTANCE.getGDPRConsentTitle(), ConfigManager.INSTANCE.getGDPRConsentMessage(), ConfigManager.INSTANCE.getGDPRButtonAccept(), ConfigManager.INSTANCE.getGDPRButtonDeny());
        if (collectedConsent) {
            PrivacyManager.INSTANCE.updateGdprConsent("opted_out_by_timeout", "vungle_modal", "");
        }
        if ((delay = this.advertisement.getShowCloseDelay(this.placement.isRewardedVideo())) > 0) {
            this.getScheduler().schedule(() -> MRAIDPresenter.prepare$lambda-14(this), delay);
        } else {
            this.backEnabled = true;
        }
        AdEventListener adEventListener2 = this.bus;
        if (adEventListener2 != null) {
            adEventListener2.onNext("start", null, this.placement.getReferenceId());
        }
        if (this.heartbeatEnabled) {
            this.getSuspendableTimer$vungle_ads_release().start();
        }
        if (this.advertisement.adLoadOptimizationEnabled()) {
            this.recordPlayAssetMetric();
        }
    }

    private final void recordPlayAssetMetric() {
        Sdk.SDKMetric.SDKMetricType playAssetMetricType = this.advertisement.getAssetsFullyDownloaded() ? Sdk.SDKMetric.SDKMetricType.LOCAL_ASSETS_USED : Sdk.SDKMetric.SDKMetricType.REMOTE_ASSETS_USED;
        SingleValueMetric playAssetMetric = new SingleValueMetric(playAssetMetricType);
        AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, playAssetMetric, this.getLogEntry(), null, 4, null);
    }

    public final boolean shouldBlockAutoRedirect$vungle_ads_release() {
        if (!ConfigManager.INSTANCE.allowAutoRedirects()) {
            if (this.lastUserInteractionTimestamp == 0L) {
                return true;
            }
            long millisSinceUserInteraction = System.currentTimeMillis() - this.lastUserInteractionTimestamp;
            return millisSinceUserInteraction > ConfigManager.INSTANCE.afterClickDuration();
        }
        return false;
    }

    private static final void processCommand$lambda-5(MRAIDPresenter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.adWidget.setVisibility(0);
    }

    private static final void processCommand$lambda-10(MRAIDPresenter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.placement.getReferenceId();
        String string2 = this$0.advertisement.advAppId();
        Long l = this$0.adStartTime;
        String string3 = this$0.userId;
        CommonRequestBody.RequestParam requestParam = new CommonRequestBody.RequestParam(null, null, l, string2, string, string3, 3, null);
        Call<Void> riCall = this$0.getVungleApiClient().ri(requestParam);
        if (riCall == null) {
            Logger.Companion.e(TAG, "Invalid ri call.");
            new NetworkUnreachable("Error RI API for placement: " + this$0.placement.getReferenceId()).setLogEntry$vungle_ads_release(this$0.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
            return;
        }
        riCall.enqueue(new Callback<Void>(this$0){
            final /* synthetic */ MRAIDPresenter this$0;
            {
                this.this$0 = $receiver;
            }

            public void onResponse(@Nullable Call<Void> call, @Nullable Response<Void> response) {
                Logger.Companion.d("MRAIDPresenter", "send RI success");
            }

            public void onFailure(@Nullable Call<Void> call, @Nullable Throwable t) {
                Logger.Companion.d("MRAIDPresenter", "send RI Failure");
                Throwable throwable = t;
                new NetworkUnreachable("Error RI API calls: " + (throwable != null ? throwable.getLocalizedMessage() : null)).setLogEntry$vungle_ads_release(MRAIDPresenter.access$getLogEntry(this.this$0)).logErrorNoReturnValue$vungle_ads_release();
            }
        });
    }

    private static final void processCommand$lambda-11(MRAIDPresenter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getSuspendableTimer$vungle_ads_release().reset();
    }

    private static final void processCommand$lambda-12(MRAIDPresenter this$0, long $availableDiskSpace) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.vungleWebClient.notifyDiskAvailableSize($availableDiskSpace);
    }

    private static final void prepare$lambda-14(MRAIDPresenter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.backEnabled = true;
    }

    public static final /* synthetic */ MRAIDAdWidget access$getAdWidget$p(MRAIDPresenter $this) {
        return $this.adWidget;
    }

    public static final /* synthetic */ LogEntry access$getLogEntry(MRAIDPresenter $this) {
        return $this.getLogEntry();
    }

    public static final /* synthetic */ AdPayload access$getAdvertisement$p(MRAIDPresenter $this) {
        return $this.advertisement;
    }

    public static final /* synthetic */ TpatSender access$getTpatSender(MRAIDPresenter $this) {
        return $this.getTpatSender();
    }

    public static final /* synthetic */ void access$handleWebViewException(MRAIDPresenter $this, VungleError reason, boolean fatal, String errorMessage) {
        $this.handleWebViewException(reason, fatal, errorMessage);
    }

    public static final /* synthetic */ void access$reportErrorAndCloseAd(MRAIDPresenter $this, VungleError reason) {
        $this.reportErrorAndCloseAd(reason);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"checkpoint.0", (Object)((Object)Sdk.SDKMetric.SDKMetricType.AD_START_EVENT)), TuplesKt.to((Object)"clickUrl", (Object)((Object)Sdk.SDKMetric.SDKMetricType.AD_CLICK_EVENT))};
        eventMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0016\u0010\u0007\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0016\u0010\t\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u0016\u0010\u000b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R\u0016\u0010\r\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0002R\u0016\u0010\u000f\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0002R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0002R\u0016\u0010\u0018\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u0002R\u0016\u0010\u001a\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u0002R\u0016\u0010\u001c\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u0002R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b \u0010\u0002R\u0016\u0010!\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010\u0002R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b&\u0010\u0002R\u0016\u0010'\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b(\u0010\u0002R(\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020+0*8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b,\u0010\u0002\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lcom/vungle/ads/internal/presenter/MRAIDPresenter$Companion;", "", "()V", "ACTION", "", "ACTION_WITH_VALUE", "getACTION_WITH_VALUE$vungle_ads_release$annotations", "CLOSE", "getCLOSE$vungle_ads_release$annotations", "CONSENT_ACTION", "getCONSENT_ACTION$vungle_ads_release$annotations", "CREATIVE_HEARTBEAT", "getCREATIVE_HEARTBEAT$vungle_ads_release$annotations", "ERROR", "getERROR$vungle_ads_release$annotations", "GET_AVAILABLE_DISK_SPACE", "getGET_AVAILABLE_DISK_SPACE$vungle_ads_release$annotations", "HEARTBEAT_INTERVAL", "", "OPEN", "getOPEN$vungle_ads_release$annotations", "OPEN_NON_MRAID", "OPEN_PRIVACY", "getOPEN_PRIVACY$vungle_ads_release$annotations", "PING_URL", "getPING_URL$vungle_ads_release$annotations", "SET_ORIENTATION_PROPERTIES", "getSET_ORIENTATION_PROPERTIES$vungle_ads_release$annotations", "SUCCESSFUL_VIEW", "getSUCCESSFUL_VIEW$vungle_ads_release$annotations", "TAG", "TPAT", "getTPAT$vungle_ads_release$annotations", "UPDATE_SIGNALS", "getUPDATE_SIGNALS$vungle_ads_release$annotations", "USE_CUSTOM_CLOSE", "USE_CUSTOM_PRIVACY", "VIDEO_LENGTH", "getVIDEO_LENGTH$vungle_ads_release$annotations", "VIDEO_VIEWED", "getVIDEO_VIEWED$vungle_ads_release$annotations", "eventMap", "", "Lcom/vungle/ads/internal/protos/Sdk$SDKMetric$SDKMetricType;", "getEventMap$vungle_ads_release$annotations", "getEventMap$vungle_ads_release", "()Ljava/util/Map;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getCLOSE$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getCONSENT_ACTION$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTION_WITH_VALUE$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getVIDEO_VIEWED$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getVIDEO_LENGTH$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getTPAT$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPING_URL$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getOPEN$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getOPEN_PRIVACY$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSUCCESSFUL_VIEW$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSET_ORIENTATION_PROPERTIES$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getCREATIVE_HEARTBEAT$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getGET_AVAILABLE_DISK_SPACE$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getUPDATE_SIGNALS$vungle_ads_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getERROR$vungle_ads_release$annotations() {
        }

        @NotNull
        public final Map<String, Sdk.SDKMetric.SDKMetricType> getEventMap$vungle_ads_release() {
            return eventMap;
        }

        @VisibleForTesting
        public static /* synthetic */ void getEventMap$vungle_ads_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

