/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.ads.internal.presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.ContextThemeWrapper;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import com.vungle.ads.AnalyticsClient;
import com.vungle.ads.LinkError;
import com.vungle.ads.PrivacyUrlError;
import com.vungle.ads.ServiceLocator;
import com.vungle.ads.SingleValueMetric;
import com.vungle.ads.TpatError;
import com.vungle.ads.internal.ConfigManager;
import com.vungle.ads.internal.model.AdPayload;
import com.vungle.ads.internal.network.TpatRequest;
import com.vungle.ads.internal.network.TpatSender;
import com.vungle.ads.internal.omsdk.NativeOMTracker;
import com.vungle.ads.internal.omsdk.OMInjector;
import com.vungle.ads.internal.platform.Platform;
import com.vungle.ads.internal.presenter.AdEventListener;
import com.vungle.ads.internal.presenter.NativePresenterDelegate;
import com.vungle.ads.internal.privacy.PrivacyConsent;
import com.vungle.ads.internal.privacy.PrivacyManager;
import com.vungle.ads.internal.protos.Sdk;
import com.vungle.ads.internal.ui.PresenterAdOpenCallback;
import com.vungle.ads.internal.util.ExternalRouter;
import com.vungle.ads.internal.util.FileUtility;
import com.vungle.ads.internal.util.LogEntry;
import com.vungle.ads.internal.util.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\u0018\u0000 92\u00020\u0001:\u00019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u000fH\u0002J\u0012\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010%H\u0002J\u0006\u0010)\u001a\u00020\"J\u0012\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010%H\u0002J\u0006\u0010,\u001a\u00020\"J\u001a\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020%2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010%J\u0010\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00010\u0011J\b\u00102\u001a\u00020\"H\u0002J\b\u00103\u001a\u00020\"H\u0002J\u000e\u00104\u001a\u00020\"2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020\"2\u0006\u00108\u001a\u00020%H\u0002R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0019\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006:\u00b2\u0006\n\u0010;\u001a\u00020<X\u008a\u0084\u0002"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter;", "", "context", "Landroid/content/Context;", "delegate", "Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;", "advertisement", "Lcom/vungle/ads/internal/model/AdPayload;", "platform", "Lcom/vungle/ads/internal/platform/Platform;", "(Landroid/content/Context;Lcom/vungle/ads/internal/presenter/NativePresenterDelegate;Lcom/vungle/ads/internal/model/AdPayload;Lcom/vungle/ads/internal/platform/Platform;)V", "adStartTime", "", "Ljava/lang/Long;", "adViewed", "", "bus", "Lcom/vungle/ads/internal/presenter/AdEventListener;", "currentDialog", "Landroid/app/Dialog;", "logEntry", "Lcom/vungle/ads/internal/util/LogEntry;", "getLogEntry", "()Lcom/vungle/ads/internal/util/LogEntry;", "logEntry$delegate", "Lkotlin/Lazy;", "omTracker", "Lcom/vungle/ads/internal/omsdk/NativeOMTracker;", "tpatSender", "Lcom/vungle/ads/internal/network/TpatSender;", "getTpatSender", "()Lcom/vungle/ads/internal/network/TpatSender;", "tpatSender$delegate", "detach", "", "initOMTracker", "omSdkData", "", "needShowGdpr", "onDownload", "ctaUrl", "onImpression", "onPrivacy", "privacyUrl", "prepare", "processCommand", "action", "value", "setEventListener", "listener", "showGdpr", "start", "startTracking", "rootView", "Landroid/view/View;", "triggerEventMetricForTpat", "key", "Companion", "vungle-ads_release", "omInjector", "Lcom/vungle/ads/internal/omsdk/OMInjector;"})
public final class NativeAdPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final NativePresenterDelegate delegate;
    @Nullable
    private final AdPayload advertisement;
    @NotNull
    private final Platform platform;
    @Nullable
    private Long adStartTime;
    @Nullable
    private AdEventListener bus;
    @NotNull
    private final Lazy tpatSender$delegate;
    @Nullable
    private Dialog currentDialog;
    @NotNull
    private final Lazy logEntry$delegate;
    private boolean adViewed;
    @Nullable
    private NativeOMTracker omTracker;
    @NotNull
    private static final String TAG = "NativeAdPresenter";
    @NotNull
    public static final String VIDEO_VIEWED = "videoViewed";
    @NotNull
    public static final String TPAT = "tpat";
    @NotNull
    public static final String OPEN_PRIVACY = "openPrivacy";
    @NotNull
    public static final String DOWNLOAD = "download";
    @NotNull
    private static final Map<String, Sdk.SDKMetric.SDKMetricType> eventMap;

    public NativeAdPresenter(@NotNull Context context, @NotNull NativePresenterDelegate delegate, @Nullable AdPayload advertisement, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.context = context;
        this.delegate = delegate;
        this.advertisement = advertisement;
        this.platform = platform;
        ServiceLocator.Companion companion = ServiceLocator.Companion;
        Context context$iv = this.context;
        boolean $i$f$inject = false;
        this.tpatSender$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<TpatSender>(context$iv){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final TpatSender invoke() {
                return ServiceLocator.Companion.getInstance(this.$context).getService(TpatSender.class);
            }
        }));
        this.logEntry$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LogEntry>(this){
            final /* synthetic */ NativeAdPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final LogEntry invoke() {
                AdPayload adPayload = NativeAdPresenter.access$getAdvertisement$p(this.this$0);
                return adPayload != null ? adPayload.getLogEntry$vungle_ads_release() : null;
            }
        }));
    }

    private final TpatSender getTpatSender() {
        Lazy lazy = this.tpatSender$delegate;
        return (TpatSender)lazy.getValue();
    }

    private final LogEntry getLogEntry() {
        Lazy lazy = this.logEntry$delegate;
        return (LogEntry)lazy.getValue();
    }

    public final void setEventListener(@Nullable AdEventListener listener) {
        this.bus = listener;
    }

    public final void processCommand(@NotNull String action, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        switch (action) {
            case "videoViewed": {
                if (this.bus == null || this.adViewed) {
                    return;
                }
                this.adViewed = true;
                AdEventListener adEventListener2 = this.bus;
                if (adEventListener2 != null) {
                    adEventListener2.onNext("adViewed", null, this.delegate.getPlacementRefId());
                }
                List<String> list = this.delegate.getImpressionUrls();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        TpatRequest request = new TpatRequest.Builder(url).tpatKey("impression").withLogEntry(this.getLogEntry()).build();
                        TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    }
                }
                return;
            }
            case "tpat": {
                List<String> list;
                CharSequence charSequence = value;
                if (charSequence == null || charSequence.length() == 0) {
                    new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return;
                }
                this.triggerEventMetricForTpat(value);
                if (Intrinsics.areEqual((Object)value, (Object)"checkpoint.0")) {
                    AdPayload adPayload = this.advertisement;
                    list = adPayload != null ? adPayload.getTpatUrls(value, this.platform.getCarrierName(), String.valueOf(this.platform.getVolumeLevel())) : null;
                } else {
                    AdPayload adPayload = this.advertisement;
                    list = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, value, null, null, 6, null) : null;
                }
                List<String> urls = list;
                Iterable $this$forEach$iv = urls;
                if ($this$forEach$iv == null || $this$forEach$iv.isEmpty()) {
                    new TpatError(Sdk.SDKError.Reason.INVALID_TPAT_KEY, "Empty urls for tpat: " + value).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                } else {
                    $this$forEach$iv = urls;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl = false;
                        TpatRequest request = new TpatRequest.Builder(url).tpatKey(value).withLogEntry(this.getLogEntry()).build();
                        TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    }
                }
                return;
            }
            case "openPrivacy": {
                this.onPrivacy(value);
                return;
            }
            case "download": {
                this.onDownload(value);
                return;
            }
        }
        Logger.Companion.w(TAG, "Unknown native ad action: " + action);
    }

    public static /* synthetic */ void processCommand$default(NativeAdPresenter nativeAdPresenter, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        nativeAdPresenter.processCommand(string, string2);
    }

    private final void onDownload(String ctaUrl) {
        block6: {
            Object object;
            AdPayload adPayload = this.advertisement;
            List urls = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, "clickUrl", null, null, 6, null) : null;
            Collection collection = urls;
            if (collection == null || collection.isEmpty()) {
                new TpatError(Sdk.SDKError.Reason.EMPTY_TPAT_ERROR, "Empty tpat key: clickUrl").setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
            } else {
                Iterable $this$forEach$iv = urls;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String url = (String)element$iv;
                    boolean bl = false;
                    TpatRequest request = new TpatRequest.Builder(url).tpatKey("clickUrl").withLogEntry(this.getLogEntry()).build();
                    TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                }
            }
            String string = ctaUrl;
            if (string != null) {
                String url = string;
                boolean bl = false;
                TpatRequest request = new TpatRequest.Builder(url).tpatKey("cta_url").withLogEntry(this.getLogEntry()).build();
                TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
            }
            String deeplinkUrl = (object = this.advertisement) != null && (object = ((AdPayload)object).adUnit()) != null ? ((AdPayload.AdUnit)object).getDeeplinkUrl() : null;
            boolean launched2 = ExternalRouter.launch(deeplinkUrl, ctaUrl, this.context, this.getLogEntry(), new PresenterAdOpenCallback(deeplinkUrl, this){
                final /* synthetic */ String $deeplinkUrl;
                final /* synthetic */ NativeAdPresenter this$0;
                {
                    this.$deeplinkUrl = $deeplinkUrl;
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onDeeplinkClick(boolean opened) {
                    block2: {
                        void $this$forEach$iv;
                        List deeplinkClickTpatUrls;
                        if (!opened) {
                            new LinkError(Sdk.SDKError.Reason.DEEPLINK_OPEN_FAILED, "Fail to open " + this.$deeplinkUrl).setLogEntry$vungle_ads_release(NativeAdPresenter.access$getLogEntry(this.this$0)).logErrorNoReturnValue$vungle_ads_release();
                        }
                        AdPayload adPayload = NativeAdPresenter.access$getAdvertisement$p(this.this$0);
                        List list = deeplinkClickTpatUrls = adPayload != null ? AdPayload.getTpatUrls$default(adPayload, "deeplink.click", String.valueOf(opened), null, 4, null) : null;
                        if (list == null) break block2;
                        Iterable iterable = list;
                        NativeAdPresenter nativeAdPresenter = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String url = (String)element$iv;
                            boolean bl = false;
                            TpatRequest request = new TpatRequest.Builder(url).tpatKey("deeplink.click").withLogEntry(NativeAdPresenter.access$getLogEntry(nativeAdPresenter)).build();
                            TpatSender.sendTpat$default(NativeAdPresenter.access$getTpatSender(nativeAdPresenter), request, false, 2, null);
                        }
                    }
                }
            });
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 != null) {
                adEventListener2.onNext("open", "adClick", this.delegate.getPlacementRefId());
            }
            if (!launched2) break block6;
            AdEventListener adEventListener3 = this.bus;
            if (adEventListener3 != null) {
                adEventListener3.onNext("open", "adLeftApplication", this.delegate.getPlacementRefId());
            }
        }
    }

    private final void onPrivacy(String privacyUrl) {
        block1: {
            String it;
            block2: {
                AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(Sdk.SDKMetric.SDKMetricType.PRIVACY_URL_OPENED), this.getLogEntry(), null, 4, null);
                String string = privacyUrl;
                if (string == null) break block1;
                it = string;
                boolean bl = false;
                if (!FileUtility.INSTANCE.isValidUrl(privacyUrl)) {
                    new PrivacyUrlError(it).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
                    return;
                }
                boolean launched2 = ExternalRouter.launch$default(null, it, this.context, this.getLogEntry(), null, 16, null);
                if (!launched2) break block2;
                AdEventListener adEventListener2 = this.bus;
                if (adEventListener2 == null) break block1;
                adEventListener2.onNext("open", "adLeftApplication", this.delegate.getPlacementRefId());
                break block1;
            }
            new PrivacyUrlError(it).setLogEntry$vungle_ads_release(this.getLogEntry()).logErrorNoReturnValue$vungle_ads_release();
        }
    }

    public final void prepare() {
        this.start();
        AdEventListener adEventListener2 = this.bus;
        if (adEventListener2 != null) {
            adEventListener2.onNext("start", null, this.delegate.getPlacementRefId());
        }
        this.adStartTime = System.currentTimeMillis();
    }

    private final void start() {
        if (this.needShowGdpr()) {
            this.showGdpr();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void detach() {
        block6: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker != null) {
                nativeOMTracker.stop();
            }
            Dialog dialog = this.currentDialog;
            if (dialog != null) {
                Dialog $this$detach_u24lambda_u2d5 = dialog;
                boolean bl = false;
                if ($this$detach_u24lambda_u2d5.isShowing()) {
                    $this$detach_u24lambda_u2d5.dismiss();
                }
            }
            Long l = this.adStartTime;
            if (l != null) {
                List<String> list;
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                long duration = System.currentTimeMillis() - it;
                AdPayload adPayload = this.advertisement;
                if (adPayload != null && (list = adPayload.getTpatUrls("ad.close", String.valueOf(duration), String.valueOf(this.platform.getVolumeLevel()))) != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String url = (String)element$iv;
                        boolean bl2 = false;
                        TpatRequest request = new TpatRequest.Builder(url).tpatKey("ad.close").withLogEntry(this.getLogEntry()).build();
                        TpatSender.sendTpat$default(this.getTpatSender(), request, false, 2, null);
                    }
                }
            }
            AdEventListener adEventListener2 = this.bus;
            if (adEventListener2 == null) break block6;
            adEventListener2.onNext("end", null, this.delegate.getPlacementRefId());
        }
    }

    private final boolean needShowGdpr() {
        return ConfigManager.INSTANCE.getGDPRIsCountryDataProtected() && Intrinsics.areEqual((Object)"unknown", (Object)PrivacyManager.INSTANCE.getConsentStatus());
    }

    private final void showGdpr() {
        PrivacyManager.INSTANCE.updateGdprConsent("opted_out_by_timeout", "vungle_modal", null);
        if (!(this.context instanceof Activity)) {
            Logger.Companion.w(TAG, "We can not show GDPR dialog with application context.");
            return;
        }
        DialogInterface.OnClickListener listener = (arg_0, arg_1) -> NativeAdPresenter.showGdpr$lambda-8(this, arg_0, arg_1);
        String dialogTitle = ConfigManager.INSTANCE.getGDPRConsentTitle();
        String dialogBody = ConfigManager.INSTANCE.getGDPRConsentMessage();
        String dialogContinue = ConfigManager.INSTANCE.getGDPRButtonAccept();
        String dialogClose = ConfigManager.INSTANCE.getGDPRButtonDeny();
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this.context, ((Activity)this.context).getApplicationInfo().theme));
        CharSequence charSequence = dialogTitle;
        if (!(charSequence == null || charSequence.length() == 0)) {
            dialogBuilder.setTitle((CharSequence)dialogTitle);
        }
        if (!((charSequence = (CharSequence)dialogBody) == null || charSequence.length() == 0)) {
            dialogBuilder.setMessage((CharSequence)dialogBody);
        }
        dialogBuilder.setPositiveButton((CharSequence)dialogContinue, listener);
        dialogBuilder.setNegativeButton((CharSequence)dialogClose, listener);
        dialogBuilder.setCancelable(false);
        AlertDialog dialog = dialogBuilder.create();
        dialog.setOnDismissListener(arg_0 -> NativeAdPresenter.showGdpr$lambda-9(this, arg_0));
        this.currentDialog = (Dialog)dialog;
        dialog.show();
    }

    public final void initOMTracker(@NotNull String omSdkData) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)omSdkData, (String)"omSdkData");
            AdPayload adPayload = this.advertisement;
            boolean adOmEnabled = adPayload != null ? adPayload.omEnabled() : false;
            if (!(((CharSequence)omSdkData).length() > 0) || !adOmEnabled) break block1;
            ServiceLocator.Companion companion = ServiceLocator.Companion;
            Context context$iv = this.context;
            boolean $i$f$inject = false;
            Lazy omInjector$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<OMInjector>(context$iv){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final OMInjector invoke() {
                    return ServiceLocator.Companion.getInstance(this.$context).getService(OMInjector.class);
                }
            }));
            NativeAdPresenter.initOMTracker$lambda-10((Lazy<OMInjector>)omInjector$delegate).init();
            String string = NativeAdPresenter.initOMTracker$lambda-10((Lazy<OMInjector>)omInjector$delegate).getOMSDKJS$vungle_ads_release();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.omTracker = new NativeOMTracker(omSdkData, it);
            }
        }
    }

    public final void startTracking(@NotNull View rootView) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker == null) break block0;
            nativeOMTracker.start(rootView);
        }
    }

    public final void onImpression() {
        block0: {
            NativeOMTracker nativeOMTracker = this.omTracker;
            if (nativeOMTracker == null) break block0;
            nativeOMTracker.impressionOccurred();
        }
    }

    private final void triggerEventMetricForTpat(String key) {
        Sdk.SDKMetric.SDKMetricType event = eventMap.get(key);
        if (event != null) {
            AnalyticsClient.logMetric$vungle_ads_release$default(AnalyticsClient.INSTANCE, new SingleValueMetric(event), this.getLogEntry(), null, 4, null);
        }
    }

    private static final void showGdpr$lambda-8(NativeAdPresenter this$0, DialogInterface dialogInterface, int which) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String consented = "opted_out_by_timeout";
        switch (which) {
            case -2: {
                consented = PrivacyConsent.OPT_OUT.getValue();
                break;
            }
            case -1: {
                consented = PrivacyConsent.OPT_IN.getValue();
            }
        }
        PrivacyManager.INSTANCE.updateGdprConsent(consented, "vungle_modal", null);
        this$0.start();
    }

    private static final void showGdpr$lambda-9(NativeAdPresenter this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.currentDialog = null;
    }

    private static final OMInjector initOMTracker$lambda-10(Lazy<OMInjector> $omInjector$delegate) {
        Lazy<OMInjector> lazy = $omInjector$delegate;
        return (OMInjector)lazy.getValue();
    }

    public static final /* synthetic */ LogEntry access$getLogEntry(NativeAdPresenter $this) {
        return $this.getLogEntry();
    }

    public static final /* synthetic */ AdPayload access$getAdvertisement$p(NativeAdPresenter $this) {
        return $this.advertisement;
    }

    public static final /* synthetic */ TpatSender access$getTpatSender(NativeAdPresenter $this) {
        return $this.getTpatSender();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"checkpoint.0", (Object)((Object)Sdk.SDKMetric.SDKMetricType.AD_START_EVENT)), TuplesKt.to((Object)"clickUrl", (Object)((Object)Sdk.SDKMetric.SDKMetricType.AD_CLICK_EVENT))};
        eventMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/vungle/ads/internal/presenter/NativeAdPresenter$Companion;", "", "()V", "DOWNLOAD", "", "OPEN_PRIVACY", "TAG", "TPAT", "VIDEO_VIEWED", "eventMap", "", "Lcom/vungle/ads/internal/protos/Sdk$SDKMetric$SDKMetricType;", "getEventMap$vungle_ads_release$annotations", "getEventMap$vungle_ads_release", "()Ljava/util/Map;", "vungle-ads_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Sdk.SDKMetric.SDKMetricType> getEventMap$vungle_ads_release() {
            return eventMap;
        }

        @VisibleForTesting
        public static /* synthetic */ void getEventMap$vungle_ads_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

